/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.ControlFlow;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.DfaControlTransferValue;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.LiveVariablesAnalyzer;
import com.intellij.codeInspection.dataFlow.LoopAnalyzer;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.StateQueue;
import com.intellij.codeInspection.dataFlow.instructions.BranchingInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ConditionalGotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ControlTransferInstruction;
import com.intellij.codeInspection.dataFlow.instructions.GotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaExpressionFactory;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import gnu.trove.THashSet;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataFlowRunner {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.dataFlow.DataFlowRunner");
    private static final int MERGING_BACK_BRANCHES_THRESHOLD = 50;
    private Instruction[] myInstructions;
    private final MultiMap<PsiElement, DfaMemoryState> myNestedClosures = new MultiMap();
    @NotNull
    private final DfaValueFactory myValueFactory;
    private boolean myInlining = true;
    private boolean myCancelled = false;
    private boolean myWasForciblyMerged = false;
    static final int MAX_STATES_PER_BRANCH = 300;

    protected DataFlowRunner() {
        this(false, null);
    }

    protected DataFlowRunner(boolean unknownMembersAreNullable, PsiElement context) {
        this.myValueFactory = new DfaValueFactory(context, unknownMembersAreNullable);
    }

    @NotNull
    public DfaValueFactory getFactory() {
        return this.myValueFactory;
    }

    public void cancel() {
        this.myCancelled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Collection<DfaMemoryState> createInitialStates(@NotNull PsiElement psiBlock, @NotNull InstructionVisitor visitor, boolean allowInlining) {
        PsiElement block;
        PsiElement container = PsiTreeUtil.getParentOfType((PsiElement)psiBlock, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
        if (container != null && (!(container instanceof PsiClass) || PsiUtil.isLocalOrAnonymousClass((PsiClass)((PsiClass)container))) && (block = DfaPsiUtil.getTopmostBlockInSameClass(container.getParent())) != null) {
            RunnerResult result;
            try {
                this.myInlining = allowInlining;
                result = this.analyzeMethod(block, visitor);
            }
            finally {
                this.myInlining = true;
            }
            if (result == RunnerResult.OK) {
                Collection closureStates = this.myNestedClosures.get((Object)DfaPsiUtil.getTopmostBlockInSameClass(psiBlock));
                if (allowInlining || !closureStates.isEmpty()) {
                    return closureStates;
                }
            }
            return null;
        }
        return Collections.singletonList(this.createMemoryState());
    }

    @NotNull
    public final RunnerResult analyzeMethod(@NotNull PsiElement psiBlock, @NotNull InstructionVisitor visitor) {
        Collection<DfaMemoryState> initialStates = this.createInitialStates(psiBlock, visitor, false);
        return initialStates == null ? RunnerResult.NOT_APPLICABLE : this.analyzeMethod(psiBlock, visitor, false, initialStates);
    }

    @NotNull
    public final RunnerResult analyzeMethodWithInlining(@NotNull PsiElement psiBlock, @NotNull InstructionVisitor visitor) {
        Collection<DfaMemoryState> initialStates = this.createInitialStates(psiBlock, visitor, true);
        if (initialStates == null) {
            return RunnerResult.NOT_APPLICABLE;
        }
        if (initialStates.isEmpty()) {
            return RunnerResult.OK;
        }
        return this.analyzeMethod(psiBlock, visitor, false, initialStates);
    }

    public final RunnerResult analyzeCodeBlock(@NotNull PsiCodeBlock block, @NotNull InstructionVisitor visitor, Consumer<? super DfaMemoryState> initialStateAdjuster) {
        DfaMemoryState state = this.createMemoryState();
        initialStateAdjuster.accept(state);
        return this.analyzeMethod((PsiElement)block, visitor, false, Collections.singleton(state));
    }

    @NotNull
    final RunnerResult analyzeMethod(@NotNull PsiElement psiBlock, @NotNull InstructionVisitor visitor, boolean ignoreAssertions, @NotNull Collection<? extends DfaMemoryState> initialStates) {
        ControlFlow flow = null;
        DfaInstructionState lastInstructionState = null;
        try {
            TimeStats stats = new TimeStats();
            flow = new ControlFlowAnalyzer(this.myValueFactory, psiBlock, ignoreAssertions, this.myInlining).buildControlFlow();
            stats.endFlow();
            if (flow == null) {
                return RunnerResult.NOT_APPLICABLE;
            }
            if (Registry.is((String)"idea.dfa.live.variables.analysis")) {
                new LiveVariablesAnalyzer(flow, this.myValueFactory).flushDeadVariablesOnStatementFinish();
            }
            stats.endLVA();
            int[] loopNumber = LoopAnalyzer.calcInLoop(flow);
            this.initializeVariables(psiBlock, initialStates, flow);
            int endOffset = flow.getInstructionCount();
            this.myInstructions = flow.getInstructions();
            this.myNestedClosures.clear();
            this.myWasForciblyMerged = false;
            Set<Instruction> joinInstructions = this.getJoinInstructions();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Analyzing code block: " + psiBlock.getText());
                for (int i = 0; i < this.myInstructions.length; ++i) {
                    LOG.trace(i + ": " + this.myInstructions[i]);
                }
            }
            StateQueue queue = new StateQueue();
            for (DfaMemoryState dfaMemoryState : initialStates) {
                queue.offer(new DfaInstructionState(this.myInstructions[0], dfaMemoryState));
            }
            MultiMap processedStates = MultiMap.createSet();
            MultiMap multiMap = MultiMap.createSet();
            int stateLimit = Registry.intValue((String)"ide.dfa.state.limit");
            int count = 0;
            while (!queue.isEmpty()) {
                stats.startMerge();
                List<DfaInstructionState> states = queue.getNextInstructionStates(joinInstructions);
                stats.endMerge();
                if (states.size() > 300) {
                    LOG.trace("Too complex because too many different possible states");
                    return RunnerResult.TOO_COMPLEX;
                }
                Iterator<DfaInstructionState> iterator = states.iterator();
                while (iterator.hasNext()) {
                    DfaValue topValue;
                    DfaMemoryState memoryState;
                    Instruction instruction;
                    DfaInstructionState instructionState;
                    lastInstructionState = instructionState = iterator.next();
                    if (count++ > stateLimit) {
                        LOG.trace("Too complex data flow: too many instruction states processed");
                        return RunnerResult.TOO_COMPLEX;
                    }
                    ProgressManager.checkCanceled();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace(instructionState.toString());
                    }
                    if ((instruction = instructionState.getInstruction()) instanceof BranchingInstruction) {
                        BranchingInstruction branching = (BranchingInstruction)instruction;
                        Collection processed = processedStates.get((Object)branching);
                        if (DataFlowRunner.containsState(processed, instructionState)) continue;
                        if (processed.size() > 50) {
                            stats.startMerge();
                            instructionState = this.mergeBackBranches(instructionState, processed);
                            stats.endMerge();
                            if (DataFlowRunner.containsState(processed, instructionState)) continue;
                        }
                        if (processed.size() > 300) {
                            LOG.trace("Too complex because too many different possible states");
                            return RunnerResult.TOO_COMPLEX;
                        }
                        if (loopNumber[branching.getIndex()] != 0) {
                            processedStates.putValue((Object)branching, (Object)instructionState.getMemoryState().createCopy());
                        }
                    }
                    DfaInstructionState[] after = this.acceptInstruction(visitor, instructionState);
                    if (!(!LOG.isDebugEnabled() || !(instruction instanceof ControlTransferInstruction) || after.length != 0 || (memoryState = instructionState.getMemoryState()).isEmptyStack() || (topValue = memoryState.pop()) instanceof DfaControlTransferValue || psiBlock instanceof PsiCodeFragment && memoryState.isEmptyStack())) {
                        memoryState.push(topValue);
                        DataFlowRunner.reportDfaProblem(psiBlock, flow, instructionState, new RuntimeException("Stack is corrupted"));
                    }
                    for (DfaInstructionState state : after) {
                        Instruction nextInstruction = state.getInstruction();
                        if (nextInstruction.getIndex() >= endOffset) continue;
                        this.handleStepOutOfLoop(instruction, nextInstruction, loopNumber, (MultiMap<BranchingInstruction, DfaMemoryState>)processedStates, (MultiMap<BranchingInstruction, DfaMemoryState>)multiMap, states, after, queue);
                        if (nextInstruction instanceof BranchingInstruction) {
                            BranchingInstruction branching = (BranchingInstruction)nextInstruction;
                            if (DataFlowRunner.containsState(processedStates.get((Object)branching), state) || DataFlowRunner.containsState(multiMap.get((Object)branching), state)) continue;
                            if (loopNumber[branching.getIndex()] != 0) {
                                multiMap.putValue((Object)branching, (Object)state.getMemoryState().createCopy());
                            }
                        }
                        queue.offer(state);
                    }
                }
                if (!this.myCancelled) continue;
                return RunnerResult.CANCELLED;
            }
            LOG.trace("Analysis ok");
            this.myWasForciblyMerged |= queue.wasForciblyMerged();
            stats.endProcess();
            if (stats.isTooSlow()) {
                String message2 = "Too slow DFA\nIf you report this problem, please consider including the attachments\n" + stats + "\nControl flow size: " + flow.getInstructionCount();
                DataFlowRunner.reportDfaProblem(psiBlock, flow, null, new RuntimeException(message2));
            }
            return RunnerResult.OK;
        }
        catch (ProcessCanceledException ex) {
            throw ex;
        }
        catch (AssertionError | RuntimeException e) {
            DataFlowRunner.reportDfaProblem(psiBlock, flow, lastInstructionState, (Throwable)e);
            return RunnerResult.ABORTED;
        }
    }

    @NotNull
    private DfaInstructionState mergeBackBranches(DfaInstructionState instructionState, Collection<DfaMemoryState> processed) {
        DfaMemoryStateImpl curState = (DfaMemoryStateImpl)instructionState.getMemoryState();
        Object key2 = curState.getMergeabilityKey();
        DfaMemoryStateImpl mergedState = (DfaMemoryStateImpl)StreamEx.of(processed).select(DfaMemoryStateImpl.class).filterBy(DfaMemoryStateImpl::getMergeabilityKey, key2).foldLeft((Object)curState, (s1, s2) -> {
            s1.merge((DfaMemoryStateImpl)s2);
            return s1;
        });
        instructionState = new DfaInstructionState(instructionState.getInstruction(), mergedState);
        this.myWasForciblyMerged = true;
        return instructionState;
    }

    boolean wasForciblyMerged() {
        return this.myWasForciblyMerged;
    }

    @NotNull
    private Set<Instruction> getJoinInstructions() {
        HashSet joinInstructions = ContainerUtil.newHashSet();
        for (int index = 0; index < this.myInstructions.length; ++index) {
            Instruction instruction = this.myInstructions[index];
            if (instruction instanceof GotoInstruction) {
                joinInstructions.add(this.myInstructions[((GotoInstruction)instruction).getOffset()]);
                continue;
            }
            if (instruction instanceof ConditionalGotoInstruction) {
                joinInstructions.add(this.myInstructions[((ConditionalGotoInstruction)instruction).getOffset()]);
                continue;
            }
            if (instruction instanceof ControlTransferInstruction) {
                IntStreamEx.of(((ControlTransferInstruction)instruction).getPossibleTargetIndices()).elements((Object[])this.myInstructions).into((Collection)joinInstructions);
                continue;
            }
            if (!(instruction instanceof MethodCallInstruction) || ((MethodCallInstruction)instruction).getContracts().isEmpty()) continue;
            joinInstructions.add(this.myInstructions[index + 1]);
        }
        return joinInstructions;
    }

    private static void reportDfaProblem(@NotNull PsiElement psiBlock, ControlFlow flow, DfaInstructionState lastInstructionState, Throwable e) {
        Object[] attachments = new Attachment[]{new Attachment("method_body.txt", psiBlock.getText())};
        if (flow != null) {
            String flowText = flow.toString();
            if (lastInstructionState != null) {
                int index = lastInstructionState.getInstruction().getIndex();
                flowText = flowText.replaceAll("(?m)^", "  ");
                flowText = flowText.replaceFirst("(?m)^ {2}" + index + ": ", "* " + index + ": ");
            }
            attachments = (Attachment[])ArrayUtil.append((Object[])attachments, (Object)new Attachment("flow.txt", flowText));
            if (lastInstructionState != null) {
                DfaMemoryState memoryState = lastInstructionState.getMemoryState();
                String memStateText = null;
                try {
                    memStateText = memoryState.toString();
                }
                catch (RuntimeException second) {
                    e.addSuppressed(second);
                }
                if (memStateText != null) {
                    attachments = (Attachment[])ArrayUtil.append((Object[])attachments, (Object)new Attachment("memory_state.txt", memStateText));
                }
            }
        }
        LOG.error((Throwable)new RuntimeExceptionWithAttachments(e, (Attachment[])attachments));
    }

    public RunnerResult analyzeMethodRecursively(@NotNull PsiElement block, StandardInstructionVisitor visitor) {
        Collection<DfaMemoryState> states = this.createInitialStates(block, visitor, false);
        if (states == null) {
            return RunnerResult.NOT_APPLICABLE;
        }
        return this.analyzeBlockRecursively(block, states, visitor);
    }

    public RunnerResult analyzeBlockRecursively(@NotNull PsiElement block, Collection<? extends DfaMemoryState> states, StandardInstructionVisitor visitor) {
        RunnerResult result = this.analyzeMethod(block, visitor, false, states);
        if (result != RunnerResult.OK) {
            return result;
        }
        Ref ref = Ref.create((Object)((Object)RunnerResult.OK));
        this.forNestedClosures((closure, nestedStates) -> {
            RunnerResult res = this.analyzeBlockRecursively((PsiElement)closure, (Collection<? extends DfaMemoryState>)nestedStates, visitor);
            if (res != RunnerResult.OK) {
                ref.set((Object)res);
            }
        });
        return (RunnerResult)((Object)ref.get());
    }

    private void initializeVariables(@NotNull PsiElement psiBlock, @NotNull Collection<? extends DfaMemoryState> initialStates, ControlFlow flow) {
        if (psiBlock instanceof PsiClass) {
            DfaVariableValue thisValue = this.getFactory().getVarFactory().createThisValue((PsiClass)psiBlock);
            for (DfaMemoryState dfaMemoryState : initialStates) {
                dfaMemoryState.applyFact(thisValue, DfaFactType.LOCALITY, true);
            }
            return;
        }
        PsiElement parent = psiBlock.getParent();
        if (parent instanceof PsiMethod && !((PsiMethod)parent).isConstructor()) {
            Map initialValues = StreamEx.of(flow.accessedVariables()).mapToEntry(var -> DataFlowRunner.makeInitialValue(var, (PsiMethod)parent)).nonNullValues().toMap();
            for (DfaMemoryState dfaMemoryState : initialStates) {
                initialValues.forEach(dfaMemoryState::setVarValue);
            }
        }
    }

    @Nullable
    private static DfaValue makeInitialValue(DfaVariableValue var, @NotNull PsiMethod method) {
        DfaValueFactory factory = var.getFactory();
        if (var.getDescriptor() instanceof DfaExpressionFactory.ThisDescriptor) {
            PsiClass aClass = ((DfaExpressionFactory.ThisDescriptor)var.getDescriptor()).getPsiElement();
            DfaValue value2 = factory.createTypeValue(var.getType(), Nullability.NOT_NULL);
            if (method.getContainingClass() == aClass && MutationSignature.fromMethod(method).preservesThis()) {
                return factory.withFact(value2, DfaFactType.MUTABILITY, Mutability.UNMODIFIABLE_VIEW);
            }
            return null;
        }
        if (!DfaUtil.isEffectivelyUnqualified(var)) {
            return null;
        }
        PsiField field = (PsiField)ObjectUtils.tryCast((Object)var.getPsiVariable(), PsiField.class);
        if (field == null || DfaUtil.ignoreInitializer((PsiVariable)field) || DfaUtil.hasInitializationHacks(field)) {
            return null;
        }
        return DfaUtil.getPossiblyNonInitializedValue(factory, field, (PsiElement)method);
    }

    private static boolean containsState(Collection<DfaMemoryState> processed, DfaInstructionState instructionState) {
        if (processed.contains(instructionState.getMemoryState())) {
            return true;
        }
        for (DfaMemoryState state : processed) {
            if (!((DfaMemoryStateImpl)state).isSuperStateOf((DfaMemoryStateImpl)instructionState.getMemoryState())) continue;
            return true;
        }
        return false;
    }

    private void handleStepOutOfLoop(@NotNull Instruction prevInstruction, @NotNull Instruction nextInstruction, @NotNull int[] loopNumber, @NotNull MultiMap<BranchingInstruction, DfaMemoryState> processedStates, @NotNull MultiMap<BranchingInstruction, DfaMemoryState> incomingStates, @NotNull List<DfaInstructionState> inFlightStates, @NotNull DfaInstructionState[] afterStates, @NotNull StateQueue queue) {
        if (loopNumber[prevInstruction.getIndex()] == 0 || DataFlowRunner.inSameLoop(prevInstruction, nextInstruction, loopNumber)) {
            return;
        }
        for (DfaInstructionState state2 : inFlightStates) {
            Instruction instruction = state2.getInstruction();
            if (!DataFlowRunner.inSameLoop(prevInstruction, instruction, loopNumber)) continue;
            return;
        }
        for (DfaInstructionState state3 : afterStates) {
            Instruction instruction = state3.getInstruction();
            if (!DataFlowRunner.inSameLoop(prevInstruction, instruction, loopNumber)) continue;
            return;
        }
        if (!queue.processAll((Processor<? super DfaInstructionState>)((Processor)state -> {
            Instruction instruction = state.getInstruction();
            return !DataFlowRunner.inSameLoop(prevInstruction, instruction, loopNumber);
        }))) {
            return;
        }
        THashSet mayRemoveStatesFor = new THashSet();
        for (Instruction instruction : this.myInstructions) {
            if (!DataFlowRunner.inSameLoop(prevInstruction, instruction, loopNumber) || !(instruction instanceof BranchingInstruction)) continue;
            mayRemoveStatesFor.add((BranchingInstruction)instruction);
        }
        for (Instruction instruction : mayRemoveStatesFor) {
            processedStates.remove((Object)((BranchingInstruction)instruction));
            incomingStates.remove((Object)((BranchingInstruction)instruction));
        }
    }

    private static boolean inSameLoop(@NotNull Instruction prevInstruction, @NotNull Instruction nextInstruction, @NotNull int[] loopNumber) {
        return loopNumber[nextInstruction.getIndex()] == loopNumber[prevInstruction.getIndex()];
    }

    @NotNull
    protected DfaInstructionState[] acceptInstruction(@NotNull InstructionVisitor visitor, @NotNull DfaInstructionState instructionState) {
        Instruction instruction = instructionState.getInstruction();
        DfaInstructionState[] states = instruction.accept(this, instructionState.getMemoryState(), visitor);
        PsiElement closure = DfaUtil.getClosureInside(instruction);
        if (closure instanceof PsiClass) {
            this.registerNestedClosures(instructionState, (PsiClass)closure);
        } else if (closure instanceof PsiLambdaExpression) {
            this.registerNestedClosures(instructionState, (PsiLambdaExpression)closure);
        }
        return states;
    }

    private void registerNestedClosures(@NotNull DfaInstructionState instructionState, @NotNull PsiClass nestedClass) {
        DfaMemoryState state = instructionState.getMemoryState();
        for (PsiMethod psiMethod : nestedClass.getMethods()) {
            PsiCodeBlock body2 = psiMethod.getBody();
            if (body2 == null || !psiMethod.isPhysical() && nestedClass.isPhysical()) continue;
            this.createClosureState((PsiElement)body2, state);
        }
        for (PsiMethod psiMethod : nestedClass.getInitializers()) {
            this.createClosureState((PsiElement)psiMethod.getBody(), state);
        }
        for (PsiMethod psiMethod : nestedClass.getFields()) {
            this.createClosureState((PsiElement)psiMethod, state);
        }
    }

    private void registerNestedClosures(@NotNull DfaInstructionState instructionState, @NotNull PsiLambdaExpression expr) {
        DfaMemoryState state = instructionState.getMemoryState();
        PsiElement body2 = expr.getBody();
        if (body2 != null) {
            this.createClosureState(body2, state);
        }
    }

    private void createClosureState(PsiElement anchor, DfaMemoryState state) {
        this.myNestedClosures.putValue((Object)anchor, (Object)state.createClosureState());
    }

    @NotNull
    protected DfaMemoryState createMemoryState() {
        return new DfaMemoryStateImpl(this.myValueFactory);
    }

    @NotNull
    public Instruction[] getInstructions() {
        return this.myInstructions;
    }

    @NotNull
    public Instruction getInstruction(int index) {
        return this.myInstructions[index];
    }

    public void forNestedClosures(BiConsumer<? super PsiElement, ? super Collection<? extends DfaMemoryState>> consumer) {
        MultiMap closures = new MultiMap(this.myNestedClosures);
        for (PsiElement closure : closures.keySet()) {
            List unusedVars = ((StreamEx)((StreamEx)StreamEx.of(this.getFactory().getValues()).select(DfaVariableValue.class).filter(var -> var.getQualifier() == null)).filter(var -> var.getPsiVariable() instanceof PsiVariable && !VariableAccessUtils.variableIsUsed((PsiVariable)var.getPsiVariable(), closure))).toList();
            List<DfaMemoryStateImpl> states = closures.get((Object)closure);
            if (!unusedVars.isEmpty()) {
                List stateList = ((StreamEx)((StreamEx)StreamEx.of((Collection)states).peek(state -> unusedVars.forEach(state::flushVariable))).map(state -> (DfaMemoryStateImpl)state).distinct()).toList();
                states = StateQueue.mergeGroup(stateList);
            }
            consumer.accept((PsiElement)closure, states);
        }
    }

    @NotNull
    public Pair<Set<Instruction>, Set<Instruction>> getConstConditionalExpressions() {
        BranchingInstruction branchingInstruction;
        HashSet<BranchingInstruction> trueSet = new HashSet<BranchingInstruction>();
        HashSet<BranchingInstruction> falseSet = new HashSet<BranchingInstruction>();
        for (Instruction instruction : this.myInstructions) {
            if (!(instruction instanceof BranchingInstruction) || (branchingInstruction = (BranchingInstruction)instruction).getPsiAnchor() == null || !branchingInstruction.isConditionConst()) continue;
            if (!branchingInstruction.isTrueReachable()) {
                falseSet.add(branchingInstruction);
            }
            if (branchingInstruction.isFalseReachable()) continue;
            trueSet.add(branchingInstruction);
        }
        for (Instruction instruction : this.myInstructions) {
            if (!(instruction instanceof BranchingInstruction)) continue;
            branchingInstruction = (BranchingInstruction)instruction;
            if (branchingInstruction.isTrueReachable()) {
                falseSet.remove(branchingInstruction);
            }
            if (!branchingInstruction.isFalseReachable()) continue;
            trueSet.remove(branchingInstruction);
        }
        return Pair.create(trueSet, falseSet);
    }

    private static class TimeStats {
        private static final long DFA_EXECUTION_TIME_TO_REPORT_NANOS = TimeUnit.SECONDS.toNanos(30L);
        @Nullable
        private final ThreadMXBean myMxBean;
        private final long myStart;
        private long myMergeStart;
        private long myFlowTime;
        private long myLVATime;
        private long myMergeTime;
        private long myProcessTime;

        TimeStats() {
            Application application = ApplicationManager.getApplication();
            if (application.isInternal() || application.isEAP()) {
                this.myMxBean = ManagementFactory.getThreadMXBean();
                this.myStart = this.myMxBean.getCurrentThreadCpuTime();
            } else {
                this.myMxBean = null;
                this.myStart = 0L;
            }
        }

        void endFlow() {
            if (this.myMxBean != null) {
                this.myFlowTime = this.myMxBean.getCurrentThreadCpuTime() - this.myStart;
            }
        }

        void endLVA() {
            if (this.myMxBean != null) {
                this.myLVATime = this.myMxBean.getCurrentThreadCpuTime() - this.myStart - this.myFlowTime;
            }
        }

        void startMerge() {
            if (this.myMxBean != null) {
                this.myMergeStart = System.nanoTime();
            }
        }

        void endMerge() {
            if (this.myMxBean != null) {
                this.myMergeTime += System.nanoTime() - this.myMergeStart;
            }
        }

        void endProcess() {
            if (this.myMxBean != null) {
                this.myProcessTime = this.myMxBean.getCurrentThreadCpuTime() - this.myStart;
            }
        }

        boolean isTooSlow() {
            return this.myProcessTime > DFA_EXECUTION_TIME_TO_REPORT_NANOS;
        }

        public String toString() {
            double flowTime = (double)this.myFlowTime / 1.0E9;
            double lvaTime = (double)this.myLVATime / 1.0E9;
            double mergeTime = (double)this.myMergeTime / 1.0E9;
            double interpretTime = (double)(this.myProcessTime - this.myFlowTime - this.myLVATime - this.myMergeTime) / 1.0E9;
            double totalTime = (double)this.myProcessTime / 1.0E9;
            String format = "Building ControlFlow: %.2fs\nLiveVariableAnalyzer: %.2fs\nMerging states: %.2fs\nInterpreting: %.2fs\nTotal: %.2fs";
            return String.format(Locale.ENGLISH, format, flowTime, lvaTime, mergeTime, interpretTime, totalTime);
        }
    }
}

