/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.util.keyFMap.KeyFMap;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DfaFactMap {
    public static final DfaFactMap EMPTY = new DfaFactMap(KeyFMap.EMPTY_MAP);
    @NotNull
    private final KeyFMap myMap;

    private DfaFactMap(@NotNull KeyFMap map2) {
        this.myMap = map2;
    }

    @Nullable
    public <T> T get(@NotNull DfaFactType<T> type2) {
        return (T)this.myMap.get(type2);
    }

    @NotNull
    public <T> DfaFactMap with(@NotNull DfaFactType<T> type2, @Nullable T value2) {
        KeyFMap newMap = value2 == null || type2.isUnknown(value2) ? this.myMap.minus(type2) : this.myMap.plus(type2, value2);
        return newMap == this.myMap ? this : new DfaFactMap(newMap);
    }

    public boolean isSuperStateOf(DfaFactMap subMap) {
        for (DfaFactType<?> key2 : DfaFactType.getTypes()) {
            Object other;
            Object thisValue;
            DfaFactType<?> type2 = key2;
            if (type2.isSuper(thisValue = this.myMap.get(type2), other = subMap.get(type2))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public <T> DfaFactMap intersect(@NotNull DfaFactType<T> type2, @Nullable T value2) {
        if (value2 == null || type2.isUnknown(value2)) {
            return this;
        }
        T curFact = this.get(type2);
        if (curFact == null) {
            return this.with(type2, value2);
        }
        T newFact = type2.intersectFacts(curFact, value2);
        return newFact == null ? null : this.with(type2, newFact);
    }

    private <TT> DfaFactMap intersect(@NotNull DfaFactMap otherMap, @NotNull DfaFactType<TT> type2) {
        return this.intersect(type2, otherMap.get(type2));
    }

    @Nullable
    public DfaFactMap intersect(@NotNull DfaFactMap other) {
        DfaFactMap result = this;
        List<DfaFactType<?>> types = DfaFactType.getTypes();
        for (DfaFactType<?> type2 : types) {
            if ((result = result.intersect(other, type2)) != null) continue;
            return null;
        }
        return result;
    }

    @NotNull
    public <T> DfaFactMap unite(@NotNull DfaFactType<T> type2, @Nullable T value2) {
        if (value2 == null) {
            return this.with(type2, null);
        }
        T curFact = this.get(type2);
        if (curFact == null) {
            return this;
        }
        T newFact = type2.uniteFacts(curFact, value2);
        return this.with(type2, newFact);
    }

    @NotNull
    private <TT> DfaFactMap unite(DfaFactMap otherMap, @NotNull DfaFactType<TT> type2) {
        return this.unite(type2, otherMap.get(type2));
    }

    @NotNull
    public DfaFactMap unite(@NotNull DfaFactMap other) {
        return (DfaFactMap)StreamEx.of(DfaFactType.getTypes()).foldLeft((Object)this, (map2, type2) -> map2.unite(other, (DfaFactType)((Object)type2)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof DfaFactMap && this.myMap.equals(((DfaFactMap)o).myMap);
    }

    public int hashCode() {
        return this.myMap.hashCode();
    }

    public String toString() {
        return this.facts(DfaFactType::toString).joining((CharSequence)", ");
    }

    public <R> StreamEx<R> facts(FactMapper<? extends R> mapper) {
        return StreamEx.of((Object[])this.myMap.getKeys()).map(f -> {
            DfaFactType key2 = (DfaFactType)((Object)f);
            Object value2 = this.myMap.get(f);
            return mapper.apply(key2, value2);
        });
    }

    public static DfaFactMap calcFromVariable(@NotNull DfaVariableValue value2) {
        return (DfaFactMap)StreamEx.of(DfaFactType.getTypes()).foldLeft((Object)EMPTY, (factMap, type2) -> DfaFactMap.updateMap(factMap, type2, value2));
    }

    private static <T> DfaFactMap updateMap(DfaFactMap map2, DfaFactType<T> factType, DfaVariableValue value2) {
        return map2.with(factType, factType.calcFromVariable(value2));
    }

    @NotNull
    public static DfaFactMap fromDfaValue(DfaValue value2) {
        return (DfaFactMap)StreamEx.of(DfaFactType.getTypes()).foldLeft((Object)EMPTY, (map2, type2) -> DfaFactMap.updateMap(map2, type2, value2));
    }

    private static <T> DfaFactMap updateMap(DfaFactMap map2, DfaFactType<T> factType, DfaValue value2) {
        return map2.with(factType, factType.fromDfaValue(value2));
    }

    @FunctionalInterface
    public static interface FactMapper<R> {
        public <T> R apply(DfaFactType<T> var1, T var2);
    }
}

