/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.SpecialFieldValue;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.value.DfaBinOpValue;
import com.intellij.codeInspection.dataFlow.value.DfaBoxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaFactMapValue;
import com.intellij.codeInspection.dataFlow.value.DfaPsiType;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DfaFactType<T>
extends Key<T> {
    private static final List<DfaFactType<?>> ourFactTypes = new ArrayList();
    public static final DfaFactType<DfaNullability> NULLABILITY = new DfaFactType<DfaNullability>("Nullability"){

        @Override
        @NotNull
        public String toString(@NotNull DfaNullability fact) {
            return fact.getInternalName();
        }

        @Override
        boolean isUnknown(@NotNull DfaNullability fact) {
            return fact == DfaNullability.UNKNOWN;
        }

        @Override
        @NotNull
        public String getPresentationText(@NotNull DfaNullability fact, @Nullable PsiType type2) {
            if (type2 instanceof PsiPrimitiveType) {
                return "";
            }
            return fact.getPresentationName();
        }

        @Override
        boolean isSuper(@Nullable DfaNullability superFact, @Nullable DfaNullability subFact) {
            return superFact == null && (subFact == DfaNullability.NOT_NULL || subFact == DfaNullability.FLUSHED) || super.isSuper(superFact, subFact);
        }

        @Override
        @NotNull
        DfaNullability uniteFacts(@NotNull DfaNullability left, @NotNull DfaNullability right) {
            if (left == right) {
                return left;
            }
            if (left == DfaNullability.NULL || right == DfaNullability.NULL) {
                return DfaNullability.UNKNOWN;
            }
            return DfaNullability.FLUSHED;
        }

        @Override
        @Nullable
        DfaNullability intersectFacts(@NotNull DfaNullability left, @NotNull DfaNullability right) {
            if (left == DfaNullability.NOT_NULL || right == DfaNullability.NOT_NULL) {
                return DfaNullability.NOT_NULL;
            }
            if (left == DfaNullability.FLUSHED && DfaNullability.toNullability(right) == Nullability.NULLABLE || right == DfaNullability.FLUSHED && DfaNullability.toNullability(left) == Nullability.NULLABLE) {
                return DfaNullability.NULLABLE;
            }
            return super.intersectFacts(left, right);
        }

        @Override
        @Nullable
        public DfaNullability fromDfaValue(DfaValue value2) {
            if (value2 instanceof DfaConstValue) {
                return ((DfaConstValue)value2).getValue() == null ? DfaNullability.NULL : DfaNullability.NOT_NULL;
            }
            if (value2 instanceof DfaBoxedValue) {
                return DfaNullability.NOT_NULL;
            }
            if (value2 instanceof DfaFactMapValue && ((DfaFactMapValue)value2).get(RANGE) != null) {
                return DfaNullability.NOT_NULL;
            }
            return (DfaNullability)((Object)super.fromDfaValue(value2));
        }

        @Override
        @Nullable
        DfaNullability calcFromVariable(@NotNull DfaVariableValue value2) {
            return NullabilityUtil.calcCanBeNull(value2);
        }
    };
    public static final DfaFactType<Mutability> MUTABILITY = new DfaFactType<Mutability>("Mutability"){

        @Override
        boolean isUnknown(@NotNull Mutability fact) {
            return fact == Mutability.UNKNOWN;
        }

        @Override
        @NotNull
        Mutability uniteFacts(@NotNull Mutability left, @NotNull Mutability right) {
            return left.unite(right);
        }

        @Override
        @NotNull
        Mutability calcFromVariable(@NotNull DfaVariableValue value2) {
            PsiModifierListOwner variable = value2.getPsiVariable();
            return variable == null ? Mutability.UNKNOWN : Mutability.getMutability(variable);
        }
    };
    public static final DfaFactType<LongRangeSet> RANGE = new DfaFactType<LongRangeSet>("Range"){

        @Override
        boolean isSuper(@Nullable LongRangeSet superFact, @Nullable LongRangeSet subFact) {
            return superFact == null || subFact != null && superFact.contains(subFact);
        }

        @Override
        boolean isUnknown(@NotNull LongRangeSet fact) {
            return LongRangeSet.all().equals(fact);
        }

        @Override
        @Nullable
        public LongRangeSet fromDfaValue(DfaValue value2) {
            if (value2 instanceof DfaVariableValue) {
                return this.calcFromVariable((DfaVariableValue)value2);
            }
            if (value2 instanceof DfaBinOpValue) {
                DfaBinOpValue binOp = (DfaBinOpValue)value2;
                LongRangeSet left = this.fromDfaValue(binOp.getLeft());
                LongRangeSet right = this.fromDfaValue(binOp.getRight());
                if (left != null && right != null) {
                    return left.binOpFromToken(binOp.getTokenType(), right, PsiType.LONG.equals((Object)binOp.getType()));
                }
            }
            return LongRangeSet.fromDfaValue(value2);
        }

        @Override
        @Nullable
        LongRangeSet calcFromVariable(@NotNull DfaVariableValue var) {
            DfaValue defaultValue;
            LongRangeSet fromSpecialField;
            VariableDescriptor descriptor = var.getDescriptor();
            if (descriptor instanceof SpecialField && (fromSpecialField = LongRangeSet.fromDfaValue(defaultValue = ((SpecialField)descriptor).getDefaultValue(var.getFactory(), false))) != null) {
                return fromSpecialField;
            }
            LongRangeSet fromType = LongRangeSet.fromType(var.getType());
            return fromType == null ? null : LongRangeSet.fromPsiElement(var.getPsiVariable()).intersect(fromType);
        }

        @Override
        @Nullable
        LongRangeSet uniteFacts(@NotNull LongRangeSet left, @NotNull LongRangeSet right) {
            return left.unite(right);
        }

        @Override
        @Nullable
        LongRangeSet intersectFacts(@NotNull LongRangeSet left, @NotNull LongRangeSet right) {
            LongRangeSet intersection = left.intersect(right);
            return intersection.isEmpty() ? null : intersection;
        }

        @Override
        @NotNull
        public String getPresentationText(@NotNull LongRangeSet fact, @Nullable PsiType type2) {
            LongRangeSet fromType = LongRangeSet.fromType(type2);
            if (fact.equals(fromType)) {
                return "";
            }
            return fact.toString();
        }
    };
    public static final DfaFactType<TypeConstraint> TYPE_CONSTRAINT = new DfaFactType<TypeConstraint>("Constraints"){

        @Override
        boolean isSuper(@Nullable TypeConstraint superFact, @Nullable TypeConstraint subFact) {
            return superFact == null || subFact != null && superFact.isSuperStateOf(subFact);
        }

        @Override
        @Nullable
        TypeConstraint calcFromVariable(@NotNull DfaVariableValue value2) {
            PsiType psiType = value2.getType();
            DfaPsiType type2 = psiType == null ? null : value2.getFactory().createDfaType(psiType);
            return type2 == null ? null : TypeConstraint.empty().withInstanceofValue(type2);
        }

        @Override
        boolean isUnknown(@NotNull TypeConstraint fact) {
            return fact.isEmpty();
        }

        @Override
        @Nullable
        TypeConstraint intersectFacts(@NotNull TypeConstraint left, @NotNull TypeConstraint right) {
            return left.intersect(right);
        }

        @Override
        @Nullable
        TypeConstraint uniteFacts(@NotNull TypeConstraint left, @NotNull TypeConstraint right) {
            return left.unite(right);
        }

        @Override
        @NotNull
        public String getPresentationText(@NotNull TypeConstraint fact, @Nullable PsiType type2) {
            return fact.getPresentationText(type2);
        }
    };
    public static final DfaFactType<Boolean> LOCALITY = new DfaFactType<Boolean>("Locality"){

        @Override
        boolean isUnknown(@NotNull Boolean fact) {
            return fact == false;
        }

        @Override
        @NotNull
        public String toString(@NotNull Boolean fact) {
            return fact != false ? "local object" : "";
        }
    };
    public static final DfaFactType<SpecialFieldValue> SPECIAL_FIELD_VALUE = new DfaFactType<SpecialFieldValue>("Special field value"){

        @Override
        @NotNull
        public String getName(SpecialFieldValue fact) {
            return fact == null ? super.getName(null) : StringUtil.wordsToBeginFromUpperCase((String)fact.getField().toString());
        }

        @Override
        @Nullable
        SpecialFieldValue uniteFacts(@NotNull SpecialFieldValue left, @NotNull SpecialFieldValue right) {
            return left.unite(right);
        }

        @Override
        @NotNull
        public String getPresentationText(@NotNull SpecialFieldValue fact, @Nullable PsiType type2) {
            return fact.getPresentationText(type2);
        }
    };
    @NotNull
    private final String myName;

    private DfaFactType(@NotNull String name) {
        super("DfaFactType: " + name);
        this.myName = name;
        ourFactTypes.add(this);
    }

    @NotNull
    public String getName(T fact) {
        return this.myName;
    }

    @Nullable
    public T fromDfaValue(DfaValue value2) {
        return value2 instanceof DfaFactMapValue ? (T)((DfaFactMapValue)value2).get(this) : null;
    }

    @Nullable
    T calcFromVariable(@NotNull DfaVariableValue value2) {
        return null;
    }

    boolean isSuper(@Nullable T superFact, @Nullable T subFact) {
        return Objects.equals(superFact, subFact);
    }

    boolean isUnknown(@NotNull T fact) {
        return false;
    }

    @Nullable
    T intersectFacts(@NotNull T left, @NotNull T right) {
        return (T)(left.equals(right) ? left : null);
    }

    @Nullable
    T uniteFacts(@NotNull T left, @NotNull T right) {
        return (T)(left.equals(right) ? left : null);
    }

    @NotNull
    public String toString(@NotNull T fact) {
        return fact.toString();
    }

    @NotNull
    public String getPresentationText(@NotNull T fact, @Nullable PsiType type2) {
        return this.toString(fact);
    }

    static List<DfaFactType<?>> getTypes() {
        return Collections.unmodifiableList(ourFactTypes);
    }
}

