/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.DfaFactMap;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum DfaNullability {
    NULL("Null", "null", Nullability.NULLABLE),
    NULLABLE("Nullable", "nullable", Nullability.NULLABLE),
    NOT_NULL("Not-null", "non-null", Nullability.NOT_NULL),
    UNKNOWN("Unknown", "", Nullability.UNKNOWN),
    FLUSHED("Flushed", "", Nullability.UNKNOWN);

    @NotNull
    private final String myInternalName;
    @NotNull
    private final String myPresentationalName;
    @NotNull
    private final Nullability myNullability;

    private DfaNullability(@NotNull String internalName, String presentationalName, Nullability nullability) {
        this.myInternalName = internalName;
        this.myPresentationalName = presentationalName;
        this.myNullability = nullability;
    }

    @NotNull
    public String getInternalName() {
        return this.myInternalName;
    }

    @NotNull
    public String getPresentationName() {
        return this.myPresentationalName;
    }

    public static boolean isNullable(DfaFactMap map2) {
        return DfaNullability.toNullability(map2.get(DfaFactType.NULLABILITY)) == Nullability.NULLABLE;
    }

    public static boolean isNotNull(DfaFactMap map2) {
        return map2.get(DfaFactType.NULLABILITY) == NOT_NULL;
    }

    @NotNull
    public static Nullability toNullability(@Nullable DfaNullability dfaNullability) {
        return dfaNullability == null ? Nullability.UNKNOWN : dfaNullability.myNullability;
    }

    @NotNull
    public static DfaNullability fromNullability(@NotNull Nullability nullability) {
        switch (nullability) {
            case NOT_NULL: {
                return NOT_NULL;
            }
            case NULLABLE: {
                return NULLABLE;
            }
            case UNKNOWN: {
                return UNKNOWN;
            }
        }
        throw new IllegalStateException("Unknown nullability: " + nullability);
    }
}

