/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.ExpressionUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.StandardDataFlowRunner;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.ValuableDataFlowRunner;
import com.intellij.codeInspection.dataFlow.inference.InferenceFromSourceUtil;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.EmptyInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.LambdaInstruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaBoxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaExpressionFactory;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameterListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaUtil {
    private static final Object UNKNOWN_VALUE = ObjectUtils.sentinel((String)"UNKNOWN_VALUE");

    @Nullable(value="null means DFA analysis has failed (too complex to analyze)")
    public static Collection<PsiExpression> getCachedVariableValues(@Nullable PsiVariable variable, @Nullable PsiElement context) {
        Collection concatenations;
        if (variable == null || context == null) {
            return Collections.emptyList();
        }
        PsiElement codeBlock = DfaPsiUtil.getEnclosingCodeBlock(variable, context);
        if (codeBlock == null) {
            return Collections.emptyList();
        }
        Map<PsiElement, ValuableInstructionVisitor.PlaceResult> value2 = DfaUtil.getCachedPlaceResults(codeBlock);
        if (value2 == null) {
            return null;
        }
        ValuableInstructionVisitor.PlaceResult placeResult = value2.get(context);
        Collection collection = concatenations = placeResult == null ? null : placeResult.myValues.get((Object)variable);
        if (concatenations != null) {
            return ContainerUtil.map((Collection)concatenations, DfaUtil::concatenateExpressions);
        }
        return Collections.emptyList();
    }

    @Nullable(value="null means DFA analysis has failed (too complex to analyze)")
    private static Map<PsiElement, ValuableInstructionVisitor.PlaceResult> getCachedPlaceResults(@NotNull PsiElement codeBlock) {
        return (Map)CachedValuesManager.getCachedValue((PsiElement)codeBlock, () -> {
            ValuableInstructionVisitor visitor = new ValuableInstructionVisitor();
            RunnerResult runnerResult = new ValuableDataFlowRunner().analyzeMethod(codeBlock, visitor);
            return CachedValueProvider.Result.create(runnerResult == RunnerResult.OK ? visitor.myResults : null, (Object[])new Object[]{codeBlock});
        });
    }

    @Deprecated
    @NotNull
    public static Nullness checkNullness(@Nullable PsiVariable variable, @Nullable PsiElement context) {
        return Nullness.fromNullability(DfaUtil.checkNullability(variable, context));
    }

    @NotNull
    public static Nullability checkNullability(@Nullable PsiVariable variable, @Nullable PsiElement context) {
        Nullability nullability = DfaUtil.tryCheckNullability(variable, context, null);
        return nullability != null ? nullability : Nullability.UNKNOWN;
    }

    @Nullable(value="null means DFA analysis has failed (too complex to analyze)")
    public static Nullability tryCheckNullability(@Nullable PsiVariable variable, @Nullable PsiElement context, @Nullable PsiElement outerBlock) {
        ValuableInstructionVisitor.PlaceResult placeResult;
        if (variable == null || context == null) {
            return null;
        }
        PsiElement codeBlock = outerBlock == null ? DfaPsiUtil.getEnclosingCodeBlock(variable, context) : outerBlock;
        Map<PsiElement, ValuableInstructionVisitor.PlaceResult> results = codeBlock == null ? null : DfaUtil.getCachedPlaceResults(codeBlock);
        ValuableInstructionVisitor.PlaceResult placeResult2 = placeResult = results == null ? null : results.get(context);
        if (placeResult == null) {
            return null;
        }
        if (placeResult.myNulls.contains(variable) && !placeResult.myNotNulls.contains(variable)) {
            return Nullability.NULLABLE;
        }
        if (placeResult.myNotNulls.contains(variable) && !placeResult.myNulls.contains(variable)) {
            return Nullability.NOT_NULL;
        }
        return Nullability.UNKNOWN;
    }

    @NotNull
    public static Collection<PsiExpression> getPossibleInitializationElements(@NotNull PsiElement qualifierExpression2) {
        if (qualifierExpression2 instanceof PsiMethodCallExpression) {
            return Collections.singletonList((PsiMethodCallExpression)qualifierExpression2);
        }
        if (qualifierExpression2 instanceof PsiReferenceExpression) {
            PsiElement targetElement = ((PsiReferenceExpression)qualifierExpression2).resolve();
            if (!(targetElement instanceof PsiVariable)) {
                return Collections.emptyList();
            }
            Collection<PsiExpression> variableValues = DfaUtil.getCachedVariableValues((PsiVariable)targetElement, qualifierExpression2);
            if (variableValues == null || variableValues.isEmpty()) {
                return DfaPsiUtil.getVariableAssignmentsInFile((PsiVariable)targetElement, false, qualifierExpression2);
            }
            return variableValues;
        }
        if (qualifierExpression2 instanceof PsiLiteralExpression) {
            return Collections.singletonList((PsiLiteralExpression)qualifierExpression2);
        }
        return Collections.emptyList();
    }

    @Nullable
    static PsiElement getClosureInside(Instruction instruction) {
        if (instruction instanceof MethodCallInstruction) {
            PsiCall anchor = ((MethodCallInstruction)instruction).getCallExpression();
            if (anchor instanceof PsiNewExpression) {
                return ((PsiNewExpression)anchor).getAnonymousClass();
            }
        } else {
            PsiElement anchor;
            if (instruction instanceof LambdaInstruction) {
                return ((LambdaInstruction)instruction).getLambdaExpression();
            }
            if (instruction instanceof EmptyInstruction && (anchor = ((EmptyInstruction)instruction).getAnchor()) instanceof PsiClass) {
                return anchor;
            }
        }
        return null;
    }

    @Deprecated
    @NotNull
    public static Nullness inferMethodNullity(PsiMethod method) {
        return Nullness.fromNullability(DfaUtil.inferMethodNullability(method));
    }

    @NotNull
    public static Nullability inferMethodNullability(PsiMethod method) {
        if (PsiUtil.resolveClassInType((PsiType)method.getReturnType()) == null) {
            return Nullability.UNKNOWN;
        }
        return DfaUtil.inferBlockNullability((PsiParameterListOwner)method, InferenceFromSourceUtil.suppressNullable(method));
    }

    @NotNull
    public static Nullability inferLambdaNullability(PsiLambdaExpression lambda2) {
        if (LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)lambda2) == null) {
            return Nullability.UNKNOWN;
        }
        return DfaUtil.inferBlockNullability((PsiParameterListOwner)lambda2, false);
    }

    @NotNull
    private static Nullability inferBlockNullability(PsiParameterListOwner owner, boolean suppressNullable) {
        PsiElement body2 = owner.getBody();
        if (body2 == null) {
            return Nullability.UNKNOWN;
        }
        StandardDataFlowRunner dfaRunner = new StandardDataFlowRunner();
        class BlockNullabilityVisitor
        extends StandardInstructionVisitor {
            boolean hasNulls = false;
            boolean hasNotNulls = false;
            boolean hasUnknowns = false;
            final /* synthetic */ PsiParameterListOwner val$owner;

            BlockNullabilityVisitor(PsiParameterListOwner psiParameterListOwner) {
                this.val$owner = psiParameterListOwner;
            }

            @Override
            protected void checkReturnValue(@NotNull DfaValue value2, @NotNull PsiExpression expression2, @NotNull PsiParameterListOwner context, @NotNull DfaMemoryState state) {
                if (context == this.val$owner) {
                    if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)expression2.getType()) || state.isNotNull(value2)) {
                        this.hasNotNulls = true;
                    } else if (state.isNull(value2)) {
                        this.hasNulls = true;
                    } else {
                        this.hasUnknowns = true;
                    }
                }
            }
        }
        BlockNullabilityVisitor visitor = new BlockNullabilityVisitor(owner);
        RunnerResult rc = dfaRunner.analyzeMethod(body2, visitor);
        if (rc == RunnerResult.OK) {
            if (visitor.hasNulls) {
                return suppressNullable ? Nullability.UNKNOWN : Nullability.NULLABLE;
            }
            if (visitor.hasNotNulls && !visitor.hasUnknowns) {
                return Nullability.NOT_NULL;
            }
        }
        return Nullability.UNKNOWN;
    }

    static DfaValue getPossiblyNonInitializedValue(@NotNull DfaValueFactory factory, @NotNull PsiField target, @NotNull PsiElement context) {
        if (target.getType() instanceof PsiPrimitiveType) {
            return null;
        }
        PsiMethod placeMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)context, PsiMethod.class, (boolean)false, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
        if (placeMethod == null) {
            return null;
        }
        PsiClass placeClass = placeMethod.getContainingClass();
        if (placeClass == null || placeClass != target.getContainingClass()) {
            return null;
        }
        if (!placeMethod.hasModifierProperty("static") && target.hasModifierProperty("static")) {
            return null;
        }
        if (DfaUtil.getAccessOffset(placeMethod) >= DfaUtil.getWriteOffset(target)) {
            return null;
        }
        return factory.createTypeValue(target.getType(), Nullability.NULLABLE);
    }

    private static int getWriteOffset(PsiField target) {
        boolean isFinal = target.hasModifierProperty("final");
        int offset = Integer.MAX_VALUE;
        if (target.getInitializer() != null) {
            offset = target.getInitializer().getTextRange().getStartOffset();
            if (isFinal) {
                return offset;
            }
        }
        PsiClass aClass = Objects.requireNonNull(target.getContainingClass());
        PsiClassInitializer[] initializers = aClass.getInitializers();
        Predicate<PsiElement> writesToTarget = element -> !PsiTreeUtil.processElements((PsiElement)element, e -> !(e instanceof PsiExpression) || !PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)e)) || !ExpressionUtils.isReferenceTo((PsiExpression)e, (PsiVariable)target));
        Predicate<PsiElement> hasSideEffectCall = element -> !PsiTreeUtil.findChildrenOfType((PsiElement)element, PsiMethodCallExpression.class).stream().map(PsiCall::resolveMethod).allMatch(method -> method != null && JavaMethodContractUtil.isPure(method));
        for (PsiClassInitializer psiClassInitializer : initializers) {
            if (psiClassInitializer.hasModifierProperty("static") != target.hasModifierProperty("static")) continue;
            if (!isFinal && hasSideEffectCall.test((PsiElement)psiClassInitializer)) {
                offset = Math.min(offset, psiClassInitializer.getTextRange().getStartOffset());
                break;
            }
            if (!writesToTarget.test((PsiElement)psiClassInitializer)) continue;
            offset = Math.min(offset, psiClassInitializer.getTextRange().getStartOffset());
            if (!isFinal) break;
            return offset;
        }
        if (!isFinal) {
            for (PsiClassInitializer psiClassInitializer : aClass.getFields()) {
                if (psiClassInitializer.hasModifierProperty("static") != target.hasModifierProperty("static") || !hasSideEffectCall.test((PsiElement)psiClassInitializer.getInitializer()) && !writesToTarget.test((PsiElement)psiClassInitializer)) continue;
                offset = Math.min(offset, psiClassInitializer.getTextRange().getStartOffset());
                break;
            }
        }
        return offset;
    }

    private static int getAccessOffset(PsiMethod referrer) {
        PsiClass aClass = Objects.requireNonNull(referrer.getContainingClass());
        boolean isStatic = referrer.hasModifierProperty("static");
        for (PsiField field : aClass.getFields()) {
            Predicate<PsiExpression> callToMethod;
            PsiExpression initializer;
            if (field.hasModifierProperty("static") != isStatic || !ExpressionUtils.isMatchingChildAlwaysExecuted(initializer = field.getInitializer(), callToMethod = e -> {
                if (!(e instanceof PsiMethodCallExpression)) {
                    return false;
                }
                PsiMethodCallExpression call = (PsiMethodCallExpression)e;
                return call.getMethodExpression().isReferenceTo((PsiElement)referrer) && (isStatic || ExpressionUtil.isEffectivelyUnqualified(call.getMethodExpression()));
            })) continue;
            return field.getTextRange().getStartOffset();
        }
        return Integer.MAX_VALUE;
    }

    public static boolean hasInitializationHacks(@NotNull PsiField field) {
        PsiClass containingClass = field.getContainingClass();
        return containingClass != null && System.class.getName().equals(containingClass.getQualifiedName());
    }

    public static boolean ignoreInitializer(PsiVariable variable) {
        if (variable instanceof PsiField && variable.hasModifierProperty("final") && variable.getType().equals(PsiType.BOOLEAN)) {
            PsiLiteralExpression initializer = (PsiLiteralExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)variable.getInitializer()), PsiLiteralExpression.class);
            return initializer != null && initializer.getValue() instanceof Boolean;
        }
        return false;
    }

    static boolean isEffectivelyUnqualified(DfaVariableValue variableValue) {
        return variableValue.getQualifier() == null || variableValue.getQualifier().getDescriptor() instanceof DfaExpressionFactory.ThisDescriptor;
    }

    public static boolean hasImplicitImpureSuperCall(PsiClass aClass, PsiMethod constructor) {
        PsiClass superClass = aClass.getSuperClass();
        if (superClass == null) {
            return false;
        }
        PsiElement superCtor = JavaResolveUtil.resolveImaginarySuperCallInThisPlace((PsiMember)constructor, constructor.getProject(), superClass);
        if (!(superCtor instanceof PsiMethod)) {
            return false;
        }
        return !JavaMethodContractUtil.isPure((PsiMethod)superCtor);
    }

    @Nullable
    static PsiElement getDataflowContext(PsiExpression expression2) {
        PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMember.class);
        if (member instanceof PsiField || member instanceof PsiClassInitializer) {
            return member.getContainingClass();
        }
        if (member instanceof PsiMethod) {
            return ((PsiMethod)member).isConstructor() ? member.getContainingClass() : ((PsiMethod)member).getBody();
        }
        return null;
    }

    @Nullable
    public static Boolean evaluateCondition(@Nullable PsiExpression condition2) {
        CommonDataflow.DataflowResult result = CommonDataflow.getDataflowResult(condition2);
        if (result == null) {
            return null;
        }
        return (Boolean)ObjectUtils.tryCast((Object)ContainerUtil.getOnlyItem(result.getExpressionValues(condition2)), Boolean.class);
    }

    public static boolean isComparedByEquals(PsiType type2) {
        return type2 != null && (TypeUtils.isJavaLangString(type2) || TypeConversionUtil.isPrimitiveWrapper((PsiType)type2));
    }

    public static DfaValue boxUnbox(DfaValue value2, @Nullable PsiType type2) {
        if (TypeConversionUtil.isPrimitiveWrapper((PsiType)type2) && (value2 instanceof DfaConstValue || value2 instanceof DfaVariableValue && TypeConversionUtil.isPrimitiveAndNotNull((PsiType)value2.getType()))) {
            DfaValue boxed = value2.getFactory().getBoxedFactory().createBoxed(value2, type2);
            return boxed == null ? DfaUnknownValue.getInstance() : boxed;
        }
        if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)type2) && (value2 instanceof DfaBoxedValue || value2 instanceof DfaVariableValue && TypeConversionUtil.isPrimitiveWrapper((PsiType)value2.getType()))) {
            return SpecialField.UNBOX.createValue(value2.getFactory(), value2);
        }
        return value2;
    }

    public static Object computeValue(PsiExpression expression2) {
        final PsiExpression expressionToAnalyze = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2);
        if (expressionToAnalyze == null) {
            return null;
        }
        Object computed = ExpressionUtils.computeConstantExpression(expression2);
        if (computed != null) {
            return computed;
        }
        final StandardDataFlowRunner runner = new StandardDataFlowRunner(false, (PsiElement)expression2);
        class Visitor
        extends StandardInstructionVisitor {
            Object exprValue;

            Visitor() {
            }

            @Override
            protected void beforeExpressionPush(@NotNull DfaValue value2, @NotNull PsiExpression expr, @Nullable TextRange range, @NotNull DfaMemoryState state) {
                super.beforeExpressionPush(value2, expr, range, state);
                if (expr != expressionToAnalyze) {
                    return;
                }
                Object newValue = value2 instanceof DfaConstValue ? ((DfaConstValue)value2).getValue() : UNKNOWN_VALUE;
                if (this.exprValue == null) {
                    this.exprValue = newValue;
                } else if (this.exprValue != newValue) {
                    this.exprValue = UNKNOWN_VALUE;
                }
                if (this.exprValue == UNKNOWN_VALUE) {
                    runner.cancel();
                }
            }
        }
        Visitor visitor = new Visitor();
        RunnerResult result = runner.analyzeMethod((PsiElement)expressionToAnalyze, visitor);
        if (result == RunnerResult.OK && visitor.exprValue != UNKNOWN_VALUE) {
            return visitor.exprValue;
        }
        return null;
    }

    private static PsiExpression concatenateExpressions(FList<PsiExpression> concatenation) {
        if (concatenation.size() == 1) {
            return (PsiExpression)concatenation.getHead();
        }
        String text2 = StringUtil.join((Collection)ContainerUtil.reverse(new ArrayList<PsiExpression>((Collection<PsiExpression>)concatenation)), PsiElement::getText, (String)"+");
        try {
            return JavaPsiFacade.getElementFactory((Project)((PsiExpression)concatenation.getHead()).getProject()).createExpressionFromText(text2, (PsiElement)concatenation.getHead());
        }
        catch (IncorrectOperationException e) {
            return (PsiExpression)concatenation.getHead();
        }
    }

    public static boolean isNaN(Object value2) {
        if (value2 instanceof Double && ((Double)value2).isNaN()) {
            return true;
        }
        return value2 instanceof Float && ((Float)value2).isNaN();
    }

    private static class ValuableInstructionVisitor
    extends StandardInstructionVisitor {
        final Map<PsiElement, PlaceResult> myResults = ContainerUtil.newHashMap();

        private ValuableInstructionVisitor() {
        }

        @Override
        public DfaInstructionState[] visitPush(PushInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
            PsiExpression place = instruction.getExpression();
            if (place != null) {
                PsiModifierListOwner element;
                PlaceResult result = this.myResults.computeIfAbsent((PsiElement)place, __ -> new PlaceResult());
                ((ValuableDataFlowRunner.MyDfaMemoryState)memState).forVariableStates((variableValue, value2) -> {
                    PsiModifierListOwner element;
                    ValuableDataFlowRunner.ValuableDfaVariableState state = (ValuableDataFlowRunner.ValuableDfaVariableState)value2;
                    FList<PsiExpression> concatenation = state.myConcatenation;
                    if (!concatenation.isEmpty() && DfaUtil.isEffectivelyUnqualified(variableValue) && (element = variableValue.getPsiVariable()) instanceof PsiVariable) {
                        result.myValues.put((Object)((PsiVariable)element), concatenation);
                    }
                });
                DfaValue value3 = instruction.getValue();
                if (value3 instanceof DfaVariableValue && DfaUtil.isEffectivelyUnqualified((DfaVariableValue)value3) && (element = ((DfaVariableValue)value3).getPsiVariable()) instanceof PsiVariable) {
                    if (memState.isNotNull(value3)) {
                        result.myNotNulls.add((PsiVariable)element);
                    }
                    if (memState.isNull(value3)) {
                        result.myNulls.add((PsiVariable)element);
                    }
                }
            }
            return super.visitPush(instruction, runner, memState);
        }

        @Override
        public DfaInstructionState[] visitAssign(AssignInstruction instruction, DataFlowRunner runner, DfaMemoryState _memState) {
            Instruction nextInstruction = runner.getInstruction(instruction.getIndex() + 1);
            ValuableDataFlowRunner.MyDfaMemoryState memState = (ValuableDataFlowRunner.MyDfaMemoryState)_memState;
            DfaValue dfaSource = memState.pop();
            DfaValue dfaDest = memState.pop();
            if (dfaDest instanceof DfaVariableValue) {
                DfaVariableValue var = (DfaVariableValue)dfaDest;
                PsiExpression rightValue = instruction.getRExpression();
                PsiElement parent = rightValue == null ? null : rightValue.getParent();
                IElementType type2 = parent instanceof PsiAssignmentExpression ? ((PsiAssignmentExpression)parent).getOperationTokenType() : JavaTokenType.EQ;
                FList<PsiExpression> prevValue = ((ValuableDataFlowRunner.ValuableDfaVariableState)memState.getVariableState((DfaVariableValue)var)).myConcatenation;
                memState.setVarValue(var, dfaSource);
                ValuableDataFlowRunner.ValuableDfaVariableState curState = (ValuableDataFlowRunner.ValuableDfaVariableState)memState.getVariableState(var);
                FList curValue = curState.myConcatenation;
                FList nextValue = type2 == JavaTokenType.PLUSEQ && !prevValue.isEmpty() ? prevValue.prepend((Object)rightValue) : (curValue.isEmpty() && rightValue != null ? curValue.prepend((Object)rightValue) : curValue);
                memState.setVariableState(var, curState.withExpression((FList<PsiExpression>)nextValue));
            }
            memState.push(dfaDest);
            return new DfaInstructionState[]{new DfaInstructionState(nextInstruction, memState)};
        }

        static class PlaceResult {
            final MultiValuesMap<PsiVariable, FList<PsiExpression>> myValues = new MultiValuesMap(true);
            final Set<PsiVariable> myNulls = new THashSet();
            final Set<PsiVariable> myNotNulls = new THashSet();

            PlaceResult() {
            }
        }
    }
}

