/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.DfaFactMap;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.value.DfaPsiType;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.PsiPrimitiveType;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DfaVariableState {
    @NotNull
    final DfaFactMap myFactMap;
    private final int myHash;

    DfaVariableState(@NotNull DfaVariableValue dfaVar) {
        this(dfaVar.getInherentFacts());
    }

    public boolean isSuperStateOf(DfaVariableState that) {
        return this.myFactMap.isSuperStateOf(that.myFactMap);
    }

    DfaVariableState(@NotNull DfaFactMap factMap) {
        this.myFactMap = factMap.with(DfaFactType.SPECIAL_FIELD_VALUE, null);
        this.myHash = this.myFactMap.hashCode();
    }

    @Nullable
    DfaVariableState withInstanceofValue(@NotNull DfaPsiType dfaType) {
        if (dfaType.getPsiType() instanceof PsiPrimitiveType) {
            return this;
        }
        return this.withFacts(TypeConstraint.withInstanceOf(this.myFactMap, dfaType));
    }

    @Nullable
    DfaVariableState withNotInstanceofValue(@NotNull DfaPsiType dfaType) {
        TypeConstraint typeConstraint = this.getTypeConstraint();
        TypeConstraint newTypeConstraint = typeConstraint.withNotInstanceofValue(dfaType);
        return newTypeConstraint == null ? null : this.withFact(DfaFactType.TYPE_CONSTRAINT, newTypeConstraint);
    }

    @NotNull
    DfaVariableState withoutType(@NotNull DfaPsiType type2) {
        return this.withFact(DfaFactType.TYPE_CONSTRAINT, this.getTypeConstraint().withoutType(type2));
    }

    public int hashCode() {
        return this.myHash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DfaVariableState)) {
            return false;
        }
        DfaVariableState aState = (DfaVariableState)obj;
        return this.myHash == aState.myHash && Objects.equals(this.myFactMap, aState.myFactMap);
    }

    @NotNull
    protected DfaVariableState createCopy(@NotNull DfaFactMap factMap) {
        return new DfaVariableState(factMap);
    }

    public String toString() {
        return "State: " + this.myFactMap;
    }

    @NotNull
    Nullability getNullability() {
        return DfaNullability.toNullability(this.myFactMap.get(DfaFactType.NULLABILITY));
    }

    public boolean isNotNull() {
        return DfaNullability.isNotNull(this.myFactMap);
    }

    @NotNull
    DfaVariableState withNotNull() {
        return this.getNullability() == Nullability.NOT_NULL ? this : this.withoutFact(DfaFactType.NULLABILITY);
    }

    @NotNull
    <T> DfaVariableState withFact(DfaFactType<T> type2, T value2) {
        return this.withFacts(this.myFactMap.with(type2, value2));
    }

    @NotNull
    <T> DfaVariableState withoutFact(DfaFactType<T> type2) {
        return this.withFact(type2, null);
    }

    @Nullable
    <T> DfaVariableState intersectFact(DfaFactType<T> type2, T value2) {
        return this.withFacts(this.myFactMap.intersect(type2, value2));
    }

    @Nullable
    DfaVariableState intersectMap(DfaFactMap map2) {
        return this.withFacts(this.myFactMap.intersect(map2));
    }

    @Contract(value="null -> null;!null -> !null")
    public DfaVariableState withFacts(@Nullable DfaFactMap facts) {
        return facts == null ? null : (facts.equals(this.myFactMap) ? this : this.createCopy(facts));
    }

    @NotNull
    public DfaVariableState withValue(DfaValue value2) {
        return this;
    }

    @Nullable
    public DfaValue getValue() {
        return null;
    }

    @NotNull
    public TypeConstraint getTypeConstraint() {
        TypeConstraint fact = this.getFact(DfaFactType.TYPE_CONSTRAINT);
        return fact == null ? TypeConstraint.empty() : fact;
    }

    @Nullable
    public <T> T getFact(@NotNull DfaFactType<T> factType) {
        return this.myFactMap.get(factType);
    }
}

