/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.DefaultInferredAnnotationProvider;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.ExternalAnnotationsManagerImpl;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.dataFlow.ContractInspection;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collections;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditContractIntention
extends BaseIntentionAction
implements LowPriorityAction {
    private static final String ourPrompt = "<html>Please specify the contract text<p>Example: <code>_, null -> false</code><br><small>See intention action description for more details</small></html>";

    @NotNull
    public String getFamilyName() {
        return "Edit method contract";
    }

    @Nullable
    private static PsiMethod getTargetMethod(Editor editor, PsiFile file) {
        PsiModifierListOwner owner = AddAnnotationPsiFix.getContainer(file, editor.getCaretModel().getOffset());
        if (owner instanceof PsiMethod && ExternalAnnotationsManagerImpl.areExternalAnnotationsApplicable(owner)) {
            PsiElement original = owner.getOriginalElement();
            return original instanceof PsiMethod ? (PsiMethod)original : (PsiMethod)owner;
        }
        return null;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiMethod method = EditContractIntention.getTargetMethod(editor, file);
        if (method != null) {
            boolean hasContract = JavaMethodContractUtil.findContractAnnotation(method) != null;
            this.setText(hasContract ? "Edit method contract of '" + method.getName() + "'" : "Add method contract to '" + method.getName() + "'");
            return true;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        final PsiMethod method = EditContractIntention.getTargetMethod(editor, file);
        assert (method != null);
        PsiAnnotation existingAnno = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)method, Collections.singleton(Contract.class.getName()));
        String oldContract = existingAnno == null ? null : AnnotationUtil.getStringAttributeValue((PsiAnnotation)existingAnno, (String)"value");
        boolean oldPure = existingAnno != null && Boolean.TRUE.equals(AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)existingAnno, (String)"pure"));
        String oldMutates = existingAnno == null ? null : AnnotationUtil.getStringAttributeValue((PsiAnnotation)existingAnno, (String)"mutates");
        final JBTextField contractText = new JBTextField(oldContract);
        final JBTextField mutatesText = new JBTextField(oldMutates);
        JCheckBox pureCB = EditContractIntention.createPureCheckBox(oldPure);
        final DialogBuilder builder = EditContractIntention.createDialog(project, contractText, pureCB, mutatesText);
        DocumentAdapter validator = new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                String contractError = EditContractIntention.getContractErrorMessage(contractText.getText(), method);
                if (contractError != null) {
                    builder.setOkActionEnabled(false);
                    builder.setErrorText(contractError, (JComponent)contractText);
                } else {
                    String mutatesError = EditContractIntention.getMutatesErrorMessage(mutatesText.getText(), method);
                    if (mutatesError != null) {
                        builder.setOkActionEnabled(false);
                        builder.setErrorText(mutatesError, (JComponent)mutatesText);
                    } else {
                        builder.setOkActionEnabled(true);
                        builder.setErrorText(null);
                    }
                }
            }
        };
        Runnable updateControls = () -> {
            if (pureCB.isSelected()) {
                mutatesText.setText("");
                mutatesText.setEnabled(false);
            } else {
                mutatesText.setEnabled(true);
            }
        };
        pureCB.addChangeListener(e -> updateControls.run());
        contractText.getDocument().addDocumentListener((DocumentListener)validator);
        mutatesText.getDocument().addDocumentListener((DocumentListener)validator);
        updateControls.run();
        if (builder.showAndGet()) {
            EditContractIntention.updateContract(method, contractText.getText(), pureCB.isSelected(), mutatesText.getText());
        }
    }

    private static DialogBuilder createDialog(@NotNull Project project, JBTextField contractText, JCheckBox pureCB, JBTextField mutatesText) {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 2, 1, 4.0, 1.0, 17, 2, (Insets)JBUI.insets((int)2), 0, 0);
        panel.add((Component)Messages.configureMessagePaneUi((JTextPane)new JTextPane(), (String)ourPrompt), constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.weightx = 1.0;
        JLabel contractLabel = new JLabel("Contract:");
        contractLabel.setDisplayedMnemonic('c');
        contractLabel.setLabelFor((Component)contractText);
        panel.add((Component)contractLabel, constraints);
        constraints.gridx = 1;
        constraints.weightx = 3.0;
        panel.add((Component)contractText, constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 2;
        constraints.weightx = 4.0;
        panel.add((Component)pureCB, constraints);
        panel.add((Component)pureCB, constraints);
        if (ApplicationManagerEx.getApplicationEx().isInternal()) {
            constraints.gridx = 0;
            constraints.gridy = 3;
            constraints.weightx = 1.0;
            constraints.gridwidth = 1;
            JLabel mutatesLabel = new JLabel("Mutates:");
            mutatesLabel.setDisplayedMnemonic('m');
            mutatesLabel.setLabelFor((Component)mutatesText);
            panel.add((Component)mutatesLabel, constraints);
            constraints.gridx = 1;
            constraints.weightx = 3.0;
            panel.add((Component)mutatesText, constraints);
        }
        DialogBuilder builder = new DialogBuilder(project).setNorthPanel((JComponent)panel).title("Edit Method Contract");
        builder.setPreferredFocusComponent((JComponent)contractText);
        builder.setHelpId("define_contract_dialog");
        return builder;
    }

    private static JCheckBox createPureCheckBox(boolean selected) {
        NonFocusableCheckBox pureCB = new NonFocusableCheckBox("Method is pure (has no side effects)");
        pureCB.setMnemonic('p');
        pureCB.setSelected(selected);
        return pureCB;
    }

    private static void updateContract(PsiMethod method, String contract, boolean pure, String mutates) {
        Project project = method.getProject();
        ExternalAnnotationsManager manager = ExternalAnnotationsManager.getInstance((Project)project);
        manager.deannotate((PsiModifierListOwner)method, JavaMethodContractUtil.ORG_JETBRAINS_ANNOTATIONS_CONTRACT);
        PsiAnnotation mockAnno = DefaultInferredAnnotationProvider.createContractAnnotation(project, pure, contract, mutates);
        if (mockAnno != null) {
            try {
                manager.annotateExternally((PsiModifierListOwner)method, JavaMethodContractUtil.ORG_JETBRAINS_ANNOTATIONS_CONTRACT, method.getContainingFile(), mockAnno.getParameterList().getAttributes());
            }
            catch (ExternalAnnotationsManager.CanceledConfigurationException canceledConfigurationException) {
                // empty catch block
            }
        }
        DaemonCodeAnalyzer.getInstance((Project)project).restart();
    }

    @Nullable
    private static String getMutatesErrorMessage(String mutates, PsiMethod method) {
        return StringUtil.isEmpty((String)mutates) ? null : MutationSignature.checkSignature(mutates, method);
    }

    @Nullable
    private static String getContractErrorMessage(String contract, PsiMethod method) {
        if (StringUtil.isEmpty((String)contract)) {
            return null;
        }
        StandardMethodContract.ParseException error = ContractInspection.checkContract(method, contract);
        return error != null ? error.getMessage() : null;
    }

    public boolean startInWriteAction() {
        return false;
    }
}

