/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.codeInspection.dataFlow.inference.JavaSourceInference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum Mutability {
    UNKNOWN("unknown", null),
    MUTABLE("modifiable", null),
    UNMODIFIABLE("unmodifiable", "org.jetbrains.annotations.Unmodifiable"),
    UNMODIFIABLE_VIEW("unmodifiable view", "org.jetbrains.annotations.UnmodifiableView");

    @NotNull
    public static final String UNMODIFIABLE_ANNOTATION;
    @NotNull
    public static final String UNMODIFIABLE_VIEW_ANNOTATION;
    private final String myName;
    private final String myAnnotation;
    private final Key<CachedValue<PsiAnnotation>> myKey;

    private Mutability(String name, String annotation) {
        this.myName = name;
        this.myAnnotation = annotation;
        this.myKey = annotation == null ? null : Key.create((String)annotation);
    }

    public String toString() {
        return this.myName;
    }

    public boolean isUnmodifiable() {
        return this == UNMODIFIABLE || this == UNMODIFIABLE_VIEW;
    }

    @NotNull
    public Mutability unite(Mutability other) {
        if (this == other) {
            return this;
        }
        if (this == MUTABLE || other == MUTABLE) {
            return MUTABLE;
        }
        if (this == UNKNOWN || other == UNKNOWN) {
            return UNKNOWN;
        }
        if (this == UNMODIFIABLE_VIEW || other == UNMODIFIABLE_VIEW) {
            return UNMODIFIABLE_VIEW;
        }
        return UNMODIFIABLE;
    }

    @Nullable
    public PsiAnnotation asAnnotation(Project project) {
        if (this.myAnnotation == null) {
            return null;
        }
        return (PsiAnnotation)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, this.myKey, () -> {
            PsiAnnotation annotation = JavaPsiFacade.getElementFactory((Project)project).createAnnotationFromText("@" + this.myAnnotation, null);
            ((LightVirtualFile)annotation.getContainingFile().getViewProvider().getVirtualFile()).setWritable(false);
            return CachedValueProvider.Result.create((Object)annotation, (Object[])new Object[]{ModificationTracker.NEVER_CHANGED});
        }, false);
    }

    @NotNull
    public static Mutability getMutability(@NotNull PsiModifierListOwner owner) {
        if (owner instanceof LightElement) {
            return UNKNOWN;
        }
        return (Mutability)((Object)CachedValuesManager.getCachedValue((PsiElement)owner, () -> CachedValueProvider.Result.create((Object)((Object)Mutability.calcMutability(owner)), (Object[])new Object[]{owner, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT})));
    }

    @NotNull
    public static Mutability calcMutability(@NotNull PsiModifierListOwner owner) {
        PsiParameterList list;
        PsiMethod method;
        if (owner instanceof PsiParameter && owner.getParent() instanceof PsiParameterList && (method = (PsiMethod)ObjectUtils.tryCast((Object)(list = (PsiParameterList)owner.getParent()).getParent(), PsiMethod.class)) != null) {
            int index = list.getParameterIndex((PsiParameter)owner);
            MutationSignature signature = MutationSignature.fromMethod(method);
            if (signature.mutatesArg(index)) {
                return MUTABLE;
            }
            if (signature.preservesArg(index) && PsiTreeUtil.findChildOfAnyType((PsiElement)method.getBody(), (Class[])new Class[]{PsiLambdaExpression.class, PsiClass.class}) == null) {
                return UNMODIFIABLE_VIEW;
            }
            return UNKNOWN;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)owner, Collections.singleton(UNMODIFIABLE_ANNOTATION), (int)7)) {
            return UNMODIFIABLE;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)owner, Collections.singleton(UNMODIFIABLE_VIEW_ANNOTATION), (int)7)) {
            return UNMODIFIABLE_VIEW;
        }
        if (owner instanceof PsiField && owner.hasModifierProperty("final")) {
            PsiField field = (PsiField)owner;
            List<PsiExpression> initializers = ContainerUtil.createMaybeSingletonList((Object)field.getInitializer());
            if (initializers.isEmpty() && !owner.hasModifierProperty("static")) {
                initializers = DfaPsiUtil.findAllConstructorInitializers(field);
            }
            if ((initializers = StreamEx.of((Collection)initializers).flatMap(ExpressionUtils::nonStructuralChildren).toList()).isEmpty()) {
                return UNKNOWN;
            }
            Mutability mutability = UNMODIFIABLE;
            for (PsiExpression initializer : initializers) {
                Mutability newMutability = UNKNOWN;
                if (ClassUtils.isImmutable(initializer.getType())) {
                    newMutability = UNMODIFIABLE;
                } else if (initializer instanceof PsiMethodCallExpression) {
                    PsiMethod method2 = ((PsiMethodCallExpression)initializer).resolveMethod();
                    Mutability mutability2 = newMutability = method2 == null ? UNKNOWN : Mutability.getMutability((PsiModifierListOwner)method2);
                }
                if ((mutability = mutability.unite(newMutability)).isUnmodifiable()) continue;
                break;
            }
            return mutability;
        }
        return owner instanceof PsiMethodImpl ? JavaSourceInference.inferMutability((PsiMethodImpl)owner) : UNKNOWN;
    }

    static {
        UNMODIFIABLE_ANNOTATION = Mutability.UNMODIFIABLE.myAnnotation;
        UNMODIFIABLE_VIEW_ANNOTATION = Mutability.UNMODIFIABLE_VIEW.myAnnotation;
    }
}

