/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.Arrays;
import java.util.stream.Stream;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MutationSignature {
    public static final String ATTR_MUTATES = "mutates";
    static final MutationSignature UNKNOWN = new MutationSignature(false, new boolean[0]);
    static final MutationSignature PURE = new MutationSignature(false, new boolean[0]);
    public static final String INVALID_TOKEN_MESSAGE = "Invalid token: %s; supported are 'this', 'param1', 'param2', etc.";
    private final boolean myThis;
    private final boolean[] myParameters;

    private MutationSignature(boolean mutatesThis, boolean[] params) {
        this.myThis = mutatesThis;
        this.myParameters = params;
    }

    public boolean mutatesThis() {
        return this.myThis;
    }

    public boolean mutatesArg(int n) {
        return n < this.myParameters.length && this.myParameters[n];
    }

    public boolean preservesThis() {
        return this != UNKNOWN && !this.myThis;
    }

    public boolean preservesArg(int n) {
        return this != UNKNOWN && !this.mutatesArg(n);
    }

    public Stream<PsiExpression> mutatedExpressions(PsiMethodCallExpression call) {
        Object[] args = call.getArgumentList().getExpressions();
        StreamEx elements = IntStreamEx.range((int)Math.min(this.myParameters.length, MethodCallUtils.isVarArgCall((PsiCall)call) ? args.length - 1 : args.length)).filter(idx -> this.myParameters[idx]).elements(args);
        return this.myThis ? elements.prepend((Object)ExpressionUtils.getQualifierOrThis(call.getMethodExpression())) : elements;
    }

    public boolean mutatesAnything() {
        if (this.myThis) {
            return true;
        }
        for (boolean parameter2 : this.myParameters) {
            if (!parameter2) continue;
            return true;
        }
        return false;
    }

    public static MutationSignature parse(@NotNull String signature) {
        if (signature.trim().isEmpty()) {
            return UNKNOWN;
        }
        boolean mutatesThis = false;
        boolean[] args = new boolean[]{};
        for (String part : signature.split(",")) {
            if ((part = part.trim()).equals("this")) {
                mutatesThis = true;
                continue;
            }
            if (part.equals("param")) {
                if (args.length == 0) {
                    args = new boolean[]{true};
                    continue;
                }
                args[0] = true;
                continue;
            }
            if (part.startsWith("param")) {
                int argNum = Integer.parseInt(part.substring("param".length()));
                if (argNum < 0 || argNum > 255) {
                    throw new IllegalArgumentException(String.format(INVALID_TOKEN_MESSAGE, part));
                }
                if (args.length < argNum) {
                    args = Arrays.copyOf(args, argNum);
                }
                args[argNum - 1] = true;
                continue;
            }
            if (part.isEmpty()) continue;
            throw new IllegalArgumentException(String.format(INVALID_TOKEN_MESSAGE, part));
        }
        return new MutationSignature(mutatesThis, args);
    }

    @Nullable
    public static String checkSignature(@NotNull String signature, @NotNull PsiMethod method) {
        try {
            MutationSignature ms = MutationSignature.parse(signature);
            if (ms.myThis && method.hasModifierProperty("static")) {
                return "Static method cannot mutate 'this'";
            }
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            if (ms.myParameters.length > parameters2.length) {
                return "Reference to parameter #" + ms.myParameters.length + " is invalid";
            }
            for (int i = 0; i < ms.myParameters.length; ++i) {
                PsiType type2;
                if (!ms.myParameters[i] || !ClassUtils.isImmutable(type2 = parameters2[i].getType())) continue;
                return "Parameter #" + (i + 1) + " has immutable type '" + type2.getPresentableText() + "'";
            }
        }
        catch (IllegalArgumentException ex) {
            return ex.getMessage();
        }
        return null;
    }

    @NotNull
    public static MutationSignature fromMethod(@Nullable PsiMethod method) {
        if (method == null) {
            return UNKNOWN;
        }
        return JavaMethodContractUtil.getContractInfo(method).getMutationSignature();
    }
}

