/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaFactMap;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.DfaVariableState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ReturnInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.search.JavaNullMethodArgumentUtil;
import com.intellij.util.SmartList;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class NullParameterConstraintChecker
extends DataFlowRunner {
    private final Set<PsiParameter> myPossiblyViolatedParameters;
    private final Set<PsiParameter> myUsedParameters;
    private final Set<PsiParameter> myParametersWithSuccessfulExecutionInNotNullState;

    private NullParameterConstraintChecker(Collection<PsiParameter> parameters2) {
        super(false, null);
        this.myPossiblyViolatedParameters = new THashSet(parameters2);
        this.myParametersWithSuccessfulExecutionInNotNullState = new THashSet();
        this.myUsedParameters = new THashSet();
    }

    @NotNull
    static PsiParameter[] checkMethodParameters(PsiMethod method) {
        if (method.getBody() == null) {
            return PsiParameter.EMPTY_ARRAY;
        }
        SmartList nullableParameters = new SmartList();
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        for (int index = 0; index < parameters2.length; ++index) {
            PsiParameter parameter2 = parameters2[index];
            if (parameter2.getType() instanceof PsiPrimitiveType || NullableNotNullManager.getNullability((PsiModifierListOwner)parameter2) != Nullability.UNKNOWN || !JavaNullMethodArgumentUtil.hasNullArgument(method, index)) continue;
            nullableParameters.add(parameter2);
        }
        if (nullableParameters.isEmpty()) {
            return PsiParameter.EMPTY_ARRAY;
        }
        NullParameterConstraintChecker checker = new NullParameterConstraintChecker((Collection<PsiParameter>)nullableParameters);
        checker.analyzeMethod((PsiElement)method.getBody(), new StandardInstructionVisitor());
        return (PsiParameter[])checker.myPossiblyViolatedParameters.stream().filter(checker.myUsedParameters::contains).filter(checker.myParametersWithSuccessfulExecutionInNotNullState::contains).toArray(PsiParameter[]::new);
    }

    @Override
    @NotNull
    protected DfaInstructionState[] acceptInstruction(@NotNull InstructionVisitor visitor, @NotNull DfaInstructionState instructionState) {
        PsiModifierListOwner psiVariable;
        DfaValue value2;
        PsiModifierListOwner psiVar;
        DfaValue var;
        Instruction instruction = instructionState.getInstruction();
        if (instruction instanceof PushInstruction && (var = ((PushInstruction)instruction).getValue()) instanceof DfaVariableValue && (psiVar = ((DfaVariableValue)var).getPsiVariable()) instanceof PsiParameter) {
            this.myUsedParameters.add((PsiParameter)psiVar);
        }
        if (instruction instanceof AssignInstruction && (value2 = ((AssignInstruction)instruction).getAssignedValue()) instanceof DfaVariableValue && (psiVariable = ((DfaVariableValue)value2).getPsiVariable()) instanceof PsiParameter) {
            this.myPossiblyViolatedParameters.remove(psiVariable);
        }
        if (instruction instanceof ReturnInstruction && !((ReturnInstruction)instruction).isViaException()) {
            DfaMemoryState memState = instructionState.getMemoryState();
            for (PsiParameter parameter2 : this.myPossiblyViolatedParameters.toArray(PsiParameter.EMPTY_ARRAY)) {
                DfaVariableValue dfaVar = this.getFactory().getVarFactory().createVariableValue((PsiVariable)parameter2);
                if (memState.isNotNull(dfaVar)) {
                    this.myParametersWithSuccessfulExecutionInNotNullState.add(parameter2);
                    continue;
                }
                this.myPossiblyViolatedParameters.remove(parameter2);
            }
        }
        return super.acceptInstruction(visitor, instructionState);
    }

    @Override
    @NotNull
    protected DfaMemoryState createMemoryState() {
        return new MyDfaMemoryState(this.getFactory());
    }

    private class MyDfaMemoryState
    extends DfaMemoryStateImpl {
        protected MyDfaMemoryState(DfaValueFactory factory) {
            super(factory);
            for (PsiParameter parameter2 : NullParameterConstraintChecker.this.myPossiblyViolatedParameters) {
                this.setVariableState(this.getFactory().getVarFactory().createVariableValue((PsiVariable)parameter2), new DfaVariableState(DfaFactMap.EMPTY.with(DfaFactType.NULLABILITY, DfaNullability.NULLABLE)));
            }
        }

        protected MyDfaMemoryState(MyDfaMemoryState toCopy) {
            super(toCopy);
        }

        @Override
        public void flushVariable(@NotNull DfaVariableValue variable) {
            PsiModifierListOwner psi = variable.getPsiVariable();
            if (psi instanceof PsiParameter && NullParameterConstraintChecker.this.myPossiblyViolatedParameters.contains(psi)) {
                return;
            }
            super.flushVariable(variable);
        }

        @Override
        @NotNull
        public DfaMemoryStateImpl createCopy() {
            return new MyDfaMemoryState(this);
        }
    }
}

