/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.SpecialFieldValue;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.value.DfaBoxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaFactMapValue;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.codeInspection.util.OptionalUtil;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum SpecialField implements VariableDescriptor
{
    ARRAY_LENGTH("length", true){

        @Override
        boolean isMyQualifierType(PsiType type2) {
            return type2 instanceof PsiArrayType;
        }

        @Override
        boolean isMyAccessor(PsiMember accessor) {
            return accessor instanceof PsiField && "length".equals(accessor.getName()) && PsiUtil.isArrayClass((PsiElement)accessor.getContainingClass());
        }

        @Override
        DfaValue fromInitializer(DfaValueFactory factory, PsiExpression initializer) {
            if (initializer instanceof PsiArrayInitializerExpression) {
                return factory.getInt(((PsiArrayInitializerExpression)initializer).getInitializers().length);
            }
            if (initializer instanceof PsiNewExpression) {
                Object length;
                PsiArrayInitializerExpression arrayInitializer = ((PsiNewExpression)initializer).getArrayInitializer();
                if (arrayInitializer != null) {
                    return factory.getInt(arrayInitializer.getInitializers().length);
                }
                PsiExpression[] dimensions = ((PsiNewExpression)initializer).getArrayDimensions();
                if (dimensions.length > 0 && (length = ExpressionUtils.computeConstantExpression(dimensions[0])) instanceof Integer) {
                    return factory.getInt((Integer)length);
                }
            }
            return null;
        }
    }
    ,
    STRING_LENGTH("length", true){

        @Override
        DfaValue fromInitializer(DfaValueFactory factory, PsiExpression initializer) {
            return this.fromConstant(factory, ExpressionUtils.computeConstantExpression(initializer));
        }

        @Override
        boolean isMyQualifierType(PsiType type2) {
            return TypeUtils.isJavaLangString(type2);
        }

        @Override
        boolean isMyAccessor(PsiMember accessor) {
            if (!(accessor instanceof PsiMethod && "length".equals(accessor.getName()) && ((PsiMethod)accessor).getParameterList().isEmpty())) {
                return false;
            }
            PsiClass containingClass = accessor.getContainingClass();
            return containingClass != null && "java.lang.String".equals(containingClass.getQualifiedName());
        }

        @Override
        public DfaValue fromConstant(DfaValueFactory factory, @Nullable Object obj) {
            return obj instanceof String ? factory.getInt(((String)obj).length()) : null;
        }
    }
    ,
    COLLECTION_SIZE("size", false){
        private final CallMatcher SIZE_METHODS = CallMatcher.anyOf(CallMatcher.instanceCall("java.util.Collection", "size").parameterCount(0), CallMatcher.instanceCall("java.util.Map", "size").parameterCount(0));
        private final CallMatcher MAP_COLLECTIONS = CallMatcher.instanceCall("java.util.Map", "keySet", "entrySet", "values").parameterCount(0);

        @Override
        boolean isMyQualifierType(PsiType type2) {
            return InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Map") || InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Collection");
        }

        @Override
        boolean isMyAccessor(PsiMember accessor) {
            return accessor instanceof PsiMethod && this.SIZE_METHODS.methodMatches((PsiMethod)accessor);
        }

        @Override
        @NotNull
        public DfaValue createValue(@NotNull DfaValueFactory factory, @Nullable DfaValue qualifier, boolean forAccessor) {
            if (qualifier instanceof DfaVariableValue) {
                DfaVariableValue var = (DfaVariableValue)qualifier;
                PsiModifierListOwner owner = var.getPsiVariable();
                if (var.getQualifier() != null && owner instanceof PsiMethod && this.MAP_COLLECTIONS.methodMatches((PsiMethod)owner)) {
                    return super.createValue(factory, var.getQualifier(), forAccessor);
                }
            }
            return super.createValue(factory, qualifier, forAccessor);
        }
    }
    ,
    UNBOX("value", true){
        private final CallMatcher UNBOXING_CALL = CallMatcher.anyOf(CallMatcher.exactInstanceCall("java.lang.Integer", "intValue").parameterCount(0), CallMatcher.exactInstanceCall("java.lang.Long", "longValue").parameterCount(0), CallMatcher.exactInstanceCall("java.lang.Short", "shortValue").parameterCount(0), CallMatcher.exactInstanceCall("java.lang.Byte", "byteValue").parameterCount(0), CallMatcher.exactInstanceCall("java.lang.Character", "charValue").parameterCount(0), CallMatcher.exactInstanceCall("java.lang.Boolean", "booleanValue").parameterCount(0), CallMatcher.exactInstanceCall("java.lang.Float", "floatValue").parameterCount(0), CallMatcher.exactInstanceCall("java.lang.Double", "doubleValue").parameterCount(0));

        public PsiPrimitiveType getType(DfaVariableValue variableValue) {
            return PsiPrimitiveType.getUnboxedType((PsiType)variableValue.getType());
        }

        @Override
        @NotNull
        public DfaValue getDefaultValue(DfaValueFactory factory, boolean forAccessor) {
            return DfaUnknownValue.getInstance();
        }

        @Override
        @NotNull
        public DfaValue createValue(@NotNull DfaValueFactory factory, @Nullable DfaValue qualifier, boolean forAccessor) {
            if (qualifier instanceof DfaBoxedValue) {
                return ((DfaBoxedValue)qualifier).getWrappedValue();
            }
            return super.createValue(factory, qualifier, forAccessor);
        }

        @Override
        boolean isMyQualifierType(PsiType type2) {
            return TypeConversionUtil.isPrimitiveWrapper((PsiType)type2);
        }

        @Override
        boolean isMyAccessor(PsiMember accessor) {
            return accessor instanceof PsiMethod && this.UNBOXING_CALL.methodMatches((PsiMethod)accessor);
        }
    }
    ,
    OPTIONAL_VALUE("value", true){

        @Override
        public PsiType getType(DfaVariableValue variableValue) {
            return OptionalUtil.getOptionalElementType(variableValue.getType());
        }

        @Override
        @NotNull
        public DfaValue getDefaultValue(DfaValueFactory factory, boolean forAccessor) {
            return factory.getFactValue(DfaFactType.NULLABILITY, forAccessor ? DfaNullability.NOT_NULL : DfaNullability.NULLABLE);
        }

        @Override
        boolean isMyQualifierType(PsiType type2) {
            return TypeUtils.isOptional(type2);
        }

        @Override
        public String getPresentationText(@NotNull DfaValue value2, @Nullable PsiType type2) {
            if (value2 instanceof DfaConstValue && ((DfaConstValue)value2).getValue() == null) {
                return "empty Optional";
            }
            if (value2 instanceof DfaFactMapValue) {
                DfaNullability nullability = ((DfaFactMapValue)value2).get(DfaFactType.NULLABILITY);
                if (nullability == DfaNullability.NOT_NULL) {
                    return "present Optional";
                }
                return "";
            }
            return super.getPresentationText(value2, type2);
        }

        @Override
        boolean isMyAccessor(PsiMember accessor) {
            return accessor instanceof PsiMethod && OptionalUtil.OPTIONAL_GET.methodMatches((PsiMethod)accessor);
        }
    };

    private static final SpecialField[] VALUES;
    private final String myTitle;
    private final boolean myFinal;

    private SpecialField(String title, boolean isFinal) {
        this.myTitle = title;
        this.myFinal = isFinal;
    }

    @Override
    public boolean isStable() {
        return this.myFinal;
    }

    abstract boolean isMyQualifierType(PsiType var1);

    abstract boolean isMyAccessor(PsiMember var1);

    public String getPresentationText(@NotNull DfaValue value2, @Nullable PsiType type2) {
        return value2.toString();
    }

    @Contract(value="null -> null")
    @Nullable
    public static SpecialField findSpecialField(PsiElement accessor) {
        if (!(accessor instanceof PsiMember)) {
            return null;
        }
        PsiMember member = (PsiMember)accessor;
        for (SpecialField sf : VALUES) {
            if (!sf.isMyAccessor(member)) continue;
            return sf;
        }
        return null;
    }

    @Override
    @NotNull
    public final DfaValue createValue(@NotNull DfaValueFactory factory, @Nullable DfaValue qualifier) {
        return this.createValue(factory, qualifier, false);
    }

    @Override
    @NotNull
    public DfaValue createValue(@NotNull DfaValueFactory factory, @Nullable DfaValue qualifier, boolean forAccessor) {
        DfaValue value2;
        Object obj;
        SpecialFieldValue sfValue;
        if (qualifier instanceof DfaVariableValue) {
            DfaValue value3;
            PsiExpression initializer;
            DfaVariableValue variableValue = (DfaVariableValue)qualifier;
            PsiModifierListOwner psiVariable = variableValue.getPsiVariable();
            if (psiVariable instanceof PsiField && factory.canTrustFieldInitializer((PsiField)psiVariable) && psiVariable.hasModifierProperty("static") && psiVariable.hasModifierProperty("final") && (initializer = ((PsiField)psiVariable).getInitializer()) != null && (value3 = this.fromInitializer(factory, initializer)) != null) {
                return value3;
            }
            return VariableDescriptor.super.createValue(factory, qualifier, forAccessor);
        }
        if (qualifier instanceof DfaFactMapValue && (sfValue = ((DfaFactMapValue)qualifier).get(DfaFactType.SPECIAL_FIELD_VALUE)) != null && sfValue.getField() == this) {
            return sfValue.getValue();
        }
        if (qualifier instanceof DfaConstValue && (obj = ((DfaConstValue)qualifier).getValue()) != null && (value2 = this.fromConstant(factory, obj)) != null) {
            return value2;
        }
        return this.getDefaultValue(factory, forAccessor);
    }

    @NotNull
    public DfaValue getDefaultValue(DfaValueFactory factory, boolean forAccessor) {
        return factory.getFactValue(DfaFactType.RANGE, LongRangeSet.indexRange());
    }

    @Override
    public PsiType getType(DfaVariableValue variableValue) {
        return PsiType.INT;
    }

    DfaValue fromInitializer(DfaValueFactory factory, PsiExpression initializer) {
        return null;
    }

    DfaValue fromConstant(DfaValueFactory factory, @Nullable Object obj) {
        return null;
    }

    public MethodContract[] getEmptyContracts() {
        ContractValue thisValue = ContractValue.qualifier().specialField(this);
        return new MethodContract[]{MethodContract.singleConditionContract(thisValue, DfaRelationValue.RelationType.EQ, ContractValue.zero(), ContractReturnValue.returnTrue()), MethodContract.trivialContract(ContractReturnValue.returnFalse())};
    }

    public MethodContract[] getEqualsContracts() {
        return new MethodContract[]{new StandardMethodContract(new StandardMethodContract.ValueConstraint[]{StandardMethodContract.ValueConstraint.NULL_VALUE}, ContractReturnValue.returnFalse()), MethodContract.singleConditionContract(ContractValue.qualifier().specialField(this), DfaRelationValue.RelationType.NE, ContractValue.argument(0).specialField(this), ContractReturnValue.returnFalse())};
    }

    public SpecialFieldValue withValue(DfaValue value2) {
        return new SpecialFieldValue(this, value2);
    }

    @Contract(value="null -> null")
    @Nullable
    public DfaValue extract(@Nullable SpecialFieldValue sfValue) {
        return sfValue != null && sfValue.getField() == this ? sfValue.getValue() : null;
    }

    @Nullable
    public static SpecialField fromQualifierType(PsiType type2) {
        for (SpecialField value2 : VALUES) {
            if (!value2.isMyQualifierType(type2)) continue;
            return value2;
        }
        return null;
    }

    public String toString() {
        return this.myTitle;
    }

    static {
        VALUES = SpecialField.values();
    }
}

