/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaFactMapValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.psi.PsiType;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpecialFieldValue {
    @NotNull
    private final SpecialField myField;
    @NotNull
    private final DfaValue myValue;

    public SpecialFieldValue(@NotNull SpecialField field, @NotNull DfaValue value2) {
        if (value2 instanceof DfaFactMapValue) {
            this.myValue = ((DfaFactMapValue)value2).withFact(DfaFactType.SPECIAL_FIELD_VALUE, null);
        } else if (value2 instanceof DfaConstValue) {
            this.myValue = value2;
        } else {
            throw new IllegalArgumentException("Unexpected value: " + value2);
        }
        this.myField = field;
    }

    @NotNull
    public SpecialField getField() {
        return this.myField;
    }

    @NotNull
    public DfaValue getValue() {
        return this.myValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpecialFieldValue)) {
            return false;
        }
        SpecialFieldValue value2 = (SpecialFieldValue)o;
        return this.myField == value2.myField && this.myValue == value2.myValue;
    }

    @Nullable
    public SpecialFieldValue unite(SpecialFieldValue other) {
        if (other == this) {
            return this;
        }
        if (this.myField != other.myField) {
            return null;
        }
        DfaValue newValue = this.myValue.unite(other.myValue);
        if (newValue instanceof DfaConstValue || newValue instanceof DfaFactMapValue) {
            return new SpecialFieldValue(this.myField, newValue);
        }
        return null;
    }

    public int hashCode() {
        return this.myField.hashCode() * 31 + Objects.hashCode(this.myValue);
    }

    public String toString() {
        return this.myField + " = " + this.myValue;
    }

    public String getPresentationText(PsiType type2) {
        return this.myField.getPresentationText(this.myValue, type2);
    }
}

