/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StandardMethodContract
extends MethodContract {
    @NotNull
    private final ValueConstraint[] myParameters;

    public StandardMethodContract(@NotNull ValueConstraint[] parameters2, @NotNull ContractReturnValue returnValue) {
        super(returnValue);
        this.myParameters = parameters2;
    }

    public int getParameterCount() {
        return this.myParameters.length;
    }

    public ValueConstraint getParameterConstraint(int parameterIndex) {
        return this.myParameters[parameterIndex];
    }

    public List<ValueConstraint> getConstraints() {
        return ContainerUtil.immutableList((Object[])this.myParameters);
    }

    @NotNull
    public StandardMethodContract withReturnValue(@NotNull ContractReturnValue returnValue) {
        return returnValue.equals(this.getReturnValue()) ? this : new StandardMethodContract(this.myParameters, returnValue);
    }

    public static StandardMethodContract trivialContract(int paramCount, @NotNull ContractReturnValue returnValue) {
        return new StandardMethodContract(StandardMethodContract.createConstraintArray(paramCount), returnValue);
    }

    @Nullable
    StandardMethodContract intersect(StandardMethodContract contract) {
        ValueConstraint[] result = (ValueConstraint[])this.myParameters.clone();
        assert (contract.getParameterCount() == result.length);
        for (int i = 0; i < result.length; ++i) {
            ValueConstraint condition2 = result[i];
            ValueConstraint constraint = contract.getParameterConstraint(i);
            if (condition2 == constraint || condition2 == ValueConstraint.ANY_VALUE) {
                result[i] = constraint;
                continue;
            }
            if (constraint == ValueConstraint.ANY_VALUE) {
                result[i] = condition2;
                continue;
            }
            return null;
        }
        return new StandardMethodContract(result, this.getReturnValue().intersect(contract.getReturnValue()));
    }

    @NotNull
    Stream<StandardMethodContract> excludeContract(StandardMethodContract contract) {
        assert (contract.getParameterCount() == this.myParameters.length);
        List<ValueConstraint> constraints = contract.getConstraints();
        List template = StreamEx.constant((Object)((Object)ValueConstraint.ANY_VALUE), (long)this.myParameters.length).toList();
        ArrayList<StandardMethodContract> antiContracts = new ArrayList<StandardMethodContract>();
        for (int i = 0; i < constraints.size(); ++i) {
            ValueConstraint constraint = constraints.get(i);
            if (constraint == ValueConstraint.ANY_VALUE) continue;
            template.set(i, constraint.negate());
            antiContracts.add(new StandardMethodContract(template.toArray(new ValueConstraint[0]), this.getReturnValue()));
            template.set(i, constraint);
        }
        return StreamEx.of(antiContracts).map(this::intersect).nonNull();
    }

    public StandardMethodContract tryCollapse(StandardMethodContract other) {
        if (!other.getReturnValue().equals(this.getReturnValue())) {
            return null;
        }
        ValueConstraint[] thatParameters = other.myParameters;
        ValueConstraint[] thisParameters = this.myParameters;
        if (thatParameters.length != thisParameters.length) {
            return null;
        }
        ValueConstraint[] result = null;
        for (int i = 0; i < thisParameters.length; ++i) {
            ValueConstraint thisConstraint = thisParameters[i];
            ValueConstraint thatConstraint = thatParameters[i];
            if (thisConstraint == thatConstraint) continue;
            if (result != null || !thisConstraint.canBeNegated() || thisConstraint.negate() != thatConstraint) {
                return null;
            }
            result = (ValueConstraint[])thisParameters.clone();
            result[i] = ValueConstraint.ANY_VALUE;
        }
        return result == null ? null : new StandardMethodContract(result, this.getReturnValue());
    }

    @Nullable(value="When result is too big or contracts are erroneous")
    public static List<StandardMethodContract> toNonIntersectingContracts(List<StandardMethodContract> contracts2) {
        if (contracts2.isEmpty()) {
            return contracts2;
        }
        int paramCount = contracts2.get(0).getParameterCount();
        ArrayList<StandardMethodContract> result = new ArrayList<StandardMethodContract>();
        List leftovers = Collections.singletonList(StandardMethodContract.trivialContract(paramCount, ContractReturnValue.returnAny()));
        for (StandardMethodContract contract : contracts2) {
            if (contract.getParameterCount() != paramCount) {
                return null;
            }
            StreamEx.of(leftovers).map(c -> c.intersect(contract)).nonNull().into(result);
            if (result.size() >= 300) {
                return null;
            }
            if (!(leftovers = StreamEx.of(leftovers).flatMap(c -> c.excludeContract(contract)).toList()).isEmpty()) continue;
            break;
        }
        return result;
    }

    @NotNull
    public static ValueConstraint[] createConstraintArray(int paramCount) {
        ValueConstraint[] args = new ValueConstraint[paramCount];
        Arrays.fill((Object[])args, (Object)ValueConstraint.ANY_VALUE);
        return args;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        StandardMethodContract contract = (StandardMethodContract)o;
        return Arrays.equals((Object[])this.myParameters, (Object[])contract.myParameters) && this.getReturnValue().equals(contract.getReturnValue());
    }

    public int hashCode() {
        int result = 0;
        for (ValueConstraint argument : this.myParameters) {
            result = 31 * result + argument.ordinal();
        }
        result = 31 * result + this.getReturnValue().hashCode();
        return result;
    }

    @Override
    String getArgumentsPresentation() {
        return StringUtil.join((Object[])this.myParameters, ValueConstraint::toString, (String)", ");
    }

    @Override
    public List<ContractValue> getConditions() {
        return IntStreamEx.ofIndices((Object[])this.myParameters).mapToObj(idx -> this.myParameters[idx].getCondition(idx)).without((Object)ContractValue.booleanValue(true)).toList();
    }

    public static List<StandardMethodContract> parseContract(String text2) throws ParseException {
        ArrayList result = ContainerUtil.newArrayList();
        String[] split = StringUtil.replace((String)text2, (String)" ", (String)"").split(";");
        for (int clauseIndex = 0; clauseIndex < split.length; ++clauseIndex) {
            String returnValueString;
            ContractReturnValue returnValue;
            ValueConstraint[] args;
            String clause = split[clauseIndex];
            String arrow = "->";
            int arrowIndex = clause.indexOf(arrow);
            if (arrowIndex < 0) {
                throw ParseException.forClause("A contract clause must be in form arg1, ..., argN -> return-value", text2, clauseIndex);
            }
            String beforeArrow = clause.substring(0, arrowIndex);
            if (StringUtil.isNotEmpty((String)beforeArrow)) {
                String[] argStrings = beforeArrow.split(",");
                args = new ValueConstraint[argStrings.length];
                for (int i = 0; i < args.length; ++i) {
                    args[i] = StandardMethodContract.parseConstraint(argStrings[i], text2, clauseIndex, i);
                }
            } else {
                args = new ValueConstraint[]{};
            }
            if ((returnValue = ContractReturnValue.valueOf(returnValueString = clause.substring(arrowIndex + arrow.length()))) == null) {
                throw ParseException.forReturnValue("Return value should be one of: null, !null, true, false, this, new, paramN, fail, _. Found: " + returnValueString, text2, clauseIndex);
            }
            result.add(new StandardMethodContract(args, returnValue));
        }
        return result;
    }

    private static ValueConstraint parseConstraint(String name, String text2, int clauseIndex, int constraintIndex) throws ParseException {
        if (StringUtil.isEmpty((String)name)) {
            throw new ParseException("Constraint should not be empty");
        }
        for (ValueConstraint constraint : ValueConstraint.values()) {
            if (!constraint.toString().equals(name)) continue;
            return constraint;
        }
        throw ParseException.forConstraint("Constraint should be one of: null, !null, true, false, _. Found: " + name, text2, clauseIndex, constraintIndex);
    }

    public static class ParseException
    extends Exception {
        @Nullable
        private final TextRange myRange;

        ParseException(String message2) {
            this(message2, (TextRange)null);
        }

        ParseException(String message2, @Nullable TextRange range) {
            super(message2);
            this.myRange = range != null && range.isEmpty() ? null : range;
        }

        @Nullable
        public TextRange getRange() {
            return this.myRange;
        }

        static ParseException forConstraint(String message2, String text2, int clauseNumber, int constraintNumber) {
            TextRange range = ParseException.findClauseRange(text2, clauseNumber);
            if (range == null) {
                return new ParseException(message2);
            }
            int start = range.getStartOffset();
            while (constraintNumber > 0) {
                if ((start = text2.indexOf(44, start)) == -1) {
                    return new ParseException(message2, range);
                }
                ++start;
                --constraintNumber;
            }
            int end = text2.indexOf(44, start);
            if (!(end != -1 && end <= range.getEndOffset() || (end = text2.indexOf("->", start)) != -1 && end <= range.getEndOffset())) {
                end = range.getEndOffset();
            }
            if (!text2.substring(start, end).trim().isEmpty()) {
                while (text2.charAt(start) == ' ') {
                    ++start;
                }
                while (end > start && text2.charAt(end - 1) == ' ') {
                    --end;
                }
            }
            return new ParseException(message2, new TextRange(start, end));
        }

        static ParseException forReturnValue(String message2, String text2, int clauseNumber) {
            TextRange range = ParseException.findClauseRange(text2, clauseNumber);
            if (range == null) {
                return new ParseException(message2);
            }
            int index = text2.indexOf("->", range.getStartOffset());
            if (index == -1 || index > range.getEndOffset()) {
                return new ParseException(message2, range);
            }
            index += "->".length();
            while (index < range.getEndOffset() && text2.charAt(index) == ' ') {
                ++index;
            }
            if (index == range.getEndOffset()) {
                return new ParseException(message2, range);
            }
            return new ParseException(message2, new TextRange(index, range.getEndOffset()));
        }

        static ParseException forClause(String message2, String text2, int clauseNumber) {
            TextRange range = ParseException.findClauseRange(text2, clauseNumber);
            return range == null ? new ParseException(message2) : new ParseException(message2, range);
        }

        private static TextRange findClauseRange(String text2, int clauseNumber) {
            int start = 0;
            while (clauseNumber > 0) {
                if ((start = text2.indexOf(59, start)) == -1) {
                    return null;
                }
                ++start;
                --clauseNumber;
            }
            int end = text2.indexOf(59, start);
            if (end == -1) {
                end = text2.length();
            }
            if (text2.substring(start, end).trim().isEmpty()) {
                return new TextRange(start, end);
            }
            while (text2.charAt(start) == ' ') {
                ++start;
            }
            while (end > start && text2.charAt(end - 1) == ' ') {
                --end;
            }
            return new TextRange(start, end);
        }
    }

    public static enum ValueConstraint {
        ANY_VALUE("_", ContractReturnValue.returnAny()),
        NULL_VALUE("null", ContractReturnValue.returnNull()),
        NOT_NULL_VALUE("!null", ContractReturnValue.returnNotNull()),
        TRUE_VALUE("true", ContractReturnValue.returnTrue()),
        FALSE_VALUE("false", ContractReturnValue.returnFalse());

        private final String myPresentableName;
        private final ContractReturnValue myCorrespondingReturnValue;

        private ValueConstraint(String presentableName, ContractReturnValue correspondingReturnValue) {
            this.myPresentableName = presentableName;
            this.myCorrespondingReturnValue = correspondingReturnValue;
        }

        public ContractReturnValue asReturnValue() {
            return this.myCorrespondingReturnValue;
        }

        @Nullable
        DfaConstValue getComparisonValue(DfaValueFactory factory) {
            if (this == NULL_VALUE || this == NOT_NULL_VALUE) {
                return factory.getConstFactory().getNull();
            }
            if (this == TRUE_VALUE || this == FALSE_VALUE) {
                return factory.getConstFactory().getTrue();
            }
            return null;
        }

        boolean shouldUseNonEqComparison() {
            return this == NOT_NULL_VALUE || this == FALSE_VALUE;
        }

        public ContractValue getCondition(int argumentIndex) {
            ContractValue left;
            if (this == NULL_VALUE || this == NOT_NULL_VALUE) {
                left = ContractValue.nullValue();
            } else if (this == TRUE_VALUE || this == FALSE_VALUE) {
                left = ContractValue.booleanValue(true);
            } else {
                return ContractValue.booleanValue(true);
            }
            return ContractValue.condition(left, DfaRelationValue.RelationType.equivalence(!this.shouldUseNonEqComparison()), ContractValue.argument(argumentIndex));
        }

        public boolean canBeNegated() {
            return this != ANY_VALUE;
        }

        public ValueConstraint negate() {
            switch (this) {
                case NULL_VALUE: {
                    return NOT_NULL_VALUE;
                }
                case NOT_NULL_VALUE: {
                    return NULL_VALUE;
                }
                case TRUE_VALUE: {
                    return FALSE_VALUE;
                }
                case FALSE_VALUE: {
                    return TRUE_VALUE;
                }
            }
            throw new IllegalStateException("ValueConstraint = " + (Object)((Object)this));
        }

        public String toString() {
            return this.myPresentableName;
        }
    }
}

