/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.DfaVariableState;
import com.intellij.codeInspection.dataFlow.DistinctPairSet;
import com.intellij.codeInspection.dataFlow.EqClass;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaPsiType;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import one.util.streamex.LongStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StateMerger {
    private static final int COMPLEXITY_LIMIT = 250000;
    private final Map<DfaMemoryStateImpl, Set<Fact>> myFacts = ContainerUtil.newIdentityHashMap();
    private final Map<DfaMemoryState, Map<DfaVariableValue, DfaMemoryStateImpl>> myCopyCache = ContainerUtil.newIdentityHashMap();

    StateMerger() {
    }

    @Nullable
    List<DfaMemoryStateImpl> mergeByFacts(@NotNull List<DfaMemoryStateImpl> states) {
        MultiMap<Fact, DfaMemoryStateImpl> statesByFact = this.createFactToStateMap(states);
        Set facts = statesByFact.keySet();
        int complexity = 0;
        for (Fact fact : facts) {
            Collection positiveStates;
            Collection negativeStates;
            if (fact.myPositive || (negativeStates = statesByFact.get((Object)fact)).size() == states.size() || (positiveStates = statesByFact.get((Object)fact.getPositiveCounterpart())).isEmpty()) continue;
            ProgressManager.checkCanceled();
            MultiMap<CompactFactSet, DfaMemoryStateImpl> statesByUnrelatedFacts1 = this.mapByUnrelatedFacts(fact, negativeStates, facts);
            MultiMap<CompactFactSet, DfaMemoryStateImpl> statesByUnrelatedFacts2 = this.mapByUnrelatedFacts(fact, positiveStates, facts);
            if ((complexity += StreamEx.of((Object[])new MultiMap[]{statesByUnrelatedFacts1, statesByUnrelatedFacts2}).flatCollection(MultiMap::keySet).mapToInt(CompactFactSet::size).sum()) > 250000) {
                return null;
            }
            Replacements replacements = new Replacements(states);
            for (Map.Entry entry : statesByUnrelatedFacts1.entrySet()) {
                Collection group1 = (Collection)entry.getValue();
                Collection group2 = statesByUnrelatedFacts2.get(entry.getKey());
                if (group1.isEmpty() || group2.isEmpty()) continue;
                ArrayList group = ContainerUtil.newArrayList((Iterable)ContainerUtil.concat((Iterable[])new Iterable[]{group1, group2}));
                replacements.stripAndMerge(group, (Function<DfaMemoryStateImpl, DfaMemoryStateImpl>)original -> {
                    DfaMemoryStateImpl copy = original.createCopy();
                    fact.removeFromState(copy);
                    if (fact instanceof EqualityFact) {
                        this.restoreOtherInequalities((EqualityFact)fact, group, copy);
                    }
                    return copy;
                });
            }
            if (!replacements.hasMerges()) continue;
            return replacements.getMergeResult();
        }
        return null;
    }

    @NotNull
    private MultiMap<Fact, DfaMemoryStateImpl> createFactToStateMap(@NotNull List<DfaMemoryStateImpl> states) {
        MultiMap statesByFact = MultiMap.createLinked();
        HashMap<DfaConstValue, Map<DfaVariableValue, Set<DfaMemoryStateImpl>>> constantVars = new HashMap<DfaConstValue, Map<DfaVariableValue, Set<DfaMemoryStateImpl>>>();
        for (DfaMemoryStateImpl state : states) {
            ProgressManager.checkCanceled();
            for (Fact fact : this.getFacts(state)) {
                statesByFact.putValue((Object)fact, (Object)state);
                DfaConstValue value2 = fact.comparedToConstant();
                if (value2 == null) continue;
                constantVars.computeIfAbsent(value2, k -> new HashMap()).computeIfAbsent(fact.myVar, k -> ContainerUtil.newIdentityTroveSet()).add(state);
            }
        }
        for (Fact fact : new ArrayList(statesByFact.keySet())) {
            if (fact.myPositive) continue;
            Collection negativeStates = statesByFact.get((Object)fact);
            Collection positiveStates = statesByFact.get((Object)fact.getPositiveCounterpart());
            if (!StateMerger.isComparisonOfVariablesComparedWithConstant(fact, constantVars, positiveStates, negativeStates)) continue;
            statesByFact.remove((Object)fact);
            statesByFact.remove((Object)fact.getPositiveCounterpart());
        }
        return statesByFact;
    }

    private static boolean isComparisonOfVariablesComparedWithConstant(Fact fact, Map<DfaConstValue, Map<DfaVariableValue, Set<DfaMemoryStateImpl>>> constantVars, Collection<DfaMemoryStateImpl> positiveStates, Collection<DfaMemoryStateImpl> negativeStates) {
        if (!(fact instanceof EqualityFact) || !(((EqualityFact)fact).myArg instanceof DfaVariableValue)) {
            return false;
        }
        DfaVariableValue var1 = fact.myVar;
        DfaVariableValue var2 = (DfaVariableValue)((EqualityFact)fact).myArg;
        for (Map<DfaVariableValue, Set<DfaMemoryStateImpl>> map2 : constantVars.values()) {
            Set<DfaMemoryStateImpl> states1 = map2.get(var1);
            Set<DfaMemoryStateImpl> states2 = map2.get(var2);
            if (states1 == null || states2 == null || !states1.containsAll(negativeStates) || !states1.containsAll(positiveStates) || !states2.containsAll(negativeStates) || !states2.containsAll(positiveStates)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private MultiMap<CompactFactSet, DfaMemoryStateImpl> mapByUnrelatedFacts(@NotNull Fact fact, @NotNull Collection<DfaMemoryStateImpl> states, @NotNull Set<Fact> interestingFacts) {
        MultiMap statesByUnrelatedFacts = MultiMap.createLinked();
        for (DfaMemoryStateImpl state : states) {
            statesByUnrelatedFacts.putValue((Object)this.getUnrelatedFacts(fact, state, interestingFacts), (Object)state);
        }
        return statesByUnrelatedFacts;
    }

    @NotNull
    private CompactFactSet getUnrelatedFacts(@NotNull Fact fact, @NotNull DfaMemoryStateImpl state, @NotNull Set<Fact> interestingFacts) {
        ArrayList<Fact> result = new ArrayList<Fact>();
        for (Fact other : this.getFacts(state)) {
            if (fact.invalidatesFact(other) || !interestingFacts.contains(other)) continue;
            result.add(other);
        }
        return new CompactFactSet(state.getFactory(), result);
    }

    private void restoreOtherInequalities(@NotNull EqualityFact removedFact, @NotNull Collection<DfaMemoryStateImpl> mergedGroup, @NotNull DfaMemoryStateImpl state) {
        Set<DfaConstValue> inequalitiesToRestore = null;
        for (DfaMemoryStateImpl member : mergedGroup) {
            Set<Fact> memberFacts = this.getFacts(member);
            if (!memberFacts.contains(removedFact)) continue;
            Set<DfaConstValue> otherInequalities = StateMerger.getOtherInequalities(removedFact, memberFacts, member);
            if (inequalitiesToRestore == null) {
                inequalitiesToRestore = otherInequalities;
                continue;
            }
            inequalitiesToRestore.retainAll(otherInequalities);
        }
        if (inequalitiesToRestore != null) {
            DfaRelationValue.Factory relationFactory = state.getFactory().getRelationFactory();
            for (DfaConstValue toRestore : inequalitiesToRestore) {
                state.applyCondition(relationFactory.createRelation(removedFact.myVar, DfaRelationValue.RelationType.NE, toRestore));
            }
        }
    }

    @NotNull
    private static Set<DfaConstValue> getOtherInequalities(@NotNull EqualityFact removedFact, @NotNull Set<Fact> memberFacts, @NotNull DfaMemoryStateImpl state) {
        LinkedHashSet otherInequalities = ContainerUtil.newLinkedHashSet();
        HashSet eqValues = ContainerUtil.newHashSet(state.getEquivalentValues(removedFact.myArg));
        for (Fact candidate : memberFacts) {
            if (!(candidate instanceof EqualityFact)) continue;
            EqualityFact equality = (EqualityFact)candidate;
            if (equality.myPositive || equality.myVar != removedFact.myVar || !(equality.myArg instanceof DfaConstValue) || eqValues.contains(equality.myArg)) continue;
            otherInequalities.add((DfaConstValue)equality.myArg);
        }
        return otherInequalities;
    }

    @Nullable
    List<DfaMemoryStateImpl> mergeByRanges(List<DfaMemoryStateImpl> states) {
        Map<DfaVariableValue, Set<LongRangeSet>> ranges = StateMerger.createRangeMap(states);
        boolean changed = false;
        for (Map.Entry<DfaVariableValue, Set<LongRangeSet>> entry : ranges.entrySet()) {
            List<DfaMemoryStateImpl> updated;
            if (entry.getValue().size() <= 1 || (updated = this.mergeIndependentRanges(states, entry.getKey())) == null) continue;
            states = updated;
            changed = true;
        }
        return changed ? states : null;
    }

    @NotNull
    private static Map<DfaVariableValue, Set<LongRangeSet>> createRangeMap(List<DfaMemoryStateImpl> states) {
        LinkedHashMap<DfaVariableValue, Set<LongRangeSet>> ranges = new LinkedHashMap<DfaVariableValue, Set<LongRangeSet>>();
        for (DfaMemoryStateImpl state : states) {
            ProgressManager.checkCanceled();
            state.forVariableStates((varValue, varState) -> {
                LongRangeSet range = varState.getFact(DfaFactType.RANGE);
                if (range != null) {
                    ranges.computeIfAbsent((DfaVariableValue)varValue, k -> new HashSet()).add(range);
                }
            });
        }
        return ranges;
    }

    @Nullable
    private List<DfaMemoryStateImpl> mergeIndependentRanges(List<DfaMemoryStateImpl> states, DfaVariableValue var) {
        ProgressManager.checkCanceled();
        class Record {
            final DfaMemoryStateImpl myState;
            final LongRangeSet myRange;
            final Set<EqualityFact> myCommonEqualities;
            final /* synthetic */ DfaVariableValue val$var;
            final /* synthetic */ StateMerger this$0;

            Record(DfaMemoryStateImpl state, LongRangeSet range, Set<EqualityFact> commonEqualities) {
                this.this$0 = this$0;
                this.val$var = var5_5;
                this.myState = state;
                this.myRange = range;
                this.myCommonEqualities = commonEqualities;
            }

            Set<EqualityFact> getEqualityFacts() {
                return ((StreamEx)StreamEx.of((Collection)this.this$0.getFacts(this.myState)).select(EqualityFact.class).filter(fact -> fact.myVar == this.val$var || ((EqualityFact)fact).myArg == this.val$var)).toSet();
            }

            Record unite(Record other) {
                Set<EqualityFact> equalities = this.myCommonEqualities == null ? this.getEqualityFacts() : this.myCommonEqualities;
                equalities.retainAll(other.getEqualityFacts());
                return new Record(this.this$0, this.myState, this.myRange.unite(other.myRange), equalities, this.val$var);
            }

            DfaMemoryStateImpl getState() {
                if (this.myCommonEqualities != null) {
                    this.this$0.myFacts.remove(this.myState);
                    this.myState.removeEquivalenceForVariableAndWrappers(this.val$var);
                    this.myState.setVariableState(this.val$var, this.myState.getVariableState(this.val$var).withFact(DfaFactType.RANGE, this.myRange));
                    for (EqualityFact equality : this.myCommonEqualities) {
                        equality.applyTo(this.myState);
                    }
                }
                return this.myState;
            }
        }
        LinkedHashMap<DfaMemoryStateImpl, Record> merged = new LinkedHashMap<DfaMemoryStateImpl, Record>();
        for (DfaMemoryStateImpl state : states) {
            DfaVariableState variableState = state.getVariableState(var);
            LongRangeSet range = variableState.getFact(DfaFactType.RANGE);
            if (range == null && (range = LongRangeSet.fromType(var.getType())) == null) {
                return null;
            }
            merged.merge(this.copyWithoutVar(state, var), new Record(this, state, range, null, var), Record::unite);
        }
        return merged.size() == states.size() ? null : StreamEx.ofValues(merged).map(Record::getState).toList();
    }

    @NotNull
    private DfaMemoryStateImpl copyWithoutVar(@NotNull DfaMemoryStateImpl state, @NotNull DfaVariableValue var) {
        Map map2 = this.myCopyCache.computeIfAbsent(state, k -> ContainerUtil.newIdentityHashMap());
        DfaMemoryStateImpl copy = (DfaMemoryStateImpl)map2.get(var);
        if (copy == null) {
            copy = state.createCopy();
            copy.flushVariable(var);
            map2.put(var, copy);
        }
        return copy;
    }

    @NotNull
    private Set<Fact> getFacts(@NotNull DfaMemoryStateImpl state) {
        return this.myFacts.computeIfAbsent(state, StateMerger::doGetFacts);
    }

    @NotNull
    private static Set<Fact> doGetFacts(DfaMemoryStateImpl state) {
        LinkedHashSet result = ContainerUtil.newLinkedHashSet();
        IdentityHashMap<EqClass, EqClassInfo> classInfo = new IdentityHashMap<EqClass, EqClassInfo>();
        for (EqClass eqClass : state.getNonTrivialEqClasses()) {
            EqClassInfo info = classInfo.computeIfAbsent(eqClass, EqClassInfo::new);
            DfaConstValue constant = info.constant;
            List<DfaVariableValue> vars = info.vars;
            int size = vars.size();
            for (int i = 0; i < size; ++i) {
                DfaVariableValue var2 = vars.get(i);
                if (constant != null) {
                    result.add(Fact.createEqualityFact(var2, constant));
                }
                for (int j = i + 1; j < size; ++j) {
                    DfaVariableValue eqVar = vars.get(j);
                    result.add(Fact.createEqualityFact(var2, eqVar));
                }
            }
        }
        for (DistinctPairSet.DistinctPair classPair : state.getDistinctClassPairs()) {
            EqClassInfo info1 = classInfo.computeIfAbsent(classPair.getFirst(), EqClassInfo::new);
            EqClassInfo info2 = classInfo.computeIfAbsent(classPair.getSecond(), EqClassInfo::new);
            for (DfaVariableValue var1 : info1.vars) {
                for (DfaVariableValue var2 : info2.vars) {
                    result.add(new EqualityFact(var1, false, var2));
                    result.add(new EqualityFact(var2, false, var1));
                }
            }
            if (info1.constant != null) {
                for (DfaVariableValue var2 : info2.vars) {
                    result.add(new EqualityFact(var2, false, info1.constant));
                }
            }
            if (info2.constant == null) continue;
            for (DfaVariableValue var1 : info1.vars) {
                result.add(new EqualityFact(var1, false, info2.constant));
            }
        }
        state.forVariableStates((var, variableState) -> {
            TypeConstraint typeConstraint = variableState.getTypeConstraint();
            for (DfaPsiType type2 : typeConstraint.getInstanceofValues()) {
                result.add(new InstanceofFact((DfaVariableValue)var, true, type2));
            }
            for (DfaPsiType type2 : typeConstraint.getNotInstanceofValues()) {
                result.add(new InstanceofFact((DfaVariableValue)var, false, type2));
            }
        });
        return result;
    }

    static final class EqClassInfo {
        final List<DfaVariableValue> vars;
        final DfaConstValue constant;

        EqClassInfo(EqClass eqClass) {
            this.vars = eqClass.getVariables(false);
            this.constant = eqClass.findConstant();
        }
    }

    private static class Replacements {
        @NotNull
        private final List<DfaMemoryStateImpl> myAllStates;
        private final Set<DfaMemoryStateImpl> myRemovedStates = ContainerUtil.newIdentityTroveSet();
        private final List<DfaMemoryStateImpl> myMerged = ContainerUtil.newArrayList();

        private Replacements(@NotNull List<DfaMemoryStateImpl> allStates) {
            this.myAllStates = allStates;
        }

        private boolean hasMerges() {
            return !this.myMerged.isEmpty();
        }

        @Nullable
        private List<DfaMemoryStateImpl> getMergeResult() {
            if (this.hasMerges()) {
                ArrayList result = ContainerUtil.newArrayList(this.myMerged);
                for (DfaMemoryStateImpl state : this.myAllStates) {
                    if (this.myRemovedStates.contains(state)) continue;
                    result.add(state);
                }
                return result;
            }
            return null;
        }

        private void stripAndMerge(@NotNull Collection<DfaMemoryStateImpl> group, @NotNull Function<DfaMemoryStateImpl, DfaMemoryStateImpl> stripper) {
            if (group.size() <= 1) {
                return;
            }
            MultiMap strippedToOriginals = MultiMap.create();
            for (DfaMemoryStateImpl original : group) {
                strippedToOriginals.putValue(stripper.fun((Object)original), (Object)original);
            }
            for (Map.Entry entry : strippedToOriginals.entrySet()) {
                Collection merged = (Collection)entry.getValue();
                if (merged.size() <= 1) continue;
                this.myRemovedStates.addAll(merged);
                this.myMerged.add((DfaMemoryStateImpl)entry.getKey());
            }
        }
    }

    static final class InstanceofFact
    extends Fact {
        @NotNull
        private final DfaPsiType myType;

        private InstanceofFact(@NotNull DfaVariableValue var, boolean positive, @NotNull DfaPsiType type2) {
            super(positive, var, (var.hashCode() * 31 + type2.hashCode()) * 31 + (positive ? 1 : 0));
            this.myType = type2;
        }

        @Override
        int packHigh() {
            return -this.myType.getID();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof InstanceofFact)) {
                return false;
            }
            InstanceofFact fact = (InstanceofFact)o;
            return this.myPositive == fact.myPositive && this.myType == fact.myType && this.myVar == fact.myVar;
        }

        public String toString() {
            return this.myVar + (this.myPositive ? " IS " : " IS NOT ") + this.myType;
        }

        @Override
        @NotNull
        Fact getPositiveCounterpart() {
            return new InstanceofFact(this.myVar, true, this.myType);
        }

        @Override
        boolean invalidatesFact(@NotNull Fact another) {
            return another instanceof InstanceofFact && this.myType == ((InstanceofFact)another).myType && this.myVar == another.myVar;
        }

        @Override
        void removeFromState(@NotNull DfaMemoryStateImpl state) {
            DfaVariableState varState = state.getVariableState(this.myVar);
            state.setVariableState(this.myVar, varState.withoutType(this.myType));
        }
    }

    static final class EqualityFact
    extends Fact {
        @NotNull
        private final DfaValue myArg;

        private EqualityFact(@NotNull DfaVariableValue var, boolean positive, @NotNull DfaValue arg) {
            super(positive, var, (var.hashCode() * 31 + arg.hashCode()) * 31 + (positive ? 1 : 0));
            this.myArg = arg;
        }

        @Override
        int packHigh() {
            return this.myArg.getID();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EqualityFact)) {
                return false;
            }
            EqualityFact fact = (EqualityFact)o;
            return this.myArg == fact.myArg && this.myVar == fact.myVar && this.myPositive == fact.myPositive;
        }

        public String toString() {
            return this.myVar + (this.myPositive ? " EQ " : " NE ") + this.myArg;
        }

        @Override
        DfaConstValue comparedToConstant() {
            return this.myArg instanceof DfaConstValue ? (DfaConstValue)this.myArg : null;
        }

        @Override
        @NotNull
        EqualityFact getPositiveCounterpart() {
            return new EqualityFact(this.myVar, true, this.myArg);
        }

        void applyTo(DfaMemoryStateImpl state) {
            state.applyCondition(state.getFactory().createCondition(this.myVar, this.myPositive ? DfaRelationValue.RelationType.EQ : DfaRelationValue.RelationType.NE, this.myArg));
        }

        @Override
        boolean invalidatesFact(@NotNull Fact another) {
            if (!(another instanceof EqualityFact)) {
                return false;
            }
            return this.myVar == another.myVar || this.myVar == ((EqualityFact)another).myArg;
        }

        @Override
        void removeFromState(@NotNull DfaMemoryStateImpl state) {
            state.removeEquivalenceForVariableAndWrappers(this.myVar);
        }
    }

    static abstract class Fact {
        final boolean myPositive;
        @NotNull
        final DfaVariableValue myVar;
        private final int myHash;

        protected Fact(boolean positive, @NotNull DfaVariableValue var, int hash) {
            this.myPositive = positive;
            this.myVar = var;
            this.myHash = hash;
        }

        private int packLow() {
            return this.myPositive ? this.myVar.getID() : -this.myVar.getID();
        }

        abstract int packHigh();

        long pack() {
            int lo = this.packLow();
            int hi = this.packHigh();
            return (long)hi << 32 | (long)lo & 0xFFFFFFFFL;
        }

        public final int hashCode() {
            return this.myHash;
        }

        @NotNull
        abstract Fact getPositiveCounterpart();

        DfaConstValue comparedToConstant() {
            return null;
        }

        abstract boolean invalidatesFact(@NotNull Fact var1);

        abstract void removeFromState(@NotNull DfaMemoryStateImpl var1);

        @NotNull
        static EqualityFact createEqualityFact(@NotNull DfaVariableValue var, @NotNull DfaValue val) {
            if (val instanceof DfaVariableValue && val.getID() < var.getID()) {
                return new EqualityFact((DfaVariableValue)val, true, var);
            }
            return new EqualityFact(var, true, val);
        }

        static Fact unpack(DfaValueFactory factory, long packed) {
            int lo = (int)(packed & 0xFFFFFFFFL);
            int hi = (int)(packed >> 32);
            boolean positive = lo >= 0;
            DfaVariableValue var = (DfaVariableValue)factory.getValue(Math.abs(lo));
            if (hi >= 0) {
                return new EqualityFact(var, positive, factory.getValue(hi));
            }
            return new InstanceofFact(var, positive, factory.getType(-hi));
        }
    }

    static final class CompactFactSet {
        private final long[] myData;
        private final int myHashCode;
        private final DfaValueFactory myFactory;

        CompactFactSet(DfaValueFactory factory, Collection<Fact> facts) {
            this.myData = facts.stream().mapToLong(Fact::pack).toArray();
            Arrays.sort(this.myData);
            this.myHashCode = Arrays.hashCode(this.myData);
            this.myFactory = factory;
        }

        public int size() {
            return this.myData.length;
        }

        public int hashCode() {
            return this.myHashCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CompactFactSet)) {
                return false;
            }
            CompactFactSet other = (CompactFactSet)obj;
            return this.myHashCode == other.myHashCode && Arrays.equals(this.myData, other.myData);
        }

        public String toString() {
            return LongStreamEx.of((long[])this.myData).mapToObj(f -> Fact.unpack(this.myFactory, f)).joining((CharSequence)", ", (CharSequence)"{", (CharSequence)"}");
        }
    }
}

