/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaFactMap;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.value.DfaPsiType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TypeConstraint {
    @NotNull
    public abstract String getPresentationText(@Nullable PsiType var1);

    @Nullable
    public abstract TypeConstraint withInstanceofValue(@NotNull DfaPsiType var1);

    @Nullable
    public abstract TypeConstraint withNotInstanceofValue(DfaPsiType var1);

    @NotNull
    abstract TypeConstraint withoutType(@NotNull DfaPsiType var1);

    @Nullable
    public abstract PsiType getPsiType();

    abstract boolean isSuperStateOf(@NotNull TypeConstraint var1);

    @Nullable
    public abstract TypeConstraint unite(@NotNull TypeConstraint var1);

    @Nullable
    abstract TypeConstraint intersect(@NotNull TypeConstraint var1);

    @NotNull
    public abstract Set<DfaPsiType> getInstanceofValues();

    @NotNull
    public abstract Set<DfaPsiType> getNotInstanceofValues();

    public abstract boolean isEmpty();

    public abstract boolean isExact();

    public abstract boolean isExact(String var1);

    private static TypeConstraint create(@NotNull Set<DfaPsiType> instanceofValues, @NotNull Set<DfaPsiType> notInstanceofValues) {
        if (instanceofValues.isEmpty() && notInstanceofValues.isEmpty()) {
            return Constrained.EMPTY;
        }
        if (instanceofValues.isEmpty()) {
            instanceofValues = Collections.emptySet();
        } else if (instanceofValues.size() == 1) {
            instanceofValues = Collections.singleton(instanceofValues.iterator().next());
        }
        if (notInstanceofValues.isEmpty()) {
            notInstanceofValues = Collections.emptySet();
        } else if (notInstanceofValues.size() == 1) {
            notInstanceofValues = Collections.singleton(notInstanceofValues.iterator().next());
        }
        return new Constrained(instanceofValues, notInstanceofValues);
    }

    @Nullable
    public static DfaFactMap withInstanceOf(@NotNull DfaFactMap map2, @NotNull DfaPsiType type2) {
        TypeConstraint constraint = map2.get(DfaFactType.TYPE_CONSTRAINT);
        if (constraint == null) {
            constraint = Constrained.EMPTY;
        }
        return (constraint = constraint.withInstanceofValue(type2)) == null ? null : map2.with(DfaFactType.TYPE_CONSTRAINT, constraint);
    }

    public static TypeConstraint exact(@NotNull DfaPsiType type2) {
        return new Exact(type2);
    }

    public static TypeConstraint empty() {
        return Constrained.EMPTY;
    }

    private static final class Constrained
    extends TypeConstraint {
        private static final TypeConstraint EMPTY = new Constrained(Collections.emptySet(), Collections.emptySet());
        @NotNull
        private final Set<DfaPsiType> myInstanceofValues;
        @NotNull
        private final Set<DfaPsiType> myNotInstanceofValues;

        Constrained(@NotNull Set<DfaPsiType> instanceofValues, @NotNull Set<DfaPsiType> notInstanceofValues) {
            this.myInstanceofValues = instanceofValues;
            this.myNotInstanceofValues = notInstanceofValues;
        }

        @Override
        @NotNull
        public String getPresentationText(@Nullable PsiType type2) {
            Set instanceOfTypes = this.myInstanceofValues;
            if (type2 != null) {
                instanceOfTypes = StreamEx.of(instanceOfTypes).removeBy(DfaPsiType::getPsiType, (Object)DfaPsiType.normalizeType(type2)).toSet();
            }
            return EntryStream.of((Object)"instanceof ", instanceOfTypes, (Object)"not instanceof ", this.myNotInstanceofValues).removeValues(Set::isEmpty).mapKeyValue((prefix, set) -> ((StreamEx)StreamEx.of((Collection)set).map(DfaPsiType::toString).sorted()).joining((CharSequence)", ", (CharSequence)prefix, (CharSequence)"")).joining((CharSequence)"\n");
        }

        boolean checkInstanceofValue(@NotNull DfaPsiType dfaType) {
            if (this.myInstanceofValues.contains(dfaType)) {
                return true;
            }
            for (DfaPsiType dfaTypeValue : this.myNotInstanceofValues) {
                if (!dfaTypeValue.isAssignableFrom(dfaType)) continue;
                return false;
            }
            for (DfaPsiType dfaTypeValue : this.myInstanceofValues) {
                if (dfaType.isConvertibleFrom(dfaTypeValue)) continue;
                return false;
            }
            return true;
        }

        @Override
        @Nullable
        public TypeConstraint withInstanceofValue(@NotNull DfaPsiType type2) {
            PsiType psiType = type2.getPsiType();
            if (psiType instanceof PsiPrimitiveType || LambdaUtil.notInferredType((PsiType)psiType)) {
                return this;
            }
            PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)psiType);
            if (psiClass != null && psiClass.hasModifierProperty("final")) {
                return new Exact(type2).intersect(this);
            }
            if (!this.checkInstanceofValue(type2)) {
                return null;
            }
            ArrayList<DfaPsiType> moreGeneric = new ArrayList<DfaPsiType>();
            for (DfaPsiType alreadyInstanceof : this.myInstanceofValues) {
                if (type2.isAssignableFrom(alreadyInstanceof)) {
                    return this;
                }
                if (!alreadyInstanceof.isAssignableFrom(type2)) continue;
                moreGeneric.add(alreadyInstanceof);
            }
            THashSet newInstanceof = ContainerUtil.newTroveSet(this.myInstanceofValues);
            newInstanceof.removeAll(moreGeneric);
            newInstanceof.add(type2);
            return TypeConstraint.create((Set)newInstanceof, this.myNotInstanceofValues);
        }

        @Override
        @Nullable
        public TypeConstraint withNotInstanceofValue(DfaPsiType type2) {
            if (this.myNotInstanceofValues.contains(type2)) {
                return this;
            }
            for (DfaPsiType dfaPsiType : this.myInstanceofValues) {
                if (!type2.isAssignableFrom(dfaPsiType)) continue;
                return null;
            }
            ArrayList<DfaPsiType> moreSpecific = new ArrayList<DfaPsiType>();
            for (DfaPsiType alreadyNotInstanceof : this.myNotInstanceofValues) {
                if (alreadyNotInstanceof.isAssignableFrom(type2)) {
                    return this;
                }
                if (!type2.isAssignableFrom(alreadyNotInstanceof)) continue;
                moreSpecific.add(alreadyNotInstanceof);
            }
            THashSet tHashSet = ContainerUtil.newTroveSet(this.myNotInstanceofValues);
            tHashSet.removeAll(moreSpecific);
            tHashSet.add(type2);
            return TypeConstraint.create(this.myInstanceofValues, (Set)tHashSet);
        }

        @Override
        @NotNull
        TypeConstraint withoutType(@NotNull DfaPsiType type2) {
            if (this.myInstanceofValues.contains(type2)) {
                THashSet newInstanceof = ContainerUtil.newTroveSet(this.myInstanceofValues);
                newInstanceof.remove(type2);
                return TypeConstraint.create((Set)newInstanceof, this.myNotInstanceofValues);
            }
            if (this.myNotInstanceofValues.contains(type2)) {
                THashSet newNotInstanceof = ContainerUtil.newTroveSet(this.myNotInstanceofValues);
                newNotInstanceof.remove(type2);
                return TypeConstraint.create(this.myInstanceofValues, (Set)newNotInstanceof);
            }
            return this;
        }

        @Override
        @Nullable
        public PsiType getPsiType() {
            PsiType[] conjuncts = (PsiType[])StreamEx.of(this.myInstanceofValues).map(DfaPsiType::getPsiType).toArray((Object[])PsiType.EMPTY_ARRAY);
            return conjuncts.length == 0 ? null : PsiIntersectionType.createIntersection((boolean)true, (PsiType[])conjuncts);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        boolean isSuperStateOf(@NotNull TypeConstraint other) {
            if (other instanceof Constrained) {
                Constrained that = (Constrained)other;
                if (that.myNotInstanceofValues.containsAll(this.myNotInstanceofValues) && that.myInstanceofValues.containsAll(this.myInstanceofValues)) {
                    return true;
                }
                if (!this.myNotInstanceofValues.isEmpty()) return false;
                if (!that.myNotInstanceofValues.isEmpty()) return false;
                return that.myInstanceofValues.stream().allMatch(thatType -> this.myInstanceofValues.stream().allMatch(thisType -> thisType.isAssignableFrom((DfaPsiType)thatType)));
            }
            if (!(other instanceof Exact)) return false;
            DfaPsiType otherType = ((Exact)other).myType;
            if (!this.myInstanceofValues.stream().allMatch(otherType::isAssignableFrom)) return false;
            if (!this.myNotInstanceofValues.stream().noneMatch(otherType::isAssignableFrom)) return false;
            return true;
        }

        @Override
        @Nullable
        public TypeConstraint unite(@NotNull TypeConstraint other) {
            if (this.isSuperStateOf(other)) {
                return this;
            }
            if (other.isSuperStateOf(this)) {
                return other;
            }
            if (other instanceof Constrained) {
                return this.unite((Constrained)other);
            }
            if (other instanceof Exact) {
                return this.unite(new Constrained(Collections.singleton(((Exact)other).myType), Collections.emptySet()));
            }
            return EMPTY;
        }

        @Override
        @Nullable
        TypeConstraint intersect(@NotNull TypeConstraint right) {
            if (right instanceof Exact) {
                return right.intersect(this);
            }
            TypeConstraint result = this;
            for (DfaPsiType type2 : right.getInstanceofValues()) {
                if ((result = result.withInstanceofValue(type2)) != null) continue;
                return null;
            }
            for (DfaPsiType type2 : right.getNotInstanceofValues()) {
                if ((result = result.withNotInstanceofValue(type2)) != null) continue;
                return null;
            }
            return result;
        }

        private TypeConstraint unite(@NotNull Constrained other) {
            Set<DfaPsiType> instanceOfTypes;
            THashSet notTypes = ContainerUtil.newTroveSet(this.myNotInstanceofValues);
            notTypes.retainAll(other.myNotInstanceofValues);
            if (this.myInstanceofValues.containsAll(other.myInstanceofValues)) {
                instanceOfTypes = other.myInstanceofValues;
            } else if (other.myInstanceofValues.containsAll(this.myInstanceofValues)) {
                instanceOfTypes = this.myInstanceofValues;
            } else {
                instanceOfTypes = Constrained.withSuper(this.myInstanceofValues);
                instanceOfTypes.retainAll(Constrained.withSuper(other.myInstanceofValues));
            }
            TypeConstraint constraint = EMPTY;
            for (DfaPsiType type2 : instanceOfTypes) {
                if ((constraint = constraint.withInstanceofValue(type2)) != null) continue;
                return EMPTY;
            }
            for (DfaPsiType type2 : notTypes) {
                if ((constraint = constraint.withNotInstanceofValue(type2)) != null) continue;
                return EMPTY;
            }
            return constraint;
        }

        private static Set<DfaPsiType> withSuper(Set<DfaPsiType> instanceofValues) {
            return StreamEx.of(instanceofValues).flatMap(DfaPsiType::superTypes).append(instanceofValues).toSet();
        }

        @Override
        @NotNull
        public Set<DfaPsiType> getInstanceofValues() {
            return Collections.unmodifiableSet(this.myInstanceofValues);
        }

        @Override
        @NotNull
        public Set<DfaPsiType> getNotInstanceofValues() {
            return Collections.unmodifiableSet(this.myNotInstanceofValues);
        }

        @Override
        public boolean isEmpty() {
            return this.myInstanceofValues.isEmpty() && this.myNotInstanceofValues.isEmpty();
        }

        @Override
        public boolean isExact() {
            return false;
        }

        @Override
        public boolean isExact(String typeName) {
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Constrained that = (Constrained)o;
            return Objects.equals(this.myInstanceofValues, that.myInstanceofValues) && Objects.equals(this.myNotInstanceofValues, that.myNotInstanceofValues);
        }

        public int hashCode() {
            return Objects.hash(this.myInstanceofValues, this.myNotInstanceofValues);
        }

        public String toString() {
            return EntryStream.of((Object)"instanceof ", this.myInstanceofValues, (Object)"not instanceof ", this.myNotInstanceofValues).removeValues(Set::isEmpty).mapKeyValue((prefix, set) -> StreamEx.of((Collection)set).joining((CharSequence)", ", (CharSequence)prefix, (CharSequence)"")).joining((CharSequence)" ");
        }
    }

    static final class Exact
    extends TypeConstraint {
        @NotNull
        final DfaPsiType myType;

        Exact(@NotNull DfaPsiType type2) {
            this.myType = type2;
        }

        @Override
        @NotNull
        public String getPresentationText(@Nullable PsiType type2) {
            return type2 != null && DfaPsiType.normalizeType(type2).equals(this.myType.getPsiType()) ? "" : "exactly " + this.myType;
        }

        @Override
        @Nullable
        public TypeConstraint withInstanceofValue(@NotNull DfaPsiType type2) {
            return type2.isAssignableFrom(this.myType) ? this : null;
        }

        @Override
        @Nullable
        public TypeConstraint withNotInstanceofValue(DfaPsiType type2) {
            return type2.isAssignableFrom(this.myType) ? null : this;
        }

        @Override
        @NotNull
        TypeConstraint withoutType(@NotNull DfaPsiType type2) {
            return this.myType == type2 ? Constrained.EMPTY : this;
        }

        @Override
        @NotNull
        public PsiType getPsiType() {
            return this.myType.getPsiType();
        }

        @Override
        boolean isSuperStateOf(@NotNull TypeConstraint other) {
            return this.equals(other);
        }

        @Override
        @Nullable
        public TypeConstraint unite(@NotNull TypeConstraint other) {
            if (this.isSuperStateOf(other)) {
                return this;
            }
            if (other.isSuperStateOf(this)) {
                return other;
            }
            return new Constrained(Collections.singleton(this.myType), Collections.emptySet()).unite(other);
        }

        @Override
        @Nullable
        TypeConstraint intersect(@NotNull TypeConstraint right) {
            if (right instanceof Exact) {
                return right.equals(this) ? this : null;
            }
            TypeConstraint result = this;
            for (DfaPsiType type2 : right.getInstanceofValues()) {
                if ((result = result.withInstanceofValue(type2)) != null) continue;
                return null;
            }
            for (DfaPsiType type2 : right.getNotInstanceofValues()) {
                if ((result = result.withNotInstanceofValue(type2)) != null) continue;
                return null;
            }
            return result;
        }

        @Override
        @NotNull
        public Set<DfaPsiType> getInstanceofValues() {
            return Collections.singleton(this.myType);
        }

        @Override
        @NotNull
        public Set<DfaPsiType> getNotInstanceofValues() {
            return Collections.emptySet();
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isExact() {
            return true;
        }

        @Override
        public boolean isExact(String typeName) {
            return this.myType.getPsiType().equalsToText(typeName);
        }

        public int hashCode() {
            return this.myType.hashCode();
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Exact && ((Exact)obj).myType.equals(this.myType);
        }

        public String toString() {
            return "exactly " + this.myType;
        }
    }
}

