/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.fix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class DeleteSwitchLabelFix
implements LocalQuickFix {
    private final String myName;
    private final boolean myBranch;

    public DeleteSwitchLabelFix(@NotNull PsiExpression label) {
        this.myName = label.getText();
        PsiSwitchLabelStatementBase labelStatement = Objects.requireNonNull(PsiImplUtil.getSwitchLabel(label));
        PsiExpressionList values = labelStatement.getCaseValues();
        boolean multiple = values != null && values.getExpressionCount() > 1;
        this.myBranch = !multiple && DeleteSwitchLabelFix.shouldRemoveBranch(labelStatement);
    }

    private static boolean shouldRemoveBranch(PsiSwitchLabelStatementBase label) {
        if (label instanceof PsiSwitchLabeledRuleStatement) {
            return true;
        }
        PsiStatement nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)label, PsiStatement.class);
        if (nextStatement instanceof PsiSwitchLabelStatement) {
            return false;
        }
        PsiStatement prevStatement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)label, PsiStatement.class);
        return prevStatement == null || !ControlFlowUtils.statementMayCompleteNormally(prevStatement);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getName() {
        return this.myBranch ? "Remove switch branch '" + this.myName + "'" : "Remove switch label '" + this.myName + "'";
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return "Remove switch label";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiExpression expression2 = (PsiExpression)ObjectUtils.tryCast((Object)descriptor.getStartElement(), PsiExpression.class);
        if (expression2 == null) {
            return;
        }
        PsiSwitchLabelStatementBase label = PsiImplUtil.getSwitchLabel(expression2);
        if (label == null) {
            return;
        }
        PsiExpressionList values = label.getCaseValues();
        if (values != null && values.getExpressionCount() == 1) {
            DeleteSwitchLabelFix.deleteLabel(label);
        } else {
            new CommentTracker().deleteAndRestoreComments((PsiElement)expression2);
        }
    }

    public static void deleteLabel(PsiSwitchLabelStatementBase label) {
        if (DeleteSwitchLabelFix.shouldRemoveBranch(label)) {
            PsiStatement next;
            PsiSwitchLabelStatementBase stopAt;
            PsiCodeBlock scope = (PsiCodeBlock)ObjectUtils.tryCast((Object)label.getParent(), PsiCodeBlock.class);
            if (scope == null) {
                return;
            }
            PsiSwitchLabelStatementBase nextLabel = (PsiSwitchLabelStatementBase)PsiTreeUtil.getNextSiblingOfType((PsiElement)label, PsiSwitchLabelStatementBase.class);
            Object object = stopAt = nextLabel == null ? scope.getRBrace() : nextLabel;
            while ((next = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)nextLabel, PsiStatement.class)) instanceof PsiSwitchLabelStatement) {
                nextLabel = (PsiSwitchLabelStatement)next;
            }
            int end = nextLabel == null ? -1 : nextLabel.getTextOffset();
            ArrayList<PsiElement> toDelete = new ArrayList<PsiElement>();
            ArrayList<PsiDeclarationStatement> declarations = new ArrayList<PsiDeclarationStatement>();
            for (PsiElement e = label.getNextSibling(); e != stopAt; e = e.getNextSibling()) {
                PsiDeclarationStatement declaration2;
                Object[] elements;
                boolean declarationIsReused;
                if (e instanceof PsiDeclarationStatement && nextLabel != null && (declarationIsReused = Stream.of(elements = (declaration2 = (PsiDeclarationStatement)e).getDeclaredElements()).anyMatch(element -> ReferencesSearch.search((PsiElement)element, (SearchScope)new LocalSearchScope((PsiElement)scope)).anyMatch(ref -> ref.getElement().getTextOffset() > end)))) {
                    StreamEx.of((Object[])elements).select(PsiVariable.class).map(PsiVariable::getInitializer).nonNull().into(toDelete);
                    declarations.add(declaration2);
                    continue;
                }
                toDelete.add(e);
            }
            CommentTracker ct = new CommentTracker();
            toDelete.stream().filter(PsiElement::isValid).forEach(ct::delete);
            for (PsiDeclarationStatement declaration3 : declarations) {
                scope.addAfter((PsiElement)declaration3, (PsiElement)nextLabel);
                declaration3.delete();
            }
            ct.insertCommentsBefore((PsiElement)label);
        }
        new CommentTracker().deleteAndRestoreComments((PsiElement)label);
    }
}

