/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.fix;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;

public class RedundantInstanceofFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        return InspectionsBundle.message((String)"inspection.data.flow.redundant.instanceof.quickfix", (Object[])new Object[0]);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        String replacement;
        PsiElement psiElement = descriptor.getPsiElement();
        CommentTracker ct = new CommentTracker();
        if (psiElement instanceof PsiMethodReferenceExpression) {
            String replacement2 = "java.util.Objects::nonNull";
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(ct.replaceAndRestoreComments(psiElement, replacement2));
            return;
        }
        String nonNullExpression = null;
        if (psiElement instanceof PsiInstanceOfExpression) {
            nonNullExpression = ct.text((PsiElement)((PsiInstanceOfExpression)psiElement).getOperand());
        } else if (psiElement instanceof PsiMethodCallExpression) {
            PsiExpression arg = (PsiExpression)ArrayUtil.getFirstElement((Object[])((PsiMethodCallExpression)psiElement).getArgumentList().getExpressions());
            if (arg == null) {
                return;
            }
            nonNullExpression = ct.text((PsiElement)arg);
        }
        if (nonNullExpression == null) {
            return;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)psiElement.getParent());
        if (parent instanceof PsiExpression && BoolUtils.isNegation((PsiExpression)parent)) {
            replacement = nonNullExpression + "==null";
            psiElement = parent;
        } else {
            replacement = nonNullExpression + "!=null";
        }
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(ct.replaceAndRestoreComments(psiElement, replacement));
    }
}

