/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.fix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.refactoring.extractMethod.ExtractMethodUtil;
import org.jetbrains.annotations.NotNull;

public class ReplaceWithConstantValueFix
implements LocalQuickFix {
    private final String myPresentableName;
    private final String myReplacementText;

    public ReplaceWithConstantValueFix(String presentableName, String replacementText) {
        this.myPresentableName = presentableName;
        this.myReplacementText = replacementText;
    }

    @NotNull
    public String getName() {
        return "Replace with '" + this.myPresentableName + "'";
    }

    @NotNull
    public String getFamilyName() {
        return "Replace with constant value";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement problemElement = descriptor.getPsiElement();
        if (problemElement == null) {
            return;
        }
        PsiMethodCallExpression call = problemElement.getParent() instanceof PsiExpressionList && problemElement.getParent().getParent() instanceof PsiMethodCallExpression ? (PsiMethodCallExpression)problemElement.getParent().getParent() : null;
        PsiMethod targetMethod = call == null ? null : call.resolveMethod();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        problemElement.replace((PsiElement)facade.getElementFactory().createExpressionFromText(this.myReplacementText, null));
        if (targetMethod != null) {
            ExtractMethodUtil.addCastsToEnsureResolveTarget(targetMethod, call);
        }
    }
}

