/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.fix;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SurroundWithRequireNonNullFix
implements LocalQuickFix {
    private final String myText;
    private final SmartPsiElementPointer<PsiExpression> myQualifierPointer;

    public SurroundWithRequireNonNullFix(@NotNull PsiExpression expressionToSurround) {
        this.myText = expressionToSurround.getText();
        this.myQualifierPointer = SmartPointerManager.getInstance((Project)expressionToSurround.getProject()).createSmartPsiElementPointer((PsiElement)expressionToSurround);
    }

    @Nls
    @NotNull
    public String getName() {
        return InspectionsBundle.message((String)"inspection.surround.requirenonnull.quickfix", (Object[])new Object[]{this.myText});
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return InspectionsBundle.message((String)"inspection.surround.requirenonnull.quickfix", (Object[])new Object[]{""});
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiExpression qualifier = (PsiExpression)this.myQualifierPointer.getElement();
        if (qualifier == null) {
            return;
        }
        PsiExpression replacement = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText("java.util.Objects.requireNonNull(" + qualifier.getText() + ")", (PsiElement)qualifier);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(qualifier.replace((PsiElement)replacement));
    }
}

