/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.inference;

import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.codeInspection.dataFlow.inference.DelegationContract;
import com.intellij.codeInspection.dataFlow.inference.ExpressionRange;
import com.intellij.codeInspection.dataFlow.inference.KnownContract;
import com.intellij.codeInspection.dataFlow.inference.MethodCallContract;
import com.intellij.codeInspection.dataFlow.inference.PreContract;
import com.intellij.codeInspection.dataFlow.inference.SideEffectFilter;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.JavaLightTreeUtil;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.RecursiveLighterASTNodeWalkingVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ContractInferenceInterpreter {
    private static final TokenSet UNARY_INCREMENT_DECREMENT = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.PLUSPLUS, JavaTokenType.MINUSMINUS});
    private final LighterAST myTree;
    private final LighterASTNode myMethod;
    private final LighterASTNode myBody;

    ContractInferenceInterpreter(LighterAST tree, LighterASTNode method, LighterASTNode body2) {
        this.myTree = tree;
        this.myMethod = method;
        this.myBody = body2;
    }

    @NotNull
    private List<LighterASTNode> getParameters() {
        LighterASTNode paramList = LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)this.myMethod, (IElementType)JavaElementType.PARAMETER_LIST);
        return paramList != null ? LightTreeUtil.getChildrenOfType((LighterAST)this.myTree, (LighterASTNode)paramList, (IElementType)JavaElementType.PARAMETER) : Collections.emptyList();
    }

    @NotNull
    List<PreContract> inferContracts(List<LighterASTNode> statements) {
        ContractReturnValue value2;
        List<PreContract> result;
        if (statements.isEmpty()) {
            return Collections.emptyList();
        }
        if (statements.size() == 1 && (result = this.handleSingleStatement(statements.get(0))) != null) {
            return result;
        }
        List<PreContract> contracts2 = this.visitStatements(Collections.singletonList(StandardMethodContract.createConstraintArray(this.getParameters().size())), statements);
        if (contracts2.isEmpty() && !(value2 = this.getDefaultReturnValue(statements)).isFail() && !value2.equals(ContractReturnValue.returnAny())) {
            contracts2 = Collections.singletonList(new KnownContract(StandardMethodContract.trivialContract(this.getParameters().size(), value2)));
        }
        return contracts2;
    }

    @Nullable
    private List<PreContract> handleSingleStatement(LighterASTNode statement) {
        if (statement.getTokenType() == JavaElementType.RETURN_STATEMENT) {
            LighterASTNode returned = JavaLightTreeUtil.findExpressionChild(this.myTree, statement);
            return this.getLiteralConstraint(returned) != null ? Collections.emptyList() : this.handleDelegation(returned, false);
        }
        if (statement.getTokenType() == JavaElementType.EXPRESSION_STATEMENT) {
            LighterASTNode expr = JavaLightTreeUtil.findExpressionChild(this.myTree, statement);
            return expr != null && expr.getTokenType() == JavaElementType.METHOD_CALL_EXPRESSION ? this.handleDelegation(expr, false) : null;
        }
        return null;
    }

    @Nullable
    private LighterASTNode getCodeBlock(@Nullable LighterASTNode parent) {
        return LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)parent, (IElementType)JavaElementType.CODE_BLOCK);
    }

    @NotNull
    static List<LighterASTNode> getStatements(@Nullable LighterASTNode codeBlock, LighterAST tree) {
        return codeBlock == null ? Collections.emptyList() : LightTreeUtil.getChildrenOfType((LighterAST)tree, (LighterASTNode)codeBlock, (TokenSet)ElementType.JAVA_STATEMENT_BIT_SET);
    }

    @Nullable
    private List<PreContract> handleDelegation(@Nullable LighterASTNode expression2, boolean negated) {
        if (expression2 == null) {
            return null;
        }
        if (expression2.getTokenType() == JavaElementType.PARENTH_EXPRESSION) {
            return this.handleDelegation(JavaLightTreeUtil.findExpressionChild(this.myTree, expression2), negated);
        }
        if (this.isNegationExpression(expression2)) {
            return this.handleDelegation(JavaLightTreeUtil.findExpressionChild(this.myTree, expression2), !negated);
        }
        if (expression2.getTokenType() == JavaElementType.METHOD_CALL_EXPRESSION) {
            return Collections.singletonList(new DelegationContract(ExpressionRange.create(expression2, this.myBody.getStartOffset()), negated));
        }
        return null;
    }

    private boolean isNegationExpression(@Nullable LighterASTNode expression2) {
        return expression2 != null && expression2.getTokenType() == JavaElementType.PREFIX_EXPRESSION && LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)expression2, (IElementType)JavaTokenType.EXCL) != null;
    }

    private ContractReturnValue getDefaultReturnValue(List<LighterASTNode> statements) {
        class ReturnValueVisitor
        extends RecursiveLighterASTNodeWalkingVisitor {
            public ContractReturnValue returnValue;
            private BitSet assignedParameters;

            ReturnValueVisitor() {
                super(ContractInferenceInterpreter.this.myTree);
                this.returnValue = ContractReturnValue.fail();
            }

            public void visitNode(@NotNull LighterASTNode element) {
                LighterASTNode expression2;
                int paramIndex;
                IElementType type2 = element.getTokenType();
                if (type2 == JavaElementType.CLASS || type2 == JavaElementType.LAMBDA_EXPRESSION) {
                    return;
                }
                if (this.returnValue.equals(ContractReturnValue.returnAny())) {
                    return;
                }
                if ((type2 == JavaElementType.ASSIGNMENT_EXPRESSION || type2 == JavaElementType.POSTFIX_EXPRESSION || type2 == JavaElementType.PREFIX_EXPRESSION && LightTreeUtil.firstChildOfType((LighterAST)ContractInferenceInterpreter.this.myTree, (LighterASTNode)element, (TokenSet)UNARY_INCREMENT_DECREMENT) != null) && (paramIndex = ContractInferenceInterpreter.this.resolveParameter(expression2 = JavaLightTreeUtil.skipParenthesesCastsDown(ContractInferenceInterpreter.this.myTree, JavaLightTreeUtil.findExpressionChild(ContractInferenceInterpreter.this.myTree, element)))) >= 0) {
                    if (this.assignedParameters == null) {
                        this.assignedParameters = new BitSet();
                    }
                    this.assignedParameters.set(paramIndex);
                    if (this.returnValue.equals(ContractReturnValue.returnParameter(paramIndex))) {
                        this.returnValue = ContractReturnValue.returnAny();
                    }
                }
                if (type2 == JavaElementType.RETURN_STATEMENT) {
                    expression2 = JavaLightTreeUtil.findExpressionChild(ContractInferenceInterpreter.this.myTree, element);
                    ContractReturnValue newReturnValue = this.expressionToReturnValue(expression2);
                    if (this.returnValue.isFail()) {
                        this.returnValue = newReturnValue;
                    } else if (!this.returnValue.equals(newReturnValue)) {
                        this.returnValue = ContractReturnValue.returnAny();
                    }
                }
                super.visitNode(element);
            }

            @NotNull
            private ContractReturnValue expressionToReturnValue(LighterASTNode expression2) {
                int paramIndex;
                expression2 = JavaLightTreeUtil.skipParenthesesDown(ContractInferenceInterpreter.this.myTree, expression2);
                if (expression2 == null) {
                    return ContractReturnValue.returnAny();
                }
                IElementType type2 = expression2.getTokenType();
                if (type2 == JavaElementType.NEW_EXPRESSION) {
                    return ContractReturnValue.returnNew();
                }
                if (type2 == JavaElementType.THIS_EXPRESSION) {
                    return ContractReturnValue.returnThis();
                }
                if (!(type2 != JavaElementType.REFERENCE_EXPRESSION || (paramIndex = ContractInferenceInterpreter.this.resolveParameter(expression2)) < 0 || this.assignedParameters != null && this.assignedParameters.get(paramIndex))) {
                    return ContractReturnValue.returnParameter(paramIndex);
                }
                return ContractReturnValue.returnAny();
            }
        }
        ReturnValueVisitor visitor = new ReturnValueVisitor();
        for (LighterASTNode statement : statements) {
            visitor.visitNode(statement);
        }
        return visitor.returnValue;
    }

    @NotNull
    private List<PreContract> visitExpression(List<StandardMethodContract.ValueConstraint[]> states, @Nullable LighterASTNode expr) {
        int parameter2;
        if (expr == null) {
            return Collections.emptyList();
        }
        if (states.isEmpty()) {
            return Collections.emptyList();
        }
        if (states.size() > 300) {
            return Collections.emptyList();
        }
        IElementType type2 = expr.getTokenType();
        if (type2 == JavaElementType.POLYADIC_EXPRESSION || type2 == JavaElementType.BINARY_EXPRESSION) {
            return this.visitPolyadic(states, expr);
        }
        if (type2 == JavaElementType.CONDITIONAL_EXPRESSION) {
            List<LighterASTNode> children = JavaLightTreeUtil.getExpressionChildren(this.myTree, expr);
            if (children.size() != 3) {
                return Collections.emptyList();
            }
            List<PreContract> conditionResults = this.visitExpression(states, children.get(0));
            return ContainerUtil.concat(this.visitExpression(ContractInferenceInterpreter.antecedentsReturning(conditionResults, ContractReturnValue.returnTrue()), children.get(1)), this.visitExpression(ContractInferenceInterpreter.antecedentsReturning(conditionResults, ContractReturnValue.returnFalse()), children.get(2)));
        }
        if (type2 == JavaElementType.PARENTH_EXPRESSION) {
            return this.visitExpression(states, JavaLightTreeUtil.findExpressionChild(this.myTree, expr));
        }
        if (type2 == JavaElementType.TYPE_CAST_EXPRESSION) {
            return this.visitExpression(states, JavaLightTreeUtil.findExpressionChild(this.myTree, expr));
        }
        if (this.isNegationExpression(expr)) {
            return ContainerUtil.mapNotNull(this.visitExpression(states, JavaLightTreeUtil.findExpressionChild(this.myTree, expr)), PreContract::negate);
        }
        if (type2 == JavaElementType.INSTANCE_OF_EXPRESSION && (parameter2 = this.resolveParameter(JavaLightTreeUtil.findExpressionChild(this.myTree, expr))) >= 0) {
            return ContractInferenceInterpreter.asPreContracts(ContainerUtil.mapNotNull(states, state -> ContractInferenceInterpreter.contractWithConstraint(state, parameter2, StandardMethodContract.ValueConstraint.NULL_VALUE, ContractReturnValue.returnFalse())));
        }
        if (type2 == JavaElementType.NEW_EXPRESSION) {
            return ContractInferenceInterpreter.asPreContracts(ContractInferenceInterpreter.toContracts(states, ContractReturnValue.returnNew()));
        }
        if (type2 == JavaElementType.THIS_EXPRESSION) {
            return ContractInferenceInterpreter.asPreContracts(ContractInferenceInterpreter.toContracts(states, ContractReturnValue.returnThis()));
        }
        if (type2 == JavaElementType.METHOD_CALL_EXPRESSION) {
            return Collections.singletonList(new MethodCallContract(ExpressionRange.create(expr, this.myBody.getStartOffset()), ContainerUtil.map(states, Arrays::asList)));
        }
        StandardMethodContract.ValueConstraint constraint = this.getLiteralConstraint(expr);
        if (constraint != null) {
            return ContractInferenceInterpreter.asPreContracts(ContractInferenceInterpreter.toContracts(states, constraint.asReturnValue()));
        }
        int paramIndex = this.resolveParameter(expr);
        if (paramIndex >= 0) {
            ArrayList result = ContainerUtil.newArrayList();
            for (StandardMethodContract.ValueConstraint[] state2 : states) {
                if (state2[paramIndex] == StandardMethodContract.ValueConstraint.TRUE_VALUE || state2[paramIndex] == StandardMethodContract.ValueConstraint.FALSE_VALUE || state2[paramIndex] == StandardMethodContract.ValueConstraint.NULL_VALUE) {
                    result.add(new StandardMethodContract(state2, state2[paramIndex].asReturnValue()));
                    continue;
                }
                if (JavaTokenType.BOOLEAN_KEYWORD == this.getPrimitiveParameterType(paramIndex)) {
                    ContainerUtil.addIfNotNull((Collection)result, (Object)ContractInferenceInterpreter.contractWithConstraint(state2, paramIndex, StandardMethodContract.ValueConstraint.TRUE_VALUE, ContractReturnValue.returnTrue()));
                    ContainerUtil.addIfNotNull((Collection)result, (Object)ContractInferenceInterpreter.contractWithConstraint(state2, paramIndex, StandardMethodContract.ValueConstraint.FALSE_VALUE, ContractReturnValue.returnFalse()));
                    continue;
                }
                result.add(new StandardMethodContract(state2, ContractReturnValue.returnParameter(paramIndex)));
            }
            return ContractInferenceInterpreter.asPreContracts(result);
        }
        return Collections.emptyList();
    }

    @NotNull
    private List<PreContract> visitPolyadic(List<StandardMethodContract.ValueConstraint[]> states, @NotNull LighterASTNode expr) {
        boolean logicalAnd;
        if (LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)expr, (IElementType)JavaTokenType.PLUS) != null) {
            return ContractInferenceInterpreter.asPreContracts(ContainerUtil.map(states, s -> new StandardMethodContract((StandardMethodContract.ValueConstraint[])s, ContractReturnValue.returnNotNull())));
        }
        List<LighterASTNode> operands2 = JavaLightTreeUtil.getExpressionChildren(this.myTree, expr);
        if (operands2.size() == 2) {
            boolean equality;
            boolean bl = equality = LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)expr, (IElementType)JavaTokenType.EQEQ) != null;
            if (equality || LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)expr, (IElementType)JavaTokenType.NE) != null) {
                return ContractInferenceInterpreter.asPreContracts(this.visitEqualityComparison(states, operands2.get(0), operands2.get(1), equality));
            }
        }
        boolean bl = logicalAnd = LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)expr, (IElementType)JavaTokenType.ANDAND) != null;
        if (logicalAnd || LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)expr, (IElementType)JavaTokenType.OROR) != null) {
            return ContractInferenceInterpreter.asPreContracts(this.visitLogicalOperation(operands2, logicalAnd, states));
        }
        return Collections.emptyList();
    }

    @NotNull
    private static List<PreContract> asPreContracts(List<StandardMethodContract> contracts2) {
        return ContainerUtil.map(contracts2, KnownContract::new);
    }

    @Nullable
    private static StandardMethodContract contractWithConstraint(StandardMethodContract.ValueConstraint[] state, int parameter2, StandardMethodContract.ValueConstraint paramConstraint, ContractReturnValue returnValue) {
        StandardMethodContract.ValueConstraint[] newState = ContractInferenceInterpreter.withConstraint(state, parameter2, paramConstraint);
        return newState == null ? null : new StandardMethodContract(newState, returnValue);
    }

    private List<StandardMethodContract> visitEqualityComparison(List<StandardMethodContract.ValueConstraint[]> states, LighterASTNode op1, LighterASTNode op2, boolean equality) {
        int parameter2 = this.resolveParameter(op1);
        StandardMethodContract.ValueConstraint constraint = this.getLiteralConstraint(op2);
        if (parameter2 < 0 || constraint == null) {
            parameter2 = this.resolveParameter(op2);
            constraint = this.getLiteralConstraint(op1);
        }
        if (parameter2 >= 0 && constraint != null) {
            ArrayList result = ContainerUtil.newArrayList();
            for (StandardMethodContract.ValueConstraint[] state : states) {
                if (constraint == StandardMethodContract.ValueConstraint.NOT_NULL_VALUE) {
                    if (this.getPrimitiveParameterType(parameter2) != null) continue;
                    ContainerUtil.addIfNotNull((Collection)result, (Object)ContractInferenceInterpreter.contractWithConstraint(state, parameter2, StandardMethodContract.ValueConstraint.NULL_VALUE, ContractReturnValue.returnBoolean(!equality)));
                    continue;
                }
                ContainerUtil.addIfNotNull((Collection)result, (Object)ContractInferenceInterpreter.contractWithConstraint(state, parameter2, constraint, ContractReturnValue.returnBoolean(equality)));
                ContainerUtil.addIfNotNull((Collection)result, (Object)ContractInferenceInterpreter.contractWithConstraint(state, parameter2, constraint.negate(), ContractReturnValue.returnBoolean(!equality)));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Nullable
    private IElementType getPrimitiveParameterType(int paramIndex) {
        LighterASTNode typeElement = LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)this.getParameters().get(paramIndex), (IElementType)JavaElementType.TYPE);
        LighterASTNode primitive = LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)typeElement, (TokenSet)ElementType.PRIMITIVE_TYPE_BIT_SET);
        return primitive == null ? null : primitive.getTokenType();
    }

    static List<StandardMethodContract> toContracts(List<StandardMethodContract.ValueConstraint[]> states, ContractReturnValue constraint) {
        return ContainerUtil.map(states, state -> new StandardMethodContract((StandardMethodContract.ValueConstraint[])state, constraint));
    }

    private List<StandardMethodContract> visitLogicalOperation(List<LighterASTNode> operands2, boolean conjunction, List<StandardMethodContract.ValueConstraint[]> states) {
        ContractReturnValue.BooleanReturnValue breakValue = ContractReturnValue.returnBoolean(!conjunction);
        ArrayList finalStates = ContainerUtil.newArrayList();
        for (LighterASTNode operand2 : operands2) {
            List<PreContract> opResults = this.visitExpression(states, operand2);
            finalStates.addAll(ContainerUtil.filter(ContractInferenceInterpreter.knownContracts(opResults), contract -> contract.getReturnValue() == breakValue));
            states = ContractInferenceInterpreter.antecedentsReturning(opResults, breakValue.negate());
        }
        finalStates.addAll(ContractInferenceInterpreter.toContracts(states, breakValue.negate()));
        return finalStates;
    }

    private static List<StandardMethodContract> knownContracts(List<PreContract> values) {
        return ContainerUtil.mapNotNull(values, pc -> pc instanceof KnownContract ? ((KnownContract)pc).getContract() : null);
    }

    private static List<StandardMethodContract.ValueConstraint[]> antecedentsReturning(List<PreContract> values, ContractReturnValue result) {
        return ContainerUtil.mapNotNull(ContractInferenceInterpreter.knownContracts(values), contract -> contract.getReturnValue().equals(result) ? contract.getConstraints().toArray(new StandardMethodContract.ValueConstraint[0]) : null);
    }

    @NotNull
    private List<PreContract> visitStatements(List<StandardMethodContract.ValueConstraint[]> states, List<LighterASTNode> statements) {
        CodeBlockContracts result = new CodeBlockContracts();
        for (LighterASTNode statement : statements) {
            List<PreContract> conditionResults;
            IElementType type2 = statement.getTokenType();
            if (type2 == JavaElementType.BLOCK_STATEMENT) {
                result.addAll(this.visitStatements(states, ContractInferenceInterpreter.getStatements(this.getCodeBlock(statement), this.myTree)));
                break;
            }
            if (type2 == JavaElementType.IF_STATEMENT) {
                conditionResults = this.visitExpression(states, JavaLightTreeUtil.findExpressionChild(this.myTree, statement));
                List<LighterASTNode> thenElse = ContractInferenceInterpreter.getStatements(statement, this.myTree);
                if (thenElse.size() > 0) {
                    result.addAll(this.visitStatements(ContractInferenceInterpreter.antecedentsReturning(conditionResults, ContractReturnValue.returnTrue()), Collections.singletonList(thenElse.get(0))));
                }
                List<StandardMethodContract.ValueConstraint[]> falseStates = ContractInferenceInterpreter.antecedentsReturning(conditionResults, ContractReturnValue.returnFalse());
                if (thenElse.size() > 1) {
                    result.addAll(this.visitStatements(falseStates, Collections.singletonList(thenElse.get(1))));
                    break;
                }
                states = falseStates;
                continue;
            }
            if (type2 == JavaElementType.WHILE_STATEMENT) {
                states = ContractInferenceInterpreter.antecedentsReturning(this.visitExpression(states, JavaLightTreeUtil.findExpressionChild(this.myTree, statement)), ContractReturnValue.returnFalse());
                continue;
            }
            if (type2 == JavaElementType.THROW_STATEMENT) {
                result.addAll(ContractInferenceInterpreter.asPreContracts(ContractInferenceInterpreter.toContracts(states, ContractReturnValue.fail())));
                break;
            }
            if (type2 == JavaElementType.RETURN_STATEMENT) {
                result.addAll(this.visitExpression(states, JavaLightTreeUtil.findExpressionChild(this.myTree, statement)));
                break;
            }
            if (type2 == JavaElementType.ASSERT_STATEMENT) {
                conditionResults = this.visitExpression(states, JavaLightTreeUtil.findExpressionChild(this.myTree, statement));
                result.addAll(ContractInferenceInterpreter.asPreContracts(ContractInferenceInterpreter.toContracts(ContractInferenceInterpreter.antecedentsReturning(conditionResults, ContractReturnValue.returnFalse()), ContractReturnValue.fail())));
                break;
            }
            if (type2 == JavaElementType.DECLARATION_STATEMENT) {
                result.registerDeclaration(statement, this.myTree, this.myBody.getStartOffset());
                continue;
            }
            if (type2 != JavaElementType.DO_WHILE_STATEMENT) break;
            result.addAll(this.visitStatements(states, ContractInferenceInterpreter.getStatements(statement, this.myTree)));
            break;
        }
        return result.accumulated;
    }

    @Nullable
    private StandardMethodContract.ValueConstraint getLiteralConstraint(@Nullable LighterASTNode expr) {
        if (expr != null && expr.getTokenType() == JavaElementType.LITERAL_EXPRESSION) {
            return ContractInferenceInterpreter.getLiteralConstraint(((LighterASTNode)this.myTree.getChildren(expr).get(0)).getTokenType());
        }
        return null;
    }

    @NotNull
    static StandardMethodContract.ValueConstraint getLiteralConstraint(@NotNull IElementType literalTokenType) {
        if (literalTokenType.equals(JavaTokenType.TRUE_KEYWORD)) {
            return StandardMethodContract.ValueConstraint.TRUE_VALUE;
        }
        if (literalTokenType.equals(JavaTokenType.FALSE_KEYWORD)) {
            return StandardMethodContract.ValueConstraint.FALSE_VALUE;
        }
        if (literalTokenType.equals(JavaTokenType.NULL_KEYWORD)) {
            return StandardMethodContract.ValueConstraint.NULL_VALUE;
        }
        return StandardMethodContract.ValueConstraint.NOT_NULL_VALUE;
    }

    private int resolveParameter(@Nullable LighterASTNode expr) {
        if (expr != null && expr.getTokenType() == JavaElementType.REFERENCE_EXPRESSION && JavaLightTreeUtil.findExpressionChild(this.myTree, expr) == null) {
            String name = JavaLightTreeUtil.getNameIdentifierText(this.myTree, expr);
            if (name == null) {
                return -1;
            }
            List<LighterASTNode> parameters2 = this.getParameters();
            for (int i = 0; i < parameters2.size(); ++i) {
                if (!name.equals(JavaLightTreeUtil.getNameIdentifierText(this.myTree, parameters2.get(i)))) continue;
                return i;
            }
        }
        return -1;
    }

    @Nullable
    static StandardMethodContract.ValueConstraint[] withConstraint(StandardMethodContract.ValueConstraint[] constraints, int index, StandardMethodContract.ValueConstraint constraint) {
        if (constraints[index] == constraint) {
            return constraints;
        }
        StandardMethodContract.ValueConstraint negated = constraint.negate();
        if (negated != constraint && constraints[index] == negated) {
            return null;
        }
        StandardMethodContract.ValueConstraint[] copy = (StandardMethodContract.ValueConstraint[])constraints.clone();
        copy[index] = constraint;
        return copy;
    }

    private static class CodeBlockContracts {
        List<PreContract> accumulated = new ArrayList<PreContract>();
        List<ExpressionRange> varInitializers = new ArrayList<ExpressionRange>();

        private CodeBlockContracts() {
        }

        void addAll(List<PreContract> contracts2) {
            if (contracts2.isEmpty()) {
                return;
            }
            if (this.varInitializers.isEmpty()) {
                this.accumulated.addAll(contracts2);
            } else {
                this.accumulated.add(new SideEffectFilter(this.varInitializers, contracts2));
            }
        }

        void registerDeclaration(@NotNull LighterASTNode declStatement, @NotNull LighterAST tree, int scopeStart) {
            for (LighterASTNode var : LightTreeUtil.getChildrenOfType((LighterAST)tree, (LighterASTNode)declStatement, (IElementType)JavaElementType.LOCAL_VARIABLE)) {
                LighterASTNode initializer = JavaLightTreeUtil.findExpressionChild(tree, var);
                if (initializer == null) continue;
                this.varInitializers.add(ExpressionRange.create(initializer, scopeStart));
            }
        }
    }
}

