/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.inference;

import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;

public class InferenceFromSourceUtil {
    static boolean shouldInferFromSource(@NotNull PsiMethodImpl method, boolean allowOverridden) {
        if (!allowOverridden && PsiUtil.canBeOverridden((PsiMethod)method)) {
            return false;
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)method, () -> CachedValueProvider.Result.create((Object)InferenceFromSourceUtil.calcShouldInferFromSource(method), (Object[])new Object[]{method, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT}));
    }

    private static boolean calcShouldInferFromSource(@NotNull PsiMethod method) {
        if (InferenceFromSourceUtil.isLibraryCode(method) || method.hasModifierProperty("abstract") || method.hasModifierProperty("native")) {
            return false;
        }
        if (method.hasModifierProperty("static")) {
            return true;
        }
        return !InferenceFromSourceUtil.isUnusedInAnonymousClass(method);
    }

    private static boolean isUnusedInAnonymousClass(@NotNull PsiMethod method) {
        PsiClass containingClass = method.getContainingClass();
        if (!(containingClass instanceof PsiAnonymousClass)) {
            return false;
        }
        if (containingClass.getParent() instanceof PsiNewExpression && containingClass.getParent().getParent() instanceof PsiVariable && !method.getHierarchicalMethodSignature().getSuperSignatures().isEmpty()) {
            return false;
        }
        return MethodReferencesSearch.search((PsiMethod)method, (SearchScope)new LocalSearchScope((PsiElement)containingClass), (boolean)false).findFirst() == null;
    }

    private static boolean isLibraryCode(@NotNull PsiMethod method) {
        if (method instanceof PsiCompiledElement) {
            return true;
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)method);
        return virtualFile != null && FileIndexFacade.getInstance((Project)method.getProject()).isInLibrarySource(virtualFile);
    }

    public static boolean suppressNullable(PsiMethod method) {
        if (method.getParameterList().isEmpty()) {
            return false;
        }
        for (StandardMethodContract contract : JavaMethodContractUtil.getMethodContracts(method)) {
            if (!contract.getReturnValue().isNull()) continue;
            return true;
        }
        return false;
    }
}

