/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.inference;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.codeInspection.dataFlow.inference.ContractInferenceIndexKt;
import com.intellij.codeInspection.dataFlow.inference.InferenceFromSourceUtil;
import com.intellij.codeInspection.dataFlow.inference.MethodData;
import com.intellij.codeInspection.dataFlow.inference.MethodReturnInferenceResult;
import com.intellij.codeInspection.dataFlow.inference.PreContract;
import com.intellij.codeInspection.dataFlow.inference.PurityInferenceResult;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaSourceInference {
    public static final int MAX_CONTRACT_COUNT = 10;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.dataFlow.inference.JavaSourceInference");

    @NotNull
    public static Nullability inferNullability(PsiMethodImpl method) {
        if (!InferenceFromSourceUtil.shouldInferFromSource(method, false)) {
            return Nullability.UNKNOWN;
        }
        PsiType type2 = method.getReturnType();
        if (type2 == null || type2 instanceof PsiPrimitiveType) {
            return Nullability.UNKNOWN;
        }
        return (Nullability)CachedValuesManager.getCachedValue((PsiElement)method, () -> {
            Nullability nullability;
            MethodData data = ContractInferenceIndexKt.getIndexedData(method);
            MethodReturnInferenceResult result = data == null ? null : data.getMethodReturn();
            Nullability nullability2 = nullability = result == null ? null : (Nullability)RecursionManager.doPreventingRecursion((Object)((Object)method), (boolean)true, () -> result.getNullability(method, data.methodBody(method)));
            if (nullability == null) {
                nullability = Nullability.UNKNOWN;
            }
            return CachedValueProvider.Result.create((Object)nullability, (Object[])new Object[]{method, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
    }

    public static Nullability inferNullability(@NotNull PsiParameter parameter2) {
        if (!parameter2.isPhysical() || parameter2.getType() instanceof PsiPrimitiveType) {
            return Nullability.UNKNOWN;
        }
        PsiParameterList parent = (PsiParameterList)ObjectUtils.tryCast((Object)parameter2.getParent(), PsiParameterList.class);
        if (parent == null) {
            return Nullability.UNKNOWN;
        }
        PsiMethodImpl method = (PsiMethodImpl)((Object)ObjectUtils.tryCast((Object)parent.getParent(), PsiMethodImpl.class));
        if (method == null || !InferenceFromSourceUtil.shouldInferFromSource(method, true)) {
            return Nullability.UNKNOWN;
        }
        return (Nullability)CachedValuesManager.getCachedValue((PsiElement)parameter2, () -> {
            int index;
            BitSet notNullParameters;
            Nullability nullability = Nullability.UNKNOWN;
            MethodData data = ContractInferenceIndexKt.getIndexedData(method);
            if (data != null && !(notNullParameters = data.getNotNullParameters()).isEmpty() && notNullParameters.get(index = ArrayUtil.indexOf((Object[])parent.getParameters(), (Object)parameter2))) {
                nullability = Nullability.NOT_NULL;
            }
            return CachedValueProvider.Result.create((Object)nullability, (Object[])new Object[]{method, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
    }

    @NotNull
    public static Mutability inferMutability(PsiMethodImpl method) {
        if (!InferenceFromSourceUtil.shouldInferFromSource(method, false)) {
            return Mutability.UNKNOWN;
        }
        PsiType type2 = method.getReturnType();
        if (type2 == null || ClassUtils.isImmutable(type2, false)) {
            return Mutability.UNKNOWN;
        }
        return (Mutability)((Object)CachedValuesManager.getCachedValue((PsiElement)method, () -> {
            Mutability mutability;
            MethodData data = ContractInferenceIndexKt.getIndexedData(method);
            MethodReturnInferenceResult result = data == null ? null : data.getMethodReturn();
            Mutability mutability2 = mutability = result == null ? null : (Mutability)((Object)((Object)RecursionManager.doPreventingRecursion((Object)((Object)method), (boolean)true, () -> result.getMutability(method, data.methodBody(method)))));
            if (mutability == null) {
                mutability = Mutability.UNKNOWN;
            }
            return CachedValueProvider.Result.create((Object)((Object)mutability), (Object[])new Object[]{method, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        }));
    }

    @NotNull
    public static List<StandardMethodContract> inferContracts(@NotNull PsiMethodImpl method) {
        if (!InferenceFromSourceUtil.shouldInferFromSource(method, false)) {
            return Collections.emptyList();
        }
        return (List)CachedValuesManager.getCachedValue((PsiElement)method, () -> {
            MethodData data;
            List<Object> preContracts = (data = ContractInferenceIndexKt.getIndexedData(method)) == null ? Collections.emptyList() : data.getContracts();
            List result = (List)RecursionManager.doPreventingRecursion((Object)((Object)method), (boolean)true, () -> JavaSourceInference.postProcessContracts(method, data, preContracts));
            if (result == null) {
                result = Collections.emptyList();
            }
            return CachedValueProvider.Result.create(result, (Object[])new Object[]{method, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
    }

    public static boolean inferPurity(@NotNull PsiMethodImpl method) {
        if (!InferenceFromSourceUtil.shouldInferFromSource(method, false) || PsiType.VOID.equals((Object)method.getReturnType())) {
            return false;
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)method, () -> {
            MethodData data = ContractInferenceIndexKt.getIndexedData(method);
            PurityInferenceResult result = data == null ? null : data.getPurity();
            Boolean pure = (Boolean)RecursionManager.doPreventingRecursion((Object)((Object)method), (boolean)true, () -> result != null && result.isPure(method, data.methodBody(method)));
            return CachedValueProvider.Result.create((Object)(pure == Boolean.TRUE ? 1 : 0), (Object[])new Object[]{method});
        });
    }

    @NotNull
    private static List<StandardMethodContract> postProcessContracts(@NotNull PsiMethodImpl method, MethodData data, List<PreContract> rawContracts) {
        List compatible;
        PsiType returnType;
        StandardMethodContract collapsed;
        List<StandardMethodContract> contracts2 = ContainerUtil.concat(rawContracts, c -> c.toContracts(method, data.methodBody(method)));
        if (contracts2.isEmpty()) {
            return Collections.emptyList();
        }
        if (contracts2.size() == 2 && (collapsed = ((StandardMethodContract)contracts2.get(0)).tryCollapse((StandardMethodContract)contracts2.get(1))) != null) {
            contracts2 = Collections.singletonList(collapsed);
        }
        if ((returnType = method.getReturnType()) != null && !(returnType instanceof PsiPrimitiveType)) {
            contracts2 = JavaSourceInference.boxReturnValues(contracts2);
        }
        if ((compatible = ContainerUtil.filter((Collection)contracts2, contract -> JavaSourceInference.isContractCompatibleWithMethod(method, contract))).size() > 10) {
            LOG.debug("Too many contracts for " + PsiUtil.getMemberQualifiedName((PsiMember)method) + ", shrinking the list");
            return compatible.subList(0, 10);
        }
        return compatible;
    }

    private static boolean isContractCompatibleWithMethod(@NotNull PsiMethod method, StandardMethodContract contract) {
        if (JavaSourceInference.hasContradictoryExplicitParameterNullity(method, contract)) {
            return false;
        }
        if (JavaSourceInference.isReturnNullitySpecifiedExplicitly(method, contract)) {
            return false;
        }
        if (JavaSourceInference.isContradictingExplicitNullableReturn(method, contract)) {
            return false;
        }
        return contract.getReturnValue().isMethodCompatible(method);
    }

    private static boolean hasContradictoryExplicitParameterNullity(@NotNull PsiMethod method, StandardMethodContract contract) {
        for (int i = 0; i < contract.getParameterCount(); ++i) {
            if (contract.getParameterConstraint(i) != StandardMethodContract.ValueConstraint.NULL_VALUE || !NullableNotNullManager.isNotNull((PsiModifierListOwner)method.getParameterList().getParameters()[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean isContradictingExplicitNullableReturn(@NotNull PsiMethod method, StandardMethodContract contract) {
        return contract.getReturnValue().isNotNull() && contract.isTrivial() && NullableNotNullManager.getInstance((Project)method.getProject()).isNullable((PsiModifierListOwner)method, false);
    }

    private static boolean isReturnNullitySpecifiedExplicitly(@NotNull PsiMethod method, StandardMethodContract contract) {
        if (!contract.getReturnValue().equals(ContractReturnValue.returnNotNull()) && !contract.getReturnValue().isNull()) {
            return false;
        }
        return NullableNotNullManager.getInstance((Project)method.getProject()).isNotNull((PsiModifierListOwner)method, false);
    }

    @NotNull
    private static List<StandardMethodContract> boxReturnValues(List<StandardMethodContract> contracts2) {
        return ContainerUtil.mapNotNull(contracts2, contract -> {
            if (contract.getReturnValue().isBoolean()) {
                return contract.withReturnValue(ContractReturnValue.returnNotNull());
            }
            return contract;
        });
    }
}

