/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.inliner;

import com.intellij.codeInspection.dataFlow.CFGBuilder;
import com.intellij.codeInspection.dataFlow.NullabilityProblemKind;
import com.intellij.codeInspection.dataFlow.inliner.CallInliner;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.MethodCallUtils;
import org.jetbrains.annotations.NotNull;

public class AssumeInliner
implements CallInliner {
    private static final CallMatcher ASSUME_NOT_NULL = CallMatcher.staticCall("org.junit.Assume", "assumeNotNull");

    @Override
    public boolean tryInlineCall(@NotNull CFGBuilder builder, @NotNull PsiMethodCallExpression call) {
        if (ASSUME_NOT_NULL.test(call) && MethodCallUtils.isVarArgCall((PsiCall)call)) {
            PsiExpression[] args;
            for (PsiExpression arg : args = call.getArgumentList().getExpressions()) {
                builder.pushExpression(arg, NullabilityProblemKind.assumeNotNull).pop();
            }
            builder.pushUnknown();
            return true;
        }
        return false;
    }
}

