/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.inliner;

import com.intellij.codeInsight.ExpressionUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.dataFlow.CFGBuilder;
import com.intellij.codeInspection.dataFlow.NullabilityProblemKind;
import com.intellij.codeInspection.dataFlow.inliner.CallInliner;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

public class SimpleMethodInliner
implements CallInliner {
    @Override
    public boolean tryInlineCall(@NotNull CFGBuilder builder, @NotNull PsiMethodCallExpression call) {
        if (!call.getArgumentList().isEmpty()) {
            return false;
        }
        if (!ExpressionUtil.isEffectivelyUnqualified(call.getMethodExpression())) {
            return false;
        }
        PsiMethod method = call.resolveMethod();
        if (method == null || PsiUtil.canBeOverridden((PsiMethod)method) || call.isPhysical() && !method.isPhysical()) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null || !PsiTreeUtil.isAncestor((PsiElement)aClass, (PsiElement)call, (boolean)true)) {
            return false;
        }
        if (PsiType.VOID.equals((Object)method.getReturnType())) {
            return false;
        }
        if (PsiTreeUtil.isAncestor((PsiElement)method, (PsiElement)call, (boolean)true)) {
            return false;
        }
        PsiReturnStatement statement = (PsiReturnStatement)ObjectUtils.tryCast((Object)ControlFlowUtils.getOnlyStatementInBlock(method.getBody()), PsiReturnStatement.class);
        if (statement == null) {
            return false;
        }
        PsiExpression returnValue = PsiUtil.skipParenthesizedExprDown((PsiExpression)statement.getReturnValue());
        if (returnValue == null) {
            return false;
        }
        if (returnValue instanceof PsiLiteralExpression) {
            return false;
        }
        if (!SimpleMethodInliner.isSimple(returnValue)) {
            return false;
        }
        NullabilityAnnotationInfo info = NullableNotNullManager.getInstance((Project)method.getProject()).findEffectiveNullabilityInfo((PsiModifierListOwner)method);
        boolean nonNull = info != null && info.getNullability() == Nullability.NOT_NULL && !info.isInferred();
        builder.pushExpression(returnValue, nonNull ? NullabilityProblemKind.assumeNotNull : NullabilityProblemKind.noProblem).resultOf((PsiExpression)call);
        return true;
    }

    private static boolean isSimple(PsiExpression value2) {
        if (value2 == null) {
            return true;
        }
        Ref hasFieldRefs = Ref.create((Object)false);
        boolean allowed = PsiTreeUtil.processElements((PsiElement)value2, e -> {
            if (!(e instanceof PsiExpression)) {
                return true;
            }
            if (e instanceof PsiInstanceOfExpression || e instanceof PsiParenthesizedExpression || e instanceof PsiLiteralExpression || e instanceof PsiPolyadicExpression || e instanceof PsiUnaryExpression || e instanceof PsiConditionalExpression || e instanceof PsiTypeCastExpression || e instanceof PsiArrayAccessExpression || e instanceof PsiLambdaExpression || e instanceof PsiMethodReferenceExpression || e instanceof PsiThisExpression) {
                return true;
            }
            if (e instanceof PsiReferenceExpression) {
                PsiElement target = ((PsiReferenceExpression)e).resolve();
                if (target instanceof PsiField && !((PsiField)target).hasModifierProperty("static")) {
                    hasFieldRefs.set((Object)true);
                }
                return true;
            }
            return false;
        });
        return allowed && (Boolean)hasFieldRefs.get() != false;
    }
}

