/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.instructions;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.ExpressionPushingInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.psi.PsiArrayAccessExpression;
import org.jetbrains.annotations.NotNull;

public class ArrayAccessInstruction
extends Instruction
implements ExpressionPushingInstruction {
    @NotNull
    private final DfaValue myValue;
    @NotNull
    private final PsiArrayAccessExpression myExpression;

    public ArrayAccessInstruction(@NotNull DfaValue value2, @NotNull PsiArrayAccessExpression expression2) {
        this.myValue = value2;
        this.myExpression = expression2;
    }

    @NotNull
    public DfaValue getValue() {
        return this.myValue;
    }

    @NotNull
    public PsiArrayAccessExpression getExpression() {
        return this.myExpression;
    }

    @Override
    public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState stateBefore, InstructionVisitor visitor) {
        return visitor.visitArrayAccess(this, runner, stateBefore);
    }

    public String toString() {
        return "ARRAY_ACCESS " + this.myExpression.getText();
    }
}

