/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.instructions;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.BinopInstruction;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstanceofInstruction
extends BinopInstruction {
    @Nullable
    private final PsiExpression myLeft;
    @Nullable
    private final PsiType myCastType;

    public InstanceofInstruction(PsiExpression psiAnchor, @Nullable PsiExpression left, @NotNull PsiType castType) {
        super(JavaTokenType.INSTANCEOF_KEYWORD, psiAnchor, (PsiType)PsiType.BOOLEAN);
        this.myLeft = left;
        this.myCastType = castType;
    }

    public InstanceofInstruction(PsiMethodCallExpression psiAnchor) {
        super(JavaTokenType.INSTANCEOF_KEYWORD, (PsiExpression)psiAnchor, (PsiType)PsiType.BOOLEAN);
        this.myLeft = null;
        this.myCastType = null;
    }

    @Override
    public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState stateBefore, InstructionVisitor visitor) {
        return visitor.visitInstanceof(this, runner, stateBefore);
    }

    @Nullable
    public PsiExpression getLeft() {
        return this.myLeft;
    }

    @Nullable
    public PsiType getCastType() {
        return this.myCastType;
    }

    public boolean isClassObjectCheck() {
        return this.myCastType == null;
    }
}

