/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.instructions;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.ExpressionPushingInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.psi.PsiExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PushInstruction
extends Instruction
implements ExpressionPushingInstruction {
    private final DfaValue myValue;
    private final PsiExpression myPlace;
    private final boolean myReferenceWrite;

    public PushInstruction(@Nullable DfaValue value2, PsiExpression place) {
        this(value2, place, false);
    }

    public PushInstruction(@Nullable DfaValue value2, PsiExpression place, boolean isReferenceWrite) {
        this.myValue = value2 != null ? value2 : DfaUnknownValue.getInstance();
        this.myPlace = place;
        this.myReferenceWrite = isReferenceWrite;
    }

    public boolean isReferenceWrite() {
        return this.myReferenceWrite;
    }

    @NotNull
    public DfaValue getValue() {
        return this.myValue;
    }

    @Override
    public PsiExpression getExpression() {
        return this.myPlace;
    }

    @Override
    public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState stateBefore, InstructionVisitor visitor) {
        return visitor.visitPush(this, runner, stateBefore);
    }

    public String toString() {
        return "PUSH " + this.myValue;
    }
}

