/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.instructions;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import java.util.Arrays;
import java.util.List;
import one.util.streamex.IntStreamEx;

public class SpliceInstruction
extends Instruction {
    private final int myCount;
    private final int[] myReplacement;

    public SpliceInstruction(int count, int ... replacement) {
        this.myCount = count;
        this.myReplacement = replacement;
    }

    @Override
    public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState stateBefore, InstructionVisitor visitor) {
        List removed = IntStreamEx.range((int)this.myCount).mapToObj(idx -> stateBefore.pop()).toList();
        IntStreamEx.of((int[])this.myReplacement).elements(removed).forEach(stateBefore::push);
        Instruction nextInstruction = runner.getInstruction(this.getIndex() + 1);
        return new DfaInstructionState[]{new DfaInstructionState(nextInstruction, stateBefore)};
    }

    public String toString() {
        return "SPLICE [" + this.myCount + "] -> " + Arrays.toString(this.myReplacement);
    }
}

