/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.instructions;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.ExpressionPushingInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import org.jetbrains.annotations.NotNull;

public class TypeCastInstruction
extends Instruction
implements ExpressionPushingInstruction {
    private final PsiTypeCastExpression myCastExpression;
    private final PsiExpression myCasted;
    private final PsiType myCastTo;

    public TypeCastInstruction(PsiTypeCastExpression castExpression, PsiExpression casted, PsiType castTo) {
        this.myCastExpression = castExpression;
        this.myCasted = casted;
        this.myCastTo = castTo;
    }

    public PsiExpression getCasted() {
        return this.myCasted;
    }

    public PsiType getCastTo() {
        return this.myCastTo;
    }

    @Override
    public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState stateBefore, InstructionVisitor visitor) {
        return visitor.visitTypeCast(this, runner, stateBefore);
    }

    public String toString() {
        return "CAST_TO " + this.myCastTo.getCanonicalText();
    }

    @NotNull
    public PsiTypeCastExpression getExpression() {
        return this.myCastExpression;
    }
}

