/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.rangeSet;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeUtil;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaFactMapValue;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ThreeState;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LongRangeSet {
    private static final String JETBRAINS_RANGE = "org.jetbrains.annotations.Range";
    private static final String CHECKER_RANGE = "org.checkerframework.common.value.qual.IntRange";
    private static final String CHECKER_GTE_NEGATIVE_ONE = "org.checkerframework.checker.index.qual.GTENegativeOne";
    private static final String CHECKER_NON_NEGATIVE = "org.checkerframework.checker.index.qual.NonNegative";
    private static final String CHECKER_POSITIVE = "org.checkerframework.checker.index.qual.Positive";
    private static final String JSR305_NONNEGATIVE = "javax.annotation.Nonnegative";
    private static final String VALIDATION_MIN = "javax.validation.constraints.Min";
    private static final String VALIDATION_MAX = "javax.validation.constraints.Max";
    private static final List<String> ANNOTATIONS = Arrays.asList("org.checkerframework.common.value.qual.IntRange", "org.checkerframework.checker.index.qual.GTENegativeOne", "org.checkerframework.checker.index.qual.NonNegative", "org.checkerframework.checker.index.qual.Positive", "javax.annotation.Nonnegative", "javax.validation.constraints.Min", "javax.validation.constraints.Max");

    LongRangeSet() {
    }

    public abstract LongRangeSet subtract(LongRangeSet var1);

    public LongRangeSet without(long value2) {
        return this.subtract(LongRangeSet.point(value2));
    }

    public boolean isEmpty() {
        return this == Empty.EMPTY;
    }

    public abstract LongRangeSet intersect(LongRangeSet var1);

    public abstract LongRangeSet unite(LongRangeSet var1);

    public abstract long min();

    public abstract long max();

    public Long getConstantValue() {
        return null;
    }

    public abstract boolean intersects(LongRangeSet var1);

    public abstract boolean contains(long var1);

    public abstract boolean contains(LongRangeSet var1);

    public LongRangeSet fromRelation(@Nullable DfaRelationValue.RelationType relation) {
        if (this.isEmpty() || relation == null) {
            return null;
        }
        switch (relation) {
            case EQ: {
                return this;
            }
            case NE: {
                long min = this.min();
                if (min == this.max()) {
                    return LongRangeSet.all().without(min);
                }
                return LongRangeSet.all();
            }
            case GT: {
                long min = this.min();
                return min == Long.MAX_VALUE ? LongRangeSet.empty() : LongRangeSet.range(min + 1L, Long.MAX_VALUE);
            }
            case GE: {
                return LongRangeSet.range(this.min(), Long.MAX_VALUE);
            }
            case LE: {
                return LongRangeSet.range(Long.MIN_VALUE, this.max());
            }
            case LT: {
                long max = this.max();
                return max == Long.MIN_VALUE ? LongRangeSet.empty() : LongRangeSet.range(Long.MIN_VALUE, max - 1L);
            }
        }
        return null;
    }

    @Contract(value="null, _, _ -> null")
    @Nullable
    public final LongRangeSet binOpFromToken(IElementType token, LongRangeSet right, boolean isLong) {
        if (token == null) {
            return null;
        }
        if (token.equals(JavaTokenType.PLUS)) {
            return this.plus(right, isLong);
        }
        if (token.equals(JavaTokenType.MINUS)) {
            return this.minus(right, isLong);
        }
        if (token.equals(JavaTokenType.AND)) {
            return this.bitwiseAnd(right);
        }
        if (token.equals(JavaTokenType.OR)) {
            return this.bitwiseOr(right, isLong);
        }
        if (token.equals(JavaTokenType.PERC)) {
            return this.mod(right);
        }
        if (token.equals(JavaTokenType.DIV)) {
            return this.div(right, isLong);
        }
        if (token.equals(JavaTokenType.LTLT)) {
            return this.shiftLeft(right, isLong);
        }
        if (token.equals(JavaTokenType.GTGT)) {
            return this.shiftRight(right, isLong);
        }
        if (token.equals(JavaTokenType.GTGTGT)) {
            return this.unsignedShiftRight(right, isLong);
        }
        if (token.equals(JavaTokenType.ASTERISK)) {
            return this.mul(right, isLong);
        }
        return null;
    }

    public abstract LongRangeSet castTo(PsiPrimitiveType var1);

    @NotNull
    public abstract LongRangeSet abs(boolean var1);

    @NotNull
    public abstract LongRangeSet negate(boolean var1);

    @NotNull
    public abstract LongRangeSet plus(LongRangeSet var1, boolean var2);

    @NotNull
    public LongRangeSet minus(LongRangeSet other, boolean isLong) {
        return this.plus(other.negate(isLong), isLong);
    }

    @NotNull
    public LongRangeSet bitwiseOr(LongRangeSet other, boolean isLong) {
        if (this.isEmpty() || other.isEmpty()) {
            return LongRangeSet.empty();
        }
        LongRangeSet result = LongRangeSet.fromBits(this.getBitwiseMask().or(other.getBitwiseMask()));
        return isLong ? result : result.intersect(Range.INT_RANGE);
    }

    @NotNull
    public LongRangeSet bitwiseAnd(LongRangeSet other) {
        if (this.isEmpty() || other.isEmpty()) {
            return LongRangeSet.empty();
        }
        long[] left = LongRangeSet.splitAtZero(this.asRanges());
        long[] right = LongRangeSet.splitAtZero(other.asRanges());
        if (left.length > 6) {
            left = LongRangeSet.splitAtZero(new long[]{left[0], left[left.length - 1]});
        }
        if (right.length > 6) {
            right = LongRangeSet.splitAtZero(new long[]{right[0], right[right.length - 1]});
        }
        LongRangeUtil.BitString globalMask = this.getBitwiseMask().and(other.getBitwiseMask());
        globalMask = new LongRangeUtil.BitString(globalMask.myBits | globalMask.myMask ^ 0xFFFFFFFFFFFFFFFFL, -1L);
        LongRangeSet result = LongRangeSet.empty();
        for (int i = 0; i < left.length; i += 2) {
            for (int j = 0; j < right.length; j += 2) {
                result = result.unite(LongRangeSet.bitwiseAnd(left[i], left[i + 1], right[j], right[j + 1], globalMask));
            }
        }
        return result;
    }

    public abstract LongRangeSet mul(LongRangeSet var1, boolean var2);

    LongRangeUtil.BitString getBitwiseMask() {
        if (this.isEmpty()) {
            return LongRangeUtil.BitString.UNSURE;
        }
        return LongRangeUtil.BitString.fromRange(this.min(), this.max());
    }

    @NotNull
    public LongRangeSet div(LongRangeSet divisor, boolean isLong) {
        if (divisor.isEmpty() || divisor.equals(new Point(0L))) {
            return LongRangeSet.empty();
        }
        long[] left = LongRangeSet.splitAtZero(this.asRanges());
        long[] right = LongRangeSet.splitAtZero(new long[]{divisor.min(), divisor.max()});
        LongRangeSet result = LongRangeSet.empty();
        for (int i = 0; i < left.length; i += 2) {
            for (int j = 0; j < right.length; j += 2) {
                result = result.unite(LongRangeSet.divide(left[i], left[i + 1], right[j], right[j + 1], isLong));
            }
        }
        return result;
    }

    public boolean subtractionMayOverflow(LongRangeSet other, boolean isLong) {
        long leftMin = this.min();
        long leftMax = this.max();
        long rightMin = other.min();
        long rightMax = other.max();
        return isLong ? LongRangeSet.overflowsLong(leftMin, rightMax) || LongRangeSet.overflowsLong(leftMax, rightMin) : LongRangeSet.overflowsInt(leftMin, rightMax) || LongRangeSet.overflowsInt(leftMax, rightMin);
    }

    private static boolean overflowsInt(long a, long b) {
        long diff = a - b;
        return diff < Integer.MIN_VALUE || diff > Integer.MAX_VALUE;
    }

    private static boolean overflowsLong(long a, long b) {
        long diff = a - b;
        return ((a ^ b) & (a ^ diff)) < 0L;
    }

    @NotNull
    private static LongRangeSet divide(long dividendMin, long dividendMax, long divisorMin, long divisorMax, boolean isLong) {
        if (divisorMin == 0L) {
            if (divisorMax == 0L) {
                return LongRangeSet.empty();
            }
            divisorMin = 1L;
        }
        if (dividendMin >= 0L) {
            return divisorMin > 0L ? LongRangeSet.range(dividendMin / divisorMax, dividendMax / divisorMin) : LongRangeSet.range(dividendMax / divisorMax, dividendMin / divisorMin);
        }
        if (divisorMin > 0L) {
            return LongRangeSet.range(dividendMin / divisorMin, dividendMax / divisorMax);
        }
        long minValue = LongRangeSet.minValue(isLong);
        if (dividendMin == minValue && divisorMax == -1L) {
            return LongRangeSet.point(minValue).unite(divisorMin == -1L ? LongRangeSet.empty() : LongRangeSet.range(dividendMin / divisorMin, dividendMin / (divisorMax - 1L))).unite(dividendMax == minValue ? LongRangeSet.empty() : LongRangeSet.range(dividendMax / divisorMin, (dividendMin + 1L) / divisorMax));
        }
        return LongRangeSet.range(dividendMax / divisorMin, dividendMin / divisorMax);
    }

    @NotNull
    public LongRangeSet shiftLeft(LongRangeSet shiftSize, boolean isLong) {
        if (this.isEmpty() || shiftSize.isEmpty()) {
            return LongRangeSet.empty();
        }
        if (shiftSize instanceof Point) {
            long shift = ((Point)shiftSize).myValue & (long)((isLong ? 64 : 32) - 1);
            return LongRangeSet.point(1L << (int)shift).mul(this, isLong);
        }
        return isLong ? Range.LONG_RANGE : Range.INT_RANGE;
    }

    @NotNull
    public LongRangeSet shiftRight(LongRangeSet shiftSize, boolean isLong) {
        return this.doShiftRight(shiftSize, isLong, false);
    }

    @NotNull
    public LongRangeSet unsignedShiftRight(LongRangeSet shiftSize, boolean isLong) {
        return this.doShiftRight(shiftSize, isLong, true);
    }

    private LongRangeSet doShiftRight(LongRangeSet shiftSize, boolean isLong, boolean unsigned) {
        LongRangeSet negativeResult;
        if (this.isEmpty() || shiftSize.isEmpty()) {
            return LongRangeSet.empty();
        }
        int maxShift = (isLong ? 64 : 32) - 1;
        if (shiftSize.min() < 0L || shiftSize.max() > (long)maxShift) {
            shiftSize = shiftSize.bitwiseAnd(LongRangeSet.point(maxShift));
        }
        long min = shiftSize.min();
        long max = shiftSize.max();
        LongRangeSet negative = this.intersect(LongRangeSet.range(LongRangeSet.minValue(isLong), -1L));
        LongRangeSet positive = this.intersect(LongRangeSet.range(0L, LongRangeSet.maxValue(isLong)));
        LongRangeSet positiveResult = positive.shrPositive(min, max, isLong);
        LongRangeSet negativeComplement = LongRangeSet.point(-1L).minus(negative, isLong);
        if (unsigned) {
            if (min == 0L) {
                positiveResult = positiveResult.unite(negative);
                if (max == 0L) {
                    return positiveResult;
                }
                ++min;
            }
            negativeResult = LongRangeSet.point(LongRangeSet.maxValue(isLong)).minus(negativeComplement.shrPositive(1L, 1L, isLong), isLong).shrPositive(min - 1L, max - 1L, isLong);
        } else {
            negativeResult = LongRangeSet.point(-1L).minus(negativeComplement.shrPositive(min, max, isLong), isLong);
        }
        return positiveResult.unite(negativeResult);
    }

    private LongRangeSet shrPositive(long min, long max, boolean isLong) {
        if (this.isEmpty()) {
            return LongRangeSet.empty();
        }
        int maxShift = (isLong ? 64 : 32) - 1;
        if (max == (long)maxShift) {
            return min == max ? LongRangeSet.point(0L) : LongRangeSet.point(0L).unite(this.div(LongRangeSet.range(1L << (int)min, 1L << (int)(max - 1L)), isLong));
        }
        return this.div(LongRangeSet.range(1L << (int)min, 1L << (int)max), isLong);
    }

    @NotNull
    public abstract LongRangeSet mod(LongRangeSet var1);

    private static long[] splitAtZero(long[] ranges) {
        for (int i = 0; i < ranges.length; i += 2) {
            if (ranges[i] >= 0L || ranges[i + 1] < 0L) continue;
            long[] result = new long[ranges.length + 2];
            System.arraycopy(ranges, 0, result, 0, i + 1);
            result[i + 1] = -1L;
            System.arraycopy(ranges, i + 1, result, i + 3, ranges.length - i - 1);
            return result;
        }
        return ranges;
    }

    private static LongRangeSet bitwiseAnd(long leftFrom, long leftTo, long rightFrom, long rightTo, LongRangeUtil.BitString globalMask) {
        if (leftFrom == leftTo && rightFrom == rightTo) {
            return LongRangeSet.point(leftFrom & rightFrom & (globalMask.myBits | globalMask.myMask ^ 0xFFFFFFFFFFFFFFFFL));
        }
        if (leftFrom == leftTo && Long.bitCount(leftFrom + 1L) == 1) {
            return LongRangeSet.bitwiseMask(rightFrom, rightTo, leftFrom);
        }
        if (rightFrom == rightTo && Long.bitCount(rightFrom + 1L) == 1) {
            return LongRangeSet.bitwiseMask(leftFrom, leftTo, rightFrom);
        }
        LongRangeUtil.BitString leftBits = LongRangeUtil.BitString.fromRange(leftFrom, leftTo);
        LongRangeUtil.BitString rightBits = LongRangeUtil.BitString.fromRange(rightFrom, rightTo);
        return LongRangeSet.fromBits(leftBits.and(rightBits).and(globalMask));
    }

    private static LongRangeSet bitwiseMask(long from, long to, long mask) {
        if (to - from > mask) {
            return LongRangeSet.range(0L, mask);
        }
        long min = from & mask;
        long max = to & mask;
        assert (min != max);
        if (min < max) {
            return LongRangeSet.range(min, max);
        }
        return new RangeSet(new long[]{0L, max, min, mask});
    }

    private static LongRangeSet fromBits(LongRangeUtil.BitString bits) {
        int j;
        int i;
        if (bits.myMask == -1L) {
            return LongRangeSet.point(bits.myBits);
        }
        long from = 0L;
        for (i = 63; i >= 0 && bits.get(i) != ThreeState.UNSURE; --i) {
            if (bits.get(i) != ThreeState.YES) continue;
            from = LongRangeUtil.setBit(from, i);
        }
        long to = (i == 63 ? 0L : 1L << i + 1) - 1L | from;
        for (j = 0; j < i && bits.get(j) != ThreeState.UNSURE; ++j) {
            if (bits.get(j) != ThreeState.NO) continue;
            to = LongRangeUtil.clearBit(to, j);
        }
        if (i == j) {
            return LongRangeSet.point(from).unite(LongRangeSet.point(to));
        }
        long modBits = -1L;
        block2: for (int rem = 0; rem < 64; ++rem) {
            for (int pos = 0; pos < 6; ++pos) {
                ThreeState bit = bits.get(pos);
                if (bit != ThreeState.fromBoolean((!LongRangeUtil.isSet(rem, pos) ? 1 : 0) != 0)) continue;
                modBits = LongRangeUtil.clearBit(modBits, rem);
                continue block2;
            }
        }
        if (from >= 0L && to < 0L) {
            from = Long.MIN_VALUE;
            to = Long.MAX_VALUE;
        }
        return from < to ? LongRangeSet.modRange(from, to, 64L, modBits) : LongRangeSet.modRange(to, from, 64L, modBits);
    }

    private static String formatNumber(long value2) {
        if (value2 == Long.MAX_VALUE) {
            return "Long.MAX_VALUE";
        }
        if (value2 == 0x7FFFFFFFFFFFFFFEL) {
            return "Long.MAX_VALUE-1";
        }
        if (value2 == Long.MIN_VALUE) {
            return "Long.MIN_VALUE";
        }
        if (value2 == Integer.MAX_VALUE) {
            return "Integer.MAX_VALUE";
        }
        if (value2 == 0x7FFFFFFEL) {
            return "Integer.MAX_VALUE-1";
        }
        if (value2 == Integer.MIN_VALUE) {
            return "Integer.MIN_VALUE";
        }
        return String.valueOf(value2);
    }

    public abstract LongStream stream();

    public static LongRangeSet empty() {
        return Empty.EMPTY;
    }

    public static LongRangeSet all() {
        return Range.LONG_RANGE;
    }

    public static LongRangeSet point(long value2) {
        return new Point(value2);
    }

    @Nullable
    public static LongRangeSet fromConstant(Object val) {
        if (val instanceof Byte || val instanceof Short || val instanceof Integer || val instanceof Long) {
            return LongRangeSet.point(((Number)val).longValue());
        }
        if (val instanceof Character) {
            return LongRangeSet.point(((Character)val).charValue());
        }
        return null;
    }

    @Nullable
    public static LongRangeSet fromDfaValue(DfaValue value2) {
        if (value2 instanceof DfaFactMapValue) {
            return ((DfaFactMapValue)value2).get(DfaFactType.RANGE);
        }
        if (value2 instanceof DfaConstValue) {
            return LongRangeSet.fromConstant(((DfaConstValue)value2).getValue());
        }
        if (value2 instanceof DfaVariableValue) {
            return LongRangeSet.fromType(value2.getType());
        }
        return null;
    }

    public static LongRangeSet range(long from, long to) {
        return from == to ? new Point(from) : new Range(from, to);
    }

    public static LongRangeSet modRange(long from, long to, long mod, long bits) {
        long leftHalf;
        int halfMod;
        long rightHalf;
        int toBit;
        long rotatedTo;
        long rotatedFrom;
        if (mod <= 0L) {
            throw new IllegalArgumentException();
        }
        if (bits == 0L) {
            return LongRangeSet.empty();
        }
        if (mod == 1L || mod > 64L) {
            return LongRangeSet.range(from, to);
        }
        int intMod = (int)mod;
        if ((from += (long)Long.numberOfTrailingZeros(rotatedFrom = LongRangeUtil.rotateRemainders(bits, intMod, LongRangeUtil.remainder(from, intMod)))) > (to -= (long)(intMod - (64 - Long.numberOfLeadingZeros(rotatedTo = LongRangeUtil.rotateRemainders(bits, intMod, toBit = (LongRangeUtil.remainder(to, intMod) + 1) % intMod)))))) {
            return LongRangeSet.empty();
        }
        if (from == to) {
            return new Point(from);
        }
        long length = to - from;
        if (length > 0L && length <= (long)(intMod / 2)) {
            for (int newMod = (int)length; newMod <= intMod / 2; ++newMod) {
                if (intMod % newMod != 0) continue;
                long newBits = 0L;
                for (long i = from; i <= to; ++i) {
                    if (!LongRangeUtil.isSet(bits, LongRangeUtil.remainder(i, intMod))) continue;
                    newBits = LongRangeUtil.setBit(newBits, LongRangeUtil.remainder(i, newMod));
                }
                intMod = newMod;
                bits = newBits;
                if (bits != 0L) break;
                return LongRangeSet.empty();
            }
        }
        if (intMod % 2 == 0 && (rightHalf = LongRangeUtil.extractBits(bits, 0, halfMod = intMod / 2)) == (leftHalf = LongRangeUtil.extractBits(bits, halfMod, halfMod))) {
            return LongRangeSet.modRange(from, to, halfMod, leftHalf);
        }
        if (Long.bitCount(bits) == intMod) {
            return LongRangeSet.range(from, to);
        }
        ModRange range = new ModRange(from, to, intMod, bits);
        LongRangeSet fullRange = LongRangeSet.range(from, to);
        return range.contains(fullRange) ? fullRange : range;
    }

    abstract long[] asRanges();

    static String toString(long from, long to) {
        return LongRangeSet.formatNumber(from) + (from == to ? "" : (to - from == 1L ? ", " : "..") + LongRangeSet.formatNumber(to));
    }

    static long minValue(boolean isLong) {
        return isLong ? Long.MIN_VALUE : Integer.MIN_VALUE;
    }

    static long maxValue(boolean isLong) {
        return isLong ? Long.MAX_VALUE : Integer.MAX_VALUE;
    }

    public static LongRangeSet indexRange() {
        return Range.INDEX_RANGE;
    }

    @Nullable
    public static LongRangeSet fromType(PsiType type2) {
        if (!(type2 instanceof PsiPrimitiveType) && !TypeConversionUtil.isPrimitiveWrapper((PsiType)type2)) {
            return null;
        }
        if ((type2 = PsiPrimitiveType.getOptionallyUnboxedType((PsiType)type2)) != null) {
            if (type2.equals(PsiType.BYTE)) {
                return Range.BYTE_RANGE;
            }
            if (type2.equals(PsiType.CHAR)) {
                return Range.CHAR_RANGE;
            }
            if (type2.equals(PsiType.SHORT)) {
                return Range.SHORT_RANGE;
            }
            if (type2.equals(PsiType.INT)) {
                return Range.INT_RANGE;
            }
            if (type2.equals(PsiType.LONG)) {
                return LongRangeSet.all();
            }
        }
        return null;
    }

    @NotNull
    public static LongRangeSet fromPsiElement(PsiModifierListOwner owner) {
        if (owner == null) {
            return LongRangeSet.all();
        }
        return (LongRangeSet)StreamEx.ofNullable((Object)AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (String[])new String[]{JETBRAINS_RANGE})).append((Object[])AnnotationUtil.findAnnotations((PsiModifierListOwner)owner, ANNOTATIONS)).map(LongRangeSet::fromAnnotation).foldLeft((Object)LongRangeSet.all(), LongRangeSet::intersect);
    }

    private static LongRangeSet fromAnnotation(PsiAnnotation annotation) {
        switch (Objects.requireNonNull(annotation.getQualifiedName())) {
            case "org.jetbrains.annotations.Range": 
            case "org.checkerframework.common.value.qual.IntRange": {
                Long from = AnnotationUtil.getLongAttributeValue((PsiAnnotation)annotation, (String)"from");
                Long to = AnnotationUtil.getLongAttributeValue((PsiAnnotation)annotation, (String)"to");
                if (from == null || to == null || to < from) break;
                return LongRangeSet.range(from, to);
            }
            case "javax.validation.constraints.Min": {
                Long minValue = AnnotationUtil.getLongAttributeValue((PsiAnnotation)annotation, (String)"value");
                if (minValue == null || annotation.findDeclaredAttributeValue("groups") != null) break;
                return LongRangeSet.range(minValue, Long.MAX_VALUE);
            }
            case "javax.validation.constraints.Max": {
                Long maxValue = AnnotationUtil.getLongAttributeValue((PsiAnnotation)annotation, (String)"value");
                if (maxValue == null || annotation.findDeclaredAttributeValue("groups") != null) break;
                return LongRangeSet.range(Long.MIN_VALUE, maxValue);
            }
            case "org.checkerframework.checker.index.qual.GTENegativeOne": {
                return LongRangeSet.range(-1L, Long.MAX_VALUE);
            }
            case "javax.annotation.Nonnegative": 
            case "org.checkerframework.checker.index.qual.NonNegative": {
                return LongRangeSet.range(0L, Long.MAX_VALUE);
            }
            case "org.checkerframework.checker.index.qual.Positive": {
                return LongRangeSet.range(1L, Long.MAX_VALUE);
            }
        }
        return LongRangeSet.all();
    }

    static LongRangeSet fromRanges(long[] ranges, int bound) {
        if (bound == 0) {
            return Empty.EMPTY;
        }
        if (bound == 2) {
            return LongRangeSet.range(ranges[0], ranges[1]);
        }
        return new RangeSet(Arrays.copyOfRange(ranges, 0, bound));
    }

    public static LongRangeSet fromRemainder(long mod, LongRangeSet remainders) {
        long max;
        if (remainders.isEmpty()) {
            return LongRangeSet.empty();
        }
        long min = remainders.min() > 0L ? 1L : Long.MIN_VALUE;
        long l = max = remainders.max() < 0L ? -1L : Long.MAX_VALUE;
        if (mod > 1L && mod <= 64L) {
            long bits = remainders.contains(0L) ? 1L : 0L;
            int rem = 1;
            while ((long)rem < mod) {
                if (remainders.contains(rem) || remainders.contains((long)rem - mod)) {
                    bits = LongRangeUtil.setBit(bits, rem);
                }
                ++rem;
            }
            return LongRangeSet.modRange(min, max, mod, bits);
        }
        return LongRangeSet.range(min, max);
    }

    static final class RangeSet
    extends LongRangeSet {
        final long[] myRanges;

        RangeSet(long[] ranges) {
            if (ranges.length < 4 || ranges.length % 2 != 0) {
                throw new IllegalArgumentException("Bad length: " + ranges.length + " " + Arrays.toString(ranges));
            }
            for (int i = 0; i < ranges.length; i += 2) {
                if (ranges[i + 1] < ranges[i]) {
                    throw new IllegalArgumentException("Bad sub-range #" + i / 2 + " " + Arrays.toString(ranges));
                }
                if (i <= 0 || ranges[i - 1] != Long.MAX_VALUE && 1L + ranges[i - 1] <= ranges[i]) continue;
                throw new IllegalArgumentException("Bad sub-ranges #" + (i / 2 - 1) + " and #" + i / 2 + " " + Arrays.toString(ranges));
            }
            this.myRanges = ranges;
        }

        @Override
        LongRangeUtil.BitString getBitwiseMask() {
            LongRangeUtil.BitString result = null;
            for (int i = 0; i < this.myRanges.length; i += 2) {
                LongRangeUtil.BitString newBits = LongRangeUtil.BitString.fromRange(this.myRanges[i], this.myRanges[i + 1]);
                result = result == null ? newBits : result.unite(newBits);
            }
            return result;
        }

        @Override
        public LongRangeSet subtract(LongRangeSet other) {
            if (other.isEmpty()) {
                return this;
            }
            if (other == this) {
                return Empty.EMPTY;
            }
            long[] result = new long[this.myRanges.length + other.asRanges().length];
            int index = 0;
            for (int i = 0; i < this.myRanges.length; i += 2) {
                LongRangeSet res = RangeSet.range(this.myRanges[i], this.myRanges[i + 1]).subtract(other);
                long[] ranges = res.asRanges();
                System.arraycopy(ranges, 0, result, index, ranges.length);
                index += ranges.length;
            }
            return RangeSet.fromRanges(result, index);
        }

        @Override
        public LongRangeSet intersect(LongRangeSet other) {
            if (other == this) {
                return this;
            }
            if (other.isEmpty()) {
                return other;
            }
            if (other instanceof Point || other instanceof Range) {
                return other.intersect(this);
            }
            return this.subtract(RangeSet.all().subtract(other));
        }

        @Override
        public LongRangeSet unite(LongRangeSet other) {
            if (!(other instanceof RangeSet)) {
                return other.unite(this);
            }
            if (other == this) {
                return this;
            }
            if (other.contains(this)) {
                return other;
            }
            if (this.contains(other)) {
                return this;
            }
            LongRangeSet result = other;
            for (int i = 0; i < this.myRanges.length; i += 2) {
                result = RangeSet.range(this.myRanges[i], this.myRanges[i + 1]).unite(result);
            }
            return result;
        }

        @Override
        public long min() {
            return this.myRanges[0];
        }

        @Override
        public long max() {
            return this.myRanges[this.myRanges.length - 1];
        }

        @Override
        public boolean intersects(LongRangeSet other) {
            long bTo;
            long aFrom;
            if (other.isEmpty()) {
                return false;
            }
            if (other instanceof Point) {
                return this.contains(((Point)other).myValue);
            }
            long[] otherRanges = other.asRanges();
            int a = 0;
            int b = 0;
            do {
                aFrom = this.myRanges[a];
                long aTo = this.myRanges[a + 1];
                long bFrom = otherRanges[b];
                bTo = otherRanges[b + 1];
                if (aFrom > bTo || bFrom > aTo) continue;
                return true;
            } while (!(aFrom > bTo ? (b += 2) >= otherRanges.length : (a += 2) >= this.myRanges.length));
            return false;
        }

        @Override
        public boolean contains(long value2) {
            for (int i = 0; i < this.myRanges.length; i += 2) {
                if (value2 < this.myRanges[i] || value2 > this.myRanges[i + 1]) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean contains(LongRangeSet other) {
            if (other.isEmpty() || other == this) {
                return true;
            }
            if (other instanceof Point) {
                return this.contains(((Point)other).myValue);
            }
            LongRangeSet result = other;
            for (int i = 0; i < this.myRanges.length; i += 2) {
                if (!(result = result.subtract(RangeSet.range(this.myRanges[i], this.myRanges[i + 1]))).isEmpty()) continue;
                return true;
            }
            return false;
        }

        @Override
        public LongRangeSet castTo(PsiPrimitiveType type2) {
            LongRangeSet result = RangeSet.all();
            for (int i = 0; i < this.myRanges.length; i += 2) {
                result = result.subtract(RangeSet.range(this.myRanges[i], this.myRanges[i + 1]).castTo(type2));
            }
            return RangeSet.all().subtract(result);
        }

        @Override
        @NotNull
        public LongRangeSet abs(boolean isLong) {
            LongRangeSet result = RangeSet.all();
            for (int i = 0; i < this.myRanges.length; i += 2) {
                result = result.subtract(RangeSet.range(this.myRanges[i], this.myRanges[i + 1]).abs(isLong));
            }
            return RangeSet.all().subtract(result);
        }

        @Override
        @NotNull
        public LongRangeSet negate(boolean isLong) {
            LongRangeSet result = RangeSet.all();
            for (int i = 0; i < this.myRanges.length; i += 2) {
                result = result.subtract(RangeSet.range(this.myRanges[i], this.myRanges[i + 1]).negate(isLong));
            }
            return RangeSet.all().subtract(result);
        }

        @Override
        @NotNull
        public LongRangeSet plus(LongRangeSet other, boolean isLong) {
            if (this.myRanges.length > 6) {
                return RangeSet.range(this.min(), this.max()).plus(other, isLong);
            }
            LongRangeSet result = RangeSet.empty();
            for (int i = 0; i < this.myRanges.length; i += 2) {
                result = result.unite(RangeSet.range(this.myRanges[i], this.myRanges[i + 1]).plus(other, isLong));
            }
            return result;
        }

        @Override
        public LongRangeSet mul(LongRangeSet multiplier, boolean isLong) {
            if (multiplier.isEmpty()) {
                return multiplier;
            }
            if (multiplier instanceof Point) {
                return multiplier.mul(this, isLong);
            }
            return isLong ? Range.LONG_RANGE : Range.INT_RANGE;
        }

        @Override
        @NotNull
        public LongRangeSet mod(LongRangeSet divisor) {
            if (divisor.isEmpty()) {
                return RangeSet.empty();
            }
            LongRangeSet result = RangeSet.empty();
            for (int i = 0; i < this.myRanges.length; i += 2) {
                result = result.unite(RangeSet.range(this.myRanges[i], this.myRanges[i + 1]).mod(divisor));
            }
            return result;
        }

        @Override
        public LongStream stream() {
            return IntStream.range(0, this.myRanges.length / 2).mapToObj(idx -> LongStream.rangeClosed(this.myRanges[idx * 2], this.myRanges[idx * 2 + 1])).reduce(LongStream::concat).orElseGet(LongStream::empty);
        }

        @Override
        long[] asRanges() {
            return this.myRanges;
        }

        public int hashCode() {
            return Arrays.hashCode(this.myRanges);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof RangeSet && Arrays.equals(this.myRanges, ((RangeSet)o).myRanges);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("{");
            for (int i = 0; i < this.myRanges.length; i += 2) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(LongRangeSet.toString(this.myRanges[i], this.myRanges[i + 1]));
            }
            sb.append("}");
            return sb.toString();
        }
    }

    static final class ModRange
    extends Range {
        private final int myMod;
        private final long myBits;

        ModRange(long from, long to, int mod, long bits) {
            super(from, to);
            assert (mod > 1 && mod <= 64);
            this.myMod = mod;
            this.myBits = bits;
            assert ((bits & (this.getMask() ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) : "bits outside of mask should be zero";
            assert (bits != this.getMask()) : "at least one bit in mask should be zero, otherwise simple Range could be used";
        }

        @Override
        public boolean contains(long value2) {
            return super.contains(value2) && LongRangeUtil.isSet(this.myBits, LongRangeUtil.remainder(value2, this.myMod));
        }

        @Override
        public LongRangeSet intersect(LongRangeSet other) {
            LongRangeSet intersection = super.intersect(other);
            if (intersection instanceof Range || intersection instanceof Point) {
                long bits = this.myBits;
                int mod = this.myMod;
                if (other instanceof ModRange) {
                    ModRange modRange = (ModRange)other;
                    int lcm = this.lcm(modRange.myMod);
                    if (lcm <= 64) {
                        bits = this.widenBits(lcm) & modRange.widenBits(lcm);
                        mod = (byte)lcm;
                    } else if (modRange.myMod > this.myMod) {
                        bits = modRange.myBits;
                        mod = modRange.myMod;
                    }
                }
                return ModRange.modRange(intersection.min(), intersection.max(), mod, bits);
            }
            if (intersection instanceof RangeSet) {
                long min = intersection.min();
                long max = intersection.max();
                long diff = max - min;
                if (diff > 0L && diff < 64L) {
                    for (byte newMod = (byte)(diff + 1L); newMod <= 64; newMod = (byte)(newMod + 1)) {
                        if (newMod % this.myMod != 0) continue;
                        long bits = this.widenBits(newMod);
                        for (long pos = min; pos <= max; ++pos) {
                            int bit = LongRangeUtil.remainder(pos, newMod);
                            if (!LongRangeUtil.isSet(bits, bit) || intersection.contains(pos)) continue;
                            bits = LongRangeUtil.clearBit(bits, bit);
                        }
                        return ModRange.modRange(min, max, newMod, bits);
                    }
                }
            }
            return intersection;
        }

        @Override
        public boolean intersects(LongRangeSet other) {
            if (other instanceof Point) {
                return this.contains(((Point)other).myValue);
            }
            if (other instanceof ModRange) {
                ModRange modRange = (ModRange)other;
                int lcm = this.lcm(modRange.myMod);
                if (lcm <= 64 && (modRange.widenBits(lcm) & this.widenBits(lcm)) == 0L) {
                    return false;
                }
            }
            long[] otherRanges = other.asRanges();
            for (int i = 0; i < otherRanges.length && otherRanges[i] <= this.myTo; i += 2) {
                if (this.myTo < otherRanges[i] || this.myFrom > otherRanges[i + 1] || ModRange.modRange(otherRanges[i], otherRanges[i + 1], this.myMod, this.myBits).isEmpty()) continue;
                return true;
            }
            return false;
        }

        @Override
        public LongRangeSet unite(LongRangeSet other) {
            if (other instanceof ModRange) {
                ModRange modRange = (ModRange)other;
                int lcm = this.lcm(modRange.myMod);
                if (lcm <= 64) {
                    long bits = this.widenBits(lcm) | modRange.widenBits(lcm);
                    if (this.myTo >= modRange.myFrom && this.myFrom <= modRange.myTo || this.myTo < modRange.myFrom && ModRange.modRange(this.myTo + 1L, modRange.myFrom - 1L, lcm, bits).isEmpty() || modRange.myTo < this.myFrom && ModRange.modRange(modRange.myTo + 1L, this.myFrom - 1L, lcm, bits).isEmpty()) {
                        return ModRange.modRange(Math.min(this.myFrom, modRange.myFrom), Math.max(this.myTo, modRange.myTo), lcm, bits);
                    }
                }
            }
            if (other instanceof Point) {
                long val = ((Point)other).myValue;
                if (LongRangeUtil.isSet(this.myBits, LongRangeUtil.remainder(val, this.myMod))) {
                    if (val >= this.myFrom && val <= this.myTo) {
                        return this;
                    }
                    if (val < this.myFrom && ModRange.modRange(val + 1L, this.myFrom - 1L, this.myMod, this.myBits).isEmpty() || val > this.myTo && ModRange.modRange(this.myTo + 1L, val - 1L, this.myMod, this.myBits).isEmpty()) {
                        return ModRange.modRange(Math.min(this.myFrom, val), Math.max(this.myTo, val), this.myMod, this.myBits);
                    }
                }
                return other.unite(ModRange.range(this.myFrom, this.myTo));
            }
            return super.unite(other);
        }

        @Override
        public boolean contains(LongRangeSet other) {
            if (other instanceof ModRange) {
                ModRange modRange = (ModRange)other;
                if (modRange.myFrom < this.myFrom || modRange.myTo > this.myTo) {
                    return false;
                }
                int lcm = this.lcm(modRange.myMod);
                if (lcm <= 64) {
                    return ((this.widenBits(lcm) ^ 0xFFFFFFFFFFFFFFFFL) & modRange.widenBits(lcm)) == 0L;
                }
            }
            long[] ranges = other.asRanges();
            for (int i = 0; i < ranges.length; i += 2) {
                if (this.contains(ranges[i], ranges[i + 1])) continue;
                return false;
            }
            return true;
        }

        @Override
        @NotNull
        public LongRangeSet negate(boolean isLong) {
            LongRangeSet negated = super.negate(isLong);
            if (negated instanceof Range) {
                long negatedBits = Long.reverse(this.myBits & 0xFFFFFFFFFFFFFFFEL) >>> 64 - this.myMod - 1 | this.myBits & 1L;
                return ModRange.modRange(negated.min(), negated.max(), this.myMod, negatedBits);
            }
            return negated;
        }

        @Override
        @NotNull
        public LongRangeSet plus(LongRangeSet other, boolean isLong) {
            LongRangeSet set = super.plus(other, isLong);
            if (other instanceof Point || other instanceof ModRange && ((ModRange)other).myMod == this.myMod && Long.bitCount(((ModRange)other).myBits) == 1) {
                long[] ranges = set.asRanges();
                LongRangeSet result = ModRange.empty();
                for (int i = 0; i < ranges.length; i += 2) {
                    result = result.unite(this.plus(ranges[i], ranges[i + 1], other, isLong));
                }
                return result;
            }
            return set;
        }

        private LongRangeSet plus(long min, long max, LongRangeSet other, boolean isLong) {
            if (Integer.bitCount(this.myMod) == 1 || !this.subtractionMayOverflow(other.negate(isLong), isLong)) {
                int bit = other instanceof Point ? LongRangeUtil.remainder(((Point)other).myValue, this.myMod) : Long.numberOfTrailingZeros(((ModRange)other).myBits);
                long bits = LongRangeUtil.rotateRemainders(this.myBits, this.myMod, this.myMod - bit);
                return ModRange.modRange(min, max, this.myMod, bits);
            }
            return ModRange.range(min, max);
        }

        @Override
        @NotNull
        public LongRangeSet mod(LongRangeSet divisor) {
            int divisorValue;
            int lcm;
            if (divisor instanceof Point && ((Point)divisor).myValue > 1L && ((Point)divisor).myValue <= 64L && (lcm = this.lcm(divisorValue = (int)((Point)divisor).myValue)) <= 64) {
                long from = Math.min(0L, Math.max(this.myFrom, (long)(-divisorValue + 1)));
                long to = Math.max(0L, Math.min(this.myTo, (long)(divisorValue - 1)));
                long possibleMods = this.widenBits(lcm);
                while (64 - Long.numberOfLeadingZeros(possibleMods) > divisorValue) {
                    possibleMods = LongRangeUtil.extractBits(possibleMods, divisorValue, 64) | LongRangeUtil.extractBits(possibleMods, 0, divisorValue);
                }
                return ModRange.modRange(from, to, divisorValue, possibleMods);
            }
            return ModRange.range(this.myFrom, this.myTo).mod(divisor);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
                return false;
            }
            return this.myMod == ((ModRange)o).myMod && this.myBits == ((ModRange)o).myBits;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.myMod, this.myBits);
        }

        @Override
        public String toString() {
            String suffix = this.myMod == 2 ? (this.myBits == 1L ? "even" : "odd") : IntStreamEx.of((BitSet)BitSet.valueOf(new long[]{this.myBits})).joining((CharSequence)", ", (CharSequence)"<", (CharSequence)("> mod " + this.myMod));
            return super.toString() + ": " + suffix;
        }

        @Override
        public LongStream stream() {
            return super.stream().filter(this::contains);
        }

        private boolean contains(long from, long to) {
            int toBit;
            if (from < this.myFrom || to > this.myTo) {
                return false;
            }
            if (to == from) {
                return this.contains(from);
            }
            if (to - from < 0L || to - from >= (long)this.myMod) {
                return false;
            }
            int fromBit = LongRangeUtil.remainder(from, this.myMod);
            if (fromBit < (toBit = LongRangeUtil.remainder(to, this.myMod))) {
                return Long.numberOfTrailingZeros(this.myBits >>> fromBit ^ 0xFFFFFFFFFFFFFFFFL) > toBit - fromBit;
            }
            return Long.numberOfTrailingZeros(this.myBits ^ 0xFFFFFFFFFFFFFFFFL) > toBit && 64 - Long.numberOfLeadingZeros((this.myBits ^ 0xFFFFFFFFFFFFFFFFL) & this.getMask()) <= fromBit;
        }

        private long widenBits(int targetMod) {
            assert (targetMod <= 64 && targetMod % this.myMod == 0);
            long result = this.myBits;
            for (int shift = targetMod - this.myMod; shift > 0; shift -= this.myMod) {
                result |= this.myBits << shift;
            }
            return result;
        }

        @Override
        LongRangeUtil.BitString getBitwiseMask() {
            int knownBits = Long.numberOfTrailingZeros(this.myMod);
            int powerOfTwo = 1 << knownBits;
            long result = -1L;
            long mask = powerOfTwo - 1;
            for (int rem = 0; rem < this.myMod; ++rem) {
                if (!LongRangeUtil.isSet(this.myBits, rem)) continue;
                int setBits = rem % powerOfTwo;
                if (result != -1L) {
                    long diffBits = result ^ (long)setBits;
                    mask &= diffBits ^ 0xFFFFFFFFFFFFFFFFL;
                }
                result = setBits;
            }
            return new LongRangeUtil.BitString(result, mask).and(super.getBitwiseMask());
        }

        private long getMask() {
            return -1L >>> 64 - this.myMod;
        }

        private int lcm(int otherMod) {
            return this.myMod * otherMod / LongRangeUtil.gcd(this.myMod, otherMod);
        }
    }

    static class Range
    extends LongRangeSet {
        static final Range BYTE_RANGE = new Range(-128L, 127L);
        static final Range CHAR_RANGE = new Range(0L, 65535L);
        static final Range SHORT_RANGE = new Range(-32768L, 32767L);
        static final Range INT_RANGE = new Range(Integer.MIN_VALUE, Integer.MAX_VALUE);
        static final Range LONG_RANGE = new Range(Long.MIN_VALUE, Long.MAX_VALUE);
        static final Range INDEX_RANGE = new Range(0L, Integer.MAX_VALUE);
        final long myFrom;
        final long myTo;

        Range(long from, long to) {
            if (to <= from) {
                throw new IllegalArgumentException(to + "<=" + from);
            }
            this.myFrom = from;
            this.myTo = to;
        }

        @Override
        public LongRangeSet subtract(LongRangeSet other) {
            if (other.isEmpty()) {
                return this;
            }
            if (other == this) {
                return Empty.EMPTY;
            }
            if (other instanceof Point) {
                long value2 = ((Point)other).myValue;
                if (value2 < this.myFrom || value2 > this.myTo) {
                    return this;
                }
                if (value2 == this.myFrom) {
                    return Range.range(this.myFrom + 1L, this.myTo);
                }
                if (value2 == this.myTo) {
                    return Range.range(this.myFrom, this.myTo - 1L);
                }
                return new RangeSet(new long[]{this.myFrom, value2 - 1L, value2 + 1L, this.myTo});
            }
            if (other instanceof Range) {
                long from = ((Range)other).myFrom;
                long to = ((Range)other).myTo;
                if (to < this.myFrom || from > this.myTo) {
                    return this;
                }
                if (from <= this.myFrom && to >= this.myTo) {
                    return Empty.EMPTY;
                }
                if (from > this.myFrom && to < this.myTo) {
                    return new RangeSet(new long[]{this.myFrom, from - 1L, to + 1L, this.myTo});
                }
                if (from <= this.myFrom) {
                    return Range.range(to + 1L, this.myTo);
                }
                assert (to >= this.myTo);
                return Range.range(this.myFrom, from - 1L);
            }
            long[] ranges = ((RangeSet)other).myRanges;
            LongRangeSet result = this;
            for (int i = 0; i < ranges.length; i += 2) {
                if (!(result = result.subtract(Range.range(ranges[i], ranges[i + 1]))).isEmpty()) continue;
                return result;
            }
            return result;
        }

        @Override
        public LongRangeSet intersect(LongRangeSet other) {
            if (other == this) {
                return this;
            }
            if (other.isEmpty()) {
                return other;
            }
            if (other instanceof ModRange && !(this instanceof ModRange) || other instanceof Point) {
                return other.intersect(this);
            }
            if (other instanceof Range) {
                long from = ((Range)other).myFrom;
                long to = ((Range)other).myTo;
                if (from <= this.myFrom && to >= this.myTo) {
                    return this;
                }
                if (from >= this.myFrom && to <= this.myTo) {
                    return other;
                }
                if (from < this.myFrom) {
                    from = this.myFrom;
                }
                if (to > this.myTo) {
                    to = this.myTo;
                }
                return from <= to ? Range.range(from, to) : Empty.EMPTY;
            }
            long[] ranges = ((RangeSet)other).myRanges;
            long[] result = new long[ranges.length];
            int index = 0;
            for (int i = 0; i < ranges.length; i += 2) {
                long[] res = this.intersect(Range.range(ranges[i], ranges[i + 1])).asRanges();
                System.arraycopy(res, 0, result, index, res.length);
                index += res.length;
            }
            return Range.fromRanges(result, index);
        }

        @Override
        public LongRangeSet unite(LongRangeSet other) {
            int maxIndex;
            if (other.isEmpty() || other == this) {
                return this;
            }
            if (other instanceof Point) {
                return other.unite(this);
            }
            if (other instanceof Range) {
                if (other.min() <= this.max() && this.min() <= other.max() || other.max() < this.min() && other.max() + 1L == this.min() || other.min() > this.max() && this.max() + 1L == other.min()) {
                    return Range.range(Math.min(this.min(), other.min()), Math.max(this.max(), other.max()));
                }
                if (other.max() < this.min()) {
                    return new RangeSet(new long[]{other.min(), other.max(), this.min(), this.max()});
                }
                return new RangeSet(new long[]{this.min(), this.max(), other.min(), other.max()});
            }
            long[] longs = other.asRanges();
            int minIndex = Arrays.binarySearch(longs, this.min());
            if (minIndex < 0) {
                if ((minIndex = -minIndex - 1) % 2 == 0 && minIndex > 0 && longs[minIndex - 1] + 1L == this.min()) {
                    --minIndex;
                }
            } else if (minIndex % 2 == 0) {
                ++minIndex;
            }
            if ((maxIndex = Arrays.binarySearch(longs, this.max())) < 0) {
                if ((maxIndex = -maxIndex - 1) % 2 == 0 && maxIndex < longs.length && this.max() + 1L == longs[maxIndex]) {
                    ++maxIndex;
                }
            } else if (maxIndex % 2 == 0) {
                ++maxIndex;
            }
            long[] result = new long[longs.length + 2];
            System.arraycopy(longs, 0, result, 0, minIndex);
            int pos = minIndex;
            if (minIndex % 2 == 0) {
                result[pos++] = this.min();
            }
            if (maxIndex % 2 == 0) {
                result[pos++] = this.max();
            }
            System.arraycopy(longs, maxIndex, result, pos, longs.length - maxIndex);
            return Range.fromRanges(result, longs.length + pos - maxIndex);
        }

        @Override
        public long min() {
            return this.myFrom;
        }

        @Override
        public long max() {
            return this.myTo;
        }

        @Override
        public boolean intersects(LongRangeSet other) {
            if (other.isEmpty()) {
                return false;
            }
            if (other instanceof RangeSet) {
                long[] otherRanges = ((RangeSet)other).myRanges;
                for (int i = 0; i < otherRanges.length && otherRanges[i] <= this.myTo; i += 2) {
                    if (this.myTo < otherRanges[i] || this.myFrom > otherRanges[i + 1]) continue;
                    return true;
                }
                return false;
            }
            return this.myTo >= other.min() && this.myFrom <= other.max();
        }

        @Override
        public boolean contains(long value2) {
            return this.myFrom <= value2 && this.myTo >= value2;
        }

        @Override
        public boolean contains(LongRangeSet other) {
            return other.isEmpty() || other.min() >= this.myFrom && other.max() <= this.myTo;
        }

        @Override
        public LongRangeSet castTo(PsiPrimitiveType type2) {
            if (PsiType.LONG.equals((Object)type2)) {
                return this;
            }
            if (PsiType.BYTE.equals((Object)type2)) {
                return this.mask(8, type2);
            }
            if (PsiType.SHORT.equals((Object)type2)) {
                return this.mask(16, type2);
            }
            if (PsiType.INT.equals((Object)type2)) {
                return this.mask(32, type2);
            }
            if (PsiType.CHAR.equals((Object)type2)) {
                if (this.myFrom <= 0L && this.myTo >= 65535L) {
                    return CHAR_RANGE;
                }
                if (this.myFrom >= 0L && this.myTo <= 65535L) {
                    return this;
                }
                return this.bitwiseAnd(Range.point(65535L));
            }
            throw new IllegalArgumentException(type2.toString());
        }

        @NotNull
        private LongRangeSet mask(int size, PsiPrimitiveType type2) {
            long addend = 1L << size - 1;
            if (this.myFrom <= -addend && this.myTo >= addend - 1L) {
                return Objects.requireNonNull(Range.fromType((PsiType)type2));
            }
            if (this.myFrom >= -addend && this.myTo <= addend - 1L) {
                return this;
            }
            long mask = (1L << size) - 1L;
            return Range.plus(this.myFrom, this.myTo, addend, addend, true).bitwiseAnd(Range.point(mask)).plus(Range.point(-addend), true);
        }

        @Override
        @NotNull
        public LongRangeSet abs(boolean isLong) {
            if (this.myFrom >= 0L) {
                return this;
            }
            long minValue = Range.minValue(isLong);
            long low = this.myFrom;
            long hi = this.myTo;
            if (low <= minValue) {
                low = minValue + 1L;
            }
            if (this.myTo <= 0L) {
                hi = -low;
                low = -this.myTo;
            } else {
                hi = Math.max(-low, hi);
                low = 0L;
            }
            if (this.myFrom <= minValue) {
                return new RangeSet(new long[]{minValue, minValue, low, hi});
            }
            return new Range(low, hi);
        }

        @Override
        @NotNull
        public LongRangeSet negate(boolean isLong) {
            long minValue = Range.minValue(isLong);
            if (this.myFrom <= minValue) {
                if (this.myTo >= Range.maxValue(isLong)) {
                    return isLong ? LONG_RANGE : INT_RANGE;
                }
                return new RangeSet(new long[]{minValue, minValue, -this.myTo, -(minValue + 1L)});
            }
            return new Range(-this.myTo, -this.myFrom);
        }

        @Override
        @NotNull
        public LongRangeSet plus(LongRangeSet other, boolean isLong) {
            if (other.isEmpty()) {
                return other;
            }
            if (isLong && this.equals(LONG_RANGE) || !isLong && this.equals(INT_RANGE)) {
                return this;
            }
            if (other instanceof Point || other instanceof Range || other instanceof RangeSet && ((RangeSet)other).myRanges.length > 6) {
                return Range.plus(this.myFrom, this.myTo, other.min(), other.max(), isLong);
            }
            long[] ranges = other.asRanges();
            LongRangeSet result = Range.empty();
            for (int i = 0; i < ranges.length; i += 2) {
                result = result.unite(Range.plus(this.myFrom, this.myTo, ranges[i], ranges[i + 1], isLong));
            }
            return result;
        }

        @Override
        public LongRangeSet mul(LongRangeSet multiplier, boolean isLong) {
            if (multiplier.isEmpty()) {
                return multiplier;
            }
            if (multiplier instanceof Point) {
                return multiplier.mul(this, isLong);
            }
            return isLong ? LONG_RANGE : INT_RANGE;
        }

        @NotNull
        private static LongRangeSet plus(long from1, long to1, long from2, long to2, boolean isLong) {
            long len1 = to1 - from1;
            long len2 = to2 - from2;
            if (len1 < 0L && len2 < 0L || (len1 < 0L || len2 < 0L) && len1 + len2 + 1L >= 0L) {
                return isLong ? LONG_RANGE : INT_RANGE;
            }
            long from = from1 + from2;
            long to = to1 + to2;
            if (!isLong) {
                if (to - from + 1L >= 0x100000000L) {
                    return INT_RANGE;
                }
                from = (int)from;
                to = (int)to;
            }
            if (to < from) {
                return new RangeSet(new long[]{Range.minValue(isLong), to, from, Range.maxValue(isLong)});
            }
            return Range.range(from, to);
        }

        @Override
        @NotNull
        public LongRangeSet mod(LongRangeSet divisor) {
            long minDivisor;
            if (divisor.isEmpty() || divisor.equals(Range.point(0L))) {
                return Range.empty();
            }
            if (divisor instanceof Point && ((Point)divisor).myValue == Long.MIN_VALUE) {
                return this.contains(Long.MIN_VALUE) ? this.subtract(divisor).unite(Range.point(0L)) : this;
            }
            if (divisor.contains(Long.MIN_VALUE)) {
                return this.possibleMod();
            }
            long min = divisor.min();
            long max = divisor.max();
            long maxDivisor = Math.max(Math.abs(min), Math.abs(max));
            long l = min > 0L ? min : (minDivisor = max < 0L ? Math.abs(max) : 0L);
            if (!this.intersects(LongRangeSet.range(Long.MIN_VALUE, -minDivisor)) && !this.intersects(LongRangeSet.range(minDivisor, Long.MAX_VALUE))) {
                return this;
            }
            return this.possibleMod().intersect(Range.range(-maxDivisor + 1L, maxDivisor - 1L));
        }

        private LongRangeSet possibleMod() {
            if (this.contains(0L)) {
                return this;
            }
            if (this.min() > 0L) {
                return Range.range(0L, this.max());
            }
            return Range.range(this.min(), 0L);
        }

        @Override
        public LongStream stream() {
            return LongStream.rangeClosed(this.myFrom, this.myTo);
        }

        @Override
        long[] asRanges() {
            return new long[]{this.myFrom, this.myTo};
        }

        public int hashCode() {
            return Long.hashCode(this.myFrom) * 1337 + Long.hashCode(this.myTo);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o != null && o.getClass() == this.getClass() && this.myFrom == ((Range)o).myFrom && this.myTo == ((Range)o).myTo;
        }

        public String toString() {
            return "{" + Range.toString(this.myFrom, this.myTo) + "}";
        }
    }

    static final class Point
    extends LongRangeSet {
        final long myValue;

        Point(long value2) {
            this.myValue = value2;
        }

        @Override
        public LongRangeSet subtract(LongRangeSet other) {
            return other.contains(this.myValue) ? Empty.EMPTY : this;
        }

        @Override
        public LongRangeSet intersect(LongRangeSet other) {
            return other.contains(this.myValue) ? this : Empty.EMPTY;
        }

        @Override
        public long min() {
            return this.myValue;
        }

        @Override
        public long max() {
            return this.myValue;
        }

        @Override
        public Long getConstantValue() {
            return this.myValue;
        }

        @Override
        public LongRangeSet unite(LongRangeSet other) {
            long[] result;
            boolean touchRight;
            if (other.isEmpty() || other == this) {
                return this;
            }
            if (other.contains(this.myValue)) {
                return other;
            }
            if (other instanceof Point) {
                long value2;
                long value1 = Math.min(this.myValue, ((Point)other).myValue);
                return value1 + 1L == (value2 = Math.max(this.myValue, ((Point)other).myValue)) ? Point.range(value1, value2) : new RangeSet(new long[]{value1, value1, value2, value2});
            }
            if (other instanceof ModRange) {
                return other.unite(this);
            }
            if (other instanceof Range) {
                if (this.myValue < other.min()) {
                    return this.myValue + 1L == other.min() ? Point.range(this.myValue, other.max()) : new RangeSet(new long[]{this.myValue, this.myValue, other.min(), other.max()});
                }
                assert (this.myValue > other.max());
                return this.myValue - 1L == other.max() ? Point.range(other.min(), this.myValue) : new RangeSet(new long[]{other.min(), other.max(), this.myValue, this.myValue});
            }
            long[] longs = other.asRanges();
            int pos = -Arrays.binarySearch(longs, this.myValue) - 1;
            assert (pos >= 0 && pos % 2 == 0);
            boolean touchLeft = pos > 0 && longs[pos - 1] + 1L == this.myValue;
            boolean bl = touchRight = pos < longs.length - 1 && this.myValue + 1L == longs[pos];
            if (touchLeft) {
                if (touchRight) {
                    result = new long[longs.length - 2];
                    System.arraycopy(longs, 0, result, 0, pos - 1);
                    System.arraycopy(longs, pos + 1, result, pos - 1, longs.length - pos - 1);
                } else {
                    result = (long[])longs.clone();
                    result[pos - 1] = this.myValue;
                }
            } else if (touchRight) {
                result = (long[])longs.clone();
                result[pos] = this.myValue;
            } else {
                result = new long[longs.length + 2];
                System.arraycopy(longs, 0, result, 0, pos);
                long l = this.myValue;
                result[pos + 1] = l;
                result[pos] = l;
                System.arraycopy(longs, pos, result, pos + 2, longs.length - pos);
            }
            return Point.fromRanges(result, result.length);
        }

        @Override
        public boolean intersects(LongRangeSet other) {
            return other.contains(this.myValue);
        }

        @Override
        public boolean contains(long value2) {
            return this.myValue == value2;
        }

        @Override
        public boolean contains(LongRangeSet other) {
            return other.isEmpty() || this.equals(other);
        }

        @Override
        public LongRangeSet castTo(PsiPrimitiveType type2) {
            long newValue;
            if (PsiType.LONG.equals((Object)type2)) {
                return this;
            }
            if (PsiType.CHAR.equals((Object)type2)) {
                newValue = (char)this.myValue;
            } else if (PsiType.INT.equals((Object)type2)) {
                newValue = (int)this.myValue;
            } else if (PsiType.SHORT.equals((Object)type2)) {
                newValue = (short)this.myValue;
            } else if (PsiType.BYTE.equals((Object)type2)) {
                newValue = (byte)this.myValue;
            } else {
                throw new IllegalArgumentException(type2.toString());
            }
            return newValue == this.myValue ? this : Point.point(newValue);
        }

        @Override
        @NotNull
        public LongRangeSet abs(boolean isLong) {
            return this.myValue >= 0L || this.myValue == Point.minValue(isLong) ? this : Point.point(-this.myValue);
        }

        @Override
        @NotNull
        public LongRangeSet negate(boolean isLong) {
            return this.myValue == Point.minValue(isLong) ? this : Point.point(-this.myValue);
        }

        @Override
        @NotNull
        public LongRangeSet plus(LongRangeSet other, boolean isLong) {
            if (other.isEmpty()) {
                return other;
            }
            if (other instanceof Point) {
                long res = this.myValue + ((Point)other).myValue;
                return Point.point(isLong ? res : (long)((int)res));
            }
            return other.plus(this, isLong);
        }

        @Override
        public LongRangeSet mul(LongRangeSet multiplier, boolean isLong) {
            if (multiplier.isEmpty()) {
                return multiplier;
            }
            if (this.myValue == 0L) {
                return this;
            }
            if (this.myValue == 1L) {
                return multiplier;
            }
            if (this.myValue == -1L) {
                return multiplier.negate(isLong);
            }
            if (multiplier instanceof Point) {
                long val = ((Point)multiplier).myValue;
                long res = this.myValue * val;
                return Point.point(isLong ? res : (long)((int)res));
            }
            boolean overflow = false;
            long min = multiplier.min();
            long max = multiplier.max();
            if (isLong) {
                try {
                    min = Math.multiplyExact(min, this.myValue);
                    max = Math.multiplyExact(max, this.myValue);
                }
                catch (ArithmeticException e) {
                    overflow = true;
                }
            } else if ((min *= this.myValue) != (long)((int)min) || (max *= this.myValue) != (long)((int)max)) {
                overflow = true;
            }
            LongRangeSet result = overflow ? (isLong ? Range.LONG_RANGE : Range.INT_RANGE) : (min > max ? Point.range(max, min) : Point.range(min, max));
            long abs = Math.abs(this.myValue);
            if (overflow) {
                abs = Long.lowestOneBit(abs);
            }
            if (abs < 0L || abs > 64L && Long.bitCount(abs) == 1) {
                abs = 64L;
            }
            return Point.modRange(result.min(), result.max(), abs, 1L);
        }

        @Override
        @NotNull
        public LongRangeSet mod(LongRangeSet divisor) {
            long abs;
            if (divisor.isEmpty() || divisor.equals(Point.point(0L))) {
                return Point.empty();
            }
            if (this.myValue == 0L) {
                return this;
            }
            if (divisor instanceof Point) {
                return LongRangeSet.point(this.myValue % ((Point)divisor).myValue);
            }
            if (this.myValue != Long.MIN_VALUE && !divisor.intersects(LongRangeSet.range(-(abs = Math.abs(this.myValue)), abs))) {
                return this;
            }
            LongRangeSet addend = Point.empty();
            if (divisor.contains(Long.MIN_VALUE)) {
                divisor = divisor.subtract(Point.point(Long.MIN_VALUE));
                addend = Point.point(this.myValue);
            }
            long max = Math.max(0L, Math.max(Math.abs(divisor.min()), Math.abs(divisor.max())) - 1L);
            if (this.myValue < 0L) {
                return LongRangeSet.range(Math.max(this.myValue, -max), 0L).unite(addend);
            }
            return LongRangeSet.range(0L, Math.min(this.myValue, max)).unite(addend);
        }

        @Override
        public LongStream stream() {
            return LongStream.of(this.myValue);
        }

        @Override
        long[] asRanges() {
            return new long[]{this.myValue, this.myValue};
        }

        public int hashCode() {
            return Long.hashCode(this.myValue);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof Point && this.myValue == ((Point)o).myValue;
        }

        public String toString() {
            return "{" + LongRangeSet.formatNumber(this.myValue) + "}";
        }
    }

    static final class Empty
    extends LongRangeSet {
        static final LongRangeSet EMPTY = new Empty();

        Empty() {
        }

        @Override
        public LongRangeSet subtract(LongRangeSet other) {
            return this;
        }

        @Override
        public LongRangeSet intersect(LongRangeSet other) {
            return this;
        }

        @Override
        public LongRangeSet unite(LongRangeSet other) {
            return other;
        }

        @Override
        public long min() {
            throw new NoSuchElementException();
        }

        @Override
        public long max() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean intersects(LongRangeSet other) {
            return false;
        }

        @Override
        public boolean contains(long value2) {
            return false;
        }

        @Override
        public boolean contains(LongRangeSet other) {
            return other.isEmpty();
        }

        @Override
        public LongRangeSet castTo(PsiPrimitiveType type2) {
            if (TypeConversionUtil.isIntegralNumberType((PsiType)type2)) {
                return this;
            }
            throw new IllegalArgumentException(type2.toString());
        }

        @Override
        @NotNull
        public LongRangeSet abs(boolean isLong) {
            return this;
        }

        @Override
        @NotNull
        public LongRangeSet negate(boolean isLong) {
            return this;
        }

        @Override
        @NotNull
        public LongRangeSet plus(LongRangeSet other, boolean isLong) {
            return this;
        }

        @Override
        public LongRangeSet mul(LongRangeSet multiplier, boolean isLong) {
            return this;
        }

        @Override
        @NotNull
        public LongRangeSet mod(LongRangeSet divisor) {
            return Empty.empty();
        }

        @Override
        public LongStream stream() {
            return LongStream.empty();
        }

        @Override
        long[] asRanges() {
            return new long[0];
        }

        public int hashCode() {
            return 2154231;
        }

        public boolean equals(Object obj) {
            return obj == this;
        }

        public String toString() {
            return "{}";
        }
    }
}

