/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaBinOpValue
extends DfaValue {
    @NotNull
    private final DfaVariableValue myLeft;
    @NotNull
    private final DfaValue myRight;
    private final boolean myLong;
    private final BinOp myOp;

    private DfaBinOpValue(@NotNull DfaVariableValue left, @NotNull DfaValue right, boolean isLong, BinOp op) {
        super(left.getFactory());
        assert (right instanceof DfaConstValue && op != BinOp.MINUS || right instanceof DfaVariableValue && op != BinOp.REM);
        this.myLeft = left;
        this.myRight = right;
        this.myLong = isLong;
        this.myOp = op;
    }

    @NotNull
    public DfaVariableValue getLeft() {
        return this.myLeft;
    }

    @NotNull
    public DfaValue getRight() {
        return this.myRight;
    }

    @Override
    @Nullable
    public PsiType getType() {
        return this.myLong ? PsiType.LONG : PsiType.INT;
    }

    @Override
    public boolean dependsOn(DfaVariableValue other) {
        return this.myLeft.dependsOn(other) || this.myRight.dependsOn(other);
    }

    public BinOp getOperation() {
        return this.myOp;
    }

    public String toString() {
        Object value2;
        String delimiter = this.myOp.toString();
        if (this.myOp == BinOp.PLUS && this.myRight instanceof DfaConstValue && (value2 = ((DfaConstValue)this.myRight).getValue()) instanceof Long && (Long)value2 < 0L) {
            delimiter = "";
        }
        return this.myLeft + delimiter + this.myRight;
    }

    @NotNull
    public IElementType getTokenType() {
        return this.myOp.getTokenType();
    }

    public static enum BinOp {
        PLUS("+", JavaTokenType.PLUS),
        MINUS("-", JavaTokenType.MINUS),
        REM("%", JavaTokenType.PERC);

        private final String mySign;
        private final IElementType myTokenType;

        private BinOp(String sign, IElementType tokenType) {
            this.mySign = sign;
            this.myTokenType = tokenType;
        }

        IElementType getTokenType() {
            return this.myTokenType;
        }

        @Nullable
        public static BinOp fromTokenType(IElementType tokenType) {
            if (PLUS.getTokenType() == tokenType) {
                return PLUS;
            }
            if (MINUS.getTokenType() == tokenType) {
                return MINUS;
            }
            if (REM.getTokenType() == tokenType) {
                return REM;
            }
            return null;
        }

        public String toString() {
            return this.mySign;
        }
    }

    public static class Factory {
        private final DfaValueFactory myFactory;
        private final Map<Pair<Long, BinOp>, DfaBinOpValue> myValues = new HashMap<Pair<Long, BinOp>, DfaBinOpValue>();

        Factory(DfaValueFactory factory) {
            this.myFactory = factory;
        }

        public DfaValue create(DfaValue left, DfaValue right, DfaMemoryState state, boolean isLong, IElementType tokenType) {
            DfaValue value2;
            if (tokenType == null) {
                return DfaUnknownValue.getInstance();
            }
            BinOp op = BinOp.fromTokenType(tokenType);
            if (op != null && (value2 = this.doCreate(left, right, state, isLong, op)) != null) {
                return value2;
            }
            LongRangeSet leftRange = state.getValueFact(left, DfaFactType.RANGE);
            LongRangeSet rightRange = state.getValueFact(right, DfaFactType.RANGE);
            if (tokenType.equals(JavaTokenType.ASTERISK)) {
                if (LongRangeSet.point(1L).equals(leftRange)) {
                    return right;
                }
                if (LongRangeSet.point(1L).equals(rightRange)) {
                    return left;
                }
            }
            if (tokenType.equals(JavaTokenType.DIV) && LongRangeSet.point(1L).equals(rightRange)) {
                return left;
            }
            if ((tokenType.equals(JavaTokenType.GTGT) || tokenType.equals(JavaTokenType.LTLT) || tokenType.equals(JavaTokenType.GTGTGT)) && LongRangeSet.point(0L).equals(rightRange)) {
                return left;
            }
            if (leftRange != null && rightRange != null) {
                LongRangeSet result = leftRange.binOpFromToken(tokenType, rightRange, isLong);
                return this.myFactory.getFactValue(DfaFactType.RANGE, result);
            }
            return DfaUnknownValue.getInstance();
        }

        @Nullable
        private DfaValue doCreate(DfaValue left, DfaValue right, DfaMemoryState state, boolean isLong, BinOp op) {
            DfaConstValue rightConst;
            DfaConstValue leftConst = state.getConstantValue(left);
            if (leftConst != null) {
                left = leftConst;
            }
            if ((rightConst = state.getConstantValue(right)) != null) {
                right = rightConst;
            }
            if (op == BinOp.MINUS && state.areEqual(left, right)) {
                return this.myFactory.getInt(0);
            }
            if (op == BinOp.REM) {
                long divisor;
                Object value2;
                if (left instanceof DfaVariableValue && right instanceof DfaConstValue && (value2 = ((DfaConstValue)right).getValue()) instanceof Long && (divisor = ((Long)value2).longValue()) > 1L && divisor <= 64L) {
                    return this.doCreate((DfaVariableValue)left, right, isLong, op);
                }
                return null;
            }
            if (left instanceof DfaConstValue && (right instanceof DfaVariableValue || right instanceof DfaBinOpValue) && op == BinOp.PLUS) {
                return this.doCreate(right, left, state, isLong, op);
            }
            if (left instanceof DfaVariableValue) {
                Long value3;
                if (right instanceof DfaVariableValue) {
                    if (op == BinOp.PLUS && right.getID() > left.getID()) {
                        return this.doCreate((DfaVariableValue)right, left, isLong, op);
                    }
                    return this.doCreate((DfaVariableValue)left, right, isLong, op);
                }
                if (right instanceof DfaConstValue && (value3 = (Long)ObjectUtils.tryCast((Object)((DfaConstValue)right).getValue(), Long.class)) != null) {
                    if (value3 == 0L) {
                        return left;
                    }
                    if (op == BinOp.MINUS && (isLong || value3 != Integer.MIN_VALUE)) {
                        right = this.myFactory.getConstFactory().createFromValue(-value3.longValue(), (PsiType)PsiType.LONG);
                    }
                    return this.doCreate((DfaVariableValue)left, right, isLong, BinOp.PLUS);
                }
            }
            if (left instanceof DfaBinOpValue) {
                DfaBinOpValue sumValue = (DfaBinOpValue)left;
                if (right instanceof DfaConstValue && sumValue.getRight() instanceof DfaConstValue) {
                    Long value1 = (Long)ObjectUtils.tryCast((Object)((DfaConstValue)sumValue.getRight()).getValue(), Long.class);
                    Long value2 = (Long)ObjectUtils.tryCast((Object)((DfaConstValue)right).getValue(), Long.class);
                    if (value1 != null && value2 != null) {
                        if (op == BinOp.MINUS) {
                            value2 = -value2.longValue();
                        }
                        long res = value1 + value2;
                        right = this.myFactory.getConstFactory().createFromValue(isLong ? res : (long)((int)res), (PsiType)PsiType.LONG);
                        return this.create(sumValue.getLeft(), right, state, isLong, JavaTokenType.PLUS);
                    }
                }
                if (op == BinOp.MINUS && sumValue.getOperation() == BinOp.PLUS) {
                    if (state.areEqual(right, sumValue.getLeft())) {
                        return sumValue.getRight();
                    }
                    if (state.areEqual(right, sumValue.getRight())) {
                        return sumValue.getLeft();
                    }
                }
            }
            return null;
        }

        @NotNull
        private DfaBinOpValue doCreate(DfaVariableValue left, DfaValue right, boolean isLong, BinOp op) {
            long hash = (isLong ? 1L : 0L) << 63 | (long)left.getID() << 32 | (long)right.getID();
            Pair key2 = Pair.create((Object)hash, (Object)((Object)op));
            return this.myValues.computeIfAbsent((Pair<Long, BinOp>)key2, k -> new DfaBinOpValue(left, right, isLong, op));
        }
    }
}

