/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.DfaFactMap;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaFactMapValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.PsiType;
import gnu.trove.TIntObjectHashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaBoxedValue
extends DfaValue {
    @NotNull
    private final DfaVariableValue myWrappedValue;
    @Nullable
    private final PsiType myType;

    private DfaBoxedValue(@NotNull DfaVariableValue valueToWrap, DfaValueFactory factory, @Nullable PsiType type2) {
        super(factory);
        this.myWrappedValue = valueToWrap;
        this.myType = type2;
    }

    @NonNls
    public String toString() {
        return "Boxed " + this.myWrappedValue.toString();
    }

    @NotNull
    public DfaVariableValue getWrappedValue() {
        return this.myWrappedValue;
    }

    @Override
    @Nullable
    public PsiType getType() {
        return this.myType;
    }

    public static class Factory {
        private final TIntObjectHashMap<DfaBoxedValue> cachedValues = new TIntObjectHashMap();
        private final DfaValueFactory myFactory;

        public Factory(DfaValueFactory factory) {
            this.myFactory = factory;
        }

        public DfaBoxedValue getBoxedIfExists(DfaVariableValue variable) {
            return (DfaBoxedValue)this.cachedValues.get(variable.getID());
        }

        @Nullable
        public DfaValue createBoxed(DfaValue valueToWrap, @Nullable PsiType type2) {
            if (valueToWrap instanceof DfaVariableValue && ((DfaVariableValue)valueToWrap).getDescriptor() == SpecialField.UNBOX) {
                return ((DfaVariableValue)valueToWrap).getQualifier();
            }
            if (valueToWrap instanceof DfaConstValue || valueToWrap instanceof DfaFactMapValue) {
                DfaFactMap facts = DfaFactMap.EMPTY.with(DfaFactType.TYPE_CONSTRAINT, type2 == null ? null : TypeConstraint.exact(this.myFactory.createDfaType(type2))).with(DfaFactType.NULLABILITY, DfaNullability.NOT_NULL).with(DfaFactType.SPECIAL_FIELD_VALUE, SpecialField.UNBOX.withValue(valueToWrap));
                return this.myFactory.getFactFactory().createValue(facts);
            }
            if (valueToWrap instanceof DfaVariableValue) {
                int id = valueToWrap.getID();
                DfaBoxedValue boxedValue = (DfaBoxedValue)this.cachedValues.get(id);
                if (boxedValue == null) {
                    boxedValue = new DfaBoxedValue((DfaVariableValue)valueToWrap, this.myFactory, type2);
                    this.cachedValues.put(id, (Object)boxedValue);
                }
                return boxedValue;
            }
            return null;
        }
    }
}

