/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaConstValue
extends DfaValue {
    private static final Throwable ourThrowable = new Throwable();
    private static final Object SENTINEL = ObjectUtils.sentinel((String)"SENTINEL");
    private final Object myValue;
    @NotNull
    private final PsiType myType;

    private DfaConstValue(Object value2, @NotNull PsiType type2, DfaValueFactory factory) {
        super(factory);
        this.myValue = value2;
        this.myType = type2;
    }

    public String toString() {
        if (this.myValue == null) {
            return "null";
        }
        return this.myValue.toString();
    }

    @Override
    @NotNull
    public PsiType getType() {
        return this.myType;
    }

    @Nullable
    public Object getValue() {
        return this.myValue;
    }

    @Override
    public DfaValue createNegated() {
        if (this == this.myFactory.getConstFactory().getTrue()) {
            return this.myFactory.getConstFactory().getFalse();
        }
        if (this == this.myFactory.getConstFactory().getFalse()) {
            return this.myFactory.getConstFactory().getTrue();
        }
        return DfaUnknownValue.getInstance();
    }

    @Contract(value="null -> false")
    public static boolean isContractFail(DfaValue value2) {
        return value2 instanceof DfaConstValue && ((DfaConstValue)value2).getValue() == ourThrowable;
    }

    public static class Factory {
        private final DfaConstValue dfaNull;
        private final DfaConstValue dfaFalse;
        private final DfaConstValue dfaTrue;
        private final DfaConstValue dfaFail;
        private final DfaConstValue dfaSentinel;
        private final DfaValueFactory myFactory;
        private final Map<Object, DfaConstValue> myValues = ContainerUtil.newHashMap();

        Factory(DfaValueFactory factory) {
            this.myFactory = factory;
            this.dfaNull = new DfaConstValue(null, (PsiType)PsiType.NULL, factory);
            this.dfaFalse = new DfaConstValue(Boolean.FALSE, (PsiType)PsiType.BOOLEAN, factory);
            this.dfaTrue = new DfaConstValue(Boolean.TRUE, (PsiType)PsiType.BOOLEAN, factory);
            this.dfaFail = new DfaConstValue(ourThrowable, (PsiType)PsiType.VOID, factory);
            this.dfaSentinel = new DfaConstValue(SENTINEL, (PsiType)PsiType.VOID, factory);
        }

        @Nullable
        public DfaValue create(PsiLiteralExpression expr) {
            PsiType type2 = expr.getType();
            if (type2 == null) {
                return null;
            }
            if (PsiType.NULL.equals((Object)type2)) {
                return this.dfaNull;
            }
            Object value2 = expr.getValue();
            if (value2 == null) {
                return null;
            }
            return this.createFromValue(value2, type2);
        }

        @Nullable
        public DfaValue create(PsiVariable variable) {
            if (DfaUtil.ignoreInitializer(variable)) {
                return null;
            }
            Object value2 = variable.computeConstantValue();
            PsiType type2 = variable.getType();
            if (value2 == null) {
                Boolean boo = Factory.computeJavaLangBooleanFieldReference(variable);
                if (boo != null) {
                    DfaConstValue unboxed = this.createFromValue(boo, (PsiType)PsiType.BOOLEAN);
                    return this.myFactory.getBoxedFactory().createBoxed(unboxed, (PsiType)PsiType.BOOLEAN.getBoxedType((PsiElement)variable));
                }
                PsiExpression initializer = PsiUtil.skipParenthesizedExprDown((PsiExpression)variable.getInitializer());
                if (initializer instanceof PsiLiteralExpression && initializer.textMatches((CharSequence)"null")) {
                    return this.dfaNull;
                }
                if (variable instanceof PsiField && variable.hasModifierProperty("static") && ExpressionUtils.isNewObject(initializer)) {
                    return this.createFromValue(variable, type2);
                }
                return null;
            }
            return this.createFromValue(value2, type2);
        }

        @Nullable
        private static Boolean computeJavaLangBooleanFieldReference(PsiVariable variable) {
            if (!(variable instanceof PsiField)) {
                return null;
            }
            PsiClass psiClass = ((PsiField)variable).getContainingClass();
            if (psiClass == null || !"java.lang.Boolean".equals(psiClass.getQualifiedName())) {
                return null;
            }
            String name = variable.getName();
            return "TRUE".equals(name) ? Boolean.TRUE : ("FALSE".equals(name) ? Boolean.FALSE : null);
        }

        @NotNull
        public DfaConstValue createDefault(@NotNull PsiType type2) {
            return this.createFromValue(PsiTypesUtil.getDefaultValue((PsiType)type2), type2);
        }

        @NotNull
        public DfaConstValue createFromValue(Object value2, @NotNull PsiType type2) {
            DfaConstValue instance;
            Object numeric;
            if (Boolean.TRUE.equals(value2)) {
                return this.dfaTrue;
            }
            if (Boolean.FALSE.equals(value2)) {
                return this.dfaFalse;
            }
            if (value2 == null) {
                return this.dfaNull;
            }
            if (TypeConversionUtil.isNumericType((PsiType)type2) && !TypeConversionUtil.isFloatOrDoubleType((PsiType)type2) && (numeric = TypeConversionUtil.computeCastTo((Object)value2, (PsiType)(type2 = PsiType.LONG))) != null) {
                value2 = numeric;
            }
            if (value2 instanceof Float) {
                value2 = ((Float)value2).doubleValue();
            }
            if ((instance = this.myValues.get(value2)) == null) {
                instance = new DfaConstValue(value2, type2, this.myFactory);
                this.myValues.put(value2, instance);
            }
            return instance;
        }

        public DfaConstValue getContractFail() {
            return this.dfaFail;
        }

        public DfaConstValue getFalse() {
            return this.dfaFalse;
        }

        public DfaConstValue getTrue() {
            return this.dfaTrue;
        }

        public DfaConstValue getNull() {
            return this.dfaNull;
        }

        public DfaConstValue getSentinel() {
            return this.dfaSentinel;
        }
    }
}

