/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.DfaFactMap;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.psi.PsiType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaFactMapValue
extends DfaValue {
    private final DfaFactMap myFacts;

    DfaFactMapValue(DfaValueFactory factory, DfaFactMap facts) {
        super(factory);
        this.myFacts = facts;
    }

    public <T> DfaValue withFact(@NotNull DfaFactType<T> factType, @Nullable T value2) {
        return this.getFactory().getFactFactory().createValue(this.myFacts.with(factType, value2));
    }

    public DfaFactMap getFacts() {
        return this.myFacts;
    }

    @Nullable
    public <T> T get(@NotNull DfaFactType<T> factType) {
        return this.myFacts.get(factType);
    }

    public String toString() {
        return this.myFacts.toString();
    }

    public static class Factory {
        private final DfaValueFactory myFactory;
        private final Map<DfaFactMap, DfaFactMapValue> myValues = new HashMap<DfaFactMap, DfaFactMapValue>();

        Factory(DfaValueFactory factory) {
            this.myFactory = factory;
        }

        public <T> DfaValue createValue(@NotNull DfaFactType<T> factType, @Nullable T value2) {
            Long constantValue;
            if (factType == DfaFactType.RANGE && value2 instanceof LongRangeSet && (constantValue = ((LongRangeSet)value2).getConstantValue()) != null) {
                return this.myFactory.getConstFactory().createFromValue(constantValue, (PsiType)PsiType.LONG);
            }
            return this.createValue(DfaFactMap.EMPTY.with(factType, value2));
        }

        public DfaValue createValue(DfaFactMap facts) {
            if (facts == DfaFactMap.EMPTY) {
                return DfaUnknownValue.getInstance();
            }
            if (facts.get(DfaFactType.NULLABILITY) == DfaNullability.NULL) {
                return this.myFactory.getConstFactory().getNull();
            }
            return this.myValues.computeIfAbsent(facts, f -> new DfaFactMapValue(this.myFactory, (DfaFactMap)f));
        }
    }
}

