/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class DfaPsiType {
    private final PsiType myPsiType;
    private final DfaValueFactory myFactory;
    private List<DfaPsiType> mySuperTypes;
    private final int myID;

    DfaPsiType(int id, @NotNull PsiType psiType, DfaValueFactory factory) {
        this.myID = id;
        this.myPsiType = psiType;
        this.myFactory = factory;
    }

    @NotNull
    public PsiType getPsiType() {
        return this.myPsiType;
    }

    public Stream<DfaPsiType> superTypes() {
        if (this.mySuperTypes == null) {
            ArrayList<DfaPsiType> superTypes = new ArrayList<DfaPsiType>();
            InheritanceUtil.processSuperTypes((PsiType)this.getPsiType(), (boolean)false, t -> superTypes.add(this.myFactory.createDfaType((PsiType)t)));
            this.mySuperTypes = superTypes;
        }
        return this.mySuperTypes.stream();
    }

    @NotNull
    public TypeConstraint asConstraint() {
        TypeConstraint constraint = TypeConstraint.empty().withInstanceofValue(this);
        assert (constraint != null);
        return constraint;
    }

    public boolean isAssignableFrom(DfaPsiType other) {
        if (other == this) {
            return true;
        }
        Pair key2 = Pair.create((Object)this, (Object)other);
        return this.myFactory.myAssignableCache.computeIfAbsent((Pair<DfaPsiType, DfaPsiType>)key2, k -> this.myPsiType.isAssignableFrom(other.myPsiType));
    }

    public boolean isConvertibleFrom(DfaPsiType other) {
        if (other == this) {
            return true;
        }
        Pair key2 = Pair.create((Object)this, (Object)other);
        return this.myFactory.myConvertibleCache.computeIfAbsent((Pair<DfaPsiType, DfaPsiType>)key2, k -> this.myPsiType.isConvertibleFrom(other.myPsiType));
    }

    public DfaValueFactory getFactory() {
        return this.myFactory;
    }

    public String toString() {
        return this.myPsiType.getPresentableText();
    }

    public int getID() {
        return this.myID;
    }

    @NotNull
    public static PsiType normalizeType(@NotNull PsiType psiType) {
        PsiType[] types;
        if (psiType instanceof PsiArrayType) {
            int dimensions = psiType.getArrayDimensions();
            psiType = psiType.getDeepComponentType();
            psiType = DfaPsiType.normalizeType(psiType);
            while (dimensions-- > 0) {
                psiType = psiType.createArrayType();
            }
            return psiType;
        }
        if (psiType instanceof PsiWildcardType) {
            return DfaPsiType.normalizeType(((PsiWildcardType)psiType).getExtendsBound());
        }
        if (psiType instanceof PsiCapturedWildcardType) {
            return DfaPsiType.normalizeType(((PsiCapturedWildcardType)psiType).getUpperBound());
        }
        if (psiType instanceof PsiIntersectionType && (types = (PsiType[])StreamEx.of((Object[])((PsiIntersectionType)psiType).getConjuncts()).map(DfaPsiType::normalizeType).toArray((Object[])PsiType.EMPTY_ARRAY)).length > 0) {
            return PsiIntersectionType.createIntersection((boolean)true, (PsiType[])types);
        }
        if (psiType instanceof PsiClassType) {
            return DfaPsiType.normalizeClassType((PsiClassType)psiType, new HashSet<PsiClass>());
        }
        return psiType;
    }

    @NotNull
    private static PsiType normalizeClassType(@NotNull PsiClassType psiType, Set<PsiClass> processed) {
        PsiClass aClass = psiType.resolve();
        if (aClass instanceof PsiTypeParameter) {
            PsiClassType[] types = aClass.getExtendsListTypes();
            ArrayList<PsiType> result = new ArrayList<PsiType>();
            for (PsiClassType type2 : types) {
                PsiClass resolved = type2.resolve();
                if (resolved == null || !processed.add(resolved)) continue;
                PsiClassType classType = JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createType(resolved);
                result.add(DfaPsiType.normalizeClassType(classType, processed));
            }
            if (!result.isEmpty()) {
                return PsiIntersectionType.createIntersection((boolean)true, (PsiType[])result.toArray(PsiType.EMPTY_ARRAY));
            }
            return PsiType.getJavaLangObject((PsiManager)aClass.getManager(), (GlobalSearchScope)aClass.getResolveScope());
        }
        return psiType.rawType();
    }
}

