/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.value.DfaBinOpValue;
import com.intellij.codeInspection.dataFlow.value.DfaBoxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaFactMapValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaRelationValue
extends DfaValue {
    @NotNull
    private final DfaValue myLeftOperand;
    @NotNull
    private final DfaValue myRightOperand;
    @NotNull
    private final RelationType myRelation;

    @Override
    public DfaRelationValue createNegated() {
        return this.myFactory.getRelationFactory().createCanonicalRelation(this.myLeftOperand, this.myRelation.getNegated(), this.myRightOperand);
    }

    private DfaRelationValue(@NotNull DfaValue leftOperand2, @NotNull DfaValue rightOperand2, @NotNull RelationType relationType, DfaValueFactory factory) {
        super(factory);
        this.myLeftOperand = leftOperand2;
        this.myRightOperand = rightOperand2;
        this.myRelation = relationType;
    }

    @NotNull
    public DfaValue getLeftOperand() {
        return this.myLeftOperand;
    }

    @NotNull
    public DfaValue getRightOperand() {
        return this.myRightOperand;
    }

    public boolean isEquality() {
        return this.myRelation == RelationType.EQ;
    }

    public boolean isNonEquality() {
        return this.myRelation == RelationType.NE || this.myRelation == RelationType.GT || this.myRelation == RelationType.LT;
    }

    @NotNull
    public RelationType getRelation() {
        return this.myRelation;
    }

    @Override
    @Nullable
    public PsiType getType() {
        return PsiType.BOOLEAN;
    }

    @NonNls
    public String toString() {
        return this.myLeftOperand + " " + (Object)((Object)this.myRelation) + " " + this.myRightOperand;
    }

    public static class Factory {
        private final Map<Trinity<DfaValue, DfaValue, RelationType>, DfaRelationValue> myValues;
        private final DfaValueFactory myFactory;

        Factory(DfaValueFactory factory) {
            this.myFactory = factory;
            this.myValues = new HashMap<Trinity<DfaValue, DfaValue, RelationType>, DfaRelationValue>();
        }

        public DfaRelationValue createRelation(DfaValue dfaLeft, RelationType relationType, DfaValue dfaRight) {
            if ((relationType == RelationType.IS || relationType == RelationType.IS_NOT) && dfaRight instanceof DfaFactMapValue && !(dfaLeft instanceof DfaFactMapValue)) {
                return this.createCanonicalRelation(dfaLeft, relationType, dfaRight);
            }
            if (dfaLeft instanceof DfaVariableValue || dfaLeft instanceof DfaBoxedValue || dfaLeft instanceof DfaBinOpValue || dfaRight instanceof DfaVariableValue || dfaRight instanceof DfaBoxedValue || dfaRight instanceof DfaBinOpValue) {
                if (!(dfaLeft instanceof DfaVariableValue) && !(dfaLeft instanceof DfaBoxedValue) && !(dfaLeft instanceof DfaBinOpValue) || dfaRight instanceof DfaBinOpValue && !(dfaLeft instanceof DfaBinOpValue)) {
                    RelationType flipped = relationType.getFlipped();
                    return flipped == null ? null : this.createCanonicalRelation(dfaRight, flipped, dfaLeft);
                }
                return this.createCanonicalRelation(dfaLeft, relationType, dfaRight);
            }
            if (dfaLeft instanceof DfaFactMapValue && dfaRight instanceof DfaConstValue) {
                return this.createConstBasedRelation((DfaFactMapValue)dfaLeft, relationType, (DfaConstValue)dfaRight);
            }
            if (dfaRight instanceof DfaFactMapValue && dfaLeft instanceof DfaConstValue) {
                return this.createConstBasedRelation((DfaFactMapValue)dfaRight, relationType, (DfaConstValue)dfaLeft);
            }
            return null;
        }

        @NotNull
        private DfaRelationValue createConstBasedRelation(DfaFactMapValue dfaLeft, RelationType relationType, DfaConstValue dfaRight) {
            if (dfaRight.getValue() == null && DfaNullability.isNullable(dfaLeft.getFacts())) {
                return this.createCanonicalRelation(this.myFactory.getFactValue(DfaFactType.NULLABILITY, DfaNullability.NULLABLE), relationType, dfaRight);
            }
            return this.createCanonicalRelation(DfaUnknownValue.getInstance(), relationType, dfaRight);
        }

        @NotNull
        private DfaRelationValue createCanonicalRelation(@NotNull DfaValue dfaLeft, @NotNull RelationType relationType, @NotNull DfaValue dfaRight) {
            return this.myValues.computeIfAbsent((Trinity<DfaValue, DfaValue, RelationType>)Trinity.create((Object)dfaLeft, (Object)dfaRight, (Object)((Object)relationType)), k -> new DfaRelationValue(dfaLeft, dfaRight, relationType, this.myFactory));
        }
    }

    public static enum RelationType {
        LE("<="),
        LT("<"),
        GE(">="),
        GT(">"),
        EQ("=="),
        NE("!="),
        IS("is"),
        IS_NOT("isn't");

        private final String myName;

        private RelationType(String name) {
            this.myName = name;
        }

        public boolean isSubRelation(RelationType other) {
            if (other == this) {
                return true;
            }
            switch (this) {
                case LE: {
                    return other == LT || other == EQ;
                }
                case GE: {
                    return other == GT || other == EQ;
                }
                case NE: {
                    return other == LT || other == GT;
                }
            }
            return false;
        }

        @NotNull
        public RelationType getNegated() {
            switch (this) {
                case LE: {
                    return GT;
                }
                case LT: {
                    return GE;
                }
                case GE: {
                    return LT;
                }
                case GT: {
                    return LE;
                }
                case EQ: {
                    return NE;
                }
                case NE: {
                    return EQ;
                }
                case IS: {
                    return IS_NOT;
                }
                case IS_NOT: {
                    return IS;
                }
            }
            throw new InternalError("Unexpected enum value: " + (Object)((Object)this));
        }

        @Nullable
        public RelationType getFlipped() {
            switch (this) {
                case LE: {
                    return GE;
                }
                case LT: {
                    return GT;
                }
                case GE: {
                    return LE;
                }
                case GT: {
                    return LT;
                }
                case NE: 
                case EQ: {
                    return this;
                }
            }
            return null;
        }

        public boolean isInequality() {
            return this == LE || this == GE || this == LT || this == GT || this == NE;
        }

        public String toString() {
            return this.myName;
        }

        @Nullable
        public static RelationType fromElementType(IElementType type2) {
            if (JavaTokenType.EQEQ.equals(type2)) {
                return EQ;
            }
            if (JavaTokenType.NE.equals(type2)) {
                return NE;
            }
            if (JavaTokenType.LT.equals(type2)) {
                return LT;
            }
            if (JavaTokenType.GT.equals(type2)) {
                return GT;
            }
            if (JavaTokenType.LE.equals(type2)) {
                return LE;
            }
            if (JavaTokenType.GE.equals(type2)) {
                return GE;
            }
            if (JavaTokenType.INSTANCEOF_KEYWORD.equals(type2)) {
                return IS;
            }
            return null;
        }

        public static RelationType equivalence(boolean equal) {
            return equal ? EQ : NE;
        }
    }
}

