/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.DfaControlTransferValue;
import com.intellij.codeInspection.dataFlow.DfaFactMap;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.dataFlow.TransferTarget;
import com.intellij.codeInspection.dataFlow.Trap;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.value.DfaBinOpValue;
import com.intellij.codeInspection.dataFlow.value.DfaBoxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaExpressionFactory;
import com.intellij.codeInspection.dataFlow.value.DfaFactMapValue;
import com.intellij.codeInspection.dataFlow.value.DfaPsiType;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.util.Pair;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.containers.FactoryMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaValueFactory {
    private final List<DfaValue> myValues = ContainerUtil.newArrayList();
    final Map<Pair<DfaPsiType, DfaPsiType>, Boolean> myAssignableCache = ContainerUtil.newHashMap();
    final Map<Pair<DfaPsiType, DfaPsiType>, Boolean> myConvertibleCache = ContainerUtil.newHashMap();
    private final Map<PsiType, DfaPsiType> myDfaTypes = ContainerUtil.newHashMap();
    private final boolean myUnknownMembersAreNullable;
    private final FieldChecker myFieldChecker;
    private static final ElementPattern<? extends PsiModifierListOwner> MEMBER_OR_METHOD_PARAMETER = StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiMember(), PsiJavaPatterns.psiParameter().withSuperParent(2, (ElementPattern)PsiJavaPatterns.psiMember())});
    private final Map<Pair<TransferTarget, FList<Trap>>, DfaControlTransferValue> myControlTransfers = FactoryMap.create(p -> new DfaControlTransferValue(this, (TransferTarget)p.first, (FList<Trap>)((FList)p.second)));
    private final DfaVariableValue.Factory myVarFactory;
    private final DfaConstValue.Factory myConstFactory;
    private final DfaBoxedValue.Factory myBoxedFactory;
    private final DfaBinOpValue.Factory myBinOpFactory;
    private final DfaRelationValue.Factory myRelationFactory;
    private final DfaExpressionFactory myExpressionFactory;
    private final DfaFactMapValue.Factory myFactFactory;

    public DfaValueFactory(@Nullable PsiElement context, boolean unknownMembersAreNullable) {
        this.myFieldChecker = new FieldChecker(context);
        this.myUnknownMembersAreNullable = unknownMembersAreNullable;
        this.myValues.add(null);
        this.myVarFactory = new DfaVariableValue.Factory(this);
        this.myConstFactory = new DfaConstValue.Factory(this);
        this.myBoxedFactory = new DfaBoxedValue.Factory(this);
        this.myRelationFactory = new DfaRelationValue.Factory(this);
        this.myExpressionFactory = new DfaExpressionFactory(this);
        this.myFactFactory = new DfaFactMapValue.Factory(this);
        this.myBinOpFactory = new DfaBinOpValue.Factory(this);
    }

    public boolean canTrustFieldInitializer(PsiField field) {
        return this.myFieldChecker.canTrustFieldInitializer(field);
    }

    @NotNull
    public Nullability suggestNullabilityForNonAnnotatedMember(@NotNull PsiModifierListOwner member) {
        if (this.myUnknownMembersAreNullable && MEMBER_OR_METHOD_PARAMETER.accepts((Object)member) && AnnotationUtil.getSuperAnnotationOwners((PsiModifierListOwner)member).isEmpty()) {
            return Nullability.NULLABLE;
        }
        return Nullability.UNKNOWN;
    }

    @NotNull
    public DfaValue createTypeValue(@Nullable PsiType type2, @NotNull Nullability nullability) {
        LongRangeSet range;
        if (type2 == null) {
            return DfaUnknownValue.getInstance();
        }
        if (type2 instanceof PsiPrimitiveType && (range = LongRangeSet.fromType(type2)) != null) {
            return this.getFactFactory().createValue(DfaFactType.RANGE, range);
        }
        DfaFactMap facts = DfaFactMap.EMPTY.with(DfaFactType.TYPE_CONSTRAINT, this.createDfaType(type2).asConstraint()).with(DfaFactType.NULLABILITY, DfaNullability.fromNullability(nullability));
        return this.getFactFactory().createValue(facts);
    }

    @NotNull
    public DfaValue createExactTypeValue(@Nullable PsiType type2) {
        if (type2 == null) {
            return DfaUnknownValue.getInstance();
        }
        DfaFactMap facts = DfaFactMap.EMPTY.with(DfaFactType.TYPE_CONSTRAINT, TypeConstraint.exact(this.createDfaType(type2))).with(DfaFactType.NULLABILITY, DfaNullability.NOT_NULL);
        return this.getFactFactory().createValue(facts);
    }

    @NotNull
    public <T> DfaValue withFact(@NotNull DfaValue value2, @NotNull DfaFactType<T> factType, @Nullable T factValue) {
        if (value2 instanceof DfaUnknownValue) {
            return this.getFactFactory().createValue(DfaFactMap.EMPTY.with(factType, factValue));
        }
        if (value2 instanceof DfaFactMapValue) {
            return ((DfaFactMapValue)value2).withFact(factType, factValue);
        }
        return DfaUnknownValue.getInstance();
    }

    @NotNull
    public DfaPsiType createDfaType(@NotNull PsiType psiType) {
        DfaPsiType dfaType = this.myDfaTypes.get(psiType = DfaPsiType.normalizeType(psiType));
        if (dfaType == null) {
            dfaType = new DfaPsiType(this.myDfaTypes.size() + 1, psiType, this);
            this.myDfaTypes.put(psiType, dfaType);
        }
        return dfaType;
    }

    int registerValue(DfaValue value2) {
        this.myValues.add(value2);
        return this.myValues.size() - 1;
    }

    public DfaValue getValue(int id) {
        return this.myValues.get(id);
    }

    @NotNull
    public DfaPsiType getType(int id) {
        return (DfaPsiType)StreamEx.ofValues(this.myDfaTypes).findFirst(t -> t.getID() == id).orElseThrow(IllegalArgumentException::new);
    }

    @Nullable
    @Contract(value="null -> null")
    public DfaValue createValue(PsiExpression psiExpression) {
        return this.myExpressionFactory.getExpressionDfaValue(psiExpression);
    }

    @NotNull
    public DfaConstValue getInt(int value2) {
        return this.getConstFactory().createFromValue(value2, (PsiType)PsiType.INT);
    }

    @Nullable
    public DfaValue createLiteralValue(PsiLiteralExpression literal) {
        return this.getConstFactory().create(literal);
    }

    @NotNull
    public DfaValue createCondition(DfaValue dfaLeft, DfaRelationValue.RelationType relationType, DfaValue dfaRight) {
        DfaConstValue value2 = this.tryEvaluate(dfaLeft, relationType, dfaRight);
        if (value2 != null) {
            return value2;
        }
        DfaRelationValue relation = this.getRelationFactory().createRelation(dfaLeft, relationType, dfaRight);
        if (relation != null) {
            return relation;
        }
        return DfaUnknownValue.getInstance();
    }

    @Nullable
    private DfaConstValue tryEvaluate(DfaValue dfaLeft, DfaRelationValue.RelationType relationType, DfaValue dfaRight) {
        DfaConstValue sentinel = this.getConstFactory().getSentinel();
        if (dfaLeft == sentinel != (dfaRight == sentinel)) {
            return this.getBoolean(relationType == DfaRelationValue.RelationType.NE);
        }
        if (dfaRight instanceof DfaFactMapValue && dfaLeft == this.getConstFactory().getNull()) {
            return this.tryEvaluate(dfaRight, relationType, dfaLeft);
        }
        if (dfaLeft instanceof DfaFactMapValue && dfaRight == this.getConstFactory().getNull() && DfaNullability.isNotNull(((DfaFactMapValue)dfaLeft).getFacts())) {
            if (relationType == DfaRelationValue.RelationType.EQ) {
                return this.getConstFactory().getFalse();
            }
            if (relationType == DfaRelationValue.RelationType.NE) {
                return this.getConstFactory().getTrue();
            }
        }
        if (dfaLeft instanceof DfaFactMapValue && dfaRight instanceof DfaFactMapValue && (relationType == DfaRelationValue.RelationType.IS || relationType == DfaRelationValue.RelationType.IS_NOT)) {
            boolean isDistinct;
            DfaFactMap leftFacts = ((DfaFactMapValue)dfaLeft).getFacts();
            DfaFactMap rightFacts = ((DfaFactMapValue)dfaRight).getFacts();
            boolean isSuperState = rightFacts.isSuperStateOf(leftFacts);
            if (isSuperState) {
                return this.getBoolean(relationType == DfaRelationValue.RelationType.IS);
            }
            boolean bl = isDistinct = rightFacts.intersect(leftFacts) == null;
            if (isDistinct) {
                return this.getBoolean(relationType == DfaRelationValue.RelationType.IS_NOT);
            }
        }
        LongRangeSet leftRange = LongRangeSet.fromDfaValue(dfaLeft);
        LongRangeSet rightRange = LongRangeSet.fromDfaValue(dfaRight);
        if (leftRange != null && rightRange != null) {
            LongRangeSet constraint = rightRange.fromRelation(relationType);
            if (constraint != null && !constraint.intersects(leftRange)) {
                return this.getConstFactory().getFalse();
            }
            LongRangeSet revConstraint = rightRange.fromRelation(relationType.getNegated());
            if (revConstraint != null && !revConstraint.intersects(leftRange)) {
                return this.getConstFactory().getTrue();
            }
        }
        if (dfaLeft instanceof DfaConstValue && dfaRight instanceof DfaConstValue && (relationType == DfaRelationValue.RelationType.EQ || relationType == DfaRelationValue.RelationType.NE)) {
            return this.getBoolean(dfaLeft == dfaRight ^ !DfaUtil.isNaN(((DfaConstValue)dfaLeft).getValue()) ^ relationType == DfaRelationValue.RelationType.EQ);
        }
        return null;
    }

    public DfaConstValue getBoolean(boolean value2) {
        return value2 ? this.getConstFactory().getTrue() : this.getConstFactory().getFalse();
    }

    public <T> DfaValue getFactValue(@NotNull DfaFactType<T> factType, @Nullable T value2) {
        return this.getFactFactory().createValue(factType, value2);
    }

    public Collection<DfaValue> getValues() {
        return Collections.unmodifiableCollection(this.myValues);
    }

    @NotNull
    public DfaControlTransferValue controlTransfer(TransferTarget kind2, FList<Trap> traps) {
        return this.myControlTransfers.get(Pair.create((Object)kind2, traps));
    }

    @NotNull
    public DfaVariableValue.Factory getVarFactory() {
        return this.myVarFactory;
    }

    @NotNull
    public DfaConstValue.Factory getConstFactory() {
        return this.myConstFactory;
    }

    @NotNull
    public DfaBoxedValue.Factory getBoxedFactory() {
        return this.myBoxedFactory;
    }

    @NotNull
    public DfaRelationValue.Factory getRelationFactory() {
        return this.myRelationFactory;
    }

    @NotNull
    public DfaFactMapValue.Factory getFactFactory() {
        return this.myFactFactory;
    }

    @NotNull
    public DfaExpressionFactory getExpressionFactory() {
        return this.myExpressionFactory;
    }

    @NotNull
    public DfaBinOpValue.Factory getBinOpFactory() {
        return this.myBinOpFactory;
    }

    @NotNull
    public DfaValue createCommonValue(@NotNull PsiExpression[] expressions2, PsiType targetType) {
        DfaValue loopElement = null;
        for (PsiExpression expression2 : expressions2) {
            DfaValue expressionValue = this.createValue(expression2);
            if (expressionValue == null) {
                expressionValue = this.createTypeValue(expression2.getType(), NullabilityUtil.getExpressionNullability(expression2));
            }
            DfaValue dfaValue = loopElement = loopElement == null ? expressionValue : loopElement.unite(expressionValue);
            if (loopElement == DfaUnknownValue.getInstance()) break;
        }
        return loopElement == null ? DfaUnknownValue.getInstance() : DfaUtil.boxUnbox(loopElement, targetType);
    }

    private static class FieldChecker {
        private final boolean myTrustDirectFieldInitializers;
        private final boolean myTrustFieldInitializersInConstructors;
        private final boolean myCanInstantiateItself;
        private final PsiClass myClass;

        FieldChecker(PsiElement context) {
            PsiClass contextClass;
            PsiMethod method;
            PsiMethod psiMethod = method = context instanceof PsiClass ? null : (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)context, PsiMethod.class);
            this.myClass = contextClass = method != null ? method.getContainingClass() : (context instanceof PsiClass ? (PsiClass)context : null);
            if (method == null || this.myClass == null) {
                this.myCanInstantiateItself = false;
                this.myTrustFieldInitializersInConstructors = false;
                this.myTrustDirectFieldInitializers = false;
                return;
            }
            ClassInitializationInfo info = (ClassInitializationInfo)CachedValuesManager.getCachedValue((PsiElement)contextClass, () -> CachedValueProvider.Result.create((Object)new ClassInitializationInfo(contextClass), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
            this.myCanInstantiateItself = info.myCanInstantiateItself;
            if (method.hasModifierProperty("static") || method.isConstructor()) {
                this.myTrustDirectFieldInitializers = true;
                this.myTrustFieldInitializersInConstructors = false;
                return;
            }
            this.myTrustFieldInitializersInConstructors = !info.mySuperCtorsCallMethods && !info.myCtorsCallMethods;
            this.myTrustDirectFieldInitializers = !info.mySuperCtorsCallMethods;
        }

        boolean canTrustFieldInitializer(PsiField field) {
            if (field.hasInitializer()) {
                boolean staticField = field.hasModifierProperty("static");
                if (staticField && this.myClass != null && field.getContainingClass() != this.myClass) {
                    return true;
                }
                return this.myTrustDirectFieldInitializers && (!this.myCanInstantiateItself || !staticField);
            }
            return this.myTrustFieldInitializersInConstructors;
        }
    }

    private static class ClassInitializationInfo {
        final boolean myCanInstantiateItself;
        final boolean myCtorsCallMethods;
        final boolean mySuperCtorsCallMethods;

        ClassInitializationInfo(@NotNull PsiClass psiClass) {
            this.myCanInstantiateItself = ((StreamEx)StreamEx.of((Object[])psiClass.getChildren()).select(PsiMember.class).filter(member -> member.hasModifierProperty("static"))).flatMap(member -> StreamEx.ofTree((Object)member, e -> StreamEx.of((Object[])e.getChildren()))).select(PsiNewExpression.class).map(PsiNewExpression::getClassReference).nonNull().anyMatch(classRef -> classRef.isReferenceTo((PsiElement)psiClass));
            this.mySuperCtorsCallMethods = !InheritanceUtil.processSupers((PsiClass)psiClass, (boolean)false, superClass -> !ClassInitializationInfo.canCallMethodsInConstructors(superClass, true));
            this.myCtorsCallMethods = ClassInitializationInfo.canCallMethodsInConstructors(psiClass, false);
        }

        private static boolean canCallMethodsInConstructors(@NotNull PsiClass aClass, boolean virtual) {
            for (PsiMethod constructor : aClass.getConstructors()) {
                if (!constructor.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
                    return true;
                }
                PsiCodeBlock body2 = constructor.getBody();
                if (body2 == null) continue;
                for (PsiMethodCallExpression call : ((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)body2)).filter(PsiMethodCallExpression.class)) {
                    PsiReferenceExpression methodExpression = call.getMethodExpression();
                    if (methodExpression.textMatches((CharSequence)"this") || methodExpression.textMatches((CharSequence)"super")) continue;
                    if (!virtual) {
                        return true;
                    }
                    PsiMethod target = call.resolveMethod();
                    if (target == null || !PsiUtil.canBeOverridden((PsiMethod)target)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

