/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.DfaFactMap;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.value.DfaExpressionFactory;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.util.SmartList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DfaVariableValue
extends DfaValue {
    @NotNull
    private final VariableDescriptor myDescriptor;
    private final PsiType myVarType;
    @Nullable
    private final DfaVariableValue myQualifier;
    private DfaFactMap myInherentFacts;
    private final List<DfaVariableValue> myDependents = new SmartList();

    private DfaVariableValue(@NotNull VariableDescriptor descriptor, DfaValueFactory factory, @Nullable DfaVariableValue qualifier) {
        super(factory);
        this.myDescriptor = descriptor;
        this.myQualifier = qualifier;
        this.myVarType = descriptor.getType(qualifier);
    }

    @Nullable
    public PsiModifierListOwner getPsiVariable() {
        return this.myDescriptor.getPsiElement();
    }

    @NotNull
    public VariableDescriptor getDescriptor() {
        return this.myDescriptor;
    }

    @Override
    @Nullable
    public PsiType getType() {
        return this.myVarType;
    }

    @Override
    public DfaValue createNegated() {
        return this.myFactory.createCondition(this, DfaRelationValue.RelationType.EQ, this.myFactory.getBoolean(false));
    }

    @Override
    public boolean dependsOn(DfaVariableValue other) {
        return other == this || this.myQualifier != null && this.myQualifier.dependsOn(other);
    }

    @NotNull
    public List<DfaVariableValue> getDependentVariables() {
        return this.myDependents;
    }

    public int getDepth() {
        int depth = 0;
        for (DfaVariableValue qualifier = this.getQualifier(); qualifier != null; qualifier = qualifier.getQualifier()) {
            ++depth;
        }
        return depth;
    }

    @NotNull
    @Contract(pure=true)
    public DfaVariableValue withQualifier(DfaVariableValue newQualifier) {
        return newQualifier == this.myQualifier ? this : this.myFactory.getVarFactory().createVariableValue(this.myDescriptor, newQualifier);
    }

    public String toString() {
        return (this.myQualifier == null ? "" : this.myQualifier + ".") + this.myDescriptor;
    }

    @Nullable
    public DfaVariableValue getQualifier() {
        return this.myQualifier;
    }

    public DfaFactMap getInherentFacts() {
        if (this.myInherentFacts == null) {
            this.myInherentFacts = DfaFactMap.calcFromVariable(this);
        }
        return this.myInherentFacts;
    }

    @NotNull
    public Nullability getInherentNullability() {
        return DfaNullability.toNullability(this.getInherentFacts().get(DfaFactType.NULLABILITY));
    }

    public boolean isFlushableByCalls() {
        return !this.myDescriptor.isStable() || this.myQualifier != null && this.myQualifier.isFlushableByCalls();
    }

    public boolean containsCalls() {
        return this.myDescriptor.isCall() || this.myQualifier != null && this.myQualifier.containsCalls();
    }

    public static class Factory {
        private final Map<Pair<VariableDescriptor, DfaVariableValue>, DfaVariableValue> myExistingVars = new HashMap<Pair<VariableDescriptor, DfaVariableValue>, DfaVariableValue>();
        private final DfaValueFactory myFactory;

        Factory(DfaValueFactory factory) {
            this.myFactory = factory;
        }

        @NotNull
        public DfaVariableValue createVariableValue(PsiVariable variable) {
            DfaVariableValue qualifier = null;
            if (variable instanceof PsiField && !variable.hasModifierProperty("static")) {
                qualifier = this.createThisValue(((PsiField)variable).getContainingClass());
            }
            return this.createVariableValue(new DfaExpressionFactory.PlainDescriptor(variable), qualifier);
        }

        @Contract(value="null -> null; !null -> !null")
        public DfaVariableValue createThisValue(@Nullable PsiClass aClass) {
            if (aClass == null) {
                return null;
            }
            return this.createVariableValue(new DfaExpressionFactory.ThisDescriptor(aClass));
        }

        @NotNull
        public DfaVariableValue createVariableValue(@NotNull VariableDescriptor descriptor) {
            return this.createVariableValue(descriptor, null);
        }

        @NotNull
        DfaVariableValue createVariableValue(@NotNull VariableDescriptor descriptor, @Nullable DfaVariableValue qualifier) {
            Pair key2 = Pair.create((Object)descriptor, (Object)qualifier);
            DfaVariableValue var = this.myExistingVars.get(key2);
            if (var == null) {
                var = new DfaVariableValue(descriptor, this.myFactory, qualifier);
                this.myExistingVars.put((Pair<VariableDescriptor, DfaVariableValue>)key2, var);
                while (qualifier != null) {
                    qualifier.myDependents.add(var);
                    qualifier = qualifier.getQualifier();
                }
            }
            return var;
        }
    }
}

