/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deadCode;

import com.intellij.codeInspection.HTMLJavaHTMLComposer;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.DescriptorComposer;
import com.intellij.codeInspection.ex.HTMLComposerImpl;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefImplicitConstructor;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefMethodImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DeadHTMLComposer
extends HTMLComposerImpl {
    private final InspectionToolPresentation myToolPresentation;
    private final HTMLJavaHTMLComposer myComposer;

    public DeadHTMLComposer(@NotNull InspectionToolPresentation presentation) {
        this.myToolPresentation = presentation;
        this.myComposer = (HTMLJavaHTMLComposer)this.getExtension(HTMLJavaHTMLComposer.COMPOSER);
    }

    public void compose(StringBuffer buf, RefEntity refEntity) {
        this.compose(buf, refEntity, true);
    }

    public void compose(final StringBuffer buf, RefEntity refEntity, boolean toExternalHtml) {
        if (toExternalHtml) {
            this.genPageHeader(buf, refEntity);
        }
        if (refEntity instanceof RefElement) {
            RefElementImpl refElement = (RefElementImpl)refEntity;
            if (refElement.isSuspicious() && !refElement.isEntry()) {
                DeadHTMLComposer.appendHeading((StringBuffer)buf, (String)InspectionsBundle.message((String)"inspection.problem.synopsis", (Object[])new Object[0]));
                buf.append("<br>");
                buf.append("<div class=\"problem-description\">");
                DeadHTMLComposer.appendProblemSynopsis((RefElement)refElement, buf);
                buf.append("</div>");
                if (toExternalHtml) {
                    buf.append("<br><br>");
                    this.appendResolution(buf, (RefEntity)refElement, DescriptorComposer.quickFixTexts((RefEntity)refElement, (InspectionToolPresentation)this.myToolPresentation));
                }
                refElement.accept((RefVisitor)new RefJavaVisitor(){

                    public void visitClass(@NotNull RefClass aClass) {
                        DeadHTMLComposer.this.appendClassInstantiations(buf, aClass);
                        DeadHTMLComposer.this.myComposer.appendDerivedClasses(buf, aClass);
                        DeadHTMLComposer.this.myComposer.appendClassExtendsImplements(buf, aClass);
                        DeadHTMLComposer.this.myComposer.appendLibraryMethods(buf, aClass);
                        DeadHTMLComposer.this.myComposer.appendTypeReferences(buf, aClass);
                    }

                    public void visitMethod(@NotNull RefMethod method) {
                        DeadHTMLComposer.this.appendElementInReferences(buf, (RefElement)method);
                        DeadHTMLComposer.this.appendElementOutReferences(buf, (RefElement)method);
                        DeadHTMLComposer.this.myComposer.appendDerivedMethods(buf, method);
                        DeadHTMLComposer.this.myComposer.appendSuperMethods(buf, method);
                    }

                    public void visitField(@NotNull RefField field) {
                        DeadHTMLComposer.this.appendElementInReferences(buf, (RefElement)field);
                        DeadHTMLComposer.this.appendElementOutReferences(buf, (RefElement)field);
                    }
                });
            } else {
                this.appendNoProblems(buf);
            }
            this.appendCallesList((RefElement)refElement, buf, new HashSet(), true);
        }
    }

    public static void appendProblemSynopsis(RefElement refElement, final StringBuffer buf) {
        refElement.accept((RefVisitor)new RefJavaVisitor(){

            public void visitField(@NotNull RefField field) {
                if (field.isUsedForReading() && !field.isUsedForWriting()) {
                    buf.append(InspectionsBundle.message((String)"inspection.dead.code.problem.synopsis", (Object[])new Object[0]));
                    return;
                }
                if (!field.isUsedForReading() && field.isUsedForWriting()) {
                    if (field.isOnlyAssignedInInitializer()) {
                        buf.append(InspectionsBundle.message((String)"inspection.dead.code.problem.synopsis1", (Object[])new Object[0]));
                        return;
                    }
                    buf.append(InspectionsBundle.message((String)"inspection.dead.code.problem.synopsis2", (Object[])new Object[0]));
                    return;
                }
                int nUsages = field.getInReferences().size();
                if (nUsages == 0) {
                    buf.append(InspectionsBundle.message((String)"inspection.dead.code.problem.synopsis1", (Object[])new Object[0]));
                } else if (nUsages == 1) {
                    buf.append(InspectionsBundle.message((String)"inspection.dead.code.problem.synopsis3", (Object[])new Object[0]));
                } else {
                    buf.append(InspectionsBundle.message((String)"inspection.dead.code.problem.synopsis4", (Object[])new Object[]{nUsages}));
                }
            }

            public void visitClass(@NotNull RefClass refClass) {
                if (refClass.isAnonymous()) {
                    buf.append(InspectionsBundle.message((String)"inspection.dead.code.problem.synopsis10", (Object[])new Object[0]));
                } else if (refClass.isInterface() || refClass.isAbstract()) {
                    String classOrInterface = HTMLJavaHTMLComposer.getClassOrInterface((RefClass)refClass, (boolean)true);
                    buf.append("&nbsp;");
                    int nDerived = DeadHTMLComposer.getImplementationsCount(refClass);
                    if (nDerived == 0) {
                        buf.append(InspectionsBundle.message((String)"inspection.dead.code.problem.synopsis23", (Object[])new Object[]{classOrInterface}));
                    } else if (nDerived == 1) {
                        buf.append(InspectionsBundle.message((String)"inspection.dead.code.problem.synopsis24", (Object[])new Object[]{classOrInterface}));
                    } else {
                        buf.append(InspectionsBundle.message((String)"inspection.dead.code.problem.synopsis25", (Object[])new Object[]{classOrInterface, nDerived}));
                    }
                } else if (refClass.isUtilityClass()) {
                    buf.append(InspectionsBundle.message((String)"inspection.dead.code.problem.synopsis11", (Object[])new Object[0]));
                } else {
                    int nInstantiationsCount = DeadHTMLComposer.getInstantiationsCount(refClass);
                    if (nInstantiationsCount == 0) {
                        int nImplementations = DeadHTMLComposer.getImplementationsCount(refClass);
                        if (nImplementations != 0) {
                            buf.append(InspectionsBundle.message((String)"inspection.dead.code.problem.synopsis19", (Object[])new Object[]{nImplementations}));
                        } else {
                            buf.append(InspectionsBundle.message((String)"inspection.dead.code.problem.synopsis13", (Object[])new Object[0]));
                        }
                    } else if (nInstantiationsCount == 1) {
                        buf.append(InspectionsBundle.message((String)"inspection.dead.code.problem.synopsis12", (Object[])new Object[0]));
                    } else {
                        buf.append(InspectionsBundle.message((String)"inspection.dead.code.problem.synopsis20", (Object[])new Object[]{nInstantiationsCount}));
                    }
                }
            }

            public void visitMethod(@NotNull RefMethod method) {
                RefClass refClass = method.getOwnerClass();
                if (method.isExternalOverride()) {
                    String classOrInterface = HTMLJavaHTMLComposer.getClassOrInterface((RefClass)refClass, (boolean)false);
                    buf.append(InspectionsBundle.message((String)"inspection.dead.code.problem.synopsis22", (Object[])new Object[]{classOrInterface}));
                } else if (method.isStatic() || method.isConstructor()) {
                    int nRefs = method.getInReferences().size();
                    if (method.isConstructor()) {
                        if (nRefs == 0) {
                            buf.append(InspectionsBundle.message((String)"inspection.dead.code.problem.synopsis26.constructor", (Object[])new Object[0]));
                        } else if (method.isConstructor() && ((RefMethodImpl)method).isSuspiciousRecursive()) {
                            buf.append(InspectionsBundle.message((String)"inspection.dead.code.problem.synopsis27.constructor", (Object[])new Object[0]));
                        } else if (nRefs == 1) {
                            buf.append(InspectionsBundle.message((String)"inspection.dead.code.problem.synopsis28.constructor", (Object[])new Object[0]));
                        } else {
                            buf.append(InspectionsBundle.message((String)"inspection.dead.code.problem.synopsis29.constructor", (Object[])new Object[]{nRefs}));
                        }
                    } else if (nRefs == 0) {
                        buf.append(InspectionsBundle.message((String)"inspection.dead.code.problem.synopsis26.method", (Object[])new Object[0]));
                    } else if (method.isConstructor() && ((RefMethodImpl)method).isSuspiciousRecursive()) {
                        buf.append(InspectionsBundle.message((String)"inspection.dead.code.problem.synopsis27.method", (Object[])new Object[0]));
                    } else if (nRefs == 1) {
                        buf.append(InspectionsBundle.message((String)"inspection.dead.code.problem.synopsis28.method", (Object[])new Object[0]));
                    } else {
                        buf.append(InspectionsBundle.message((String)"inspection.dead.code.problem.synopsis29.method", (Object[])new Object[]{nRefs}));
                    }
                } else if (refClass instanceof RefClassImpl && ((RefClassImpl)refClass).isSuspicious()) {
                    if (method.isAbstract()) {
                        buf.append(InspectionsBundle.message((String)"inspection.dead.code.problem.synopsis14", (Object[])new Object[0]));
                    } else {
                        buf.append(InspectionsBundle.message((String)"inspection.dead.code.problem.synopsis15", (Object[])new Object[0]));
                    }
                } else {
                    int nOwnRefs = method.getInReferences().size();
                    int nSuperRefs = DeadHTMLComposer.getSuperRefsCount(method);
                    int nDerivedRefs = DeadHTMLComposer.getDerivedRefsCount(method);
                    if (nOwnRefs == 0 && nSuperRefs == 0 && nDerivedRefs == 0) {
                        buf.append(InspectionsBundle.message((String)"inspection.dead.code.problem.synopsis16", (Object[])new Object[0]));
                    } else if (nDerivedRefs > 0 && nSuperRefs == 0 && nOwnRefs == 0) {
                        String classOrInterface = refClass == null ? "" : HTMLJavaHTMLComposer.getClassOrInterface((RefClass)refClass, (boolean)false);
                        buf.append(InspectionsBundle.message((String)"inspection.dead.code.problem.synopsis21", (Object[])new Object[]{classOrInterface}));
                    } else if (((RefMethodImpl)method).isSuspiciousRecursive()) {
                        buf.append(InspectionsBundle.message((String)"inspection.dead.code.problem.synopsis17", (Object[])new Object[0]));
                    } else {
                        buf.append(InspectionsBundle.message((String)"inspection.dead.code.problem.synopsis18", (Object[])new Object[0]));
                    }
                }
            }
        });
    }

    protected void appendAdditionalListItemInfo(StringBuffer buf, RefElement refElement) {
        if (refElement instanceof RefImplicitConstructor) {
            refElement = ((RefImplicitConstructor)refElement).getOwnerClass();
        }
        buf.append("<br>");
        if (refElement instanceof RefClass) {
            RefClassImpl refClass = (RefClassImpl)refElement;
            if (refClass.isSuspicious()) {
                if (!refClass.isUtilityClass()) {
                    if (refClass.isAnonymous()) {
                        buf.append(InspectionsBundle.message((String)"inspection.dead.code.problem.synopsis9.suspicious", (Object[])new Object[]{DeadHTMLComposer.getInstantiationsCount(refClass)}));
                    } else if (refClass.isInterface() || refClass.isAbstract()) {
                        buf.append(InspectionsBundle.message((String)"inspection.dead.code.problem.synopsis8.suspicious", (Object[])new Object[]{DeadHTMLComposer.getInstantiationsCount(refClass)}));
                    } else {
                        buf.append(InspectionsBundle.message((String)"inspection.dead.code.problem.synopsis7.suspicious", (Object[])new Object[]{DeadHTMLComposer.getInstantiationsCount(refClass)}));
                    }
                }
            } else if (!refClass.isUtilityClass()) {
                if (refClass.isAnonymous()) {
                    buf.append(InspectionsBundle.message((String)"inspection.dead.code.problem.synopsis9", (Object[])new Object[]{DeadHTMLComposer.getInstantiationsCount(refClass)}));
                } else if (refClass.isInterface() || refClass.isAbstract()) {
                    buf.append(InspectionsBundle.message((String)"inspection.dead.code.problem.synopsis8", (Object[])new Object[]{DeadHTMLComposer.getInstantiationsCount(refClass)}));
                } else {
                    buf.append(InspectionsBundle.message((String)"inspection.dead.code.problem.synopsis7", (Object[])new Object[]{DeadHTMLComposer.getInstantiationsCount(refClass)}));
                }
            }
        } else {
            int nUsageCount = refElement.getInReferences().size();
            if (refElement instanceof RefMethod) {
                nUsageCount += DeadHTMLComposer.getDerivedRefsCount((RefMethod)refElement);
            }
            if (((RefElementImpl)refElement).isSuspicious()) {
                buf.append(InspectionsBundle.message((String)"inspection.dead.code.problem.synopsis6.suspicious", (Object[])new Object[]{nUsageCount}));
            } else {
                buf.append(InspectionsBundle.message((String)"inspection.dead.code.problem.synopsis6", (Object[])new Object[]{nUsageCount}));
            }
        }
    }

    private static int getDerivedRefsCount(RefMethod refMethod) {
        int count = 0;
        for (RefMethod refDerived : refMethod.getDerivedMethods()) {
            count += refDerived.getInReferences().size() + DeadHTMLComposer.getDerivedRefsCount(refDerived);
        }
        return count;
    }

    private static int getSuperRefsCount(RefMethod refMethod) {
        int count = 0;
        for (RefMethod refSuper : refMethod.getSuperMethods()) {
            count += refSuper.getInReferences().size() + DeadHTMLComposer.getSuperRefsCount(refSuper);
        }
        return count;
    }

    private static int getInstantiationsCount(RefClass aClass) {
        if (!aClass.isAnonymous()) {
            int count = 0;
            for (RefMethod refConstructor : aClass.getConstructors()) {
                count += refConstructor.getInReferences().size();
            }
            for (RefClass subClass : aClass.getSubClasses()) {
                count += DeadHTMLComposer.getInstantiationsCount(subClass);
                count -= subClass.getConstructors().size();
            }
            return count;
        }
        return 1;
    }

    private static int getImplementationsCount(RefClass refClass) {
        int count = 0;
        for (RefClass subClass : refClass.getSubClasses()) {
            if (!subClass.isInterface() && !subClass.isAbstract()) {
                ++count;
            }
            count += DeadHTMLComposer.getImplementationsCount(subClass);
        }
        return count;
    }

    private void appendClassInstantiations(StringBuffer buf, RefClass refClass) {
        if (!(refClass.isInterface() || refClass.isAbstract() || refClass.isUtilityClass())) {
            boolean found = false;
            DeadHTMLComposer.appendHeading((StringBuffer)buf, (String)InspectionsBundle.message((String)"inspection.dead.code.export.results.instantiated.from.heading", (Object[])new Object[0]));
            this.startList(buf);
            for (RefMethod refMethod : refClass.getConstructors()) {
                for (RefElement refCaller : refMethod.getInReferences()) {
                    this.appendListItem(buf, refCaller);
                    found = true;
                }
            }
            if (!found) {
                this.startListItem(buf);
                buf.append(InspectionsBundle.message((String)"inspection.dead.code.export.results.no.instantiations.found", (Object[])new Object[0]));
                DeadHTMLComposer.doneListItem((StringBuffer)buf);
            }
            this.doneList(buf);
        }
    }

    private void appendCallesList(RefElement element, StringBuffer buf, Set<? super RefElement> mentionedElements, boolean appendCallees) {
        Set<RefElement> possibleChildren = DeadHTMLComposer.getPossibleChildren(element);
        if (!possibleChildren.isEmpty()) {
            if (appendCallees) {
                DeadHTMLComposer.appendHeading((StringBuffer)buf, (String)InspectionsBundle.message((String)"inspection.export.results.callees", (Object[])new Object[0]));
                buf.append("<div class=\"problem-description\">");
            }
            String ul = "<ul>";
            buf.append("<ul>");
            for (RefElement refElement : possibleChildren) {
                if (mentionedElements.contains(refElement)) continue;
                mentionedElements.add((RefElement)refElement);
                String li = "<li>";
                buf.append("<li>");
                this.appendElementReference(buf, refElement, true);
                String closeLi = "</li>";
                buf.append("</li>");
                this.appendCallesList(refElement, buf, mentionedElements, false);
            }
            String closeUl = "</ul>";
            buf.append("</ul>");
            if (appendCallees) {
                buf.append("</div>");
            }
        }
    }

    private static Set<RefElement> getPossibleChildren(RefElement refElement) {
        if (!refElement.isValid()) {
            return Collections.emptySet();
        }
        HashSet<RefElement> newChildren = new HashSet<RefElement>();
        for (RefElement refCallee : refElement.getOutReferences()) {
            if (!((RefElementImpl)refCallee).isSuspicious()) continue;
            newChildren.add(refCallee);
        }
        if (refElement instanceof RefMethod) {
            RefMethod refMethod = (RefMethod)refElement;
            RefClass aClass = refMethod.getOwnerClass();
            if (!(refMethod.isStatic() || refMethod.isConstructor() || aClass == null || aClass.isAnonymous())) {
                for (RefMethod refDerived : refMethod.getDerivedMethods()) {
                    if (!((RefMethodImpl)refDerived).isSuspicious()) continue;
                    newChildren.add((RefElement)refDerived);
                }
            }
        } else if (refElement instanceof RefClass) {
            RefClass refClass = (RefClass)refElement;
            for (RefClass subClass : refClass.getSubClasses()) {
                if (!subClass.isInterface() && !subClass.isAbstract() || !((RefClassImpl)subClass).isSuspicious()) continue;
                newChildren.add((RefElement)subClass);
            }
            if (refClass.getDefaultConstructor() instanceof RefImplicitConstructor) {
                Set<RefElement> fromConstructor = DeadHTMLComposer.getPossibleChildren((RefElement)refClass.getDefaultConstructor());
                newChildren.addAll(fromConstructor);
            }
        }
        return newChildren;
    }
}

