/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deadCode;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.deadCode.RefUnreachableFilter;
import com.intellij.codeInspection.deadCode.UnreferencedFilter;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.JobDescriptor;
import com.intellij.codeInspection.reference.EntryPoint;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefImplicitConstructor;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaElementImpl;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefUtil;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.unusedSymbol.UnusedSymbolLocalInspectionBase;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclarationKt;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UastVisibility;

public class UnusedDeclarationInspectionBase
extends GlobalInspectionTool {
    private static final Logger LOG = Logger.getInstance(UnusedDeclarationInspectionBase.class);
    public boolean ADD_MAINS_TO_ENTRIES = true;
    public boolean ADD_APPLET_TO_ENTRIES = true;
    public boolean ADD_SERVLET_TO_ENTRIES = true;
    public boolean ADD_NONJAVA_TO_ENTRIES = true;
    private boolean TEST_ENTRY_POINTS = true;
    public static final String DISPLAY_NAME = InspectionsBundle.message((String)"inspection.dead.code.display.name", (Object[])new Object[0]);
    public static final String SHORT_NAME = "unused";
    public static final String ALTERNATIVE_ID = "UnusedDeclaration";
    final List<EntryPoint> myExtensions = ContainerUtil.createLockFreeCopyOnWriteList();
    final UnusedSymbolLocalInspectionBase myLocalInspectionBase = this.createUnusedSymbolLocalInspection();
    private static final Key<Set<RefElement>> PROCESSED_SUSPICIOUS_ELEMENTS_KEY = Key.create((String)"java.unused.declaration.processed.suspicious.elements");
    private static final Key<Integer> PHASE_KEY = Key.create((String)"java.unused.declaration.phase");
    private final boolean myEnabledInEditor;

    public UnusedDeclarationInspectionBase() {
        this(!ApplicationManager.getApplication().isUnitTestMode());
    }

    public UnusedDeclarationInspectionBase(boolean enabledInEditor) {
        ExtensionPoint point = Extensions.getRootArea().getExtensionPoint("com.intellij.deadCode");
        EntryPoint[] extensions = (EntryPoint[])point.getExtensions();
        ArrayList<EntryPoint> deadCodeAddIns = new ArrayList<EntryPoint>(extensions.length);
        for (EntryPoint entryPoint : extensions) {
            try {
                deadCodeAddIns.add(entryPoint.clone());
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        Collections.sort(deadCodeAddIns, (o1, o2) -> o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName()));
        this.myExtensions.addAll(deadCodeAddIns);
        this.myEnabledInEditor = enabledInEditor;
    }

    protected UnusedSymbolLocalInspectionBase createUnusedSymbolLocalInspection() {
        return new UnusedSymbolLocalInspectionBase();
    }

    @NotNull
    public UnusedSymbolLocalInspectionBase getSharedLocalInspectionTool() {
        return this.myLocalInspectionBase;
    }

    private boolean isAddMainsEnabled() {
        return this.ADD_MAINS_TO_ENTRIES;
    }

    private boolean isAddAppletEnabled() {
        return this.ADD_APPLET_TO_ENTRIES;
    }

    private boolean isAddServletEnabled() {
        return this.ADD_SERVLET_TO_ENTRIES;
    }

    private boolean isAddNonJavaUsedEnabled() {
        return this.ADD_NONJAVA_TO_ENTRIES;
    }

    public boolean isTestEntryPoints() {
        return this.TEST_ENTRY_POINTS;
    }

    public void setTestEntryPoints(boolean testEntryPoints) {
        this.TEST_ENTRY_POINTS = testEntryPoints;
    }

    @NotNull
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @NotNull
    public String getGroupDisplayName() {
        return GroupNames.DECLARATION_REDUNDANCY;
    }

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        super.readSettings(node);
        this.myLocalInspectionBase.readSettings(node);
        for (EntryPoint extension : this.myExtensions) {
            extension.readExternal(node);
        }
        String testEntriesAttr = node.getAttributeValue("test_entries");
        this.TEST_ENTRY_POINTS = testEntriesAttr == null || Boolean.parseBoolean(testEntriesAttr);
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        this.myLocalInspectionBase.writeSettings(node);
        this.writeUnusedDeclarationSettings(node);
        if (!this.TEST_ENTRY_POINTS) {
            node.setAttribute("test_entries", Boolean.toString(false));
        }
    }

    protected void writeUnusedDeclarationSettings(Element node) throws WriteExternalException {
        super.writeSettings(node);
        for (EntryPoint extension : this.myExtensions) {
            extension.writeExternal(node);
        }
    }

    private static boolean isExternalizableNoParameterConstructor(@NotNull UMethod method, RefClass refClass) {
        if (!method.isConstructor()) {
            return false;
        }
        if (method.getVisibility() != UastVisibility.PUBLIC) {
            return false;
        }
        List parameterList = method.getUastParameters();
        if (!parameterList.isEmpty()) {
            return false;
        }
        UClass aClass = (UClass)UDeclarationKt.getContainingDeclaration((UElement)method, UClass.class);
        return aClass == null || UnusedDeclarationInspectionBase.isExternalizable(aClass, refClass);
    }

    private static boolean isSerializationImplicitlyUsedField(@NotNull UField field) {
        String name = field.getName();
        if (!"serialVersionUID".equals(name) && !"serialPersistentFields".equals(name)) {
            return false;
        }
        if (!field.isStatic()) {
            return false;
        }
        UClass aClass = (UClass)UDeclarationKt.getContainingDeclaration((UElement)field, UClass.class);
        return aClass == null || UnusedDeclarationInspectionBase.isSerializable(aClass, null);
    }

    private static boolean isWriteObjectMethod(@NotNull UMethod method, RefClass refClass) {
        String name = method.getName();
        if (!"writeObject".equals(name)) {
            return false;
        }
        List parameters2 = method.getUastParameters();
        if (parameters2.size() != 1) {
            return false;
        }
        if (!UnusedDeclarationInspectionBase.equalsToText(((UParameter)parameters2.get(0)).getType(), "java.io.ObjectOutputStream")) {
            return false;
        }
        if (method.isStatic()) {
            return false;
        }
        UClass aClass = (UClass)UDeclarationKt.getContainingDeclaration((UElement)method, UClass.class);
        return aClass == null || UnusedDeclarationInspectionBase.isSerializable(aClass, refClass);
    }

    private static boolean isReadObjectMethod(@NotNull UMethod method, RefClass refClass) {
        String name = method.getName();
        if (!"readObject".equals(name)) {
            return false;
        }
        List parameters2 = method.getUastParameters();
        if (parameters2.size() != 1) {
            return false;
        }
        if (!UnusedDeclarationInspectionBase.equalsToText(((UParameter)parameters2.get(0)).getType(), "java.io.ObjectInputStream")) {
            return false;
        }
        if (method.isStatic()) {
            return false;
        }
        UClass aClass = (UClass)UDeclarationKt.getContainingDeclaration((UElement)method, UClass.class);
        return aClass == null || UnusedDeclarationInspectionBase.isSerializable(aClass, refClass);
    }

    private static boolean isWriteReplaceMethod(@NotNull UMethod method, RefClass refClass) {
        String name = method.getName();
        if (!"writeReplace".equals(name)) {
            return false;
        }
        List parameters2 = method.getUastParameters();
        if (parameters2.size() != 0) {
            return false;
        }
        if (!UnusedDeclarationInspectionBase.equalsToText(method.getReturnType(), "java.lang.Object")) {
            return false;
        }
        if (method.isStatic()) {
            return false;
        }
        UClass aClass = (UClass)UDeclarationKt.getContainingDeclaration((UElement)method, UClass.class);
        return aClass == null || UnusedDeclarationInspectionBase.isSerializable(aClass, refClass);
    }

    private static boolean isReadResolveMethod(@NotNull UMethod method, RefClass refClass) {
        String name = method.getName();
        if (!"readResolve".equals(name)) {
            return false;
        }
        List parameters2 = method.getUastParameters();
        if (parameters2.size() != 0) {
            return false;
        }
        if (!UnusedDeclarationInspectionBase.equalsToText(method.getReturnType(), "java.lang.Object")) {
            return false;
        }
        if (method.isStatic()) {
            return false;
        }
        UClass aClass = (UClass)UDeclarationKt.getContainingDeclaration((UElement)method, UClass.class);
        return aClass == null || UnusedDeclarationInspectionBase.isSerializable(aClass, refClass);
    }

    private static boolean equalsToText(PsiType type2, String text2) {
        return type2 != null && type2.equalsToText(text2);
    }

    private static boolean isSerializable(UClass aClass, @Nullable RefClass refClass) {
        PsiClass psi = aClass.getPsi();
        PsiClass serializableClass = JavaPsiFacade.getInstance((Project)psi.getProject()).findClass("java.io.Serializable", psi.getResolveScope());
        return serializableClass != null && UnusedDeclarationInspectionBase.isSerializable(aClass, refClass, serializableClass);
    }

    private static boolean isExternalizable(@NotNull UClass aClass, RefClass refClass) {
        PsiClass psi = aClass.getPsi();
        PsiClass externalizableClass = JavaPsiFacade.getInstance((Project)psi.getProject()).findClass("java.io.Externalizable", psi.getResolveScope());
        return externalizableClass != null && UnusedDeclarationInspectionBase.isSerializable(aClass, refClass, externalizableClass);
    }

    private static boolean isSerializable(UClass aClass, RefClass refClass, PsiClass serializableClass) {
        if (aClass == null) {
            return false;
        }
        if (aClass.getJavaPsi().isInheritor(serializableClass, true)) {
            return true;
        }
        if (refClass != null) {
            Set subClasses = refClass.getSubClasses();
            for (RefClass subClass : subClasses) {
                if (!UnusedDeclarationInspectionBase.isSerializable(subClass.getUastElement(), subClass, serializableClass)) continue;
                return true;
            }
        }
        return false;
    }

    public void runInspection(final @NotNull AnalysisScope scope, @NotNull InspectionManager manager, final @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        globalContext.getRefManager().iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(@NotNull RefEntity refEntity) {
                if (refEntity instanceof RefElementImpl) {
                    RefElementImpl refElement = (RefElementImpl)refEntity;
                    if (!refElement.isSuspicious()) {
                        return;
                    }
                    PsiFile file = refElement.getContainingFile();
                    if (file == null) {
                        return;
                    }
                    boolean isSuppressed = refElement.isSuppressed(new String[]{UnusedDeclarationInspectionBase.this.getShortName(), UnusedDeclarationInspectionBase.ALTERNATIVE_ID});
                    if (!(!isSuppressed && ((GlobalInspectionContextBase)globalContext).isToCheckFile(file, (InspectionProfileEntry)UnusedDeclarationInspectionBase.this) || !isSuppressed && scope.contains((PsiElement)file))) {
                        UnusedDeclarationInspectionBase.getEntryPointsManager(globalContext).addEntryPoint((RefElement)refElement, false);
                    }
                }
            }
        });
        globalContext.putUserData(PHASE_KEY, (Object)1);
        globalContext.putUserData(PROCESSED_SUSPICIOUS_ELEMENTS_KEY, new HashSet());
    }

    public boolean isEntryPoint(@NotNull RefElement owner) {
        EntryPointsManager entryPointsManager;
        UElement uElement;
        PsiElement element = owner.getPsiElement();
        if (owner instanceof RefJavaElement && (uElement = ((RefJavaElement)owner).getUastElement()) != null) {
            element = uElement.getJavaPsi();
        }
        if (RefUtil.isImplicitUsage((PsiElement)element)) {
            return true;
        }
        if (element instanceof PsiModifierListOwner && (entryPointsManager = EntryPointsManager.getInstance((Project)element.getProject())).isEntryPoint(element)) {
            return true;
        }
        if (element != null) {
            for (EntryPoint extension : this.myExtensions) {
                if (!extension.isSelected() || !extension.isEntryPoint(owner, element)) continue;
                return true;
            }
            if (this.isAddMainsEnabled() && owner instanceof RefMethod && ((RefMethod)owner).isAppMain()) {
                return true;
            }
            if (owner instanceof RefClass && (this.isAddAppletEnabled() && ((RefClass)owner).isApplet() || this.isAddServletEnabled() && ((RefClass)owner).isServlet())) {
                return true;
            }
        }
        return false;
    }

    public boolean isEntryPoint(@NotNull PsiElement element) {
        EntryPointsManager entryPointsManager;
        Project project = element.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        if (element instanceof PsiMethod && this.isAddMainsEnabled() && PsiClassImplUtil.isMainOrPremainMethod((PsiMethod)element)) {
            return true;
        }
        if (element instanceof PsiClass) {
            PsiClass aClass = (PsiClass)element;
            PsiClass applet = psiFacade.findClass("java.applet.Applet", GlobalSearchScope.allScope((Project)project));
            if (this.isAddAppletEnabled() && applet != null && aClass.isInheritor(applet, true)) {
                return true;
            }
            PsiClass servlet = psiFacade.findClass("javax.servlet.Servlet", GlobalSearchScope.allScope((Project)project));
            if (this.isAddServletEnabled() && servlet != null && aClass.isInheritor(servlet, true)) {
                return true;
            }
            if (this.isAddMainsEnabled() && UnusedDeclarationInspectionBase.hasMainMethodDeep(aClass)) {
                return true;
            }
        }
        if (element instanceof PsiModifierListOwner && (entryPointsManager = EntryPointsManager.getInstance((Project)project)).isEntryPoint(element)) {
            return true;
        }
        for (EntryPoint extension : this.myExtensions) {
            if (!extension.isSelected() || !extension.isEntryPoint(element)) continue;
            return true;
        }
        return RefUtil.isImplicitUsage((PsiElement)element);
    }

    private static boolean hasMainMethodDeep(PsiClass aClass) {
        if (PsiMethodUtil.hasMainMethod((PsiClass)aClass)) {
            return true;
        }
        for (PsiClass innerClass : aClass.getInnerClasses()) {
            if (!innerClass.hasModifierProperty("static") || !PsiMethodUtil.hasMainMethod((PsiClass)innerClass)) continue;
            return true;
        }
        return false;
    }

    public boolean isGlobalEnabledInEditor() {
        return this.myEnabledInEditor;
    }

    @NotNull
    public static UnusedDeclarationInspectionBase findUnusedDeclarationInspection(@NotNull PsiElement element) {
        InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)element.getProject()).getCurrentProfile();
        UnusedDeclarationInspectionBase tool = (UnusedDeclarationInspectionBase)profile.getUnwrappedTool(SHORT_NAME, element);
        return tool == null ? new UnusedDeclarationInspectionBase() : tool;
    }

    public static boolean isDeclaredAsEntryPoint(@NotNull PsiElement method) {
        return UnusedDeclarationInspectionBase.findUnusedDeclarationInspection(method).isEntryPoint(method);
    }

    public boolean queryExternalUsagesRequests(@NotNull InspectionManager manager, final @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        this.checkForReachableRefs(globalContext);
        int phase = (Integer)Objects.requireNonNull(globalContext.getUserData(PHASE_KEY));
        final Set processedSuspicious = (Set)globalContext.getUserData(PROCESSED_SUSPICIOUS_ELEMENTS_KEY);
        final boolean firstPhase = phase == 1;
        final RefUnreachableFilter filter = firstPhase ? new StrictUnreferencedFilter(this, globalContext) : new RefUnreachableFilter(this, globalContext);
        LOG.assertTrue(processedSuspicious != null, (Object)("phase: " + phase));
        final boolean[] requestAdded = new boolean[]{false};
        globalContext.getRefManager().iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(@NotNull RefEntity refEntity) {
                if (!(refEntity instanceof RefJavaElement)) {
                    return;
                }
                if (refEntity instanceof RefClass && ((RefClass)refEntity).isAnonymous()) {
                    return;
                }
                final RefJavaElement refElement = (RefJavaElement)refEntity;
                if (filter.accepts(refElement) && !processedSuspicious.contains(refElement)) {
                    refEntity.accept((RefVisitor)new RefJavaVisitor(){

                        public void visitField(@NotNull RefField refField) {
                            processedSuspicious.add(refField);
                            UField uField = refField.getUastElement();
                            if (uField != null && UnusedDeclarationInspectionBase.isSerializationImplicitlyUsedField(uField)) {
                                UnusedDeclarationInspectionBase.getEntryPointsManager(globalContext).addEntryPoint((RefElement)refField, false);
                            } else {
                                ((GlobalJavaInspectionContext)globalContext.getExtension(GlobalJavaInspectionContext.CONTEXT)).enqueueFieldUsagesProcessor(refField, psiReference -> {
                                    UnusedDeclarationInspectionBase.getEntryPointsManager(globalContext).addEntryPoint((RefElement)refField, false);
                                    return false;
                                });
                                requestAdded[0] = true;
                            }
                        }

                        public void visitMethod(@NotNull RefMethod refMethod) {
                            UMethod uMethod;
                            processedSuspicious.add(refMethod);
                            if (refMethod instanceof RefImplicitConstructor) {
                                RefClass ownerClass = refMethod.getOwnerClass();
                                LOG.assertTrue(ownerClass != null);
                                this.visitClass(ownerClass);
                                return;
                            }
                            if (refMethod.isConstructor()) {
                                RefClass ownerClass = refMethod.getOwnerClass();
                                LOG.assertTrue(ownerClass != null);
                                this.queryQualifiedNameUsages(ownerClass);
                            }
                            if ((uMethod = (UMethod)refMethod.getUastElement()) != null && UnusedDeclarationInspectionBase.isSerializablePatternMethod(uMethod, refMethod.getOwnerClass())) {
                                UnusedDeclarationInspectionBase.getEntryPointsManager(globalContext).addEntryPoint((RefElement)refMethod, false);
                            } else if (!refMethod.isExternalOverride() && !"private".equals(refMethod.getAccessModifier())) {
                                processedSuspicious.addAll(refMethod.getDerivedMethods());
                                UnusedDeclarationInspectionBase.enqueueMethodUsages(globalContext, refMethod);
                                requestAdded[0] = true;
                            }
                        }

                        public void visitClass(@NotNull RefClass refClass) {
                            processedSuspicious.add(refClass);
                            if (!refClass.isAnonymous()) {
                                ((GlobalJavaInspectionContext)globalContext.getExtension(GlobalJavaInspectionContext.CONTEXT)).enqueueDerivedClassesProcessor(refClass, inheritor -> {
                                    UnusedDeclarationInspectionBase.getEntryPointsManager(globalContext).addEntryPoint((RefElement)refClass, false);
                                    return false;
                                });
                                ((GlobalJavaInspectionContext)globalContext.getExtension(GlobalJavaInspectionContext.CONTEXT)).enqueueClassUsagesProcessor(refClass, psiReference -> {
                                    UnusedDeclarationInspectionBase.getEntryPointsManager(globalContext).addEntryPoint((RefElement)refClass, false);
                                    return false;
                                });
                                this.queryQualifiedNameUsages(refClass);
                                requestAdded[0] = true;
                            }
                        }

                        public void queryQualifiedNameUsages(@NotNull RefClass refClass) {
                            if (firstPhase && UnusedDeclarationInspectionBase.this.isAddNonJavaUsedEnabled()) {
                                ((GlobalJavaInspectionContext)globalContext.getExtension(GlobalJavaInspectionContext.CONTEXT)).enqueueQualifiedNameOccurrencesProcessor(refClass, () -> {
                                    EntryPointsManager entryPointsManager = UnusedDeclarationInspectionBase.getEntryPointsManager(globalContext);
                                    entryPointsManager.addEntryPoint((RefElement)refClass, false);
                                    for (RefMethod constructor : refClass.getConstructors()) {
                                        entryPointsManager.addEntryPoint((RefElement)constructor, false);
                                    }
                                });
                                for (RefElement element : refClass.getInReferences()) {
                                    if (element instanceof RefJavaElement) continue;
                                    UnusedDeclarationInspectionBase.getEntryPointsManager(globalContext).addEntryPoint((RefElement)refElement, false);
                                }
                                requestAdded[0] = true;
                            }
                        }
                    });
                }
            }
        });
        if (!requestAdded[0]) {
            if (phase == 2) {
                globalContext.putUserData(PROCESSED_SUSPICIOUS_ELEMENTS_KEY, null);
                return false;
            }
            globalContext.putUserData(PHASE_KEY, (Object)2);
        }
        return true;
    }

    private static boolean isSerializablePatternMethod(@NotNull UMethod psiMethod, RefClass refClass) {
        return UnusedDeclarationInspectionBase.isReadObjectMethod(psiMethod, refClass) || UnusedDeclarationInspectionBase.isWriteObjectMethod(psiMethod, refClass) || UnusedDeclarationInspectionBase.isReadResolveMethod(psiMethod, refClass) || UnusedDeclarationInspectionBase.isWriteReplaceMethod(psiMethod, refClass) || UnusedDeclarationInspectionBase.isExternalizableNoParameterConstructor(psiMethod, refClass);
    }

    private static void enqueueMethodUsages(GlobalInspectionContext globalContext, RefMethod refMethod) {
        if (refMethod.getSuperMethods().isEmpty()) {
            ((GlobalJavaInspectionContext)globalContext.getExtension(GlobalJavaInspectionContext.CONTEXT)).enqueueMethodUsagesProcessor(refMethod, psiReference -> {
                UnusedDeclarationInspectionBase.getEntryPointsManager(globalContext).addEntryPoint((RefElement)refMethod, false);
                return false;
            });
        } else {
            for (RefMethod refSuper : refMethod.getSuperMethods()) {
                UnusedDeclarationInspectionBase.enqueueMethodUsages(globalContext, refSuper);
            }
        }
    }

    @Nullable
    public JobDescriptor[] getAdditionalJobs(GlobalInspectionContext context) {
        return new JobDescriptor[]{context.getStdJobDescriptors().BUILD_GRAPH, context.getStdJobDescriptors().FIND_EXTERNAL_USAGES};
    }

    void checkForReachableRefs(final @NotNull GlobalInspectionContext context) {
        CodeScanner codeScanner = new CodeScanner();
        RefManager refManager = context.getRefManager();
        refManager.iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(@NotNull RefEntity refEntity) {
                if (refEntity instanceof RefJavaElementImpl) {
                    RefJavaElementImpl refElement = (RefJavaElementImpl)refEntity;
                    if (!((GlobalInspectionContextBase)context).isToCheckMember((RefElement)refElement, (InspectionProfileEntry)UnusedDeclarationInspectionBase.this)) {
                        return;
                    }
                    refElement.setReachable(false);
                }
            }
        });
        for (RefElement entry : UnusedDeclarationInspectionBase.getEntryPointsManager(context).getEntryPoints(refManager)) {
            entry.accept((RefVisitor)codeScanner);
        }
        while (codeScanner.newlyInstantiatedClassesCount() != 0) {
            codeScanner.cleanInstantiatedClassesCount();
            codeScanner.processDelayedMethods();
        }
    }

    private static EntryPointsManager getEntryPointsManager(GlobalInspectionContext context) {
        return ((GlobalJavaInspectionContext)context.getExtension(GlobalJavaInspectionContext.CONTEXT)).getEntryPointsManager(context.getRefManager());
    }

    public List<EntryPoint> getExtensions() {
        return this.myExtensions;
    }

    private static class CodeScanner
    extends RefJavaVisitor {
        private final Map<RefClass, Set<RefMethod>> myClassIDtoMethods = new HashMap<RefClass, Set<RefMethod>>();
        private final Set<RefClass> myInstantiatedClasses = new HashSet<RefClass>();
        private int myInstantiatedClassesCount;
        private final Set<RefMethod> myProcessedMethods = new HashSet<RefMethod>();

        private CodeScanner() {
        }

        public void visitMethod(@NotNull RefMethod method) {
            if (!this.myProcessedMethods.contains(method)) {
                if (method.isStatic() || method.isConstructor() || method.isEntry()) {
                    if (method.isStatic()) {
                        ((RefElementImpl)method.getOwner()).setReachable(true);
                    } else {
                        this.addInstantiatedClass(method.getOwnerClass());
                    }
                    this.myProcessedMethods.add(method);
                    this.makeContentReachable((RefJavaElementImpl)method);
                    this.makeClassInitializersReachable(method.getOwnerClass());
                } else {
                    if (this.isClassInstantiated(method.getOwnerClass())) {
                        this.myProcessedMethods.add(method);
                        this.makeContentReachable((RefJavaElementImpl)method);
                    } else {
                        this.addDelayedMethod(method);
                    }
                    for (RefMethod refSub : method.getDerivedMethods()) {
                        this.visitMethod(refSub);
                    }
                }
            }
        }

        public void visitClass(@NotNull RefClass refClass) {
            boolean alreadyActive = refClass.isReachable();
            ((RefClassImpl)refClass).setReachable(true);
            if (!alreadyActive) {
                this.makeClassInitializersReachable(refClass);
            }
            this.addInstantiatedClass(refClass);
        }

        public void visitField(@NotNull RefField field) {
            if (!field.isReachable()) {
                this.makeContentReachable((RefJavaElementImpl)field);
                this.makeClassInitializersReachable(field.getOwnerClass());
            }
        }

        private void addInstantiatedClass(RefClass refClass) {
            if (this.myInstantiatedClasses.add(refClass)) {
                ((RefClassImpl)refClass).setReachable(true);
                ++this.myInstantiatedClassesCount;
                List refMethods = refClass.getLibraryMethods();
                for (RefMethod refMethod : refMethods) {
                    refMethod.accept((RefVisitor)this);
                }
                for (RefClass baseClass : refClass.getBaseClasses()) {
                    this.addInstantiatedClass(baseClass);
                }
            }
        }

        private void makeContentReachable(RefJavaElementImpl refElement) {
            refElement.setReachable(true);
            for (RefElement refCallee : refElement.getOutReferences()) {
                refCallee.accept((RefVisitor)this);
            }
        }

        private void makeClassInitializersReachable(@Nullable RefClass refClass) {
            if (refClass != null) {
                for (RefElement refCallee : refClass.getOutReferences()) {
                    refCallee.accept((RefVisitor)this);
                }
            }
        }

        private void addDelayedMethod(RefMethod refMethod) {
            Set<RefMethod> methods = this.myClassIDtoMethods.get(refMethod.getOwnerClass());
            if (methods == null) {
                methods = new HashSet<RefMethod>();
                this.myClassIDtoMethods.put(refMethod.getOwnerClass(), methods);
            }
            methods.add(refMethod);
        }

        private boolean isClassInstantiated(RefClass refClass) {
            return refClass == null || refClass.isUtilityClass() || this.myInstantiatedClasses.contains(refClass);
        }

        private int newlyInstantiatedClassesCount() {
            return this.myInstantiatedClassesCount;
        }

        private void cleanInstantiatedClassesCount() {
            this.myInstantiatedClassesCount = 0;
        }

        private void processDelayedMethods() {
            RefClass[] instClasses;
            for (RefClass refClass : instClasses = this.myInstantiatedClasses.toArray(new RefClass[0])) {
                RefMethod[] arMethods;
                Set<RefMethod> methods;
                if (!this.isClassInstantiated(refClass) || (methods = this.myClassIDtoMethods.get(refClass)) == null) continue;
                for (RefMethod arMethod : arMethods = methods.toArray(new RefMethod[0])) {
                    arMethod.accept((RefVisitor)this);
                }
            }
        }
    }

    private static class StrictUnreferencedFilter
    extends UnreferencedFilter {
        private StrictUnreferencedFilter(@NotNull UnusedDeclarationInspectionBase tool, @NotNull GlobalInspectionContext context) {
            super(tool, context);
        }

        @Override
        public int getElementProblemCount(@NotNull RefJavaElement refElement) {
            int problemCount = super.getElementProblemCount(refElement);
            if (problemCount > -1) {
                return problemCount;
            }
            return refElement.isReferenced() ? 0 : 1;
        }
    }
}

