/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deadCode;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedParameterFix;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaBatchInspectionTool;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiReferenceProcessor;
import com.intellij.psi.search.PsiReferenceProcessorAdapter;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UParameter;

class UnusedParametersInspection
extends GlobalJavaBatchInspectionTool {
    UnusedParametersInspection() {
    }

    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor processor) {
        if (refEntity instanceof RefMethod) {
            RefMethod refMethod = (RefMethod)refEntity;
            if (refMethod.isSyntheticJSP()) {
                return null;
            }
            if (refMethod.isExternalOverride()) {
                return null;
            }
            if (!(refMethod.isStatic() || refMethod.isConstructor() || refMethod.getSuperMethods().isEmpty())) {
                return null;
            }
            RefClass aClass = refMethod.getOwnerClass();
            if (aClass != null && (refMethod.isAbstract() || aClass.isInterface()) && refMethod.getDerivedMethods().isEmpty()) {
                return null;
            }
            if (refMethod.isAppMain()) {
                return null;
            }
            ArrayList<RefParameter> unusedParameters = UnusedParametersInspection.getUnusedParameters(refMethod);
            if (unusedParameters.isEmpty()) {
                return null;
            }
            if (refMethod.isEntry()) {
                return null;
            }
            UDeclaration uMethod = refMethod.getUastElement();
            if (uMethod == null) {
                return null;
            }
            PsiElement element = uMethod.getJavaPsi();
            if (element != null && EntryPointsManager.getInstance((Project)manager.getProject()).isEntryPoint(element)) {
                return null;
            }
            ArrayList<ProblemDescriptor> result = new ArrayList<ProblemDescriptor>();
            for (RefParameter refParameter : unusedParameters) {
                UParameter parameter2 = refParameter.getUastElement();
                PsiElement anchor = UElementKt.getSourcePsiElement((UElement)parameter2.getUastAnchor());
                if (anchor == null) continue;
                result.add(manager.createProblemDescriptor(anchor, InspectionsBundle.message((String)(refMethod.isAbstract() ? "inspection.unused.parameter.composer" : "inspection.unused.parameter.composer1"), (Object[])new Object[0]), (LocalQuickFix)new AcceptSuggested(globalContext.getRefManager(), processor, refParameter.getName()), ProblemHighlightType.LIKE_UNUSED_SYMBOL, false));
            }
            return result.toArray(CommonProblemDescriptor.EMPTY_ARRAY);
        }
        return null;
    }

    protected boolean queryExternalUsagesRequests(@NotNull RefManager manager, @NotNull GlobalJavaInspectionContext globalContext, final @NotNull ProblemDescriptionsProcessor processor) {
        Project project = manager.getProject();
        for (RefElement entryPoint : globalContext.getEntryPointsManager(manager).getEntryPoints(manager)) {
            processor.ignoreElement((RefEntity)entryPoint);
        }
        final PsiSearchHelper helper = PsiSearchHelper.getInstance((Project)project);
        final AnalysisScope scope = manager.getScope();
        manager.iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(@NotNull RefEntity refEntity) {
                PsiMethod element;
                RefMethod refMethod;
                UDeclaration uastElement;
                if (refEntity instanceof RefMethod && (uastElement = (refMethod = (RefMethod)refEntity).getUastElement()) != null && (element = (PsiMethod)uastElement.getJavaPsi()) != null && !refMethod.isStatic() && !refMethod.isConstructor() && !"private".equals(refMethod.getAccessModifier())) {
                    ArrayList<RefParameter> unusedParameters = UnusedParametersInspection.getUnusedParameters(refMethod);
                    if (unusedParameters.isEmpty()) {
                        return;
                    }
                    PsiMethod[] derived = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)element).toArray((Object[])PsiMethod.EMPTY_ARRAY);
                    for (final RefParameter refParameter : unusedParameters) {
                        if (refMethod.isAbstract() && derived.length == 0) {
                            refParameter.parameterReferenced(false);
                            processor.ignoreElement((RefEntity)refParameter);
                            continue;
                        }
                        int idx = refParameter.getIndex();
                        final boolean[] found = new boolean[]{false};
                        for (int i = 0; i < derived.length && !found[0]; ++i) {
                            PsiParameter[] parameters2;
                            if (scope != null && scope.contains((PsiElement)derived[i]) || idx >= (parameters2 = derived[i].getParameterList().getParameters()).length) continue;
                            PsiParameter psiParameter = parameters2[idx];
                            ReferencesSearch.search((PsiElement)psiParameter, (SearchScope)helper.getUseScope((PsiElement)psiParameter), (boolean)false).forEach((Processor)new PsiReferenceProcessorAdapter(new PsiReferenceProcessor(){

                                public boolean execute(PsiReference element) {
                                    refParameter.parameterReferenced(false);
                                    processor.ignoreElement((RefEntity)refParameter);
                                    found[0] = true;
                                    return false;
                                }
                            }));
                        }
                    }
                }
            }
        });
        return false;
    }

    public String getHint(@NotNull QuickFix fix2) {
        if (fix2 instanceof AcceptSuggested) {
            return ((AcceptSuggested)fix2).getHint();
        }
        return null;
    }

    @Nullable
    public QuickFix getQuickFix(String hint) {
        return new AcceptSuggested(null, null, hint);
    }

    public static ArrayList<RefParameter> getUnusedParameters(RefMethod refMethod) {
        boolean checkDeep = !refMethod.isStatic() && !refMethod.isConstructor();
        ArrayList<RefParameter> res = new ArrayList<RefParameter>();
        RefParameter[] methodParameters = refMethod.getParameters();
        RefParameter[] result = new RefParameter[methodParameters.length];
        System.arraycopy(methodParameters, 0, result, 0, methodParameters.length);
        UnusedParametersInspection.clearUsedParameters(refMethod, result, checkDeep);
        for (RefParameter parameter2 : result) {
            if (parameter2 == null || ((RefElementImpl)parameter2).isSuppressed(new String[]{"UnusedParameters", "unused"})) continue;
            res.add(parameter2);
        }
        return res;
    }

    private static void clearUsedParameters(@NotNull RefMethod refMethod, RefParameter[] params, boolean checkDeep) {
        RefParameter[] methodParams = refMethod.getParameters();
        for (int i = 0; i < methodParams.length; ++i) {
            if (!methodParams[i].isUsedForReading()) continue;
            params[i] = null;
        }
        if (checkDeep) {
            for (RefMethod refOverride : refMethod.getDerivedMethods()) {
                UnusedParametersInspection.clearUsedParameters(refOverride, params, true);
            }
        }
    }

    private static class AcceptSuggested
    implements LocalQuickFix {
        private final RefManager myManager;
        private final String myHint;
        private final ProblemDescriptionsProcessor myProcessor;

        AcceptSuggested(@Nullable RefManager manager, @Nullable ProblemDescriptionsProcessor processor, String hint) {
            this.myManager = manager;
            this.myProcessor = processor;
            this.myHint = hint;
        }

        public String getHint() {
            return this.myHint;
        }

        @NotNull
        public String getFamilyName() {
            return InspectionsBundle.message((String)"inspection.unused.parameter.delete.quickfix", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement psiElement = descriptor.getPsiElement();
            if (!FileModificationService.getInstance().preparePsiElementForWrite(psiElement)) {
                return;
            }
            PsiParameter psiParameter = (PsiParameter)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiParameter.class);
            PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiMethod.class);
            if (psiMethod != null && psiParameter != null) {
                RefElement refMethod = this.myManager != null ? this.myManager.getReference((PsiElement)psiMethod) : null;
                PsiModificationTracker tracker = psiMethod.getManager().getModificationTracker();
                long startModificationCount = tracker.getModificationCount();
                RemoveUnusedParameterFix.removeReferences(psiParameter);
                if (refMethod != null && startModificationCount != tracker.getModificationCount()) {
                    Objects.requireNonNull(this.myProcessor).ignoreElement((RefEntity)refMethod);
                }
            }
        }

        public boolean startInWriteAction() {
            return false;
        }
    }
}

