/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.defUse;

import com.intellij.codeInsight.ExpressionUtil;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedVariableUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RemoveAssignmentFix;
import com.intellij.codeInspection.RemoveInitializerFix;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class DefUseInspection
extends AbstractBaseJavaLocalInspectionTool {
    public boolean REPORT_PREFIX_EXPRESSIONS;
    public boolean REPORT_POSTFIX_EXPRESSIONS = true;
    public boolean REPORT_REDUNDANT_INITIALIZER = true;
    public static final String DISPLAY_NAME = InspectionsBundle.message((String)"inspection.unused.assignment.display.name", (Object[])new Object[0]);
    public static final String SHORT_NAME = "UnusedAssignment";

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitMethod(PsiMethod method) {
                DefUseInspection.this.checkCodeBlock(method.getBody(), holder, isOnTheFly);
            }

            public void visitClassInitializer(PsiClassInitializer initializer) {
                DefUseInspection.this.checkCodeBlock(initializer.getBody(), holder, isOnTheFly);
            }

            public void visitLambdaExpression(PsiLambdaExpression expression2) {
                PsiElement body2 = expression2.getBody();
                if (body2 instanceof PsiCodeBlock) {
                    DefUseInspection.this.checkCodeBlock((PsiCodeBlock)body2, holder, isOnTheFly);
                }
            }

            public void visitField(PsiField field) {
                DefUseInspection.this.checkField(field, holder, isOnTheFly);
            }
        };
    }

    private void checkCodeBlock(PsiCodeBlock body2, ProblemsHolder holder, boolean isOnTheFly) {
        if (body2 == null) {
            return;
        }
        THashSet usedVariables = new THashSet();
        List<DefUseUtil.Info> unusedDefs = DefUseUtil.getUnusedDefs(body2, (Set<? super PsiVariable>)usedVariables);
        if (unusedDefs != null && !unusedDefs.isEmpty()) {
            unusedDefs.sort(Comparator.comparingInt(o -> o.getContext().getTextOffset()));
            for (DefUseUtil.Info info : unusedDefs) {
                PsiElement context = info.getContext();
                PsiVariable psiVariable = info.getVariable();
                if (context instanceof PsiDeclarationStatement || context instanceof PsiResourceVariable) {
                    PsiTypeElement typeElement;
                    if (!info.isRead() || !this.REPORT_REDUNDANT_INITIALIZER || (typeElement = psiVariable.getTypeElement()) != null && typeElement.isInferredType()) continue;
                    this.reportInitializerProblem(psiVariable, holder, isOnTheFly);
                    continue;
                }
                if (context instanceof PsiAssignmentExpression) {
                    this.reportAssignmentProblem(psiVariable, (PsiAssignmentExpression)context, holder, isOnTheFly);
                    continue;
                }
                if ((!(context instanceof PsiPrefixExpression) || !this.REPORT_PREFIX_EXPRESSIONS) && (!(context instanceof PsiPostfixExpression) || !this.REPORT_POSTFIX_EXPRESSIONS)) continue;
                holder.registerProblem(context, InspectionsBundle.message((String)"inspection.unused.assignment.problem.descriptor4", (Object[])new Object[]{"<code>#ref</code> #loc"}), new LocalQuickFix[0]);
            }
        }
    }

    private void reportInitializerProblem(PsiVariable psiVariable, ProblemsHolder holder, boolean isOnTheFly) {
        List fixes = ContainerUtil.createMaybeSingletonList((Object)(DefUseInspection.isOnTheFlyOrNoSideEffects(isOnTheFly, psiVariable, psiVariable.getInitializer()) ? this.createRemoveInitializerFix() : null));
        holder.registerProblem((PsiElement)ObjectUtils.notNull((Object)psiVariable.getInitializer(), (Object)psiVariable), InspectionsBundle.message((String)"inspection.unused.assignment.problem.descriptor2", (Object[])new Object[]{"<code>" + psiVariable.getName() + "</code>", "<code>#ref</code> #loc"}), ProblemHighlightType.LIKE_UNUSED_SYMBOL, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
    }

    private void reportAssignmentProblem(PsiVariable psiVariable, PsiAssignmentExpression assignment, ProblemsHolder holder, boolean isOnTheFly) {
        List fixes = ContainerUtil.createMaybeSingletonList((Object)(DefUseInspection.isOnTheFlyOrNoSideEffects(isOnTheFly, psiVariable, assignment.getRExpression()) ? this.createRemoveAssignmentFix() : null));
        holder.registerProblem((PsiElement)assignment.getLExpression(), InspectionsBundle.message((String)"inspection.unused.assignment.problem.descriptor3", (Object[])new Object[]{((PsiExpression)ObjectUtils.assertNotNull((Object)assignment.getRExpression())).getText(), "<code>#ref</code> #loc"}), ProblemHighlightType.LIKE_UNUSED_SYMBOL, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
    }

    private void checkField(@NotNull PsiField field, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        boolean fieldHasInitializer;
        boolean isStatic;
        PsiMethod[] constructors;
        if (field.hasModifierProperty("final")) {
            return;
        }
        PsiClass psiClass = field.getContainingClass();
        if (psiClass == null) {
            return;
        }
        PsiClassInitializer[] classInitializers = psiClass.getInitializers();
        int maxPossibleWritesCount = classInitializers.length + ((constructors = !(isStatic = field.hasModifierProperty("static")) ? psiClass.getConstructors() : PsiMethod.EMPTY_ARRAY).length != 0 ? 1 : 0) + ((fieldHasInitializer = field.hasInitializer()) ? 1 : 0);
        if (maxPossibleWritesCount <= 1) {
            return;
        }
        PsiClassInitializer initializerBeforeField = (PsiClassInitializer)PsiTreeUtil.getPrevSiblingOfType((PsiElement)field, PsiClassInitializer.class);
        ArrayList<FieldWrite> fieldWrites = new ArrayList<FieldWrite>();
        if (fieldHasInitializer && initializerBeforeField == null) {
            fieldWrites.add(FieldWrite.createInitializer());
        }
        for (PsiClassInitializer classInitializer : classInitializers) {
            List<PsiAssignmentExpression> assignments;
            if (classInitializer.hasModifierProperty("static") == isStatic && !(assignments = DefUseInspection.collectAssignments(field, classInitializer)).isEmpty()) {
                boolean isDefinitely = HighlightControlFlowUtil.variableDefinitelyAssignedIn((PsiVariable)field, (PsiElement)classInitializer.getBody());
                if (isDefinitely) {
                    try {
                        ControlFlow flow = HighlightControlFlowUtil.getControlFlowNoConstantEvaluate((PsiElement)classInitializer.getBody());
                        if (ControlFlowUtil.getReadBeforeWrite(flow).stream().anyMatch(read2 -> (isStatic || ExpressionUtil.isEffectivelyUnqualified(read2)) && read2.isReferenceTo((PsiElement)field))) {
                            isDefinitely = false;
                        }
                    }
                    catch (AnalysisCanceledException analysisCanceledException) {
                        // empty catch block
                    }
                }
                fieldWrites.add(FieldWrite.createAssignments(isDefinitely, assignments));
            }
            if (!fieldHasInitializer || initializerBeforeField != classInitializer) continue;
            fieldWrites.add(FieldWrite.createInitializer());
        }
        Collections.reverse(fieldWrites);
        boolean wasDefinitelyAssigned = DefUseInspection.isAssignedInAllConstructors(field, constructors);
        for (FieldWrite fieldWrite : fieldWrites) {
            if (wasDefinitelyAssigned) {
                if (fieldWrite.isInitializer()) {
                    if (!this.REPORT_REDUNDANT_INITIALIZER) continue;
                    this.reportInitializerProblem((PsiVariable)field, holder, isOnTheFly);
                    continue;
                }
                for (PsiAssignmentExpression assignment : fieldWrite.getAssignments()) {
                    this.reportAssignmentProblem((PsiVariable)field, assignment, holder, isOnTheFly);
                }
                continue;
            }
            if (!fieldWrite.isDefinitely()) continue;
            wasDefinitelyAssigned = true;
        }
    }

    private static boolean isAssignedInAllConstructors(@NotNull PsiField field, @NotNull PsiMethod[] constructors) {
        if (constructors.length == 0 || field.hasModifierProperty("static")) {
            return false;
        }
        for (PsiMethod constructor : constructors) {
            if (!JavaHighlightUtil.getChainedConstructors(constructor).isEmpty()) continue;
            PsiCodeBlock body2 = constructor.getBody();
            if (body2 == null || !HighlightControlFlowUtil.variableDefinitelyAssignedIn((PsiVariable)field, (PsiElement)body2)) {
                return false;
            }
            try {
                ControlFlow flow = HighlightControlFlowUtil.getControlFlowNoConstantEvaluate((PsiElement)body2);
                if (!ControlFlowUtil.getReadBeforeWrite(flow).stream().anyMatch(read2 -> ExpressionUtil.isEffectivelyUnqualified(read2) && read2.isReferenceTo((PsiElement)field))) continue;
                return false;
            }
            catch (AnalysisCanceledException e) {
                return false;
            }
        }
        return true;
    }

    @NotNull
    private static List<PsiAssignmentExpression> collectAssignments(final @NotNull PsiField field, @NotNull PsiClassInitializer classInitializer) {
        final ArrayList<PsiAssignmentExpression> assignmentExpressions = new ArrayList<PsiAssignmentExpression>();
        classInitializer.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
                PsiExpression rExpression;
                PsiExpression lExpression = expression2.getLExpression();
                if (lExpression instanceof PsiJavaReference && ((PsiJavaReference)lExpression).isReferenceTo((PsiElement)field) && (rExpression = expression2.getRExpression()) != null) {
                    assignmentExpressions.add(expression2);
                }
                super.visitAssignmentExpression(expression2);
            }
        });
        return assignmentExpressions;
    }

    private static boolean isOnTheFlyOrNoSideEffects(boolean isOnTheFly, PsiVariable psiVariable, PsiExpression initializer) {
        return isOnTheFly || !RemoveUnusedVariableUtil.checkSideEffects(initializer, psiVariable, new ArrayList());
    }

    protected LocalQuickFix createRemoveInitializerFix() {
        return new RemoveInitializerFix();
    }

    protected LocalQuickFix createRemoveAssignmentFix() {
        return new RemoveAssignmentFix();
    }

    public JComponent createOptionsPanel() {
        return new OptionsPanel();
    }

    @NotNull
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @NotNull
    public String getGroupDisplayName() {
        return GroupNames.BUGS_GROUP_NAME;
    }

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    private static class FieldWrite {
        final boolean myDefinitely;
        final List<PsiAssignmentExpression> myAssignments;

        private FieldWrite(boolean definitely, List<PsiAssignmentExpression> assignments) {
            this.myDefinitely = definitely;
            this.myAssignments = assignments;
        }

        public boolean isDefinitely() {
            return this.myDefinitely;
        }

        public boolean isInitializer() {
            return this.myAssignments == null;
        }

        public List<PsiAssignmentExpression> getAssignments() {
            return this.myAssignments != null ? this.myAssignments : Collections.emptyList();
        }

        @NotNull
        public static FieldWrite createInitializer() {
            return new FieldWrite(true, null);
        }

        @NotNull
        public static FieldWrite createAssignments(boolean definitely, @NotNull List<PsiAssignmentExpression> assignmentExpressions) {
            return new FieldWrite(definitely, assignmentExpressions);
        }
    }

    private class OptionsPanel
    extends JPanel {
        private final JCheckBox myReportPrefix;
        private final JCheckBox myReportPostfix;
        private final JCheckBox myReportInitializer;

        private OptionsPanel() {
            super(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.weighty = 0.0;
            gc.weightx = 1.0;
            gc.fill = 2;
            gc.anchor = 18;
            this.myReportInitializer = new JCheckBox(InspectionsBundle.message((String)"inspection.unused.assignment.option2", (Object[])new Object[0]));
            this.myReportInitializer.setSelected(DefUseInspection.this.REPORT_REDUNDANT_INITIALIZER);
            this.myReportInitializer.getModel().addItemListener(e -> {
                DefUseInspection.this.REPORT_REDUNDANT_INITIALIZER = this.myReportInitializer.isSelected();
            });
            gc.insets = JBUI.insetsBottom((int)15);
            gc.gridy = 0;
            this.add((Component)this.myReportInitializer, gc);
            this.myReportPrefix = new JCheckBox(InspectionsBundle.message((String)"inspection.unused.assignment.option", (Object[])new Object[0]));
            this.myReportPrefix.setSelected(DefUseInspection.this.REPORT_PREFIX_EXPRESSIONS);
            this.myReportPrefix.getModel().addItemListener(e -> {
                DefUseInspection.this.REPORT_PREFIX_EXPRESSIONS = this.myReportPrefix.isSelected();
            });
            gc.insets = JBUI.emptyInsets();
            ++gc.gridy;
            this.add((Component)this.myReportPrefix, gc);
            this.myReportPostfix = new JCheckBox(InspectionsBundle.message((String)"inspection.unused.assignment.option1", (Object[])new Object[0]));
            this.myReportPostfix.setSelected(DefUseInspection.this.REPORT_POSTFIX_EXPRESSIONS);
            this.myReportPostfix.getModel().addItemListener(e -> {
                DefUseInspection.this.REPORT_POSTFIX_EXPRESSIONS = this.myReportPostfix.isSelected();
            });
            gc.weighty = 1.0;
            ++gc.gridy;
            this.add((Component)this.myReportPostfix, gc);
        }
    }
}

