/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deprecation;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.apiUsage.ApiUsageVisitorBase;
import com.intellij.codeInspection.deprecation.DeprecationInspectionBase;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolvingHint;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeprecationElementVisitor
extends ApiUsageVisitorBase {
    private final ProblemsHolder myHolder;
    private final boolean myIgnoreInsideDeprecated;
    private final boolean myIgnoreAbstractDeprecatedOverrides;
    private final boolean myIgnoreImportStatements;
    private final boolean myIgnoreMethodsOfDeprecated;
    private final boolean myIgnoreInSameOutermostClass;
    private final boolean myForRemoval;
    private final ProblemHighlightType myHighlightType;

    DeprecationElementVisitor(@NotNull ProblemsHolder holder, boolean ignoreInsideDeprecated, boolean ignoreAbstractDeprecatedOverrides, boolean ignoreImportStatements, boolean ignoreMethodsOfDeprecated, boolean ignoreInSameOutermostClass, boolean forRemoval, @Nullable HighlightSeverity severity) {
        this.myHolder = holder;
        this.myIgnoreInsideDeprecated = ignoreInsideDeprecated;
        this.myIgnoreAbstractDeprecatedOverrides = ignoreAbstractDeprecatedOverrides;
        this.myIgnoreImportStatements = ignoreImportStatements;
        this.myIgnoreMethodsOfDeprecated = ignoreMethodsOfDeprecated;
        this.myIgnoreInSameOutermostClass = ignoreInSameOutermostClass;
        this.myForRemoval = forRemoval;
        this.myHighlightType = forRemoval && severity == HighlightSeverity.ERROR ? ProblemHighlightType.LIKE_MARKED_FOR_REMOVAL : ProblemHighlightType.LIKE_DEPRECATED;
    }

    @Override
    public void processReference(@NotNull PsiReference reference) {
        if (reference instanceof ResolvingHint && !((ResolvingHint)reference).canResolveTo(PsiModifierListOwner.class)) {
            return;
        }
        PsiElement resolved = reference.resolve();
        if (resolved != null) {
            PsiElement elementToHighlight = DeprecationElementVisitor.getElementToHighlight(reference);
            DeprecationInspectionBase.checkDeprecated(resolved, elementToHighlight, null, this.myIgnoreInsideDeprecated, this.myIgnoreImportStatements, this.myIgnoreMethodsOfDeprecated, this.myIgnoreInSameOutermostClass, this.myHolder, this.myForRemoval, this.myHighlightType);
        }
    }

    @NotNull
    private static PsiElement getElementToHighlight(@NotNull PsiReference reference) {
        PsiElement referenceNameElement2;
        if (reference instanceof PsiJavaCodeReferenceElement && (referenceNameElement2 = ((PsiJavaCodeReferenceElement)reference).getReferenceNameElement()) != null) {
            return referenceNameElement2;
        }
        return reference.getElement();
    }

    @Override
    public void processConstructorInvocation(@NotNull PsiJavaCodeReferenceElement instantiatedClass, @NotNull PsiMethod constructor) {
        DeprecationInspectionBase.checkDeprecated((PsiElement)constructor, (PsiElement)instantiatedClass, null, this.myIgnoreInsideDeprecated, this.myIgnoreImportStatements, true, this.myIgnoreInSameOutermostClass, this.myHolder, this.myForRemoval, this.myHighlightType);
    }

    @Override
    public void processDefaultConstructorInvocation(@NotNull PsiJavaCodeReferenceElement instantiatedClass) {
        PsiElement createdClass = instantiatedClass.resolve();
        if (createdClass instanceof PsiClass && DeprecationElementVisitor.hasEmptyDeprecatedConstructor((PsiClass)createdClass, this.myForRemoval)) {
            this.registerDefaultConstructorProblem((PsiClass)createdClass, (PsiElement)instantiatedClass);
        }
    }

    @Override
    public void processMethodOverriding(@NotNull PsiMethod method, @NotNull PsiMethod overriddenMethod) {
        PsiClass aClass = overriddenMethod.getContainingClass();
        if (aClass == null) {
            return;
        }
        PsiIdentifier nameIdentifier = method.getNameIdentifier();
        if (nameIdentifier == null) {
            return;
        }
        if (this.myIgnoreAbstractDeprecatedOverrides && !aClass.isDeprecated() && overriddenMethod.hasModifierProperty("abstract")) {
            return;
        }
        if (overriddenMethod.isDeprecated() && this.myForRemoval == DeprecationInspectionBase.isForRemovalAttributeSet((PsiModifierListOwner)overriddenMethod)) {
            String description = JavaErrorMessages.message(this.myForRemoval ? "overrides.marked.for.removal.method" : "overrides.deprecated.method", DeprecationInspectionBase.getPresentableName((PsiElement)aClass));
            this.myHolder.registerProblem((PsiElement)nameIdentifier, DeprecationInspectionBase.getDescription(description, this.myForRemoval, this.myHighlightType), this.myHighlightType, new LocalQuickFix[0]);
        }
    }

    @Override
    public void processEmptyConstructorOfSuperClassImplicitInvocationAtSubclassConstructor(@NotNull PsiClass superClass, @NotNull PsiMethod subclassConstructor) {
        PsiIdentifier nameIdentifier;
        if (DeprecationElementVisitor.hasEmptyDeprecatedConstructor(superClass, this.myForRemoval) && (nameIdentifier = subclassConstructor.getNameIdentifier()) != null) {
            this.registerDefaultConstructorProblem(superClass, (PsiElement)nameIdentifier);
        }
    }

    @Override
    public void processEmptyConstructorOfSuperClassImplicitInvocationAtSubclassDeclaration(@NotNull PsiClass subclass, @NotNull PsiClass superClass) {
        if (DeprecationElementVisitor.hasEmptyDeprecatedConstructor(superClass, this.myForRemoval)) {
            PsiIdentifier elementToHighlight;
            PsiExpressionList argumentList;
            boolean isAnonymous = subclass instanceof PsiAnonymousClass;
            if (isAnonymous && (argumentList = ((PsiAnonymousClass)subclass).getArgumentList()) != null && !argumentList.isEmpty()) {
                return;
            }
            Object object = elementToHighlight = isAnonymous ? ((PsiAnonymousClass)subclass).getBaseClassReference() : subclass.getNameIdentifier();
            if (elementToHighlight != null) {
                this.registerDefaultConstructorProblem(superClass, (PsiElement)elementToHighlight);
            }
        }
    }

    private static boolean hasEmptyDeprecatedConstructor(@NotNull PsiClass aClass, boolean forRemoval) {
        PsiMethod[] constructors = aClass.getConstructors();
        if (constructors.length == 0) {
            List externalDeprecated = ExternalAnnotationsManager.getInstance((Project)aClass.getProject()).findDefaultConstructorExternalAnnotations(aClass, "java.lang.Deprecated");
            return externalDeprecated != null && !externalDeprecated.isEmpty() && ContainerUtil.exists((Iterable)externalDeprecated, annotation -> DeprecationInspectionBase.isForRemovalAttributeSet(annotation) == forRemoval);
        }
        return Arrays.stream(constructors).anyMatch(constructor -> constructor.getParameterList().isEmpty() && constructor.isDeprecated() && forRemoval == DeprecationInspectionBase.isForRemovalAttributeSet((PsiModifierListOwner)constructor));
    }

    private void registerDefaultConstructorProblem(@NotNull PsiClass constructorOwner, @NotNull PsiElement elementToHighlight) {
        String description = JavaErrorMessages.message(this.myForRemoval ? "marked.for.removal.default.constructor" : "deprecated.default.constructor", constructorOwner.getQualifiedName());
        this.myHolder.registerProblem(elementToHighlight, DeprecationInspectionBase.getDescription(description, this.myForRemoval, this.myHighlightType), this.myHighlightType, new LocalQuickFix[0]);
    }
}

