/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deprecation;

import com.intellij.codeInspection.DeprecationUtil;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.deprecation.DeprecationElementVisitor;
import com.intellij.codeInspection.deprecation.DeprecationInspectionBase;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiElementVisitor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class DeprecationInspection
extends DeprecationInspectionBase {
    public static final String SHORT_NAME = "Deprecation";
    public static final String ID = "deprecation";
    public static final String DISPLAY_NAME = DeprecationUtil.DEPRECATION_DISPLAY_NAME;
    public static final String IGNORE_METHODS_OF_DEPRECATED_NAME = "IGNORE_METHODS_OF_DEPRECATED";
    public boolean IGNORE_INSIDE_DEPRECATED = true;
    public boolean IGNORE_ABSTRACT_DEPRECATED_OVERRIDES = true;
    public boolean IGNORE_IMPORT_STATEMENTS = true;
    public boolean IGNORE_METHODS_OF_DEPRECATED = true;

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new DeprecationElementVisitor(holder, this.IGNORE_INSIDE_DEPRECATED, this.IGNORE_ABSTRACT_DEPRECATED_OVERRIDES, this.IGNORE_IMPORT_STATEMENTS, this.IGNORE_METHODS_OF_DEPRECATED, this.IGNORE_IN_SAME_OUTERMOST_CLASS, false, null);
    }

    @NotNull
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @NotNull
    public String getGroupDisplayName() {
        return "";
    }

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    @NotNull
    public String getID() {
        return ID;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox("Ignore inside deprecated members", "IGNORE_INSIDE_DEPRECATED");
        panel.addCheckbox("Ignore inside non-static imports", "IGNORE_IMPORT_STATEMENTS");
        panel.addCheckbox("<html>Ignore overrides of deprecated abstract methods from non-deprecated supers</html>", "IGNORE_ABSTRACT_DEPRECATED_OVERRIDES");
        panel.addCheckbox("Ignore members of deprecated classes", IGNORE_METHODS_OF_DEPRECATED_NAME);
        DeprecationInspection.addSameOutermostClassCheckBox(panel);
        return panel;
    }
}

