/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deprecation;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.deprecation.ReplaceFieldReferenceFix;
import com.intellij.codeInspection.deprecation.ReplaceMethodCallFix;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.compiled.ClsMethodImpl;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import one.util.streamex.MoreCollectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeprecationInspectionBase
extends LocalInspectionTool {
    public boolean IGNORE_IN_SAME_OUTERMOST_CLASS;

    public boolean isEnabledByDefault() {
        return true;
    }

    public static void checkDeprecated(@NotNull PsiElement element, @NotNull PsiElement elementToHighlight, @Nullable TextRange rangeInElement, boolean ignoreInsideDeprecated, boolean ignoreImportStatements, boolean ignoreMethodsOfDeprecated, boolean ignoreInSameOutermostClass, @NotNull ProblemsHolder holder, boolean forRemoval, @NotNull ProblemHighlightType highlightType) {
        if (!(element instanceof PsiModifierListOwner)) {
            return;
        }
        PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)element;
        if (PsiImplUtil.isDeprecated((PsiElement)modifierListOwner)) {
            if (forRemoval != DeprecationInspectionBase.isForRemovalAttributeSet(modifierListOwner)) {
                return;
            }
        } else {
            if (!ignoreMethodsOfDeprecated) {
                PsiClass containingClass;
                PsiClass psiClass = containingClass = element instanceof PsiMember ? ((PsiMember)element).getContainingClass() : null;
                if (containingClass != null) {
                    DeprecationInspectionBase.checkDeprecated((PsiElement)containingClass, elementToHighlight, rangeInElement, ignoreInsideDeprecated, ignoreImportStatements, false, ignoreInSameOutermostClass, holder, forRemoval, highlightType);
                }
            }
            return;
        }
        if (ignoreInSameOutermostClass && DeprecationInspectionBase.areElementsInSameOutermostClass(element, elementToHighlight)) {
            return;
        }
        if (ignoreInsideDeprecated && DeprecationInspectionBase.isElementInsideDeprecated(elementToHighlight)) {
            return;
        }
        if (ignoreImportStatements && DeprecationInspectionBase.isElementInsideImportStatement(elementToHighlight)) {
            return;
        }
        String description = JavaErrorMessages.message(forRemoval ? "marked.for.removal.symbol" : "deprecated.symbol", DeprecationInspectionBase.getPresentableName(element));
        LocalQuickFix replacementQuickFix = DeprecationInspectionBase.getReplacementQuickFix(element, elementToHighlight);
        holder.registerProblem(elementToHighlight, DeprecationInspectionBase.getDescription(description, forRemoval, highlightType), highlightType, rangeInElement, new LocalQuickFix[]{replacementQuickFix});
    }

    private static boolean isElementInsideImportStatement(@NotNull PsiElement elementToHighlight) {
        return PsiTreeUtil.getParentOfType((PsiElement)elementToHighlight, PsiImportStatement.class) != null;
    }

    public static boolean isElementInsideDeprecated(@NotNull PsiElement element) {
        PsiElement parent = element;
        while ((parent = PsiTreeUtil.getParentOfType((PsiElement)parent, PsiModifierListOwner.class, (boolean)true)) != null) {
            if (!PsiImplUtil.isDeprecated(parent)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static LocalQuickFix getReplacementQuickFix(@NotNull PsiElement refElement, @NotNull PsiElement elementToHighlight) {
        PsiField replacement;
        PsiReferenceExpression referenceExpression;
        PsiMethod replacement2;
        PsiMethodCallExpression methodCall = DeprecationInspectionBase.getMethodCall(elementToHighlight);
        if (refElement instanceof PsiMethod && methodCall != null && (replacement2 = DeprecationInspectionBase.findReplacementInJavaDoc((PsiMethod)refElement, methodCall)) != null) {
            return new ReplaceMethodCallFix((PsiMethodCallExpression)elementToHighlight.getParent().getParent(), replacement2);
        }
        if (refElement instanceof PsiField && (referenceExpression = (PsiReferenceExpression)ObjectUtils.tryCast((Object)elementToHighlight.getParent(), PsiReferenceExpression.class)) != null && (replacement = DeprecationInspectionBase.findReplacementInJavaDoc((PsiField)refElement, referenceExpression)) != null) {
            return new ReplaceFieldReferenceFix(referenceExpression, replacement);
        }
        return null;
    }

    public static String getPresentableName(@NotNull PsiElement psiElement) {
        if (psiElement instanceof PsiMethod && PsiUtil.isAnnotationMethod((PsiElement)psiElement)) {
            return ((PsiMethod)psiElement).getName();
        }
        return HighlightMessageUtil.getSymbolName(psiElement);
    }

    protected static boolean isForRemovalAttributeSet(@NotNull PsiModifierListOwner element) {
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)element, (String[])new String[]{"java.lang.Deprecated"});
        if (annotation != null) {
            return DeprecationInspectionBase.isForRemovalAttributeSet(annotation);
        }
        return false;
    }

    protected static boolean isForRemovalAttributeSet(@NotNull PsiAnnotation deprecatedAnnotation) {
        return Boolean.TRUE == AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)deprecatedAnnotation, (String)"forRemoval");
    }

    private static boolean areElementsInSameOutermostClass(PsiElement refElement, PsiElement elementToHighlight) {
        PsiClass outermostClass = (PsiClass)CachedValuesManager.getCachedValue((PsiElement)refElement, () -> new CachedValueProvider.Result((Object)PsiUtil.getTopLevelClass((PsiElement)refElement), new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT}));
        return outermostClass != null && outermostClass == PsiUtil.getTopLevelClass((PsiElement)elementToHighlight);
    }

    static void addSameOutermostClassCheckBox(MultipleCheckboxOptionsPanel panel) {
        panel.addCheckbox("Ignore in the same outermost class", "IGNORE_IN_SAME_OUTERMOST_CLASS");
    }

    protected static String getDescription(@NotNull String description, boolean forRemoval, ProblemHighlightType highlightType) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ProblemHighlightType defaultType;
            ProblemHighlightType problemHighlightType = defaultType = forRemoval ? ProblemHighlightType.LIKE_MARKED_FOR_REMOVAL : ProblemHighlightType.LIKE_DEPRECATED;
            if (highlightType != defaultType) {
                return description + "(" + highlightType + ")";
            }
        }
        return description;
    }

    private static PsiField findReplacementInJavaDoc(@NotNull PsiField field, @NotNull PsiReferenceExpression referenceExpression) {
        return ((Optional)DeprecationInspectionBase.getReplacementCandidatesFromJavadoc(field, PsiField.class, (PsiElement)field, DeprecationInspectionBase.getQualifierClass(referenceExpression)).filter(tagField -> DeprecationInspectionBase.areReplaceable(tagField, referenceExpression)).collect(MoreCollectors.onlyOne())).orElse(null);
    }

    private static PsiMethod findReplacementInJavaDoc(@NotNull PsiMethod method, @NotNull PsiMethodCallExpression call) {
        if (method instanceof PsiConstructorCall) {
            return null;
        }
        if (method instanceof ClsMethodImpl) {
            PsiMethod sourceMethod = ((ClsMethodImpl)method).getSourceMirrorMethod();
            return sourceMethod == null ? null : DeprecationInspectionBase.findReplacementInJavaDoc(sourceMethod, call);
        }
        return ((Optional)DeprecationInspectionBase.getReplacementCandidatesFromJavadoc(method, PsiMethod.class, (PsiElement)call, DeprecationInspectionBase.getQualifierClass(call.getMethodExpression())).filter(tagMethod -> DeprecationInspectionBase.areReplaceable(method, tagMethod, call)).collect(MoreCollectors.onlyOne())).orElse(null);
    }

    @NotNull
    private static <T extends PsiDocCommentOwner> Stream<? extends T> getReplacementCandidatesFromJavadoc(T member, Class<T> clazz, PsiElement context, PsiClass qualifierClass) {
        PsiDocComment doc = member.getDocComment();
        if (doc == null) {
            return Stream.empty();
        }
        Collection docTags = PsiTreeUtil.findChildrenOfType((PsiElement)doc, PsiDocTag.class);
        if (docTags.isEmpty()) {
            return Stream.empty();
        }
        return docTags.stream().filter(t -> {
            String name = t.getName();
            return "link".equals(name) || "see".equals(name);
        }).map(tag -> tag.getValueElement()).filter(Objects::nonNull).map(value2 -> value2.getReference()).filter(Objects::nonNull).map(reference -> reference.resolve()).distinct().map(resolved -> (PsiDocCommentOwner)ObjectUtils.tryCast((Object)resolved, (Class)clazz)).filter(Objects::nonNull).filter(tagMethod -> !tagMethod.isDeprecated()).filter(tagMethod -> PsiResolveHelper.SERVICE.getInstance((Project)context.getProject()).isAccessible((PsiMember)tagMethod, context, qualifierClass)).filter(tagMethod -> !member.getManager().areElementsEquivalent((PsiElement)tagMethod, (PsiElement)member));
    }

    private static boolean areReplaceable(PsiField suggested, PsiReferenceExpression expression2) {
        if (ExpressionUtils.isVoidContext((PsiExpression)expression2)) {
            return true;
        }
        PsiType expectedType = ExpectedTypeUtils.findExpectedType((PsiExpression)expression2, true);
        if (expectedType == null) {
            return true;
        }
        PsiType suggestedType = suggested.getType();
        return TypeConversionUtil.isAssignable((PsiType)expectedType, (PsiType)suggestedType);
    }

    private static boolean areReplaceable(@NotNull PsiMethod initial, @NotNull PsiMethod suggestedReplacement, @NotNull PsiMethodCallExpression call) {
        MethodCandidateInfo result;
        PsiExpression qualifierExpression2;
        boolean isInitialStatic = initial.hasModifierProperty("static");
        String qualifierText = isInitialStatic ? ((PsiClass)ObjectUtils.notNull((Object)suggestedReplacement.getContainingClass())).getQualifiedName() + "." : ((qualifierExpression2 = call.getMethodExpression().getQualifierExpression()) == null ? "" : qualifierExpression2.getText() + ".");
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)initial.getProject());
        PsiExpressionList arguments = call.getArgumentList();
        PsiMethodCallExpression suggestedCall = (PsiMethodCallExpression)elementFactory.createExpressionFromText(qualifierText + suggestedReplacement.getName() + arguments.getText(), (PsiElement)call);
        PsiType type2 = ExpectedTypeUtils.findExpectedType((PsiExpression)call, true);
        if (type2 != null && !type2.equals(PsiType.VOID)) {
            PsiType suggestedCallType = suggestedCall.getType();
            if (!ExpressionUtils.isVoidContext((PsiExpression)call) && suggestedCallType != null && !TypeConversionUtil.isAssignable((PsiType)type2, (PsiType)suggestedCallType)) {
                return false;
            }
        }
        return (result = (MethodCandidateInfo)ObjectUtils.tryCast((Object)suggestedCall.resolveMethodGenerics(), MethodCandidateInfo.class)) != null && result.isApplicable();
    }

    @Nullable
    private static PsiClass getQualifierClass(@NotNull PsiReferenceExpression referenceExpression) {
        PsiExpression expression2 = referenceExpression.getQualifierExpression();
        if (expression2 == null) {
            return RefactoringChangeUtil.getThisClass((PsiElement)referenceExpression);
        }
        return PsiUtil.resolveClassInType((PsiType)expression2.getType());
    }

    @Nullable
    private static PsiMethodCallExpression getMethodCall(@NotNull PsiElement element) {
        if (!(element instanceof PsiIdentifier)) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiReferenceExpression)) {
            return null;
        }
        return (PsiMethodCallExpression)ObjectUtils.tryCast((Object)parent.getParent(), PsiMethodCallExpression.class);
    }
}

