/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deprecation;

import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.deprecation.DeprecationInspectionQuickFixesKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.ObjectUtils;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000bH\u0016J)\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0096\u0002R\u001c\u0010\u0007\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00050\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \t*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/codeInspection/deprecation/ReplaceFieldReferenceFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "expr", "Lcom/intellij/psi/PsiReferenceExpression;", "replacementField", "Lcom/intellij/psi/PsiField;", "(Lcom/intellij/psi/PsiReferenceExpression;Lcom/intellij/psi/PsiField;)V", "myReplacementMethodPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "kotlin.jvm.PlatformType", "myReplacementText", "", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "intellij.java.analysis.impl"})
public final class ReplaceFieldReferenceFix
extends LocalQuickFixOnPsiElement {
    private final SmartPsiElementPointer<PsiField> myReplacementMethodPointer;
    private final String myReplacementText;

    @NotNull
    public String getFamilyName() {
        return "Replace Field Reference";
    }

    @NotNull
    public String getText() {
        return "Replace field reference with " + this.myReplacementText;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiReferenceExpression psiReferenceExpression = (PsiReferenceExpression)ObjectUtils.tryCast((Object)startElement, PsiReferenceExpression.class);
        if (psiReferenceExpression == null) {
            return;
        }
        PsiReferenceExpression expr = psiReferenceExpression;
        PsiField psiField = (PsiField)this.myReplacementMethodPointer.getElement();
        if (psiField == null) {
            return;
        }
        PsiField replacementField = psiField;
        String qualifierText = DeprecationInspectionQuickFixesKt.access$generateQualifierText(expr, (PsiMember)replacementField);
        PsiElement replaced = expr.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(qualifierText + replacementField.getName(), (PsiElement)expr));
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(replaced);
    }

    public ReplaceFieldReferenceFix(@NotNull PsiReferenceExpression expr, @NotNull PsiField replacementField) {
        super((PsiElement)expr);
        this.myReplacementMethodPointer = SmartPointerManager.getInstance((Project)replacementField.getProject()).createSmartPsiElementPointer((PsiElement)replacementField);
        this.myReplacementText = PsiFormatUtil.formatVariable((PsiVariable)((PsiVariable)replacementField), (int)4097, (PsiSubstitutor)PsiSubstitutor.EMPTY);
    }
}

