/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deprecation;

import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.deprecation.DeprecationInspectionQuickFixesKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.ObjectUtils;
import kotlin.Metadata;
import kotlin.TypeCastException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\f\u001a\u00020\u000bH\u0017J\b\u0010\r\u001a\u00020\u000bH\u0016J)\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0096\u0002R\u001c\u0010\u0007\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00050\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \t*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/codeInspection/deprecation/ReplaceMethodCallFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "expr", "Lcom/intellij/psi/PsiMethodCallExpression;", "replacementMethod", "Lcom/intellij/psi/PsiMethod;", "(Lcom/intellij/psi/PsiMethodCallExpression;Lcom/intellij/psi/PsiMethod;)V", "myReplacementMethodPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "kotlin.jvm.PlatformType", "myReplacementText", "", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "intellij.java.analysis.impl"})
public final class ReplaceMethodCallFix
extends LocalQuickFixOnPsiElement {
    private final SmartPsiElementPointer<PsiMethod> myReplacementMethodPointer;
    private final String myReplacementText;

    @NotNull
    public String getText() {
        return "Replace method call with " + this.myReplacementText;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return "Replace Method Call";
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiMethodCallExpression psiMethodCallExpression = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)startElement, PsiMethodCallExpression.class);
        if (psiMethodCallExpression == null) {
            return;
        }
        PsiMethodCallExpression expr = psiMethodCallExpression;
        PsiMethod psiMethod = (PsiMethod)this.myReplacementMethodPointer.getElement();
        if (psiMethod == null) {
            return;
        }
        PsiMethod replacementMethod = psiMethod;
        String qualifierText = DeprecationInspectionQuickFixesKt.access$generateQualifierText(expr.getMethodExpression(), (PsiMember)replacementMethod);
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        PsiExpression newMethodCall = elementFactory.createExpressionFromText(qualifierText + replacementMethod.getName() + expr.getArgumentList().getText(), (PsiElement)expr);
        PsiElement psiElement = expr.replace((PsiElement)newMethodCall);
        if (psiElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiMethodCallExpression");
        }
        PsiMethodCallExpression replaced = (PsiMethodCallExpression)psiElement;
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)replaced.getMethodExpression());
    }

    public ReplaceMethodCallFix(@NotNull PsiMethodCallExpression expr, @NotNull PsiMethod replacementMethod) {
        super((PsiElement)expr);
        this.myReplacementMethodPointer = SmartPointerManager.getInstance((Project)replacementMethod.getProject()).createSmartPsiElementPointer((PsiElement)replacementMethod);
        this.myReplacementText = PsiFormatUtil.formatMethod((PsiMethod)replacementMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4097, (int)0);
    }
}

