/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.duplicateExpressions;

import com.intellij.codeInspection.duplicateExpressions.ComplexityCalculator;
import com.intellij.codeInspection.duplicateExpressions.ExpressionHashingStrategy;
import com.intellij.codeInspection.duplicateExpressions.SideEffectCalculator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.util.ObjectUtils;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DuplicateExpressionsContext {
    private static final Key<Map<PsiCodeBlock, DuplicateExpressionsContext>> CONTEXTS_KEY = Key.create((String)"DuplicateExpressionsContext");
    private final Map<PsiExpression, List<PsiExpression>> myOccurrences = new THashMap((TObjectHashingStrategy)new ExpressionHashingStrategy());
    private final ComplexityCalculator myComplexityCalculator = new ComplexityCalculator();
    private final SideEffectCalculator mySideEffectCalculator = new SideEffectCalculator();

    DuplicateExpressionsContext() {
    }

    void addOccurrence(PsiExpression expression2) {
        List list = this.myOccurrences.computeIfAbsent(expression2, unused -> new ArrayList());
        list.add(expression2);
    }

    void forEach(BiConsumer<PsiExpression, List<PsiExpression>> consumer) {
        this.myOccurrences.forEach(consumer);
    }

    int getComplexity(PsiExpression expression2) {
        return this.myComplexityCalculator.getComplexity(expression2);
    }

    boolean mayHaveSideEffect(PsiExpression expression2) {
        return this.mySideEffectCalculator.mayHaveSideEffect(expression2);
    }

    @Nullable
    static DuplicateExpressionsContext getOrCreateContext(@NotNull PsiExpression expression2, @NotNull UserDataHolder session) {
        PsiCodeBlock nearestBody = DuplicateExpressionsContext.findNearestBody(expression2);
        if (nearestBody != null) {
            Map contexts = (Map)session.getUserData(CONTEXTS_KEY);
            if (contexts == null) {
                contexts = new THashMap();
                session.putUserData(CONTEXTS_KEY, (Object)contexts);
            }
            return contexts.computeIfAbsent(nearestBody, unused -> new DuplicateExpressionsContext());
        }
        return null;
    }

    @Nullable
    static DuplicateExpressionsContext getContext(@Nullable PsiCodeBlock body2, @NotNull UserDataHolder session) {
        Map contexts = (Map)session.getUserData(CONTEXTS_KEY);
        return contexts != null ? (DuplicateExpressionsContext)contexts.get(body2) : null;
    }

    static PsiCodeBlock findNearestBody(@NotNull PsiExpression expression2) {
        return (PsiCodeBlock)ObjectUtils.tryCast((Object)ControlFlowUtil.findCodeFragment((PsiElement)expression2), PsiCodeBlock.class);
    }
}

