/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.duplicateExpressions;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.duplicateExpressions.ComplexityCalculator;
import com.intellij.codeInspection.duplicateExpressions.DuplicateExpressionsContext;
import com.intellij.codeInspection.duplicateExpressions.ExpressionHashingStrategy;
import com.intellij.codeInspection.duplicateExpressions.SideEffectCalculator;
import com.intellij.codeInspection.ui.SingleIntegerFieldOptionsPanel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsControlFlowPolicy;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.introduceVariable.InputValidator;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.refactoring.introduceVariable.IntroduceVariableHandler;
import com.intellij.refactoring.introduceVariable.IntroduceVariableSettings;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.CommentTracker;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicateExpressionsInspection
extends LocalInspectionTool {
    public int complexityThreshold = 70;

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly, final @NotNull LocalInspectionToolSession session) {
        return new JavaElementVisitor(){

            public void visitExpression(PsiExpression expression2) {
                super.visitExpression(expression2);
                if (expression2 instanceof PsiParenthesizedExpression) {
                    return;
                }
                this.visitExpressionImpl(expression2);
            }

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                super.visitReferenceExpression(expression2);
                if (expression2.getParent() instanceof PsiCallExpression) {
                    return;
                }
                this.visitExpressionImpl((PsiExpression)expression2);
            }

            public void visitExpressionImpl(PsiExpression expression2) {
                if (ComplexityCalculator.isDefinitelySimple(expression2, DuplicateExpressionsInspection.this.complexityThreshold) || SideEffectCalculator.isDefinitelyWithSideEffect(expression2)) {
                    return;
                }
                DuplicateExpressionsContext context = DuplicateExpressionsContext.getOrCreateContext(expression2, (UserDataHolder)session);
                if (context == null || context.mayHaveSideEffect(expression2)) {
                    return;
                }
                PsiType type2 = RefactoringUtil.getTypeByExpressionWithExpectedType(expression2);
                if (type2 == null || PsiType.VOID.equals((Object)type2)) {
                    return;
                }
                if (context.getComplexity(expression2) > DuplicateExpressionsInspection.this.complexityThreshold) {
                    context.addOccurrence(expression2);
                }
            }

            public void visitMethod(PsiMethod method) {
                super.visitMethod(method);
                PsiCodeBlock body2 = method.getBody();
                if (body2 != null) {
                    this.registerProblemsForExpressions(body2, (UserDataHolder)session);
                }
            }

            public void visitClassInitializer(PsiClassInitializer initializer) {
                super.visitClassInitializer(initializer);
                this.registerProblemsForExpressions(initializer.getBody(), (UserDataHolder)session);
            }

            public void visitLambdaExpression(PsiLambdaExpression expression2) {
                super.visitLambdaExpression(expression2);
                PsiElement body2 = expression2.getBody();
                if (body2 instanceof PsiCodeBlock) {
                    this.registerProblemsForExpressions((PsiCodeBlock)body2, (UserDataHolder)session);
                }
            }

            public void registerProblemsForExpressions(@NotNull PsiCodeBlock body2, @NotNull UserDataHolder session2) {
                DuplicateExpressionsContext context = DuplicateExpressionsContext.getContext(body2, session2);
                if (context == null) {
                    return;
                }
                THashSet processed = new THashSet();
                context.forEach((arg_0, arg_1) -> this.lambda$registerProblemsForExpressions$0((Set)processed, body2, arg_0, arg_1));
            }

            public void registerProblems(@NotNull List<PsiExpression> occurrences, @NotNull PsiCodeBlock body2) {
                if (occurrences.size() > 1 && DuplicateExpressionsInspection.areSafeToExtract(occurrences, body2)) {
                    Map reusableVariables = DuplicateExpressionsInspection.collectReusableVariables(occurrences);
                    for (PsiExpression occurrence : occurrences) {
                        PsiVariable variable;
                        ArrayList<Object> fixes = new ArrayList<Object>();
                        List variables = (List)reusableVariables.get(occurrence);
                        if (variables != null) {
                            for (PsiVariable variable2 : variables) {
                                fixes.add(new ReuseVariableFix(occurrence, variable2));
                            }
                        }
                        if ((variable = DuplicateExpressionsInspection.findVariableByInitializer(occurrence)) != null && DuplicateExpressionsInspection.canReplaceOtherOccurrences(occurrence, occurrences, variable)) {
                            fixes.add(new ReplaceOtherOccurrencesFix(occurrence, variable));
                        } else if (isOnTheFly) {
                            fixes.add(new IntroduceVariableFix(occurrence));
                        }
                        holder.registerProblem((PsiElement)occurrence, InspectionsBundle.message((String)"inspection.duplicate.expressions.message", (Object[])new Object[0]), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                    }
                }
            }

            private /* synthetic */ void lambda$registerProblemsForExpressions$0(Set processed, PsiCodeBlock body2, PsiExpression pattern, List occurrences) {
                if (!processed.contains(pattern)) {
                    processed.addAll(occurrences);
                    this.registerProblems(occurrences, body2);
                }
            }
        };
    }

    private static boolean areSafeToExtract(@NotNull List<PsiExpression> occurrences, @NotNull PsiCodeBlock body2) {
        if (occurrences.isEmpty()) {
            return false;
        }
        Project project = occurrences.get(0).getProject();
        Set<PsiVariable> variables = DuplicateExpressionsInspection.collectVariablesSafeToExtract(occurrences);
        if (variables == null) {
            return false;
        }
        if (variables.isEmpty()) {
            return true;
        }
        PsiElement anchor = RefactoringUtil.getAnchorElementForMultipleExpressions(occurrences.toArray(PsiExpression.EMPTY_ARRAY), null);
        if (anchor == null) {
            return false;
        }
        PsiElement anchorParent = anchor.getParent();
        if (anchorParent == null) {
            return false;
        }
        try {
            ControlFlow flow = ControlFlowFactory.getInstance(project).getControlFlow((PsiElement)body2, new LocalsControlFlowPolicy((PsiElement)body2));
            int startOffset = flow.getSize();
            int endOffset = 0;
            for (PsiExpression occurrence : occurrences) {
                PsiElement occurrenceSurroundings = PsiTreeUtil.findFirstParent((PsiElement)occurrence, (boolean)false, e -> e.getParent() == anchorParent);
                if (occurrenceSurroundings == null) {
                    return false;
                }
                startOffset = Math.min(startOffset, flow.getStartOffset(occurrenceSurroundings));
                endOffset = Math.max(endOffset, flow.getEndOffset(occurrenceSurroundings));
            }
            return ControlFlowUtil.areVariablesUnmodifiedAtLocations(flow, startOffset, endOffset, variables, occurrences);
        }
        catch (AnalysisCanceledException e2) {
            return false;
        }
    }

    @Nullable
    private static Set<PsiVariable> collectVariablesSafeToExtract(@NotNull List<PsiExpression> occurrences) {
        THashSet variables = new THashSet();
        Ref refFailed = new Ref((Object)Boolean.FALSE);
        JavaRecursiveElementWalkingVisitor visitor = new JavaRecursiveElementWalkingVisitor((Set)variables, refFailed){
            final /* synthetic */ Set val$variables;
            final /* synthetic */ Ref val$refFailed;
            {
                this.val$variables = set;
                this.val$refFailed = ref;
            }

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                super.visitReferenceElement(reference);
                PsiElement resolved = reference.resolve();
                if (resolved instanceof PsiLocalVariable || resolved instanceof PsiParameter) {
                    this.val$variables.add((PsiVariable)resolved);
                } else if (resolved instanceof PsiVariable && !((PsiVariable)resolved).hasModifierProperty("final")) {
                    this.val$refFailed.set((Object)Boolean.TRUE);
                    this.stopWalking();
                }
            }
        };
        for (PsiExpression occurrence : occurrences) {
            occurrence.accept((PsiElementVisitor)visitor);
            if (!((Boolean)refFailed.get()).booleanValue()) continue;
            return null;
        }
        return variables;
    }

    @NotNull
    private static Map<PsiExpression, List<PsiVariable>> collectReusableVariables(@NotNull List<PsiExpression> occurrences) {
        if (occurrences.size() <= 1) {
            return Collections.emptyMap();
        }
        THashMap initializers = new THashMap();
        for (PsiExpression occurrence : occurrences) {
            PsiVariable variable = DuplicateExpressionsInspection.findVariableByInitializer(occurrence);
            if (variable == null) continue;
            initializers.put(variable, occurrence);
        }
        if (initializers.isEmpty()) {
            return Collections.emptyMap();
        }
        THashMap result = new THashMap();
        initializers.forEach((arg_0, arg_1) -> DuplicateExpressionsInspection.lambda$collectReusableVariables$2(occurrences, (Map)result, arg_0, arg_1));
        return result;
    }

    private static boolean canReplaceOtherOccurrences(@NotNull PsiExpression originalOccurrence, @NotNull List<PsiExpression> occurrences, @NotNull PsiVariable variable) {
        return occurrences.stream().anyMatch(occurrence -> occurrence != originalOccurrence && DuplicateExpressionsInspection.canReplaceWith(occurrence, variable));
    }

    private static boolean canReplaceWith(@NotNull PsiExpression occurrence, @NotNull PsiVariable variable) {
        PsiExpression refExpr;
        String variableName = variable.getName();
        if (variableName == null) {
            return false;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)variable.getProject());
        try {
            refExpr = factory.createExpressionFromText(variableName, (PsiElement)occurrence);
        }
        catch (IncorrectOperationException e) {
            return false;
        }
        return refExpr instanceof PsiReferenceExpression && ((PsiReferenceExpression)refExpr).resolve() == variable;
    }

    @Nullable
    private static PsiVariable findVariableByInitializer(@NotNull PsiExpression expression2) {
        PsiVariable variable;
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent());
        if (parent instanceof PsiVariable && PsiTreeUtil.isAncestor((PsiElement)(variable = (PsiVariable)parent).getInitializer(), (PsiElement)expression2, (boolean)false)) {
            return variable;
        }
        return null;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleIntegerFieldOptionsPanel(InspectionsBundle.message((String)"inspection.duplicate.expressions.complexity.threshold", (Object[])new Object[0]), (InspectionProfileEntry)this, "complexityThreshold", 3);
    }

    private static /* synthetic */ void lambda$collectReusableVariables$2(List occurrences, Map result, PsiVariable variable, PsiExpression initializer) {
        for (PsiExpression occurrence : occurrences) {
            if (occurrence == initializer || !DuplicateExpressionsInspection.canReplaceWith(occurrence, variable)) continue;
            result.computeIfAbsent(occurrence, unused -> new ArrayList()).add(variable);
        }
    }

    private static class ReplaceOtherOccurrencesFix
    implements LocalQuickFix {
        private final String myExpressionText;
        private final String myVariableName;

        private ReplaceOtherOccurrencesFix(@NotNull PsiExpression expression2, @NotNull PsiVariable variable) {
            this.myExpressionText = expression2.getText();
            this.myVariableName = variable.getName();
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return InspectionsBundle.message((String)"inspection.duplicate.expressions.replace.other.occurrences.fix.family.name", (Object[])new Object[0]);
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            return InspectionsBundle.message((String)"inspection.duplicate.expressions.replace.other.occurrences.fix.name", (Object[])new Object[]{this.myVariableName, this.myExpressionText});
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof PsiExpression) {
                List<PsiExpression> occurrences = ReplaceOtherOccurrencesFix.collectReplaceableOccurrences((PsiExpression)element);
                for (PsiExpression occurrence : occurrences) {
                    new CommentTracker().replaceAndRestoreComments((PsiElement)occurrence, this.myVariableName);
                }
            }
        }

        @NotNull
        private static List<PsiExpression> collectReplaceableOccurrences(final @NotNull PsiExpression originalExpr) {
            final PsiVariable variable = DuplicateExpressionsInspection.findVariableByInitializer(originalExpr);
            PsiCodeBlock nearestBody = DuplicateExpressionsContext.findNearestBody(originalExpr);
            if (variable != null && nearestBody != null) {
                final ArrayList<PsiExpression> replaceableOccurrences = new ArrayList<PsiExpression>();
                nearestBody.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){
                    final ExpressionHashingStrategy hashingStrategy = new ExpressionHashingStrategy();

                    public void visitExpression(PsiExpression occurrence) {
                        super.visitExpression(occurrence);
                        if (occurrence != originalExpr && this.hashingStrategy.equals(occurrence, originalExpr) && DuplicateExpressionsInspection.canReplaceWith(occurrence, variable)) {
                            replaceableOccurrences.add(occurrence);
                        }
                    }
                });
                return replaceableOccurrences;
            }
            return Collections.emptyList();
        }
    }

    private static class ReuseVariableFix
    implements LocalQuickFix {
        private final String myExpressionText;
        private final String myVariableName;

        private ReuseVariableFix(@NotNull PsiExpression expression2, @NotNull PsiVariable variable) {
            this.myExpressionText = expression2.getText();
            this.myVariableName = variable.getName();
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return InspectionsBundle.message((String)"inspection.duplicate.expressions.reuse.variable.fix.family.name", (Object[])new Object[0]);
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            return InspectionsBundle.message((String)"inspection.duplicate.expressions.reuse.variable.fix.name", (Object[])new Object[]{this.myVariableName, this.myExpressionText});
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof PsiExpression) {
                new CommentTracker().replaceAndRestoreComments(element, this.myVariableName);
            }
        }
    }

    private static class IntroduceVariableFix
    implements LocalQuickFix {
        private final String myExpressionText;

        private IntroduceVariableFix(@NotNull PsiExpression expression2) {
            this.myExpressionText = expression2.getText();
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return InspectionsBundle.message((String)"inspection.duplicate.expressions.introduce.variable.fix.family.name", (Object[])new Object[0]);
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            return InspectionsBundle.message((String)"inspection.duplicate.expressions.introduce.variable.fix.name", (Object[])new Object[]{this.myExpressionText});
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof PsiExpression) {
                VirtualFile virtualFile = element.getContainingFile().getVirtualFile();
                Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, virtualFile), true);
                if (editor != null) {
                    new MyIntroduceVariableHandler().invoke(project, editor, (PsiExpression)element);
                }
            }
        }

        private static class MyIntroduceVariableHandler
        extends IntroduceVariableHandler {
            private MyIntroduceVariableHandler() {
            }

            @Override
            public IntroduceVariableSettings getSettings(Project project, Editor editor, PsiExpression expr, PsiExpression[] occurrences, TypeSelectorManagerImpl typeSelectorManager, boolean declareFinalIfAll, boolean anyAssignmentLHS, InputValidator validator, PsiElement anchor, IntroduceVariableBase.JavaReplaceChoice replaceChoice) {
                if (replaceChoice == null && ApplicationManager.getApplication().isUnitTestMode()) {
                    replaceChoice = IntroduceVariableBase.JavaReplaceChoice.ALL;
                }
                return super.getSettings(project, editor, expr, occurrences, typeSelectorManager, declareFinalIfAll, anyAssignmentLHS, validator, anchor, replaceChoice);
            }
        }
    }
}

