/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.duplicateExpressions;

import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ObjectIntHashMap;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.Arrays;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SideEffectCalculator {
    private final ObjectIntHashMap<PsiExpression> myCache = new ObjectIntHashMap();

    SideEffectCalculator() {
    }

    @Contract(value="null -> false")
    boolean mayHaveSideEffect(@Nullable PsiExpression expression2) {
        if (expression2 == null || expression2 instanceof PsiLiteralExpression || expression2 instanceof PsiClassObjectAccessExpression) {
            return false;
        }
        int c = this.myCache.get((Object)expression2, -1);
        if (c < 0) {
            c = this.calculateSideEffect(expression2) ? 1 : 0;
            this.myCache.put((Object)expression2, c);
        }
        return c == 1;
    }

    boolean calculateSideEffect(@Nullable PsiExpression e) {
        if (e instanceof PsiParenthesizedExpression) {
            return this.mayHaveSideEffect(((PsiParenthesizedExpression)e).getExpression());
        }
        if (e instanceof PsiUnaryExpression) {
            return PsiUtil.isIncrementDecrementOperation((PsiElement)e) || this.mayHaveSideEffect(((PsiUnaryExpression)e).getOperand());
        }
        if (e instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadic = (PsiPolyadicExpression)e;
            return Arrays.stream(polyadic.getOperands()).anyMatch(this::mayHaveSideEffect);
        }
        if (e instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditional = (PsiConditionalExpression)e;
            return this.mayHaveSideEffect(conditional.getCondition()) || this.mayHaveSideEffect(conditional.getThenExpression()) || this.mayHaveSideEffect(conditional.getElseExpression());
        }
        if (e instanceof PsiMethodCallExpression) {
            return this.calculateCallSideEffect((PsiMethodCallExpression)e);
        }
        if (e instanceof PsiReferenceExpression) {
            return this.calculateReferenceSideEffect((PsiReferenceExpression)e);
        }
        if (e instanceof PsiInstanceOfExpression) {
            PsiInstanceOfExpression instanceOf = (PsiInstanceOfExpression)e;
            return this.mayHaveSideEffect(instanceOf.getOperand());
        }
        if (e instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression access = (PsiArrayAccessExpression)e;
            PsiExpression array = access.getArrayExpression();
            return this.mayHaveSideEffect(array) || this.mayHaveSideEffect(access.getIndexExpression()) || !Boolean.TRUE.equals(CommonDataflow.getExpressionFact(array, DfaFactType.LOCALITY));
        }
        if (e instanceof PsiLambdaExpression) {
            return false;
        }
        if (e instanceof PsiNewExpression) {
            return this.calculateNewSideEffect((PsiNewExpression)e);
        }
        return true;
    }

    private boolean calculateReferenceSideEffect(@NotNull PsiReferenceExpression ref) {
        if (this.mayHaveSideEffect(ref.getQualifierExpression())) {
            return true;
        }
        PsiElement resolved = ref.resolve();
        if (resolved instanceof PsiLocalVariable || resolved instanceof PsiParameter) {
            return false;
        }
        if (resolved instanceof PsiField) {
            PsiField field = (PsiField)resolved;
            return !field.hasModifierProperty("final");
        }
        if (resolved instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)resolved;
            return SideEffectCalculator.methodHasSideEffect(method);
        }
        return true;
    }

    private boolean calculateCallSideEffect(@NotNull PsiMethodCallExpression call) {
        PsiMethod method = call.resolveMethod();
        return SideEffectCalculator.methodHasSideEffect(method) || this.calculateSideEffect((PsiCallExpression)call, call.getMethodExpression().getQualifierExpression());
    }

    private boolean calculateNewSideEffect(@NotNull PsiNewExpression newExpr) {
        PsiElement resolved;
        if (newExpr.getAnonymousClass() != null || this.mayHaveSideEffect((PsiExpression)newExpr.getArrayInitializer())) {
            return true;
        }
        PsiJavaCodeReferenceElement ref = newExpr.getClassReference();
        if (ref != null && (resolved = ref.resolve()) instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)resolved;
            return !ClassUtils.isImmutableClass(psiClass) || this.calculateSideEffect((PsiCallExpression)newExpr, newExpr.getQualifier());
        }
        return true;
    }

    private boolean calculateSideEffect(@NotNull PsiCallExpression call, @Nullable PsiExpression qualifier) {
        PsiExpressionList argumentList = call.getArgumentList();
        if (argumentList != null) {
            for (PsiExpression argument : argumentList.getExpressions()) {
                if (!this.mayHaveSideEffect(argument)) continue;
                return true;
            }
        }
        return this.mayHaveSideEffect(qualifier);
    }

    @Contract(value="null -> true")
    private static boolean methodHasSideEffect(@Nullable PsiMethod method) {
        if (method == null) {
            return true;
        }
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return true;
        }
        if (ClassUtils.isImmutableClass(psiClass) || MethodUtils.isEquals(method) || MethodUtils.isHashCode(method) || MethodUtils.isToString(method) || MethodUtils.isCompareTo(method) || MethodUtils.isComparatorCompare(method)) {
            return false;
        }
        String className = psiClass.getQualifiedName();
        if ("java.util.Objects".equals(className)) {
            return false;
        }
        if ("java.lang.Math".equals(className) || "java.lang.StrictMath".equals(className)) {
            return "random".equals(method.getName());
        }
        return true;
    }

    static boolean isDefinitelyWithSideEffect(@Nullable PsiExpression expression2) {
        return expression2 instanceof PsiAssignmentExpression || PsiUtil.isIncrementDecrementOperation((PsiElement)expression2);
    }
}

